<?php

namespace App\Http\Controllers\Site\EmployeeLeave;

use App\Models\Academic\AcademicFiscalYear;
use App\Models\Academic\AcademicLeaveCategory;
use App\Models\Academic\AcademicLeaveType;
use App\Models\Designation\Designation;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveGenerate;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveHistory;
use App\Models\Site\EmployeeLeave\SiteLeavePolicy;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\User\EmployeeHistory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Employee\Employee;
use Response;
use Session;

class SiteEmployeeLeaveGenerateController extends Controller
{
    private $employeeLeaveGenerate;
    private $academicLeaveType;
    private $academicLeaveCategory;
    private $siteInfo;
    private $siteLeavePolicy;
    private $academicFiscalYear;
    private $employeeLeaveHistory;
    private $siteInfoSetting;
    private $designation;

    public function __construct(SiteEmployeeLeaveGenerate $employeeLeaveGenerate, AcademicLeaveType $academicLeaveType,
                                AcademicLeaveCategory $academicLeaveCategory, SiteInfo $siteInfo, SiteLeavePolicy $siteLeavePolicy,
                                AcademicFiscalYear $academicFiscalYear, SiteEmployeeLeaveHistory $employeeLeaveHistory, SiteInfoSetting $siteInfoSetting,
                                Designation $designation)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
      
        $this->employeeLeaveGenerate = $employeeLeaveGenerate;
        $this->academicLeaveType = $academicLeaveType;
        $this->academicLeaveCategory = $academicLeaveCategory;
        $this->siteInfo = $siteInfo;
        $this->siteLeavePolicy = $siteLeavePolicy;
        $this->academicFiscalYear = $academicFiscalYear;
        $this->employeeLeaveHistory = $employeeLeaveHistory;
        $this->siteInfoSetting = $siteInfoSetting;
        $this->designation = $siteInfoSetting;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    public function employeeLeaveGenerateList(Request $request)
    {
//        return $request;

        $academic_leave_type = $request->searchWithAcademicLeaveType;
        $academic_leave_category= $request->searchWithacademicLeaveCategory;
        $designation = $request->searchWithdesignation;
        $policy= $request->searchWithPolicy;
        $year = $request->searchWithYear;
        $search_txt = $request->searchText;
        $paginate = $request->paginate ?? 15;

        $txt = '%' . $search_txt . '%';

        $leave_generate_list = $this->employeeLeaveGenerate->with(['siteLeavePolicy'=>function($query){
                                $query->with('academicLeaveType','academicLeaveCategory','designation');
                            }])->with(['employeeHistory'=>function($query){
                                $query->with('user');
                            }])->with('academicFiscalYear')
                            ->when($academic_leave_type, function($query) use($academic_leave_type){
                                return $query->whereHas('siteLeavePolicy', function ($qr) use ($academic_leave_type){
                                    $qr->whereHas('academicLeaveType', function ($q) use ($academic_leave_type){
                                        $q->where('id', $academic_leave_type);
                                    });
//                                    $q->where('id', $academic_leave_type);
                                });
                            })
                            ->when($academic_leave_category, function($query) use($academic_leave_category){
                                return $query->whereHas('siteLeavePolicy', function ($qr) use ($academic_leave_category){
                                    $qr->whereHas('academicLeaveCategory', function ($q) use ($academic_leave_category){
                                        $q->where('id', $academic_leave_category);
                                    });
//                                    $q->where('id', $academic_leave_type);
                                });
                            })
                            ->when($designation, function($query) use($designation){
                                return $query->whereHas('siteLeavePolicy', function ($qr) use ($designation){
                                    $qr->whereHas('designation', function ($q) use ($designation){
                                        $q->where('id', $designation);
                                    });
//                                    $q->where('id', $academic_leave_type);
                                });
                            })
                            ->when($search_txt, function($query) use($txt){
                                return $query->whereHas('employeeHistory', function ($qr) use ($txt){
                                     $qr->whereHas('employee', function ($q) use ($txt){
                                          $q->where(function ($query) use ($txt) {
                                             $query->where('username', 'LIKE', $txt)
                                                 ->orWhere('email', 'LIKE', $txt)
                                                 ->orWhere('contact_number', 'LIKE', $txt)
                                                 ->orWhereTranslationLike('first_name', $txt)
                                                 ->orWhereTranslationLike('last_name', $txt);
                                         });
                                     });
                                    });

                            })
                            ->when($policy, function($query) use($policy){
                                $query->where('site_leave_policy_id', $policy);
                            })
                            ->when($year, function($query) use($year){
                                $query->where('academic_year_id', $year);
                            })
                            ->orderBy('id','ASC')
                            ->paginate($paginate);


        $leave_policy_data_for_search = SiteEmployeeLeaveGenerate::get();
        $leave_policy_for_search = SiteLeavePolicy::whereIn('id', $leave_policy_data_for_search->pluck('site_leave_policy_id'))->get();

        if(count($leave_policy_for_search)>0){

            $leave_type_list = $this->academicLeaveType->whereIn('id',  $leave_policy_for_search->pluck('academic_leave_type_id'))->get();

            $leave_category_list = $this->academicLeaveCategory->whereIn('id', $leave_policy_for_search->pluck('academic_leave_category_id'))->get();

            $academicFiscalYear = $this->academicFiscalYear->whereIn('id', $leave_policy_data_for_search->pluck('academic_year_id'))->get();

            $site_info_setting = $this->siteInfoSetting->first();
            $defined_designation_ids=Employee::whereIn('designation_id', explode(',',$site_info_setting->designation_ids))->pluck('designation_id')->unique();
            $designation_list = Designation::whereIn('id', $defined_designation_ids)->get();

        }else{
            $leave_type_list = [];
            $leave_category_list = [];
            $academicFiscalYear = [];
            $designation_list = [];
        }

        return response()->json([$leave_generate_list, $leave_type_list, $leave_category_list, $academicFiscalYear, $leave_policy_for_search, $designation_list], 200, [], JSON_NUMERIC_CHECK);
    }

    public function leavePolicyListByAcademicLeaveTypeAcademicLeaveCategory($academic_leave_type, $academic_leave_cetagory)
    {

        $leave_policy_list = $this->siteLeavePolicy->where('academic_leave_type_id', $academic_leave_type)->where('academic_leave_category_id',$academic_leave_cetagory)->get();


        return response()->json($leave_policy_list, 200, [], JSON_NUMERIC_CHECK);
    }

    public function getEmployeeByLeavePolicy($leave_policy)
    {

        $leave_policy_list = $this->siteLeavePolicy->where('id', $leave_policy)->first();
        $leave_day = $leave_policy_list->leave_days;

        $employee_list = EmployeeHistory::where('designation_id', $leave_policy_list->employee_designation_id)->where('status', 1)->with('user')->get();

        return response()->json([$leave_day, $employee_list], 200, [], JSON_NUMERIC_CHECK);
    }


    public function getEmployeeLeaveSpendDays(Request $request)
    {
//        return $request;
        $leave_generate_data = $this->employeeLeaveGenerate->where('academic_year_id', $request->academicYear)
            ->where('site_leave_policy_id',$request->leavePolicy)
            ->where('employee_history_id', $request->employee)
            ->where('status', 1)
            ->first();
        if(!$leave_generate_data){
            $employee_list = EmployeeHistory::where('id', $request->employee)->with('designation')->orderBy('id', 'DESC')->where('status', 0)->first();
            if($employee_list){
                $leave_generate_data = $this->employeeLeaveGenerate->orderBy('id', 'DESC')
                    ->where('academic_year_id', $request->academicYear)
                    ->where('site_leave_policy_id',$request->leavePolicy)
                    ->where('employee_history_id', $employee_list->id)
                    ->where('status', 1)
                    ->first();
                if($leave_generate_data){
                    $leave_history_data =  $this->employeeLeaveHistory->orderBy('id', 'DESC')
                                        ->where('site_employee_leave_generate_id', $leave_generate_data->id)
                                        ->first();
                    if($leave_history_data){
                        $spend_days = $leave_generate_data->leave_days - $leave_history_data->remaining_days;
                        $data['spend_days'] = $spend_days;
                        $data['previous_designation'] =  $employee_list->designation->name;
                        $employee_list = EmployeeHistory::where('id', $request->employee)->orderBy('id', 'DESC')->with('designation')->where('status', 1)->first();
                        $data['latest_designation'] = $employee_list->designation->name;
                        return $data;
                    }else{
                        return $data = '';
                    }
                }
            }else{
                return $data = '';
            }
        }else{
            return $data = '';
        }


    }

    public function generateEmployeeLeave(Request $request)
    {
            $this->validate($request,[
                'academicLeaveType' => 'required',
                'academicLeaveCategory' => 'required',
                'academicYear' => 'required',
                'leavePolicy' => 'required',
                'leaveDays' => 'required',
            ]);


            $leave_policy_data = $this->siteLeavePolicy->where('id', $request->leavePolicy)->first();


            if($request->employee == null){
                $employee_list = EmployeeHistory::where('designation_id', $leave_policy_data->employee_designation_id)->where('status', 1)->with('user')->get();
            }else{
                $employee_list = EmployeeHistory::where('id', $request->employee)->get();
            }

//            return $employee_list;
            if(count($employee_list)>0){
                foreach ($employee_list as $key => $value){

                    $leave_generate_data = $this->employeeLeaveGenerate->where('site_leave_policy_id', $request->leavePolicy)
                        ->where('employee_history_id', $value->id)
                        ->orderBy('id', 'DESC')
                        ->where('status', 1)->first();

                    if($leave_generate_data){
                        if($leave_policy_data->multiple_generate == true){

                            $leave_generate_data->update([
                                'leave_days' => $request->leaveDays,// + $leave_generate_data->leave_days,
                            ]);

                        }else if($leave_generate_data->academic_year_id != $request->academicYear){

                            $leave_generate_data->update([
                                'status' => 0,
                            ]);

                            $employee_leave_history_data = $this->employeeLeaveHistory->where('site_employee_leave_generate_id', $leave_generate_data->id)->where('status', 1)->first();
                            if($employee_leave_history_data){

                                if($leave_policy_data->add_to_next_year == true){
                                    $employeeLeaveGenerate=SiteEmployeeLeaveGenerate::create([
                                        'site_leave_policy_id' => $request->leavePolicy,
                                        'employee_previous_history_id' => $leave_generate_data->employee_previous_history_id ?? 'N/A',
                                        'employee_history_id' => $value->id,
                                        'academic_fiscal_year_id' => $request->academicYear,
                                        'previous_leave_days_remaining' => $employee_leave_history_data->remaining_days,
                                        'leave_days' => $request->leaveDays,
                                        'status' => $request->status
                                    ]);
                                }else{
                                    $employeeLeaveGenerate=SiteEmployeeLeaveGenerate::create([
                                        'site_leave_policy_id' => $request->leavePolicy,
                                        'employee_previous_history_id' => null,
                                        'employee_history_id' => $value->id,
                                        'academic_fiscal_year_id' => $request->academicYear,
                                        'previous_leave_days_remaining' => 0,
                                        'leave_days' => $request->leaveDays,
                                        'status' => $request->status
                                    ]);
                                }

                                $employee_leave_history_data->update([
                                    'status' => 0,
                                ]);


                            }else {
                                if($leave_policy_data->add_to_next_year == true){
                                    $employeeLeaveGenerate=SiteEmployeeLeaveGenerate::create([
                                        'site_leave_policy_id' => $request->leavePolicy,
                                        'employee_previous_history_id' => null,
                                        'employee_history_id' => $value->id,
                                        'academic_fiscal_year_id' => $request->academicYear,
                                        'previous_leave_days_remaining' => $leave_generate_data->previous_leave_days_remaining + $leave_generate_data->leave_days,
                                        'leave_days' => $request->leaveDays,
                                        'status' => $request->status
                                    ]);
                                }else{
                                    $employeeLeaveGenerate=SiteEmployeeLeaveGenerate::create([
                                        'site_leave_policy_id' => $request->leavePolicy,
                                        'employee_previous_history_id' => null,
                                        'employee_history_id' => $value->id,
                                        'academic_fiscal_year_id' => $request->academicYear,
                                        'previous_leave_days_remaining' => 0,
                                        'leave_days' => $request->leaveDays,
                                        'status' => $request->status
                                    ]);
                                }

                            }
                        }


                    }else{

                            $employee_previous_history_list = EmployeeHistory::where('user_id', $value->user_id)->orderBy('id', 'DESC')->where('status', 0)->with('user')->first();
                            if($employee_previous_history_list){
                                $leave_generate_data = $this->employeeLeaveGenerate->where('site_leave_policy_id', $request->leavePolicy)
                                    ->orderBy('id', 'DESC')
                                    ->where('employee_history_id', $employee_previous_history_list->id)
                                    ->where('status', 0)->first();
                                if($leave_generate_data){

                                    $employee_leave_history_data = $this->employeeLeaveHistory->where('id', $leave_generate_data->id)->orderBy('id', 'DESC')->first();
                                    if($employee_leave_history_data && $leave_policy_data->add_to_next_year == true){

                                        $employeeLeaveGenerate=SiteEmployeeLeaveGenerate::create([
                                            'site_leave_policy_id' => $request->leavePolicy,
                                            'employee_previous_history_id' => $employee_previous_history_list->id,
                                            'employee_history_id' => $value->id,
                                            'academic_fiscal_year_id' => $request->academicYear,
                                            'previous_leave_days_remaining' => $employee_leave_history_data->remaining_days,
                                            'leave_days' => $request->leaveDays,
                                            'status' => $request->status
                                        ]);

                                    }

                                }else{

                                    $employeeLeaveGenerate=SiteEmployeeLeaveGenerate::create([
                                        'site_leave_policy_id' => $request->leavePolicy,
                                        'employee_previous_history_id' => null,
                                        'employee_history_id' => $value->id,
                                        'academic_fiscal_year_id' => $request->academicYear,
                                        'previous_leave_days_remaining' => 0,
                                        'leave_days' => $request->leaveDays,
                                        'status' => $request->status
                                    ]);

                                }
                            }else{

                                $employeeLeaveGenerate=SiteEmployeeLeaveGenerate::create([
                                    'site_leave_policy_id' => $request->leavePolicy,
                                    'employee_previous_history_id' => null,
                                    'employee_history_id' => $value->id,
                                    'academic_fiscal_year_id' => $request->academicYear,
                                    'previous_leave_days_remaining' => 0,
                                    'leave_days' => $request->leaveDays,
                                    'status' => $request->status
                                ]);

                            }
                        }

                    }


            }




        return ['message' => 'Successfully Saved!'];
    }


    public function updateLeaveGenerate(Request $request)
    {
//        return $request;
        $leaveGenerateUpdate = $this->employeeLeaveGenerate->findOrFail($request->id);
        $leaveGenerateUpdate->update([
            'site_leave_policy_id' => $request->leavePolicy,
            'employee_history_id' => $request->employee,
            'academic_year_id' => $request->academicYear,
            'leave_days' => $request->leaveDays,
            'status' => $request->status,
        ]);
        return Response::json(['message' => 'Information Successfully Updated!'], 200);

    }

    public function searchedLeaveGenerateList($searchItem)
    {
//        $searchItem = 748;
        $leave_generate_list = $this->employeeLeaveGenerate->with(['siteLeavePolicy'=>function($query){
            $query->with('academicLeaveType','academicLeaveCategory','designation');
        }])->with(['employeeHistory'=>function($query){
            $query->with('user');
        }])->with('academicYear')
            ->whereHas('employeeHistory',function ($query) use($searchItem){
                $query->whereHas('user',function ($q) use($searchItem){
                    $q->where('first_name', $searchItem);
                });
            })
            ->get();

        return $leave_generate_list;
    }

    public function deleteLeaveGenerate($id)
    {
        $employee_leave_history_data = SiteEmployeeLeaveHistory::where('site_employee_leave_generate_id',$id)->where('status',1)->orderBy('id', 'DESC')->first();

        if($employee_leave_history_data && $employee_leave_history_data->approve_status == 1){
            return Response::json(['message' => 'Sorry! this leave has been used by employee!'], 411);

        }

        $exist_employee_leave_history_data = SiteEmployeeLeaveHistory::where('site_employee_leave_generate_id',$id)->get();
        foreach ($exist_employee_leave_history_data as $key => $value){
            $value->delete();
        }


        $leaveGenerateDelete = $this->employeeLeaveGenerate->findOrFail($id);
        if($leaveGenerateDelete->leave_use_status == true){
            return Response::json(['message' => 'Sorry! employee is enjoying this leave!'], 411);
        }else{
            $leave_generate_data = $this->employeeLeaveGenerate->orderBy('id','DESC')
                                    ->where('site_leave_policy_id', $leaveGenerateDelete->site_leave_policy_id)
                                    ->where('employee_history_id', $leaveGenerateDelete->employee_history_id)
                                    ->where('status', 0)
                                    ->first();
            if($leave_generate_data){
                $leave_generate_data->update([
                    'status' => 1,
                ]);
                $leaveGenerateDelete->delete();
            }else{
                $employee_list = EmployeeHistory::where('id', $leaveGenerateDelete->employee_history_id)->where('status', 1)->first();
                if($employee_list){
                    $inactive_employee_list = EmployeeHistory::where('user_id', $employee_list->user_id)->where('status', 0)->orderBy('id','DESC')->with('user')->first();
                    if($inactive_employee_list){
                        $leave_generate_data = $this->employeeLeaveGenerate->orderBy('id','DESC')
                                                ->where('employee_history_id', $inactive_employee_list->id)
                                                ->where('site_leave_policy_id', $leaveGenerateDelete->site_leave_policy_id)
                                                ->first();
                        if($leave_generate_data){
                            $leave_generate_data->update([
                                'status' => 1,
                            ]);
                            $leaveGenerateDelete->delete();
                        }
                    }else{
                        $leaveGenerateDelete->delete();
                    }
                }
            }
        }
        return Response::json(['message' => 'Information Successfully Deleted!'], 200);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
