<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/25/2016
 * Time: 4:50 PM
 */
namespace App\Http\Controllers\Site\Event;

use App\Http\Controllers\Controller;
use App\Forms\EventForm;
use App\Forms\DataHelper;
use App\Http\Controllers\Language\Lang;
use App\Forms\FormControll;
use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicCalendarHead;
use App\Models\Country\Country;
use App\Models\Edu\GlobalAcademicCalendar\GlobalAcademicCalendarEvent;
use App\Models\Event\Event;
use App\Models\Image\Photo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use Error;
use Illuminate\Http\Request;
use App\Http\Requests;
//use App\Http\Requests\Validator;
use Carbon\Carbon;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Log;
use Intervention\Image\Facades\Image as InterImage;
use Illuminate\Support\Facades\Session;
use App\Models\Setting\Setting;
use App\UserTranslation;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\Config;
use App\Models\AddFieldTable\AddFieldToTable;
use App\Lists\ListControll;
use DB;
use Response;


class EventController extends Controller
{
    use Lang, FormControll, DataHelper;

    private $event;
    private $fileName;
    private $extension;

    /**
     * @param Event $event
     */
    public function __construct(Event $event)
    {

        $this->middleware('auth');
    //    $this->middleware('sitepagechecker');

        $this->event = $event;
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function createEventForm($date=null)
    {
//        dd($date);
        $viewType = 'Create Event';

        return view('default.admin.events.create',compact('viewType','date'));
    }

    public function isTheDateHoliday($date)
    {
        $event = Event::where('activate_date', $date)->with('academicCalendarHead')->first();
        if($event){
            $event_name = $event->academicCalendarHead->name;
            if($event_name == 'Holiday'){

            }
        }
    }

    /**
     * @param Requests\Validator $validatedRequest
     * @return null
     */


    public function createEvent(Request $request)
    {
//        return $request;
        $request->validate([
            'acHeadId' => 'required',
            'iconColorId' => 'required',
            'title' => 'required',
            'start_date' => 'required',
            'end_date' => 'required',

        ]);

        if($request->dayName == null){

            $start_date = $request->get('start_date');//start date
            $end_date = $request->get('end_date');//end date
            $dates = array();
            while (strtotime($start_date) <= strtotime($end_date)) {
                $dates[] = $start_date;
                $start_date = date ("Y-m-d", strtotime("+1 day", strtotime($start_date)));
            }

            $eventList = Event::orderBy('id', 'DESC')->with('academicCalendarHead')->first();

            if($eventList){
                $id_number = $eventList->identification_number + 1;
            }else{
                $id_number = 101;
            }

            if($request->dataExist){

//            return 'false';
                foreach ($dates as $key => $value){


                    $year = date('Y', strtotime($value));

                    $month = date('m', strtotime($value));

                    $this->event->create([
                        'activate_date'=>$value,
                        'year'=>$year,
                        'month'=>$month,
                        'start_date'=>$request->start_date,
                        'end_date'=>$request->end_date,
                        'identification_number'=>$id_number,
                        'academic_calendar_head_id'=>$request->get('acHeadId'),
                        'subhead_color_id'=>$request->get('iconColorId'),
                        'title'=>$request->get('title'),
                        'description'=>$request->get('description'),
                        'status'=>$request->get('status'),

                    ]);

                }

            }else if(!$request->dataExist){

//            return 'true';
                foreach ($dates as $key => $value){

                    $data = Event::where('activate_date', $value)->first();

                    if($data){
                        $data_found = 'data_found';
                        return $data_found;
                    }

                }
                foreach ($dates as $key => $value){

                    $year = date('Y', strtotime($value));

                    $month = date('m', strtotime($value));

                    $this->event->create([
                        'activate_date'=>$value,
                        'year'=>$year,
                        'month'=>$month,
                        'start_date'=>$request->start_date,
                        'end_date'=>$request->end_date,
                        'identification_number'=>$id_number,
                        'academic_calendar_head_id'=>$request->get('acHeadId'),
                        'subhead_color_id'=>$request->get('iconColorId'),
                        'title'=>$request->get('title'),
                        'description'=>$request->get('description'),
                        'status'=>$request->get('status'),

                    ]);


                }
            }

            return Response::json(['message' => 'Event Successfully Created!']);

        }else{

            $start_date = $request->get('start_date');//start date
            $end_date = $request->get('end_date');//end date
            $dates = array();
            while (strtotime($start_date) <= strtotime($end_date)) {
                $dates[] = $start_date;
                $start_date = date ("Y-m-d", strtotime("+1 day", strtotime($start_date)));
            }

            if($request->dataExist){

                foreach ($dates as $key => $value){

                    $eventList = Event::orderBy('id', 'DESC')->with('academicCalendarHead')->first();

                    if($eventList){
                        $id_number = $eventList->identification_number + 1;
                    }else{
                        $id_number = 101;
                    }

                    $unixTimestamp = strtotime($value);
                    $dayOfWeek = date("D", $unixTimestamp);

                    $year = date('Y', strtotime($value));

                    $month = date('m', strtotime($value));

                    if ($request->dayName == $dayOfWeek){

                        if ($request->attendance == 'student'){

                            $this->event->create([
                                'activate_date'=>$value,
                                'year'=>$year,
                                'month'=>$month,
                                'start_date'=>$value,
                                'end_date'=>$value,
                                'identification_number'=>$id_number,
                                'academic_calendar_head_id'=>$request->get('acHeadId'),
                                'subhead_color_id'=>$request->get('iconColorId'),
                                'day_name'=>$request->get('dayName'),
                                'attendance_active_for_student'=>1,
                                'title'=>$request->get('title'),
                                'description'=>$request->get('description'),
                                'status'=>$request->get('status'),

                            ]);
                        }else if ($request->attendance == 'employee'){


                            $this->event->create([
                                'activate_date'=>$value,
                                'year'=>$year,
                                'month'=>$month,
                                'start_date'=>$value,
                                'end_date'=>$value,
                                'identification_number'=>$id_number,
                                'academic_calendar_head_id'=>$request->get('acHeadId'),
                                'subhead_color_id'=>$request->get('iconColorId'),
                                'day_name'=>$request->get('dayName'),
                                'attendance_active_for_employee'=>1,
                                'title'=>$request->get('title'),
                                'description'=>$request->get('description'),
                                'status'=>$request->get('status'),

                            ]);
                        }else if ($request->attendance == 'both'){

                            $this->event->create([
                                'activate_date'=>$value,
                                'year'=>$year,
                                'month'=>$month,
                                'start_date'=>$value,
                                'end_date'=>$value,
                                'identification_number'=>$id_number,
                                'academic_calendar_head_id'=>$request->get('acHeadId'),
                                'subhead_color_id'=>$request->get('iconColorId'),
                                'day_name'=>$request->get('dayName'),
                                'attendance_active_for_student'=>1,
                                'attendance_active_for_employee'=>1,
                                'title'=>$request->get('title'),
                                'description'=>$request->get('description'),
                                'status'=>$request->get('status'),

                            ]);
                        }else{
                            $year = date('Y', strtotime($value));

                            $month = date('m', strtotime($value));

                            $this->event->create([
                                'activate_date'=>$value,
                                'year'=>$year,
                                'month'=>$month,
                                'start_date'=>$value,
                                'end_date'=>$value,
                                'identification_number'=>$id_number,
                                'academic_calendar_head_id'=>$request->get('acHeadId'),
                                'subhead_color_id'=>$request->get('iconColorId'),
                                'day_name'=>$request->get('dayName'),
                                'title'=>$request->get('title'),
                                'description'=>$request->get('description'),
                                'status'=>$request->get('status'),

                            ]);
                        }

                    }

                }

            }else if(!$request->dataExist){

//            return 'true';
                foreach ($dates as $key => $value){

                    $data = Event::where('activate_date', $value)->first();

                    if($data){
                        $data_found = 'data_found';
                        return $data_found;
                    }

                }
                foreach ($dates as $key => $value){


                    $eventList = Event::orderBy('id', 'DESC')->with('academicCalendarHead')->first();

                    if($eventList){
                        $id_number = $eventList->identification_number + 1;
                    }else{
                        $id_number = 101;
                    }

                    $unixTimestamp = strtotime($value);
                    $dayOfWeek = date("D", $unixTimestamp);

                    $year = date('Y', strtotime($value));

                    $month = date('m', strtotime($value));

                    if ($request->dayName == $dayOfWeek){

                        if ($request->attendance == 'student'){
                            $this->event->create([
                                'activate_date'=>$value,
                                'year'=>$year,
                                'month'=>$month,
                                'start_date'=>$value,
                                'end_date'=>$value,
                                'identification_number'=>$id_number,
                                'academic_calendar_head_id'=>$request->get('acHeadId'),
                                'subhead_color_id'=>$request->get('iconColorId'),
                                'day_name'=>$request->get('dayName'),
                                'attendance_active_for_student'=>1,
                                'title'=>$request->get('title'),
                                'description'=>$request->get('description'),
                                'status'=>$request->get('status'),

                            ]);
                        }else if ($request->attendance == 'employee'){
                            $this->event->create([
                                'activate_date'=>$value,
                                'year'=>$year,
                                'month'=>$month,
                                'start_date'=>$value,
                                'end_date'=>$value,
                                'identification_number'=>$id_number,
                                'academic_calendar_head_id'=>$request->get('acHeadId'),
                                'subhead_color_id'=>$request->get('iconColorId'),
                                'day_name'=>$request->get('dayName'),
                                'attendance_active_for_employee'=>1,
                                'title'=>$request->get('title'),
                                'description'=>$request->get('description'),
                                'status'=>$request->get('status'),

                            ]);
                        }else if ($request->attendance == 'both'){
                            $this->event->create([
                                'activate_date'=>$value,
                                'year'=>$year,
                                'month'=>$month,
                                'start_date'=>$value,
                                'end_date'=>$value,
                                'identification_number'=>$id_number,
                                'academic_calendar_head_id'=>$request->get('acHeadId'),
                                'subhead_color_id'=>$request->get('iconColorId'),
                                'day_name'=>$request->get('dayName'),
                                'attendance_active_for_student'=>1,
                                'attendance_active_for_employee'=>1,
                                'title'=>$request->get('title'),
                                'description'=>$request->get('description'),
                                'status'=>$request->get('status'),

                            ]);
                        }else{
                            $this->event->create([
                                'activate_date'=>$value,
                                'year'=>$year,
                                'month'=>$month,
                                'start_date'=>$value,
                                'end_date'=>$value,
                                'identification_number'=>$id_number,
                                'academic_calendar_head_id'=>$request->get('acHeadId'),
                                'subhead_color_id'=>$request->get('iconColorId'),
                                'day_name'=>$request->get('dayName'),
                                'title'=>$request->get('title'),
                                'description'=>$request->get('description'),
                                'status'=>$request->get('status'),

                            ]);
                        }

                    }

                }
            }

            return Response::json(['message' => 'Event Successfully Created!']);


        }

    }


//    private function ownFieldsToSave(Event $event, Requests\Validator $validatedRequest)
//    {
//        //$current_date_time = Carbon::now();
//        if(isset($event->ownFields)){
//            foreach($event->ownFields as $ownField){
//                if($validatedRequest->{$ownField})
//                    $event->{$ownField} = $validatedRequest->{$ownField} ;
//            }
//        }
//
//
//        if($event->save()){
//
//            return $event;
//        }
//
//        return false;
//    }

//    private function ownFieldsToUpdate(Event $event,  Requests\Validator $validatedRequest)
//    {
//        $current_date_time = Carbon::now();
//        if(isset($event->ownFields)){
//            foreach($event->ownFields as $ownField){
//                if($validatedRequest->{$ownField})
//                    $event->{$ownField} = $validatedRequest->{$ownField} ;
//            }
//        }
//
//        $this->event->updated_at = $current_date_time;
//
//        if($event->save()){
//
//            return $event;
//        }
//
//        return false;
//    }

//    private function translatedAttrToSave(Event $event,  Requests\Validator $validatedRequest)
//    {
//        foreach ($event->translatedAttributes as $field) {
//            foreach($this->locales() as $locale => $value){
//                if($validatedRequest->get($field.'_'.$locale)){
//                    $event->translateOrNew($locale)->{$field} =$validatedRequest->get($field.'_'.$locale);
//                }
//            }
//        }
//
//        if($event->save()){
//
//            return $event;
//        }
//        return false;
//    }

//    private function savePhoto(Event $event, Requests\Validator $validatedRequest)
//    {
//        if($validatedRequest->photo):
//            $image = $validatedRequest->file('photo');
//            $this->imageUpload($image,$event);
//
//        endif;
//
//    }


//    private function imageUpload($image,Event $newlyCreatedEvent){
//
//        $this->extension = $image->getClientOriginalExtension();
//
//        $this->fileName = time().str_random(3).$image->getClientOriginalName();
//        InterImage::make($image->getRealPath())->resize(200,200)->save('uploads/'. $this->fileName);
//        $photo = new Photo();
//        $photo->name= $this->fileName;
//        $photo->user_id = $newlyCreatedEvent->id;
//        $photo->extension =  $this->extension;
//        $newlyCreatedEvent->photo()->save($photo);
//    }

    /**
     * @param Event $event
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
//return $request;
        $date = json_decode($request->date, true);
        $start_date = $date ? $date['start'] : null;
        $end_date = $request->date ? $date['end'] : null;
        $head_ids =  $request->head_ids;
        $title =  $request->title;
        $paginate =  $request->paginate ?? 20;
//        $paginate =  500;
//        return [$start_date, $end_date];


        $event_list = Event::when($head_ids, function ($query) use($head_ids){
                return $query->whereIn('academic_calendar_head_id',  $head_ids);
            })

            ->when($start_date, function ($query) use ($start_date,$end_date) {
                return $query->whereBetween('activate_date', [$start_date,$end_date]);
            })
            ->when($title, function ($query) use ($title) {
                return $query->where('title', $title);
            })
            ->with('academicCalendarHead')
            ->groupBy('identification_number')
            ->orderBy('id', 'DESC')
            ->paginate($paginate);

        if(count($event_list)>0){

            $event_title = Event::pluck('title');
            $event_title_unique = $event_title->unique();

            //==========calender head list=================

            $calender_head_data = SiteInfoSetting::first();
            $calender_head_ids = $calender_head_data->academic_calendar_head_ids;
            $separated_ids  = explode(',', $calender_head_ids);
            $academic_calender_head_list = AcademicCalendarHead::whereIn('id', $separated_ids)->get();

            //------------------end-------------------------


            return [$event_list,$event_title_unique,$academic_calender_head_list];

        }else{

            throw new Error('event not found');

        }
    }

    public function getAcademicCalenderHeadList()
    {
        $calender_head_data = SiteInfoSetting::first();
        $calender_head_ids = $calender_head_data->academic_calendar_head_ids;
        $separated_ids  = explode(',', $calender_head_ids);
        $academic_calender_head_list = AcademicCalendarHead::whereIn('id', $separated_ids)->get();
        return $academic_calender_head_list;
    }

    public function getCountryList()
    {
        $calender_head_data = Country::all();
        return $calender_head_data;
    }

    public function createGeneralEvent(Request $request)
    {

        $request->validate([
            'start_date_for_auto_data' => 'required',
            'end_date_for_auto_data' => 'required',

        ]);

        $start_date = $request->get('start_date_for_auto_data');//start date
        $end_date = $request->get('end_date_for_auto_data');//end date

        $global_acc_cal_ev_data  = GlobalAcademicCalendarEvent::whereBetween('activate_date', [$start_date,$end_date])->get();

        $event = $global_acc_cal_ev_data->pluck('identification_number');
        $event_unique = $event->unique();
        foreach ($event_unique as $key => $value){
            $data  = GlobalAcademicCalendarEvent::where('identification_number', $value)->get();

            $eventList = Event::orderBy('id', 'DESC')->with('academicCalendarHead')->first();

            if($eventList){
                $id_number = $eventList->identification_number + 1;
            }else{
                $id_number = 101;

            }
            foreach ($data as $kk => $vl){
                if($vl->day_name){
                    if($request->holidayCheck){
                        $eventListWithholiday = Event::where('day_name', $vl->day_name)->orderBy('id', 'DESC')->with('academicCalendarHead')->first();
                        if($eventListWithholiday){
                            $id_number = $eventListWithholiday->identification_number + 1;
                        }else{
                            $eventList = Event::orderBy('id', 'DESC')->with('academicCalendarHead')->first();

                            if($eventList){
                                $id_number = $eventList->identification_number + 1;
                            }else{
                                $id_number = 101;

                            }
                        }
                        $event = new Event();
                        $event->create([
                            'activate_date'=>$vl->activate_date,
                            'start_date'=>$vl->start_date,
                            'end_date'=>$vl->end_date,
                            'identification_number'=>$id_number,
                            'academic_calendar_head_id'=>$vl->academic_calendar_head_id,
                            'subhead_color_id'=>$vl->subhead_color_id,
                            'title'=>$vl->title,
                            'description'=>$vl->description,
                            'day_name'=>$vl->day_name,
                            'event_type'=>'holiday',
                            'status'=>1,

                        ]);
                    }
                }else{
                    $event = new Event();
                    $event->create([
                        'activate_date'=>$vl->activate_date,
                        'start_date'=>$vl->start_date,
                        'end_date'=>$vl->end_date,
                        'identification_number'=>$id_number,
                        'academic_calendar_head_id'=>$vl->academic_calendar_head_id,
                        'subhead_color_id'=>$vl->subhead_color_id,
                        'title'=>$vl->title,
                        'description'=>$vl->description,
                        'day_name'=>null,
                        'event_type'=>null,
                        'status'=>1,

                    ]);
                }
            }

        }

//        return $event_unique;
//        $dates = array();
//        while (strtotime($start_date) <= strtotime($end_date)) {
//            $dates[] = $start_date;
//            $start_date = date ("Y-m-d", strtotime("+1 day", strtotime($start_date)));
//        }
////        return $start_date;
//        $global_acc_cal_ev_data  = GlobalAcademicCalendarEvent::whereBetween('activate_date', [$start_date,$end_date])->get();
////        return $global_acc_cal_ev_data;
//
//        foreach($dates as $key => $value){
//
//
//
//            if(count($global_acc_cal_ev_data)){
//
//                foreach ($global_acc_cal_ev_data as $kk => $vl){
//                    Log::info($vl);
//                    if($vl->day_name){
//                        //=================generate all event with holiday================================
//
//                        if($request->holidayCheck){
//                            $eventListWithholiday = Event::where('day_name', $vl->day_name)->orderBy('id', 'DESC')->with('academicCalendarHead')->first();
//                            if($eventListWithholiday){
//                                $id_number = $eventListWithholiday->identification_number + 1;
//                            }else{
//                                $eventList = Event::orderBy('id', 'DESC')->with('academicCalendarHead')->first();
//
//                                if($eventList){
//                                    $id_number = $eventList->identification_number + 1;
//                                }else{
//                                    $id_number = 101;
//
//                                }
//                            }
//                            $event = new Event();
//                            $event->create([
//                                'activate_date'=>$vl->activate_date,
//                                'start_date'=>$vl->start_date,
//                                'end_date'=>$vl->end_date,
//                                'identification_number'=>$id_number,
//                                'academic_calendar_head_id'=>$vl->academic_calendar_head_id,
//                                'subhead_color_id'=>$vl->subhead_color_id,
//                                'title'=>$vl->title,
//                                'description'=>$vl->description,
//                                'day_name'=>$vl->day_name,
//                                'event_type'=>'holiday',
//                                'status'=>1,
//
//                            ]);
//                        }
//
//                    }else{
//                        //=================generate all event without holiday================================
//
//                        $eventList = Event::orderBy('id', 'DESC')->with('academicCalendarHead')->first();
//
//                        if($eventList){
//                            $id_number = $eventList->identification_number + 1;
//                        }else{
//                            $id_number = 101;
//
//                        }
//                        $event = new Event();
//                        $event->create([
//                            'activate_date'=>$vl->activate_date,
//                            'start_date'=>$vl->start_date,
//                            'end_date'=>$vl->end_date,
//                            'identification_number'=>$id_number,
//                            'academic_calendar_head_id'=>$vl->academic_calendar_head_id,
//                            'subhead_color_id'=>$vl->subhead_color_id,
//                            'title'=>$vl->title,
//                            'description'=>$vl->description,
//                            'day_name'=>null,
//                            'event_type'=>null,
//                            'status'=>1,
//
//                        ]);
//                    }
//
//
//                }
//            }
//        }

        return Response::json(['message' => 'Event Successfully Created!']);

    }

    public function getFilteredEventData(Request $request)
    {

        $start_date = $request->date['start'];
        $end_date = $request->date['end'];
        $head_ids =  $request->head_ids;
        $title =  $request->title;
        $paginate =  $request->paginate??20;

//        return $title;

//        $event = Event::whereIn('academic_calendar_head_id',  $request->head_ids)
        $event = Event::when($head_ids, function ($query) use($head_ids){
                            return $query->whereIn('academic_calendar_head_id',  $head_ids);
                        })

                        ->when($start_date, function ($query) use ($start_date,$end_date) {
                            return $query->whereBetween('activate_date', [$start_date,$end_date]);
                        })
                        ->when($title, function ($query) use ($title) {
                            return $query->where('title', $title);
                        })
                        ->get();



                        if(count($event)>0){
                            $event_id_no = $event->pluck('identification_number');

                            $event_unique = $event_id_no->unique();

                //        $eventList = Event::where('identification_number', 103)->with('academicCalendarHead')->first();

                            foreach ($event_unique as $key => $value){

                                $eventList[$key] = Event::where('identification_number', $value)->with('academicCalendarHead')->first();
                            }
//                            $units = Paginator::make($eventList, count($eventList), 10);
                            $pagination = new Paginator($eventList, $paginate);
                            return $pagination;
//                            return $eventList;
                        }else{
                            throw new Error('event not found');
                        }


    }

    public function viewEvent($id)
    {
        $photo='';
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $eventData = $this->event->findOrFail($id);
        if(!$eventData->photo->isEmpty()){
            $photo = $eventData->photo->last()->name;
        }

        //dd($eventData);

        return view('default.admin.events.view',compact('eventData','locale','defaultLocale', 'photo'));
    }

    public function getEventEditForm($id, EventForm $eventForm)
    {
        $viewType = 'Edit Event';
        $editEvent = $eventForm;
        $eventData = $this->editFormModel($this->event->findOrFail($id));

        return view('default.admin.events.edit', compact('viewType', 'editEvent', 'eventData'));
    }

    /*public function editEvent($id, Requests\Validator $validatedRequest)
    {
        $current_date_time = Carbon::now();
        $eventToEdit = $this->event->findOrFail($id);
        foreach ($eventToEdit->translatedAttributes as $field) {
            foreach(config('app.locales') as $locale => $value){
                if($validatedRequest->get($field.'_'.$locale)){
                    $eventToEdit->translateOrNew($locale)->{$field} =$validatedRequest->get($field.'_'.$locale);
                }
            }
        }
        $eventToEdit->from_date = $validatedRequest->get('from_date');
        $eventToEdit->to_date = $validatedRequest->get('to_date');
        $eventToEdit->status = $validatedRequest->get('status');
        $eventToEdit->updated_at = $current_date_time;

        return $eventToEdit->save()?back()->withSuccess('Successfully Updated'):null;
    }*/

    public function editEvent(Request $request)
    {

            $start_date = $request->get('start_date');//start date
            $end_date = $request->get('end_date');//end date
            $dates = array();
            while (strtotime($start_date) <= strtotime($end_date)) {
                $dates[] = $start_date;
                $start_date = date ("Y-m-d", strtotime("+1 day", strtotime($start_date)));
            }

//        foreach ($dates as $key => $value){
//            $year = date('Y', strtotime($value));
//
//            $month = date('m', strtotime($value));
//
//            return [$year, $month];
//        }


                $event_delete = Event::where('identification_number', $request->identification_number)->pluck('id');

                Event::whereIn('id', $event_delete)->delete();

                $eventList = Event::orderBy('id', 'DESC')->with('academicCalendarHead')->first();

                if($eventList){
                    $id_number = $eventList->identification_number + 1;
                }else{
                    $id_number = 101;
                }

                foreach ($dates as $key => $value){



                    $unixTimestamp = strtotime($value);
                    $dayOfWeek = date("D", $unixTimestamp);

                    $year = date('Y', strtotime($value));

                    $month = date('m', strtotime($value));

                    if ($request->dayName == null){

                        $this->event->create([
                            'activate_date'=>$value,
                            'year'=>$year,
                            'month'=>$month,
                            'start_date'=>$request->start_date,
                            'end_date'=>$request->end_date,
                            'identification_number'=>$id_number,
                            'academic_calendar_head_id'=>$request->get('acHeadId'),
                            'subhead_color_id'=>$request->get('iconColorId'),
                            'title'=>$request->get('title'),
                            'description'=>$request->get('description'),
                            'status'=>$request->get('status'),

                        ]);

                    }

                    if ($request->dayName == $dayOfWeek){

                        if ($request->attendance == 'student'){
                            $this->event->create([
                                'activate_date'=>$value,
                                'year'=>$year,
                                'month'=>$month,
                                'start_date'=>$value,
                                'end_date'=>$value,
                                'identification_number'=>$id_number,
                                'academic_calendar_head_id'=>$request->get('acHeadId'),
                                'subhead_color_id'=>$request->get('iconColorId'),
                                'day_name'=>$request->get('dayName'),
                                'attendance_active_for_student'=>1,
                                'title'=>$request->get('title'),
                                'description'=>$request->get('description'),
                                'status'=>$request->get('status'),

                            ]);
                        }else if ($request->attendance == 'employee'){
                            $this->event->create([
                                'activate_date'=>$value,
                                'year'=>$year,
                                'month'=>$month,
                                'start_date'=>$value,
                                'end_date'=>$value,
                                'identification_number'=>$id_number,
                                'academic_calendar_head_id'=>$request->get('acHeadId'),
                                'subhead_color_id'=>$request->get('iconColorId'),
                                'day_name'=>$request->get('dayName'),
                                'attendance_active_for_employee'=>1,
                                'title'=>$request->get('title'),
                                'description'=>$request->get('description'),
                                'status'=>$request->get('status'),

                            ]);
                        }else if ($request->attendance == 'both'){
                            $this->event->create([
                                'activate_date'=>$value,
                                'year'=>$year,
                                'month'=>$month,
                                'start_date'=>$value,
                                'end_date'=>$value,
                                'identification_number'=>$id_number,
                                'academic_calendar_head_id'=>$request->get('acHeadId'),
                                'subhead_color_id'=>$request->get('iconColorId'),
                                'day_name'=>$request->get('dayName'),
                                'attendance_active_for_student'=>1,
                                'attendance_active_for_employee'=>1,
                                'title'=>$request->get('title'),
                                'description'=>$request->get('description'),
                                'status'=>$request->get('status'),

                            ]);
                        }else{
                            $this->event->create([
                                'activate_date'=>$value,
                                'year'=>$year,
                                'month'=>$month,
                                'start_date'=>$value,
                                'end_date'=>$value,
                                'identification_number'=>$id_number,
                                'academic_calendar_head_id'=>$request->get('acHeadId'),
                                'subhead_color_id'=>$request->get('iconColorId'),
                                'day_name'=>$request->get('dayName'),
                                'title'=>$request->get('title'),
                                'description'=>$request->get('description'),
                                'status'=>$request->get('status'),

                            ]);
                        }

                    }


                }

            return Response::json(['message' => 'Event Successfully Created!']);




//        $intArray = array_map(
//            function($value) { return (int)$value; },
//            $event_ids
//        );
//
////        return $intArray;
////        $event_ids = explode(',', $event_delete);
////        $event_ids = array_map('intval', explode(',', $event_delete));
//
//
//      Event::whereIn('id', $intArray)->get();
//
//
//        return Response::json(['message' => 'Event succesfully updated!']);


//        $eventData = $this->event->findOrFail($id);
//        $ownFieldsToUpdate = $this->ownFieldsToUpdate($eventData,$validatedRequest);
//        $isTranslatedFieldsSaved = $this->translatedAttrToSave($eventData,$validatedRequest);
//
//        if($ownFieldsToUpdate){
//            if($isTranslatedFieldsSaved){
////                $this->savePhoto(
////                    $eventData,
////                    $validatedRequest
////                );
//                return back()->withSuccess('Successfully Updated');
//            }
//        }
    }



    public function deleteEvent(Request $request)
    {
        $event_delete = Event::where('identification_number', $request->identification_number)->pluck('id');

        Event::whereIn('id', $event_delete)->delete();

        return Response::json(['message' => 'Event succesfully deleted!'],200);

    }

    public function deleteHeadwiseEvent(Request $request)
    {
//        return $request;
        $request->validate([
            'head_id' => 'required',
            'title' => 'required',
            'start_date' => 'required',
            'end_date' => 'required',

        ]);

        $start_date = $request->get('start_date');//start date
        $end_date = $request->get('end_date');//end date
        $dates = array();
        while (strtotime($start_date) <= strtotime($end_date)) {
            $dates[] = $start_date;
            $start_date = date ("Y-m-d", strtotime("+1 day", strtotime($start_date)));
        }

        $event_delete = $this->event->where('academic_calendar_head_id', $request->head_id)
                                    ->whereIn('activate_date', $dates)
                                    ->where('title', $request->title)->get();

        if(count($event_delete)>0){
            $event_ids = $event_delete->pluck('id');
            $this->event->whereIn('id',$event_ids)->delete();
            return Response::json(['message' => 'Event succesfully deleted!'],200);
        }else{
            return Response::json(['message' => 'Sorry! Event is not  deleted!'],411);

        }

    }



    public function getDateWiseEventsList(Request $request){
        $date=$request->data;
        $event_type=$request->event_type;

        $events=(new Event())->whereDate('from_date',$date)->whereEventType($event_type)->get();
        return view('default.admin.calendar.events-list',compact('date','events'));
    }

}