<?php

namespace App\Http\Controllers\Site\Exam\Question;

use App\Models\Academic\AcademicExamType;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Exam\Question\SiteExamQuestionDeclare;
use App\Models\Site\Exam\Question\SiteExamStudentQuestion;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExamQuestion;
use App\Models\Site\Exam\SiteExamQuestionInfo;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class SiteExamQuestionDeclareController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

    public function index()
    {
        $viewType = 'Question Declare';

        return view('default.admin.layouts.master', compact('viewType'));

    }


    private function getDeclareId($request){
        $data = $request->all();

        $examDeclareIDs = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
//            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
//                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//            })
//            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
//                return $query->where('academic_section_id', $data['academic_section_id']);
//            })
//            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
//                return $query->where('academic_session_id', $data['academic_session_id']);
//            })
                ->where('status', true)
            ->pluck('id');

        return $examDeclareIDs;
    }


    public function siteExamTypeForQuestionDeclare(Request $request){


        ini_set('memory_limit', '-1');

        $data = $request->all();

        $examDeclareIDs = $this->getDeclareId($request);




        $examType_array=SiteExamRoutine::
        where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->whereIn('site_exam_declare_id', $examDeclareIDs)
            ->pluck('academic_exam_type_id')
            ->unique()
            ->filter();

        $examTypeList=AcademicExamType::whereIn('id', $examType_array)->get();



        $question_info=SiteExamQuestionInfo::where('academic_version_id', $request->academic_version_id)
//            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
//                return $query->where('academic_year_id', $data['academic_year_id']);
//            })
//            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
//                return $query->where('academic_shift_id', $data['academic_shift_id']);
//            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->get();


        $question_year_ids=$question_info->pluck('academic_year_id')->unique()->filter();
        $year_list=AcademicYear::whereIn('id', $question_year_ids)->get();


        return response()->json(
            [
                'examTypeList'=>$examTypeList,
                'year_list' => $year_list,


            ]);

    }




    public function siteQuestionListForQuestionDeclare(Request $request){
        ini_set('memory_limit', '-1');

        $data = $request->all();

        $examDeclareIDs = $this->getDeclareId($request);


        $subject_condition_list=SubjectGroupConditionSetting::where('id', $request->site_subject_group_condition_setting_id)
            ->first();




        if($subject_condition_list->academic_subject_id!=$subject_condition_list->exam_dependent_academic_subject_id){

            $exam_dependent_subject_ids[]=$subject_condition_list->academic_subject_id;
        }
        else{
            $exam_dependent_subject_ids=SubjectGroupConditionSetting::
            where('exam_dependent_academic_subject_id', $subject_condition_list->academic_subject_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->pluck('academic_subject_id')
                ->unique();
        }




        if($request->year_base_question){

            $this->validate($request, [
                "academic_class_id" => "required",
                "academic_shift_id" => "required",
                "academic_year_id" => "required",
                "examination_id" => "required",
                "site_subject_group_condition_setting_id" => "required",
                "academic_exam_type_id" => "required",
                "question_academic_year_id" => "required",
            ]);



            $question_info=SiteExamQuestionInfo::
                where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->question_academic_year_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->whereIn('academic_subject_id', $exam_dependent_subject_ids)
                ->get();
        }
        else{

            $this->validate($request, [
                "academic_class_id" => "required",
                "academic_shift_id" => "required",
                "academic_year_id" => "required",
                "examination_id" => "required",
                "site_subject_group_condition_setting_id" => "required",
                "academic_exam_type_id" => "required",
            ]);

            $question_info=SiteExamQuestionInfo::
                where('academic_version_id', $request->academic_version_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->whereIn('academic_subject_id', $exam_dependent_subject_ids)
                ->get();
        }

        $question_ids=$question_info->pluck('id');

        $question_list=SiteExamQuestion::whereIn('site_exam_question_info_id', $question_ids)
            ->where('module_key','exam')
            ->orderBy('id','desc')
            ->get();



        $declared_question_list=SiteExamQuestionDeclare::
            where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->where('examination_id',  $request->examination_id)
            ->where('site_exam_declare_id', $examDeclareIDs->first())
            ->where('academic_exam_type_id', $request->academic_exam_type_id)
            ->first();

        if($declared_question_list){

           $site_exam_question_ids=array_map('intval', explode(',', $declared_question_list->site_exam_question_ids));

            $per_student_question_quantity=$declared_question_list->per_student_question_quantity;
            $exam_time=$declared_question_list->exam_time;

        }else{
            $site_exam_question_ids=[];

            $per_student_question_quantity=null;
            $exam_time=null;

        }


        return response()->json(
            [
                'question_list'=>$question_list,
                'site_exam_question_ids'=>$site_exam_question_ids,
                'per_student_question_quantity'=>$per_student_question_quantity,
                'exam_time'=>$exam_time,

            ]);



    }




    public function createSiteStudentQuestionDeclare(SiteExamQuestionDeclare $declare, Request $request){


        $this->validate($request, [
            "academic_class_id" => "required",
            "academic_shift_id" => "required",
            "academic_year_id" => "required",
            "examination_id" => "required",
            "site_subject_group_condition_setting_id" => "required",
            "academic_exam_type_id" => "required",
            "question_quantity" => "required",
            "exam_time" => "required",
        ]);


        ini_set('memory_limit', '-1');

        $data = $request->all();

        $examDeclareIDs = $this->getDeclareId($request);
        
        $declared_student_first_list=SiteExamDeclareStudentSubject::whereIn('site_exam_declare_id', $examDeclareIDs)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->where('academic_exam_type_id', $request->academic_exam_type_id)
            ->select('id', 'student_history_id')
            ->get();

        $count_student=count($declared_student_first_list);

        $declared_student_not_created_list=$declared_student_first_list
            ->whereNotIn('student_history_id', $request->completed_student_id_array);


        $declared_student_list=$declared_student_not_created_list->take(20);




        $get_selected_question = array_map('intval', collect($request->site_exam_question_ids)->toArray());

        if ($request->question_quantity > count($request->site_exam_question_ids)) {
            return Response::json([
                'message' => 'Question quantity can not grater then selected question!',
                'mode' => 'error!'], 412);
        }

            SiteExamDeclareStudentSubject::whereIn('id', $declared_student_list->pluck('id'))
                ->update([
                    'online_exam_time' => $request->exam_time
                ]);

            $declared_question_list = SiteExamQuestionDeclare::
            where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                ->where('examination_id', $request->examination_id)
                ->where('site_exam_declare_id', $examDeclareIDs->first())
                ->where('academic_exam_type_id', $request->academic_exam_type_id)
                ->first();

            if ($declared_question_list) {

                $declared_question_list->per_student_question_quantity = $request->question_quantity;
                $declared_question_list->exam_time = $request->exam_time;
                $declared_question_list->site_exam_question_ids = collect($get_selected_question)->implode(',');

                $declared_question_list->save();

                $declare_id = $declared_question_list->id;
            } else {
                $declare->site_exam_declare_id = $examDeclareIDs->first();
                $declare->examination_id = $request->examination_id;
                $declare->academic_exam_type_id = $request->academic_exam_type_id;
                $declare->per_student_question_quantity = $request->question_quantity;
                $declare->exam_time = $request->exam_time;
                $declare->site_exam_question_ids = collect($get_selected_question)->implode(',');
                $declare->site_subject_group_condition_setting_id = $request->site_subject_group_condition_setting_id;
                $declare->site_id = \Session::get('SITE_ID');
                $declare->status = true;

                $declare->save();
                $declare_id = $declare->id;
            }


        $question_full_list = SiteExamQuestion::whereIn('id', $get_selected_question)
            ->with(['siteExamQuestionDetailList'])
            ->select('id')
            ->get();

        $option_arr = Array();
        $question_array = [];
        foreach ($question_full_list as $key => $value) {

            $option_arr['option_ids'] = collect($value->siteExamQuestionDetailList)->pluck('id');
            $option_arr['answer_ids'] = collect($value->siteExamQuestionDetailList)->where('answer_status', true)->pluck('id');


            $question_array[$key] = array_merge($option_arr, $value->toArray());
        }

        $created_student_question_all_list=SiteExamStudentQuestion::where('site_exam_question_declare_id', $declare_id)
            ->whereIn('student_history_id', $declared_student_list->pluck('student_history_id'))
            ->get();

        if(count($created_student_question_all_list)>0){
            $present_ids=$created_student_question_all_list->pluck('id');
        }else{
            $present_ids=[];
        }

        $created=[];
        $present_std_question_ids=[];
        foreach ($declared_student_list as $key => $value) {

            $rendom_question=collect($get_selected_question)->random($request->question_quantity)->shuffle();

            if(count($created_student_question_all_list)>0){
                $created_student_question=$created_student_question_all_list
                    ->where('student_history_id', $value->student_history_id);
            }else{
                $created_student_question=[];
            }


            foreach ($rendom_question as $keys => $values) {
                $check_data=collect($question_array)->where('id', $values)->first();
                if($check_data){
                    $options_id=collect($check_data['option_ids'])->random(count($check_data['option_ids']))->shuffle();

                    if(count($created_student_question)>0){
                        $present_question=$created_student_question->where('site_exam_question_id', $values)->first();

                        if($present_question){

                            $present_std_question_ids[]=$present_question->id;

                            $same_answer_check=array_diff($check_data['answer_ids']->toArray(), explode(',',$present_question->answer_ids));
                            $same_answer_question_detail=array_diff($options_id->toArray(), $present_question->site_exam_question_detail_ids[0]);

                            if(count($same_answer_check)>0 || count($same_answer_question_detail)>0){
                                $present_question->answer_ids=collect($check_data['answer_ids'])->implode(',');
                                $present_question->site_exam_question_detail_ids=collect($options_id)->implode(',');
                                $present_question->site_exam_declare_student_subject_id=$value->id;

                                $present_question->save();
                            }
                        }
                        else{
                            $created[] = [
                                'site_exam_declare_id' => $examDeclareIDs->first(),
                                'site_exam_question_declare_id' => $declare_id,
                                'student_history_id' => $value->student_history_id,
                                'site_exam_declare_student_subject_id' => $value->id,
                                'site_exam_question_id' => $values,
                                'site_exam_question_detail_ids' => collect($options_id)->implode(','),
                                'answer_ids' => collect($check_data['answer_ids'])->implode(','),
                                'status' => true,
                                'site_id' => Session::get('SITE_ID'),
                            ];
                        }
                    }
                    else{
                        $options_id=collect($check_data['option_ids'])->random(count($check_data['option_ids']))->shuffle();

                        $created[] = [
                            'site_exam_declare_id' => $examDeclareIDs->first(),
                            'site_exam_question_declare_id' => $declare_id,
                            'student_history_id' => $value->student_history_id,
                            'site_exam_declare_student_subject_id' => $value->id,
                            'site_exam_question_id' => $values,
                            'site_exam_question_detail_ids' => collect($options_id)->implode(','),
                            'answer_ids' => collect($check_data['answer_ids'])->implode(','),
                            'status' => true,
                            'site_id' => Session::get('SITE_ID'),
                        ];
                    }

                }

            }

        }



        if(count($present_ids)>0){
            $siteUncheckedColumn=array_diff($present_ids->toArray(), $present_std_question_ids);
            SiteExamStudentQuestion::whereIn('id', $siteUncheckedColumn)->delete();
        }



        if(count($created)>0){
            SiteExamStudentQuestion::insert($created);
        }

        $selected_twenty_student_ids=$declared_student_list->pluck('student_history_id');

        $completed_student_id_array=array_merge($request->completed_student_id_array, $selected_twenty_student_ids->toArray());
        $completed_percent=ceil(count($completed_student_id_array)*100/$count_student);
        return response()->json(
            [
                'completed_student_id_array'=>$completed_student_id_array,
                'count_student'=>$count_student,
                'completed_percent'=>$completed_percent,
            ]);

    }



    //==============Student Question List Show

    public function siteExamTypeStudentQuestionDeclareList(Request $request){

        $data = $request->all();

        $examDeclareIDs = $this->getDeclareId($request);



        $student_list = StudentHistory::with(['student'=>function($query){
            $query->select('id');
        }])
            ->select('id', 'user_id', 'student_roll_number')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('academic_department_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->get();


        $declared_student_list=SiteExamDeclareStudentSubject::whereIn('site_exam_declare_id', $examDeclareIDs)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->where('academic_exam_type_id', $request->academic_exam_type_id)
            ->whereIn('student_history_id', $student_list->pluck('id'))
            ->select('id', 'student_history_id')
            ->get();


        $declared_question_list = SiteExamQuestionDeclare::
        where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->where('examination_id', $request->examination_id)
            ->where('site_exam_declare_id', $examDeclareIDs->first())
            ->where('academic_exam_type_id', $request->academic_exam_type_id)
            ->first();


        $created_student_question_all_list=SiteExamStudentQuestion::where('site_exam_question_declare_id', $declared_question_list->id)
            ->whereIn('student_history_id', $declared_student_list->pluck('student_history_id'))
            ->select('student_history_id', DB::raw('count(*) as total_question'))
            ->groupBy('student_history_id')
            ->get();


        $exam_declated_student_list=$student_list->whereIn('id', $declared_student_list->pluck('student_history_id'));


        $question_list_arr=Array();
        $student_question_list_array=[];
        foreach ($exam_declated_student_list as $key => $value) {

            $check_student=$created_student_question_all_list->where('student_history_id', $value->id)->first();


            if($check_student){
                $question_list_arr['question_count']=$check_student->total_question;
            }
            else{
                $question_list_arr['question_count']=0;
            }
            $question_list_arr['id']=$value->id;
            $question_list_arr['full_name']=$value->full_name;
            $question_list_arr['student_roll_number']=$value->student_roll_number;


            $student_question_list_array[$key]=$question_list_arr;

        }


        return response()->json(
            [
                'student_question_list_array'=>$student_question_list_array,

            ]);

    }

    public function siteStudentExamQuestionListShow(Request $request){

        $data = $request->all();

        $examDeclareIDs = $this->getDeclareId($request);

        $declared_question_list = SiteExamQuestionDeclare::
        where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->where('examination_id', $request->examination_id)
            ->where('site_exam_declare_id', $examDeclareIDs->first())
            ->where('academic_exam_type_id', $request->academic_exam_type_id)
            ->first();


        $created_student_question_all_list=SiteExamStudentQuestion::with(['siteExamQuestion' => function ($query) {
            $query->with(['photo']);
        }])
        ->where('site_exam_question_declare_id', $declared_question_list->id)
            ->where('student_history_id', $request->student_history_id)
            ->get();




        $question_arr = Array();
        $question_array = [];
        foreach ($created_student_question_all_list as $key => $value) {

            $question_arr['id'] = $value->id;
            $question_arr['question'] = $value->siteExamQuestion->question;
            $question_arr['photo'] = $value->siteExamQuestion->photo;


            $question_arr['multiple_answer'] = count(explode(',', $value->answer_ids)) > 1 ? true : false;


            if (count(explode(',', $value->answer_ids)) > 1) {
                $question_arr['student_answer_ids'] = array_map('intval', explode(',', $value->student_answer_ids));
                $question_arr['answer_ids'] = array_map('intval', explode(',', $value->answer_ids));

                $answer_diff=array_diff($question_arr, $question_arr);

                if(count($answer_diff)==0){
                    $question_arr['correct_answer_status']=true;
                }else{
                    $question_arr['correct_answer_status']=false;
                }


            } else {
                $question_arr['student_answer_ids'] = collect(array_map('intval', explode(',', $value->student_answer_ids)))->first();
                $question_arr['answer_ids'] = collect(array_map('intval', explode(',', $value->answer_ids)))->first();

                if($question_arr['student_answer_ids']==$question_arr['answer_ids']){
                    $question_arr['correct_answer_status']=true;
                }else{
                    $question_arr['correct_answer_status']=false;
                }
            }


            $option_arr = Array();
            $option_array = [];
            foreach ($value->site_exam_question_detail_ids[1] as $keys => $values) {

                $option_arr['id'] = $values->id;
                $option_arr['question_option'] = $values->option;

                $option_array[$keys] = $option_arr;
            }

            $question_arr['question_option_list'] = collect($option_array)->values();
            $question_arr['question_show'] = false;
            $question_arr['question_show_value'] = 0;

            $question_array[$key] = $question_arr;
        }


        return response()->json(
            [
                'question_array'=>$question_array,

            ]);



    }







}
