<?php

namespace App\Http\Controllers\Site\Exam;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicClassGroup;
use App\Http\Controllers\ProjectController;

use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Auth;
use App\Models\AcademicYear\AcademicYear;

use Carbon\Carbon;
use App\Models\Site\SiteInfo;
use Illuminate\Support\Facades\Log;
use Response;
use Session;

class SiteBaseExamMarksSendController extends ProjectController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Site Exam Marks Entry Page';

        return view('default.admin.layouts.master', compact('viewType'));
     //   return view('default.admin.site.exam.site-base-exam-marks-entry', compact('viewType'));

    }

    public function getSiteDepartmentClassBaseExamination(Request $request){

        $data = $request->all();

        $examinationAll = SiteExamDeclares::
            where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
//            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
//                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//            })
//            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
//                return $query->where('academic_section_id', $data['academic_section_id']);
//            })
//            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
//                return $query->where('academic_session_id', $data['academic_session_id']);
//            })
            ->where('exam_declared_by','site')
            ->pluck('examination_id')
            ->unique();



        $examination_list=Examination::whereIn('id', $examinationAll)->where('use_key','site')->get();


        return $examination_list;
    }



    public function getSiteExaminationBaseSubjectList(Request $request){

        $data=$request->all();
        
        $declareListIds = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->where('exam_declared_by','site')
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('id');


        $studentHistoryIds=StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('student_roll_number', 'asc')
            ->pluck('id');


            $site_subject_group_condition_setting_ids=SiteExamDeclareStudentSubject::with(['academicExamType'])
                ->whereIn('site_exam_declare_id', $declareListIds)
                ->whereIn('student_history_id', $studentHistoryIds)
                ->pluck('site_subject_group_condition_setting_id')
                ->unique()
                ->values();
    
            $subjectIDs_array=SubjectGroupConditionSetting::whereIn('id', $site_subject_group_condition_setting_ids)->get();
            
            return $subjectIDs_array;

    }


    public function getSiteBaseStudentMarkListForSmsMarks(Request $request){

        $data = $request->all();

        //// header data
        $examination = Examination::where('id',$data['examination_id'])->first();
        $academic_class_group = AcademicClassGroup::find($data['academic_class_group_id']);
        $academic_group_condition = SubjectGroupConditionSetting::with('academicYear','academicClass','academicDepartment')->where('id',$data['site_subject_group_condition_setting_id'])->first();
        $site_info = SiteInfo::find(Session::get('SITE_ID'));

        $header_data=[
            'examination_name'=>$examination?$examination->examination_name:'',
            'year_name'=>$academic_group_condition->academicYear?$academic_group_condition->academicYear->year_name:'',
            'subject_name'=>$academic_group_condition?$academic_group_condition->subject_name:'',
            'class_name'=>$academic_group_condition->academicClass?$academic_group_condition->academicClass->class_name:'',
            'department_name'=>$academic_group_condition->academicDepartment?$academic_group_condition->academicDepartment->name:'',
            'group_name'=>$academic_class_group?$academic_class_group->group_name:'',
            'site_name'=>$site_info->site_name,
            'site_address'=>$site_info->address,
            'site_id'=>Session::get('SITE_ID'),
            'site_alias'=>$site_info->site_alias,
        ];

       // return $header_data;

        //======


        $examDeclaredList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
//            ->where('site_subject_group_condition_setting_ids', $request->site_subject_group_condition_setting_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
//            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
//                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//            })
//            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
//                return $query->where('academic_section_id', $data['academic_section_id']);
//            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
            ->where('exam_declared_by','site')
            ->pluck('id');



        $studentIds=StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
            ->where('status',true)
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_department_id')
            ->orderBy('site_batch_detail_id')
            ->orderBy('academic_class_group_id')
            ->pluck('id');




        $declaredStudentList=SiteExamDeclareStudent::with(['siteExamDeclareStudentSubject'=>function($query) use ($request){
            $query->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id);

            $query->with(['academicExamType']);
            $query->with(['marksInputBy'=>function($q) use ($request){
                $q->select('id');
            }]);
//            $query->select('id', 'site_exam_declare_id', 'student_history_id', 'exam_attendance_status', 'site_subject_group_condition_setting_id',
//                'exam_held_status', 'obtaine_marks', 'grace_marks', 'pass_mark', 'subject_exam_type_mark');

        },
            'studentHistory'=>function($querys) use ($data){

                $querys->select('id', 'user_id', 'student_roll_number');
                // $querys->when(!empty($data['academic_class_group_id']), function ($q) use ($data) {
                //     return $q->where('academic_class_group_id', $data['academic_class_group_id']);
                // });

            }])
          
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->get();

          //  return $declaredStudentList;

     //   $student_list2=[];
        $student_list=[];
        foreach ($declaredStudentList as $key => $value) {
          
            if(count($value->siteExamDeclareStudentSubject)>0){

                $total_countable_exam_type=0;
                $student_value=[];

                $declare_student_subject=[];

                foreach($value->siteExamDeclareStudentSubject as $keys=>$item){
                    $total_countable_exam_type += $item->countable_obtaine_marks;

                    $declare_student_subject[$keys]['academic_exam_type_id']=$item->academic_exam_type_id;
                    $declare_student_subject[$keys]['exam_type']=$item->academicExamType->marks_type;
                    $declare_student_subject[$keys]['exam_attendance_status']=$item->exam_attendance_status;
                    $declare_student_subject[$keys]['countable_obtaine_marks']=$item->countable_obtaine_marks;
                    $declare_student_subject[$keys]['select_exam_type']=false;
                }

                $student_value['student_exam_type_list']=$declare_student_subject;
                $student_value['total_countable_obtain_mark']=$total_countable_exam_type;
                $student_value['student_history_id']=$value->student_history_id;
                $student_value['student_roll_number']=$value->student_roll_number;
                $student_value['full_name']=$value->studentHistory?$value->studentHistory->full_name:'';
                $student_value['phone']=$value->studentHistory?$value->studentHistory->student->contact_number:'';
                $student_value['full_name']=$value->studentHistory?$value->studentHistory->full_name:'';
                $student_value['select_student']=false;
                $student_value['select_total_mark']=false;
                //   $student_value['value']=$value;

            }

            $student_list[$key]=$student_value;

        }

     //   return $student_list;

      
        // $student_asc_list=array_values(array_sort(collect($student_list), function ($value) {
        //     return $value['student_roll_number'];
        // }));

     

        $getExamTypeList=SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->distinct('academic_exam_type_id')
            ->select('academic_exam_type_id')
            ->get();

        $get_type_ids=$getExamTypeList->pluck('academic_exam_type_id')->unique();


        $getExamType=SiteExaminationExamTypeSetting::with(['academicExamType', 'examination'])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->whereIn('academic_exam_type_id', $get_type_ids)
            ->select('academic_exam_type_id', 'examination_id', 'id')
            ->orderBy('position_show')
            ->get();


        $exam_type_arr=Array();
        $exam_type_array=[];
        foreach ($getExamType as $key => $value) {

            $selected_student_count=SiteExamDeclareStudentSubject::
            whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                ->where('academic_exam_type_id', $value->academic_exam_type_id)
                ->where('exam_attendance_status', true)
                ->count();

            $passed_student_count=SiteExamDeclareStudentSubject::
            whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                ->where('academic_exam_type_id', $value->academic_exam_type_id)
                ->where('exam_attendance_status', true)
                ->whereRaw('obtaine_marks >= pass_mark')
                ->count();

            $failed_student_count=SiteExamDeclareStudentSubject::
            whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                ->where('academic_exam_type_id', $value->academic_exam_type_id)
                ->where('exam_attendance_status', true)
                ->whereRaw('obtaine_marks < pass_mark')
                ->count();

            $exam_type_arr['selected_student_count']=$selected_student_count;
            $exam_type_arr['passed_student_count']=$passed_student_count;
            $exam_type_arr['failed_student_count']=$failed_student_count;
            $exam_type_arr['select_all']=false;


            $exam_type_array[$key]=array_merge($exam_type_arr, $value->toArray());
        }

        return [$student_list, $exam_type_array, $header_data];
    }

    public function sendSingleStudentSms(Request $request){

        
        $data=$request->all();
        if($data['single_student_data']['select_student']){
            $text="";
            $text .= 'Year:'.$data['HeaderData']['year_name'];
            $text .= ', '.'Subject:'.$data['HeaderData']['subject_name'];
            $text .= ', '.'Class:'.$data['HeaderData']['class_name'];
            $text .= ', '.'Name:'.$data['single_student_data']['full_name']; 
            $text .= ', '.'Exam:'.$data['HeaderData']['examination_name'];

            foreach($data['single_student_data']['student_exam_type_list'] as $exam_type){
                if($exam_type['exam_attendance_status'] && $exam_type['select_exam_type']){
                    if(!empty($exam_type['countable_obtaine_marks'])){
                        $text .= ', '.$exam_type['exam_type'].':'. $exam_type['countable_obtaine_marks'];
                    }
                }
             
            }

            if($data['single_student_data']['select_total_mark']){
                $text .= ', '.'Total Mark:'.$data['single_student_data']['total_countable_obtain_mark'];
            }
            $text .= ', '.'Thanks: '.$data['HeaderData']['site_alias'];

            $site_id=$data['HeaderData']['site_id'];
            $phone=$data['single_student_data']['phone'];

  
          $sms_status = $this->sendSms($site_id, [$phone], $text);
        //  dd($sms_status);
           if($sms_status){
                return response()->json(['message'=>'Message Send Successfully', 'status'=>'success'],200);
           }else{
            return response()->json(['message'=>'send message error', 'status'=>'error'],401);
           }

        }else{
          return response()->json(['message'=>'Select Student', 'status'=>'error'],401);
        }

    }

    public function sendMultipleStudentSms(Request $requests){

        
        $data=$requests->all();

     //   return $data;
     $total_send_sms=0;
        foreach($data['StudentList'] as $student){
            
            $total_success_sms=0;
            $total_fail_sms=0;
            if($student['select_student']){

                $text="";
                $text .= 'Year:'.$data['HeaderData']['year_name'];
                $text .= ', '.'Subject:'.$data['HeaderData']['subject_name'];
                $text .= ', '.'Class:'.$data['HeaderData']['class_name'];
                $text .= ', '.'Name:'.$student['full_name']; 
                $text .= ', '.'Exam:'.$data['HeaderData']['examination_name'];

                foreach($student['student_exam_type_list'] as $exam_type){
                    if($exam_type['exam_attendance_status'] && $exam_type['select_exam_type']){
                        if(!empty($exam_type['countable_obtaine_marks'])){
                            $text .= ', '.$exam_type['exam_type'].':'. $exam_type['countable_obtaine_marks'];
                        }
                    }
                 
                }

                if($student['select_total_mark']){
                    $text .= ', '.'Total Mark:'.$student['total_countable_obtain_mark'];
                }
                $text .= ', '.'Thanks: '.$data['HeaderData']['site_alias'];
    
                $site_id=$data['HeaderData']['site_id'];
                $phone=$student['phone'];
    
                $sms_status = $this->sendSms($site_id, [$phone], $text);
                if($sms_status){
                    $total_success_sms++;
                }else{
                    $total_fail_sms++;
                }
                $total_send_sms++;
            }
        }

        return response()->json(['message'=>'Total SMS '.$total_send_sms.' Success '.$total_success_sms.' Fail '.$total_fail_sms, 'status'=>'error'],200);

        
       
    }


 



  


   

}
