<?php

namespace App\Http\Controllers\Site\Exam;

use App\Models\AcademicYear\AcademicYear;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;

use App\Models\Student\StudentHistory;
use Carbon\Carbon;
use App\Models\Academic\AcademicExamType;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicClass;
use App\Models\Room\Room;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo;
use App\Models\Site\YearShiftVersionSessionSectionClassWiseSiteSettings;
use App\Models\Site\Employee\Employee;
use App\Models\SiteGroup\Exam\SiteGroupStudentExamRoll;
use DateTime;
use PDF;
use Response;
use Session;
use View;

class SiteExamAdmitCardAttendanceSheetController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }




    public function index()
    {
        $viewType = 'Site Admit Card or Attendance Sheet';

        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getSiteDepartmentClassBaseExamination(Request $request)
    {

        $data = $request->all();

        $examinationAll = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            //->where('exam_declared_by','site')
            ->pluck('examination_id')
            ->unique();



        $examination_list = Examination::whereIn('id', $examinationAll)->get();


        return $examination_list;
    }


    private function checkSiteClassSettings($request)
    {
        $data = $request->all();

        $admitSettings = YearShiftVersionSessionSectionClassWiseSiteSettings::where('academic_year_id', $data['academic_year_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            // ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
            //         return $query->where('academic_section_id', $data['academic_section_id']);
            //     })
            ->first();
        return $admitSettings;
    }

    public function getSiteAdmitCardDescription(Request $request)
    {

        $admitSettings = $this->checkSiteClassSettings($request);

        return Response::json($admitSettings, 200);
    }
    public function addSiteAdmitCardDescription(Request $request)
    {

        $this->validate($request, [
            "academic_version_id" => "required",
            "academic_class_id" => "required",
            "academic_shift_id" => "required",
            "academic_year_id" => "required",
        ]);

        $admitSettings = $this->checkSiteClassSettings($request);

        if ($admitSettings) {
            $admitSettings->academic_version_id = $request->academic_version_id;
            $admitSettings->academic_year_id = $request->academic_year_id;
            $admitSettings->academic_shift_id = $request->academic_shift_id;
            $admitSettings->academic_class_id = $request->academic_class_id;
            $admitSettings->admit_card_description = $request->admit_card_description;
            $admitSettings->save();
        } else {
            $classWiseSiteSettings = new YearShiftVersionSessionSectionClassWiseSiteSettings;

            // foreach ($classWiseSiteSettings->ownFields as $field) {

            //     if ($request->{$field}) {
            //         $classWiseSiteSettings->{$field} = $request->{$field};
            //     }
            // }
            $classWiseSiteSettings->academic_version_id = $request->academic_version_id;
            $classWiseSiteSettings->academic_year_id = $request->academic_year_id;
            $classWiseSiteSettings->academic_shift_id = $request->academic_shift_id;
            $classWiseSiteSettings->academic_class_id = $request->academic_class_id;
            $classWiseSiteSettings->admit_card_description = $request->admit_card_description;
            $classWiseSiteSettings->save();
        }


        return Response::json(['message' => 'Description update Successfully', 'mode' => 'save'], 200);
    }

    public function studentListForAdmitCard(Request $request)
    {

        $data = $request->all();

        $exam_declare_ids = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->pluck('id');


        $student_ids = SiteExamDeclareStudent::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('status', true)
            ->pluck('student_history_id')
            ->unique()
            ->values();



        $student_list = StudentHistory::whereIn('id', $student_ids)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('student_roll_number')
            ->orderBy('academic_department_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_section_id')
            ->get();
        //   ->pluck('student_roll_number','student_roll_number_prefix','id');

        $roll_list = $student_list->pluck('student_full_roll_number');

        $student_roll_list = implode(', ', $roll_list->toArray());

        return $student_roll_list;
    }

    public function studentExamDetailForAdmitCard(Request $request)
    {

        $data = $request->all();

        $exam_declare_ids = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->pluck('id');

        //   dd($exam_declare_ids);

        $student_ids = SiteExamDeclareStudent::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('status', true)
            ->pluck('student_history_id')
            ->unique()
            ->values();



        $student_list = StudentHistory::whereIn('id', $student_ids)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            // ->where('student_roll_number', '>=', $request->roll_from)
            // ->where('student_roll_number', '<=', $request->roll_to)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_department_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_class_group_id')
            ->get();
        // ->pluck('id')
        // ->values();

        $student_range_ids = $student_list->when(!empty($data['roll_from']) && !empty($data['roll_to']), function ($query) use ($data) {
            return $query->where('student_full_roll_number', '>=', $data['roll_from'])
                ->where('student_full_roll_number', '<=', $data['roll_to']);
        })
            // ->where('student_full_roll_number', '>=', $request->roll_from)
            // ->where('student_full_roll_number', '<=', $request->roll_to)
            ->pluck('id')
            ->values();

        // dd($student_range_ids);

        $subject_settings_ids = SubjectGroupConditionSetting::where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->orderBy('subject_position')
            ->orderBy('subject_code')
            ->get()
            ->pluck('id')
            ->values();

        // dd($subject_settings_ids);

        $placeholders = implode(',', array_fill(0, count($subject_settings_ids), '?'));

        $student_list = StudentHistory::with(['siteExamDeclareStudentSubject' => function ($query) use ($exam_declare_ids, $placeholders, $subject_settings_ids) {
            $query->with(['subjectGroupConditionSetting' => function ($q) {
                $q->select('id', 'academic_subject_id', 'subject_code', 'subject_position');
                $q->orderBy('id');
            }]);
            $query->with('academicExamType', 'routine');
            $query->whereIn('site_exam_declare_id', $exam_declare_ids);
            $query->distinct('student_history_id', 'site_subject_group_condition_setting_id');
            $query->select('student_history_id', 'site_subject_group_condition_setting_id', 'site_exam_routine_id');
            $query->groupBy('student_history_id', 'site_subject_group_condition_setting_id');

            $query->orderByRaw("field(site_subject_group_condition_setting_id,{$placeholders})", $subject_settings_ids);
        }, 'siteGroupStudentExamRoll' => function ($qww) use ($request) {
            return $qww->where('examination_id', $request->examination_id);
        }])
            ->with([
                'department',
                'stClass',
                'shift',
                'classGroup',
                'section',
                'session',
                'year',
                'academicStudentCategory',
                'student' => function ($query) {
                    $query->with(['gender', 'religion', 'latestPhoto' => function ($query) {
                        $query->select('name', 'path', 'imageable_id');
                    }]);
                    $query->select('id', 'gender_id', 'religion_id', 'username');
                }
            ])
            ->whereIn('id', $student_range_ids)
            ->select(
                'id',
                'user_id',
                'student_roll_number',
                'academic_year_id',
                'academic_department_id',
                'academic_class_id',
                'academic_shift_id',
                'optional_subject_ids',
                'academic_student_category_id',
                'academic_class_group_id',
                'academic_section_id',
                'academic_session_id',
                'student_roll_number_prefix'
            )

            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_department_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_class_group_id')
            ->get();

        $student_list->transform(function ($student_history) {
            $optional_ids = $student_history->optional_subject_ids[1] ?? [];

            $student_history->exam_declare_subjects = $student_history->siteExamDeclareStudentSubject

                // Then sort them by the raw date
                ->sortBy(function ($subject) {
                    return $subject->routine->exam_start_date;
                })
                // Now map the sorted subjects
                ->map(function ($subject) use ($optional_ids) {
                    $subject_name = $subject->subjectGroupConditionSetting->subject_name ?? '';

                    if (in_array($subject->subjectGroupConditionSetting->academic_subject_id ?? null, $optional_ids)) {
                        $subject_name .= ' (4th subject)';
                    }

                    return [
                        'site_subject_group_condition_setting_id' => $subject->site_subject_group_condition_setting_id,
                        'student_history_id' => $subject->student_history_id,
                        'subject_name' => $subject_name ?? '',
                        'subject_code' => $subject->subjectGroupConditionSetting->subject_code ?? '',
                        'exam_date' => isset($subject->routine->exam_start_date)
                            ? Carbon::parse($subject->routine->exam_start_date)->format('d-M-Y')
                            : '',
                    ];
                })
                ->values() // reset the keys
                ->toArray();

            return $student_history;
        });

        return $student_list;
    }

    
    public function studentExamDetailForAttendanceSheet(Request $request)
    {

        $data = $request->all();

        $exam_declare_list = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->get();

        $exam_declare_ids = $exam_declare_list->pluck('id');


        $student_ids = SiteExamDeclareStudent::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('status', true)
            ->pluck('student_history_id')
            ->unique()
            ->values();

        $student_history_list = StudentHistory::with(['siteExamDeclareStudentSubject' => function ($query) use ($exam_declare_ids) {
            $query->with(['subjectGroupConditionSetting' => function ($q) {
                $q->select('id', 'academic_subject_id', 'subject_code');
                $q->orderBy('subject_position');
            }]);
            $query->with('academicExamType', 'routine');

            $query->whereIn('site_exam_declare_id', $exam_declare_ids);
            //  $query->distinct('student_history_id', 'site_subject_group_condition_setting_id');
            $query->groupBy('student_history_id', 'site_subject_group_condition_setting_id');
            $query->select('id', 'site_exam_declare_id', 'academic_exam_type_id', 'student_history_id', 'site_subject_group_condition_setting_id');
        }, 'siteGroupStudentExamRoll' => function ($qww) use ($request) {
            return $qww->where('examination_id', $request->examination_id);
        }])
            ->with([
                'department',
                'stClass',
                'shift',
                'classGroup',
                'section',
                'session',
                'year',
                'academicStudentCategory',
                'student' => function ($query) {
                    $query->with(['gender', 'religion', 'latestPhoto' => function ($query) {
                        $query->select('name', 'path', 'imageable_id');
                    }]);
                    $query->select('id', 'gender_id', 'religion_id', 'username');
                }
            ])

            ->whereIn('id', $student_ids)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->select(
                'id',
                'user_id',
                'student_roll_number',
                'academic_year_id',
                'academic_department_id',
                'academic_class_id',
                'academic_shift_id',
                'optional_subject_ids',
                'academic_student_category_id',
                'academic_class_group_id',
                'academic_section_id',
                'academic_session_id',
                'student_roll_number_prefix'
            )

            ->orderBy('academic_department_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_section_id')
            ->orderBy('student_roll_number', 'ASC')
            ->get();

        $student_range_ids = $student_history_list
            ->when(!empty($data['roll_from']) && !empty($data['roll_to']), function ($query) use ($data) {
                return $query->where('student_full_roll_number', '>=', $data['roll_from'])
                    ->where('student_full_roll_number', '<=', $data['roll_to']);
            })
            ->pluck('id')
            ->values();



        $student_list = $student_history_list->whereIn('id', $student_range_ids);


        $st_list = [];
        foreach ($student_list as $key => $student_history) {
            $st_list[$key]['full_name'] = $student_history->full_name;
            $st_list[$key]['student_roll_number'] = $student_history->student_roll_number;
            $st_list[$key]['exam_roll_number'] = $student_history->siteGroupStudentExamRoll ? $student_history->siteGroupStudentExamRoll->roll : null;
            $st_list[$key]['registration_no'] = $student_history->registration_no;
            $st_list[$key]['board_registration_number'] = $student_history->board_registration_number;
            $st_list[$key]['student'] = $student_history->student;
            $st_list[$key]['stClass'] = $student_history->stClass;
            $st_list[$key]['department'] = $student_history->department;
            $st_list[$key]['classGroup'] = $student_history->classGroup;
            $st_list[$key]['shift'] = $student_history->shift;
            $st_list[$key]['section'] = $student_history->section;
            $st_list[$key]['session'] = $student_history->session;
            $st_list[$key]['year'] = $student_history->year;
            $st_list[$key]['academicStudentCategory'] = $student_history->academicStudentCategory;
            // $st_list[$key]['test']=$student_history;


            $subject_list = array();

            foreach ($student_history->siteExamDeclareStudentSubject as $keys => $subject) {

                $subject_list[$keys]['site_subject_group_condition_setting_id'] = $subject->site_subject_group_condition_setting_id;
                $subject_list[$keys]['student_history_id'] = $subject->student_history_id;
                $subject_list[$keys]['subject_group_condition_setting'] = $subject->subjectGroupConditionSetting;


                $exam_types = SiteExamDeclareStudentSubject::where('site_subject_group_condition_setting_id', $subject->site_subject_group_condition_setting_id)
                    ->where('student_history_id', $subject->student_history_id)
                    ->where('site_exam_declare_id', $subject->site_exam_declare_id)
                    ->select('id', 'academic_exam_type_id', 'site_exam_routine_id')
                    ->with('academicExamType', 'routine')
                    ->get();
                //  dd($exam_types);
                $exam_type_list = [];
                $exam_type_count = 0;
                if (count($exam_types) > 0) {
                    foreach ($exam_types as $keyss => $item) {
                        $date = new DateTime($item->routine->exam_start_date);

                        $exam_type_count++;
                        $exam_type_list[$keyss]['exam_type'] = $item->academicExamType->marks_type;
                        $exam_type_list[$keyss]['head_key'] = $item->academicExamType->head_key;
                        $exam_type_list[$keyss]['exam_start_date'] = $date->format('d M Y');;
                        $exam_type_list[$keyss]['routine_id'] = $item->site_exam_routine_id;
                        $exam_type_list[$keyss]['id'] = $item->id;
                    }
                }

                //   dd($exam_type_list);


                $subject_list[$keys]['exam_type_count'] = $exam_type_count;
                $subject_list[$keys]['exam_type_list'] = $exam_type_list;
            }
            //   $st_list[$key]['subject']=$subject_list;
            $st_list[$key]['student_subject_list'] = $subject_list;
        }

        //     return $st_list;

        return [$exam_declare_list, $student_range_ids, $st_list];
    }




    public function studentExamDetailForAdmitCardTwoPdf(Request $request)
    {
        ini_set('memory_limit', '-1');


        $page_tittle = "Admit Card";
        $report_tittle = "<b>Admit Card</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Admit Card";

        $req_data = [
            'is_image_show' => $request->is_image_show,
            'is_subject_show' => $request->is_subject_show,
            'is_description_show' => $request->is_description_show,
            'is_exam_date_show' => $request->is_exam_date_show,
            'is_terms_and_condition_show' => $request->is_terms_and_condition_show,
        ];




        $student_list = $this->studentExamDetailForAdmitCard($request);

        //return $student_list;

        $examination = Examination::where('id', $request->examination_id)->first();
        $examination_name = $examination->examination_name;

        $year = AcademicYear::where('id', $request->academic_year_id)->first();
        $year_name = $year->year_name;

        //description
        $institute_head = Employee::where('institute_head', 1)->first();
        $signature = $institute_head->signature ?? '/img/signature/signature.png';


        $admitSettings = $this->checkSiteClassSettings($request);

        $admit_card_description = $admitSettings ? $admitSettings->admit_card_description : "";
        $view = View::make(
            'default.admin.site.exam.report.exam-admit-card-two-pdf',
            compact(
                'student_list',
                'examination',
                'examination_name',
                'year_name',
                'report_tittle',
                'page_tittle',
                'report_tittle2',
                'admit_card_description',
                'title_view',
                'req_data',
                'signature'
            )
        );



        $contents = $view->render();

        $path = storage_path() . '/pdf';

        $mpdf = new \Mpdf\Mpdf();
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;
        $mpdf->allow_charset_conversion = false;

        $htmlChunks = str_split($contents, 999999);



        foreach ($htmlChunks as $chunk) {
            $mpdf->WriteHTML($chunk);
        }

        //  $mpdf->WriteHTML($contents);
        //  $time = 'admission-form-'.$site_list->site_alias.'-'.$file_name_combination . '-' . Carbon::now()->unix();
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $mpdf->Output($path . '/' . $time . '.pdf', 'F');
        $name = $time . '.pdf';

        return Response::json([
            'link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }
    public function studentExamDetailForAdmitCardPdf(Request $request)
    {

        ini_set('memory_limit', '-1');


        $page_tittle = "Admit Card";
        $report_tittle = "<b>Admit Card</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Admit Card";

        $req_data = [
            'is_image_show' => $request->is_image_show,
            'is_subject_show' => $request->is_subject_show,
            'is_description_show' => $request->is_description_show,
            'is_exam_date_show' => $request->is_exam_date_show,
            'is_terms_and_condition_show' => $request->is_terms_and_condition_show,
        ];




        $student_list = $this->studentExamDetailForAdmitCard($request);

        //return $student_list;

        $examination = Examination::where('id', $request->examination_id)->first();
        $examination_name = $examination->examination_name;

        $year = AcademicYear::where('id', $request->academic_year_id)->first();
        $year_name = $year->year_name;

        //description
        $institute_head = Employee::where('institute_head', 1)->first();
        $signature = $institute_head->signature ?? '/img/signature/signature.png';


        $admitSettings = $this->checkSiteClassSettings($request);

        $admit_card_description = $admitSettings ? $admitSettings->admit_card_description : "";

        // $view = PDF::loadView('default.admin.site.exam.report.exam-admit-card-pdf',
        //     compact('student_list', 'examination_name', 'year_name', 'report_tittle',
        //         'page_tittle', 'report_tittle2', 'admit_card_description', 'title_view','req_data'))
        //     ->setWarnings(false);
        $view = View::make(
            'default.admin.site.exam.report.exam-admit-card-pdf',
            compact(
                'student_list',
                'examination',
                'examination_name',
                'year_name',
                'report_tittle',
                'page_tittle',
                'report_tittle2',
                'admit_card_description',
                'title_view',
                'req_data',
                'signature'
            )
        );
        //   ->setWarnings(false);


        // $path = storage_path() . '/pdf';
        // $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        // $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        // $name = $time . '.pdf';


        $contents = $view->render();

        $path = storage_path() . '/pdf';

        $mpdf = new \Mpdf\Mpdf();
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;
        $mpdf->allow_charset_conversion = false;

        $htmlChunks = str_split($contents, 999999);

        // if (!empty($htmlChunks[0])) {
        //     $mpdf->WriteHTML($htmlChunks[0]);
        // }

        foreach ($htmlChunks as $chunk) {
            $mpdf->WriteHTML($chunk);
        }

        //  $mpdf->WriteHTML($contents);
        //  $time = 'admission-form-'.$site_list->site_alias.'-'.$file_name_combination . '-' . Carbon::now()->unix();
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $mpdf->Output($path . '/' . $time . '.pdf', 'F');
        $name = $time . '.pdf';

        return Response::json([
            'link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }


    public function siteExamAttendanceSheetPdf(Request $request)
    {
        ini_set('memory_limit', '-1');


        $page_tittle = "Attendance Sheet";
        $report_tittle = "<b>Attendance Sheet</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Attendance Sheet";

        $req_data = [
            'is_image_show' => $request->is_image_show,
            'is_subject_show' => $request->is_subject_show,
            'is_description_show' => $request->is_description_show,
        ];

        $student_list = $this->studentExamDetailForAdmitCard($request);

        $examination = Examination::where('id', $request->examination_id)->first();
        $examination_name = $examination->examination_name;

        $year = AcademicYear::where('id', $request->academic_year_id)->first();
        $year_name = $year->year_name;


        $row = 14;
        $row_array = [];
        for ($i = 1; $i < $row; $i++) {
            $row_array[] = $i;
        }

        $practical_row = 6;
        $practical_row_array = [];
        for ($e = 1; $e < $practical_row; $e++) {
            $practical_row_array[] = $e;
        }

        $pdf = PDF::loadView(
            'default.admin.site.exam.report.exam-attendance-sheet-pdf',
            compact(
                'student_list',
                'examination_name',
                'year_name',
                'report_tittle',
                'row_array',
                'practical_row_array',
                'page_tittle',
                'report_tittle2',
                'title_view',
                'req_data'
            )
        )
            ->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json([
            'link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }


    public function siteExamStudentListPdf(Request $request)
    {

        ini_set('memory_limit', '-1');



        $req_data = [
            'is_image_show' => $request->is_image_show,
            'is_subject_show' => $request->is_subject_show,
            'is_description_show' => $request->is_description_show,
            'is_exam_date_show' => $request->is_exam_date_show,
        ];

        $get_data = $this->studentExamDetailForAttendanceSheet($request);
        // $student_list=$get_data;
        $student_list = $get_data[2];

        $institute_head = Employee::where('institute_head', 1)->first();
        $signature = $institute_head->signature ?? '/img/signature/signature.png';

        $examination = Examination::where('id', $request->examination_id)->first();
        $examination_name = $examination->examination_name;
       $class_name = AcademicClass::where('id', $request->academic_class_id)->first();

        $year = AcademicYear::where('id', $request->academic_year_id)->first();
        $year_name = $year->year_name;

        $page_tittle = "Student List";
        $report_tittle = "<b>Student List</b> <br/>";
       
        $report_tittle2 = " Class: " . $class_name->class_name . " <br/>";
        $title_view = "Student List";




        $pdf = PDF::loadView(
            'default.admin.site.exam.report.exam-student-list-sheet-pdf',
            compact(
                'student_list',
                'examination',
                'examination_name',
                'year_name',
                'report_tittle',

                'page_tittle',
                'report_tittle2',
                'title_view',
                'req_data',
                'signature'
            )
        )
            ->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json([
            'link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }
    public function siteExamAttendanceSheetTwoPdf(Request $request)
    {
        ini_set('memory_limit', '-1');

        $page_tittle = "Signature Sheet";
        $report_tittle = "<b>Signature Sheet</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Signature Sheet";


        $req_data = [
            'is_image_show' => $request->is_image_show,
            'is_subject_show' => $request->is_subject_show,
            'is_description_show' => $request->is_description_show,
            'is_exam_date_show' => $request->is_exam_date_show,
        ];

        $get_data = $this->studentExamDetailForAttendanceSheet($request);
        // $student_list=$get_data;
        $student_list = $get_data[2];

        $institute_head = Employee::where('institute_head', 1)->first();
        $signature = $institute_head->signature ?? '/img/signature/signature.png';

        $examination = Examination::where('id', $request->examination_id)->first();
        $examination_name = $examination->examination_name;

        $year = AcademicYear::where('id', $request->academic_year_id)->first();
        $year_name = $year->year_name;

        $row = 14;
        $row_array = [];
        for ($i = 1; $i < $row; $i++) {
            $row_array[] = $i;
        }

        $practical_row = 6;
        $practical_row_array = [];
        for ($e = 1; $e < $practical_row; $e++) {
            $practical_row_array[] = $e;
        }

        $pdf = PDF::loadView(
            'default.admin.site.exam.report.exam-attendance-sheet-two-pdf',
            compact(
                'student_list',
                'examination',
                'examination_name',
                'year_name',
                'report_tittle',
                'row_array',
                'practical_row_array',
                'page_tittle',
                'report_tittle2',
                'title_view',
                'req_data',
                'signature'
            )
        )
            ->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json([
            'link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }
    public function siteExamAttendanceSheetThreePdf(Request $request)
    {
        ini_set('memory_limit', '-1');
        // dd('tet');

        $page_tittle = "Signature Sheet";
        $report_tittle = "<b>Signature Sheet</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Signature Sheet";

        $req_data = [
            'is_image_show' => $request->is_image_show,
            'is_subject_show' => $request->is_subject_show,
            'is_description_show' => $request->is_description_show,
        ];

        // dd('$get_data');

        $get_data = $this->studentExamDetailForAttendanceSheet($request);
        $exam_declare_ids = $get_data[0]->pluck('id');
        // $student_ids=$get_data[1];
        $student_list = $get_data[2];
        $all_subject_group_condition = [];
        $keys = 0;
        //       dd($exam_declare_ids);

        foreach ($student_list as $student) {
            foreach ($student['student_subject_list'] as $student_subject) {
                $all_subject_group_condition[$keys]['subject_group_condition_setting'] = $student_subject['subject_group_condition_setting'];
                $keys++;
            }
        }

        $subject_group_condition = collect($all_subject_group_condition)
            //->pluck('site_subject_group_condition_setting_id')
            ->unique();



        $exam_routine = SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            //  ->whereIn('site_subject_group_condition_setting_id',$subject_group_condition_ids)
            ->orderBy('exam_start_date');

        //    return $exam_routine;

        // $exam_date=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
        //     ->orderBy('site_exam_declare_id');
        // dd();

        //  return $student_list;
        $institute_head = Employee::where('institute_head', 1)->first();
        $signature = $institute_head->signature ?? '/img/signature/signature.png';

        $examination = Examination::where('id', $request->examination_id)->first();
        $examination_name = $examination->examination_name;

        $year = AcademicYear::where('id', $request->academic_year_id)->first();
        $year_name = $year->year_name;

        $row = 14;
        $row_array = [];
        for ($i = 1; $i < $row; $i++) {
            $row_array[] = $i;
        }

        $practical_row = 6;
        $practical_row_array = [];
        for ($e = 1; $e < $practical_row; $e++) {
            $practical_row_array[] = $e;
        }

        $pdf = PDF::loadView(
            'default.admin.site.exam.report.exam-attendance-sheet-three-pdf',
            compact(
                'student_list',
                'subject_group_condition',
                'exam_routine',
                'examination_name',
                'year_name',
                'report_tittle',
                'row_array',
                'practical_row_array',
                'page_tittle',
                'report_tittle2',
                'title_view',
                'req_data',
                'signature'
            )
        )
            ->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json([
            'link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }

    public function getRoomListForAttendance(Request $request)
    {

        $room_list = Room::where('status', true)->select('id', 'room_name')->get();
        return $room_list;
    }

    public function studentListForAttendanceSheet(Request $request)
    {

        $data = $request->all();

        $exam_declare_ids = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->pluck('id');


        $student_ids = SiteExamDeclareStudent::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('status', true)
            ->pluck('student_history_id')
            ->unique()
            ->values();

        $student_list = StudentHistory::whereIn('id', $student_ids)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->select('id', 'user_id', 'student_roll_number')
            ->orderBy('student_roll_number')
            ->orderBy('academic_department_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_section_id')
            ->get();
        $student_history_ids = $student_list->pluck('student_roll_number');

        $student_roll_list = implode(', ', $student_history_ids->toArray());

        return [$student_list, $student_roll_list];
    }


    public function siteExamShortAttendanceSheet(Request $request)
    {

        $data = $request->all();

        $examDeclare = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->first();
        //     dd($examDeclare);

        $site_info = SiteInfo::find(Session::get('SITE_ID'));
        $academic_class_group = AcademicClassGroup::find($data['academic_class_group_id']);

        $room = Room::where('id', $request->room_id)
            ->where('status', true)
            ->select('id', 'room_name')
            ->first();

        $header_data = [
            'examination_name' => $examDeclare->examination ? $examDeclare->examination->examination_name : '',
            'year_name' => $examDeclare->year ? $examDeclare->year->year_name : '',
            'class_name' => $examDeclare->stClass ? $examDeclare->stClass->class_name : '',
            'department_name' => $examDeclare->department ? $examDeclare->department->name : '',
            'group_name' => $academic_class_group ? $academic_class_group->group_name : '',
            'site_name' => $site_info->site_name,
            'site_address' => $site_info->address,
            'roll_from' => $request->roll_from,
            'roll_to' => $request->roll_to,
            'room_name' => $room ? $room->room_name : '',
        ];

        // return $header_data;

        //======

        $examination_id = $examDeclare->examination_id ?? '';
        //    $examDeclaredIds=$examDeclare->pluck('id');
        $examDeclaredId = $examDeclare->id;
        //  dd($examDeclare->pluck('id'));

        $students_history_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
            // ->where('student_roll_number', '>=', $request->roll_from)
            // ->where('student_roll_number', '<=', $request->roll_to)
            ->when(!empty($data['select_student_user_ids']), function ($query) use ($data) {
                return $query->whereIn('id', $data['select_student_user_ids']);
            })
            ->when(!empty($data['roll_from']), function ($query) use ($data) {
                return $query->where('student_roll_number', '>=', $data['roll_from']);
            })
            ->when(!empty($data['roll_to']), function ($query) use ($data) {
                return $query->where('student_roll_number', '<=', $data['roll_to']);
            })

            // ->whereIn('id', $data['select_student_user_ids'])
            ->where('status', true)
            ->with('student')
            ->orderBy('student_roll_number')
            ->pluck('id');


        $all_exam_type_ids = SiteExamDeclareStudentSubject::whereIn('student_history_id', $students_history_ids)
            ->where('site_exam_declare_id', $examDeclaredId)
            ->pluck('academic_exam_type_id')->unique();

        $examTypeList = AcademicExamType::whereIn('id', $all_exam_type_ids)->select('id', 'marks_type')->get();

        $subjectList = SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->where('site_exam_declare_id', $examDeclaredId)
            ->whereIn('student_history_id', $students_history_ids)
            ->groupBy('site_subject_group_condition_setting_id')
            ->with(['subjectGroupConditionSetting' => function ($query) {
                //   $query->select('academic_subject_id');
                $query->with('academicSubject');
            }])
            ->select('academic_exam_type_id', 'site_subject_group_condition_setting_id')
            ->get();

        //   return $subjectList;

        $subject_list = [];

        foreach ($subjectList as $key => $subject) {
            $subject_list[$key]['subject_name'] = $subject->subjectGroupConditionSetting->academicSubject->subject_name;
            $subject_list[$key]['site_subject_group_condition_setting_id'] = $subject->site_subject_group_condition_setting_id;
        }

        $site_subject_group_condition_setting_ids = collect($subject_list)->pluck('site_subject_group_condition_setting_id');




        $student_list = StudentHistory::with(['siteExamDeclareStudentSubject' => function ($query) use ($examDeclaredId, $examination_id) {
            $query->where('examination_id', $examination_id)
                ->with(['subjectGroupConditionSetting' => function ($q) {
                    $q->select('id', 'academic_subject_id', 'subject_code');
                    $q->orderBy('subject_position');
                }]);
            $query->with('academicExamType');

            $query->where('site_exam_declare_id', $examDeclaredId);
            //  $query->with('sameSubject');
            $query->distinct('student_history_id', 'site_subject_group_condition_setting_id');
            //  $query->groupBy('site_subject_group_condition_setting_id');
            //  $query->select('id','obtaine_marks','site_exam_declare_id','academic_exam_type_id','student_history_id', 'site_subject_group_condition_setting_id');
        }, 'siteGroupStudentExamRoll' => function ($qww) use ($request) {
            return $qww->where('examination_id', $request->examination_id);
        }])
            ->with([
                'department',
                'stClass',
                'shift',
                'classGroup',
                'section',
                'session',
                'year',
                'academicStudentCategory',
                'student' => function ($query) {
                    $query->with(['gender', 'religion', 'latestPhoto' => function ($query) {
                        $query->select('name', 'path', 'imageable_id');
                    }]);
                    $query->select('id', 'gender_id', 'religion_id');
                }
            ])
            ->whereIn('id', $students_history_ids)
            ->select(
                'id',
                'user_id',
                'student_roll_number',
                'academic_year_id',
                'academic_department_id',
                'academic_class_id',
                'academic_shift_id',
                'optional_subject_ids',
                'academic_student_category_id',
                'academic_class_group_id',
                'academic_section_id',
                'academic_session_id',
                'student_roll_number_prefix'
            )
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_department_id')
            ->orderBy('academic_session_id')
            ->get();

        foreach ($student_list as $key => $history) {

            $declare_subjectss = [];
            //   return $subject_list;
            foreach ($subject_list as $keysy => $subject) {
                $StudentSubjects = $history->siteExamDeclareStudentSubject
                    ->where('site_subject_group_condition_setting_id', $subject['site_subject_group_condition_setting_id']);

                $exam_type = [];
                foreach ($examTypeList as $keys => $examType) {

                    $st_exam_type = $StudentSubjects->where('academic_exam_type_id', $examType->id)
                        ->first();

                    if ($st_exam_type) {
                        $exam_type[$keys]['obtaine_marks'] = $st_exam_type->obtaine_marks;
                        $exam_type[$keys]['academic_exam_type_id'] = $st_exam_type->academic_exam_type_id;
                        $exam_type[$keys]['exam_type'] = $examType->marks_type;
                    } else {
                        $exam_type[$keys]['obtaine_marks'] = "";
                        $exam_type[$keys]['academic_exam_type_id'] = $examType->id;
                        $exam_type[$keys]['exam_type'] = $examType->marks_type;
                    }
                }

                $declare_subjectss[$keysy]['exam_types'] = $exam_type;
                $declare_subjectss[$keysy]['site_subject_group_condition_setting_id'] = $subject['site_subject_group_condition_setting_id'];
            }

            $student_array[$key]['full_name'] = $history->full_name;
            $student_array[$key]['student_full_roll_number'] = $history->student_full_roll_number;
            $student_array[$key]['exam_roll_number'] = $history->siteGroupStudentExamRoll ? $history->siteGroupStudentExamRoll->roll : null;
            $student_array[$key]['shift'] = $history->shift ? $history->shift->shift_name : '';
            $student_array[$key]['group'] = $history->classGroup ? $history->classGroup->group_name : '';
            $student_array[$key]['section'] = $history->section ? $history->section->section_name : '';
            $student_array[$key]['year'] = $history->year ? $history->year->year_name : '';
            $student_array[$key]['subject_list'] = $declare_subjectss;
        }

        $exam_routine = SiteExamRoutine::where('site_exam_declare_id', $examDeclare->id)
            ->whereIn('site_subject_group_condition_setting_id', $site_subject_group_condition_setting_ids)
            ->groupBy('site_subject_group_condition_setting_id')
            ->orderBy('exam_start_date')
            ->get();

        return [$student_array, $examTypeList, $header_data, $subject_list, $exam_routine];
    }
}
