<?php

namespace App\Http\Controllers\Site\Exam;

use App\Models\Academic\AcademicExamType;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Exam\SiteSubjectExaminationExamTypeMark;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Response;
use Session;
use DB;

class SiteExaminationExamTypeSettingController extends Controller
{
    private $SiteExaminationExamTypeSetting;
    private $siteSubjectExaminationMark;
    private $siteSubjectExaminationExamTypeMark;

    public function __construct(SiteExaminationExamTypeSetting $SiteExaminationExamTypeSetting, SiteSubjectExaminationMark $siteSubjectExaminationMark,
    SiteSubjectExaminationExamTypeMark $siteSubjectExaminationExamTypeMark)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->SiteExaminationExamTypeSetting = $SiteExaminationExamTypeSetting;
        $this->siteSubjectExaminationMark = $siteSubjectExaminationMark;
        $this->siteSubjectExaminationExamTypeMark = $siteSubjectExaminationExamTypeMark;
    }

    public function index()
    {
        $viewType = 'Site Examination & Exam Type Setting Page';

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.site.exam.site-examination-exam-type-setting', compact('viewType'));

    }


    public function getSiteExaminationExamTypeList(Request $request){


        $siteInfoSettinglist=SiteInfoSetting::select('examination_ids','academic_exam_type_ids')->first();

        $examinationSplite = explode(',', $siteInfoSettinglist->examination_ids);
        $examinationList = Examination::whereIn('id', $examinationSplite)->where('use_key','site')->get();


        $examTypeSplite = explode(',', $siteInfoSettinglist->academic_exam_type_ids);
        $examTypeList = AcademicExamType::whereIn('id', $examTypeSplite)->get();


        $data = $request->all();
        $examinationExamTypePresent=SiteExaminationExamTypeSetting::
            where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->get();
          
        if(count($examinationExamTypePresent)<=0){

            $simpleExaminationExamTypePresent=SiteExaminationExamTypeSetting::
            whereNull('academic_year_id')
                ->whereNull('academic_class_id')
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_department_id');
                })
                ->get();

            if(count($simpleExaminationExamTypePresent)<=0){

                $examinationExamTypeArray=[];
                $examinationExamTypeArr=Array();
                foreach ($examinationList as $key => $value) {

                    $examinationExamTypeArr['select_examination_id']=false;
                    $examinationExamTypeArr['retack_allow']=false;
                    $examinationExamTypeArr['direct_result_input']=false;
                    $examinationExamTypeArr['admit_card_permission_with_due_payment']=false;

                    $examTypeArr=Array();
                    $examTypeArray=[];
                    foreach ($examTypeList as $keys => $values) {
                        $examTypeArr['select_exam_type_id']=false;
                        $examTypeArr['exam_day']=null;
                        $examTypeArr['position_show']=1;
                        $examTypeArr['type_access_owner']=null;

                        $examTypeArray[$keys]=array_merge($values->toArray(), $examTypeArr);
                    }

                    $examinationExamTypeArr['exam_type_list']=$examTypeArray;

                    $examinationExamTypeArray[$key]=array_merge($value->toArray(), $examinationExamTypeArr);


                }

                return response()->json($examinationExamTypeArray, 200, [], JSON_NUMERIC_CHECK);
            }
            else{
                

                $examinationArray=[];
                $examinationArr=Array();
                foreach ($examinationList as $key => $value) {

                    $examinationPresent=$simpleExaminationExamTypePresent->where('examination_id',$value['id'])->first();

                    if($examinationPresent){
                        $examinationArr['select_examination_id']=true;
                        $examinationArr['retack_allow']=$examinationPresent['retack_allow'];
                        $examinationArr['direct_result_input']=$examinationPresent['direct_result_input'];
                        $examinationArr['admit_card_permission_with_due_payment']=$examinationPresent['admit_card_permission_with_due_payment'];
                    }else{
                        $examinationArr['select_examination_id']=false;
                        $examinationArr['retack_allow']=false;
                        $examinationArr['direct_result_input']=false;
                        $examinationArr['admit_card_permission_with_due_payment']=false;
                    }
                  

                    $examTypeArr=Array();
                    $examTypeArray=[];
                    foreach ($examTypeList as $keys => $values) {
                        $examinationExamTypeList=$simpleExaminationExamTypePresent
                            ->where('examination_id',$value['id'])
                            ->where('academic_exam_type_id',$values['id'])
                            ->first();


                        if($examinationExamTypeList){
                            $examTypeArr['select_exam_type_id']=true;

                            $examTypeArr['exam_day']=$examinationExamTypeList['exam_day'];
                            $examTypeArr['position_show']=$examinationExamTypeList['position_show'];
                            $examTypeArr['type_access_owner']=$examinationExamTypeList['type_access_owner'];
    
                        }else{
                            $examTypeArr['select_exam_type_id']=false;
                            $examTypeArr['exam_day']=null;
                            $examTypeArr['position_show']=1;
                            $examTypeArr['type_access_owner']=null;
                        }

                       
                        $examTypeArray[$keys]=array_merge($values->toArray(), $examTypeArr);
                    }

                    $examinationArr['exam_type_list']=$examTypeArray;

                    $examinationArray[$key]=array_merge($value->toArray(), $examinationArr);
                }

                return response()->json($examinationArray, 200, [], JSON_NUMERIC_CHECK);
            }
        }
        else{
          //  dd('sfsf');
            $examinationArray=[];
            $examinationArr=Array();
            foreach ($examinationList as $key => $value) {

                $examinationPresent=$examinationExamTypePresent->where('examination_id',$value['id'])->first();

                if($examinationPresent){
                    $examinationArr['select_examination_id']=true;
                    
                    $examinationArr['retack_allow']=$examinationPresent['retack_allow'];
                    $examinationArr['direct_result_input']=$examinationPresent['direct_result_input'];
                    $examinationArr['admit_card_permission_with_due_payment']=$examinationPresent['admit_card_permission_with_due_payment'];


                }else{
                    $examinationArr['select_examination_id']=false;
                    $examinationArr['retack_allow']=false;
                    $examinationArr['direct_result_input']=false;
                    $examinationArr['admit_card_permission_with_due_payment']=false;

                }
               

                $examTypeArr=Array();
                $examTypeArray=[];
                foreach ($examTypeList as $keys => $values) {
                    $examinationExamTypeList=$examinationExamTypePresent
                        ->where('examination_id',$value['id'])
                        ->where('academic_exam_type_id',$values['id'])
                        ->first();

                    if($examinationExamTypeList){
                        $examTypeArr['select_exam_type_id']=true;

                        $examTypeArr['exam_day']=$examinationExamTypeList['exam_day'];
                        $examTypeArr['position_show']=$examinationExamTypeList['position_show'];
                        $examTypeArr['type_access_owner']=$examinationExamTypeList['type_access_owner'];
    
                    }else{
                        $examTypeArr['select_exam_type_id']=false;
                        $examTypeArr['exam_day']=null;
                        $examTypeArr['position_show']=null;
                        $examTypeArr['type_access_owner']=null;
                    }

                    $examTypeArray[$keys]=array_merge($values->toArray(), $examTypeArr);
                }

                $examinationArr['exam_type_list']=$examTypeArray;
                $examinationArray[$key]=array_merge($value->toArray(), $examinationArr);
            }

            return response()->json($examinationArray, 200, [], JSON_NUMERIC_CHECK);

        }
    }

    public function createUpdateSiteExaminationExamType(Request $request){

        $data = $request->all();

        $examinationExamTypePresent=SiteExaminationExamTypeSetting::where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->whereHas('examination', function ($query) {
                    $query->where('use_key', 'site');
                })
                ->get();

        if(count($examinationExamTypePresent)<=0){

            $simpleExaminationExamTypePresent=SiteExaminationExamTypeSetting::
            whereNull('academic_year_id')
                ->whereNull('academic_class_id')
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_department_id');
                })
                ->whereHas('examination', function ($query) {
                    $query->where('use_key', 'site');
                })
                ->get();

            if(count($simpleExaminationExamTypePresent)<=0){

                $charges=[];
                foreach ($request->examinationExamTypeList as $key => $value) {

                    $examination=Examination::where('id',$value['id'])->where('use_key','site')->first();
                    if(!$examination){
                       return Response::json(['message'=>'You have no permission'],401); 
                    }

                    if($value['select_examination_id']){

                        foreach ($value['exam_type_list'] as $keys => $values) {
                            if($values['select_exam_type_id']){
                                $charges[] = [
                                    'examination_id'=>$value['id'],
                                    'academic_exam_type_id'=>$values['id'],
                                    'direct_result_input'=>$value['direct_result_input']?true:false,
                                    'admit_card_permission_with_due_payment'=>$value['admit_card_permission_with_due_payment']?true:false,
                                    'retack_allow'=>$value['retack_allow'],
                                    'exam_day'=>$values['exam_day'],
                                    'position_show'=>$values['position_show'],
                                    'type_access_owner'=>$values['type_access_owner'],
                                    'status'=>true,
                                    'site_id'=>Session::get('SITE_ID'),
                                    'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                    'academic_year_id'=>$request->academic_year_id,
                                    'academic_class_id'=>$request->academic_class_id,
                                    'academic_department_id'=>$request->academic_department_id,

                                ];

                            }

                        }

                    }

                }

                if(count($charges)>0){
                    SiteExaminationExamTypeSetting::insert($charges);
                }

            }
            else{

                $presentIDArray=$simpleExaminationExamTypePresent->pluck('id');

                $charges=[];
                $presentID=Array();
                $presentTableIDArray=[];
                foreach ($request->examinationExamTypeList as $key => $value) {

                    if($value['select_examination_id']){

                        foreach ($value['exam_type_list'] as $keys => $values) {
                            if($values['select_exam_type_id']){

                                $checkPresentData=$simpleExaminationExamTypePresent
                                    ->where('examination_id',$value['id'])
                                    ->where('academic_exam_type_id',$values['id'])
                                    ->first();

                                // \Log::info($checkPresentDate);

                                if($checkPresentData){

                                    $checkPresentData->retack_allow=$value['retack_allow'];
                                    $checkPresentData->direct_result_input=$value['direct_result_input']?true:false;
                                    $checkPresentData->admit_card_permission_with_due_payment=$value['admit_card_permission_with_due_payment']?true:false;
                                    $checkPresentData->exam_day=$values['exam_day'];
                                    $checkPresentData->position_show=$values['position_show'];
                                    $checkPresentData->type_access_owner=$values['type_access_owner'];

                                    $checkPresentData->academic_year_id=$request->academic_year_id;
                                    $checkPresentData->academic_class_id=$request->academic_class_id;
                                    $checkPresentData->academic_department_id=$request->academic_department_id;

                                    $checkPresentData->save();

                                    $presentID[$keys]=$checkPresentData->id;
//                                \Log::info($presentID);
                                }else{
                                    $charges[] = [
                                        'examination_id'=>$value['id'],
                                        'academic_exam_type_id'=>$values['id'],
                                        'direct_result_input'=>$value['direct_result_input']?true:false,
                                        'admit_card_permission_with_due_payment'=>$value['admit_card_permission_with_due_payment']?true:false,
                                        'retack_allow'=>$value['retack_allow'],
                                        'exam_day'=>$values['exam_day'],
                                        'position_show'=>$values['position_show'],
                                        'type_access_owner'=>$values['type_access_owner'],
                                        'status'=>true,
                                        'site_id'=>Session::get('SITE_ID'),
                                        'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                        'academic_year_id'=>$request->academic_year_id,
                                        'academic_class_id'=>$request->academic_class_id,
                                        'academic_department_id'=>$request->academic_department_id,

                                    ];
                                }

                            }

                        }

                    }

                    $presentTableIDArray[$key]=array_merge($presentID);

                }


                if(count($charges)>0){
                    SiteExaminationExamTypeSetting::insert($charges);
                }

                $collection = collect($presentTableIDArray);
                $examinationArrayCollapsed = ($collection->collapse())->unique();

                $examinationAbsentCheck=array_diff($presentIDArray->toArray(), $examinationArrayCollapsed->toArray());
                SiteExaminationExamTypeSetting::whereIn('id', $examinationAbsentCheck)->delete();
            }

        }
        else{

            $presentIDArray=$examinationExamTypePresent->pluck('id');

            $charges=[];
            $presentID=Array();
            $presentTableIDArray=[];
            foreach ($request->examinationExamTypeList as $key => $value) {

                if($value['select_examination_id']){

                    foreach ($value['exam_type_list'] as $keys => $values) {
                        if($values['select_exam_type_id']){

                            $checkPresentData=$examinationExamTypePresent
                                ->where('examination_id',$value['id'])
                                ->where('academic_exam_type_id',$values['id'])
                                ->first();

                            // \Log::info($checkPresentDate);

                            if($checkPresentData){

                                $checkPresentData->direct_result_input=$value['direct_result_input']?true:false;
                                $checkPresentData->admit_card_permission_with_due_payment=$value['admit_card_permission_with_due_payment']?true:false;
                                $checkPresentData->retack_allow=$value['retack_allow'];
                                $checkPresentData->exam_day=$values['exam_day'];
                                $checkPresentData->position_show=$values['position_show'];
                                $checkPresentData->type_access_owner=$values['type_access_owner'];

                                $checkPresentData->academic_year_id=$request->academic_year_id;
                                $checkPresentData->academic_class_id=$request->academic_class_id;
                                $checkPresentData->academic_department_id=$request->academic_department_id;


                                $checkPresentData->save();

                                $presentID[$keys]=$checkPresentData->id;
//                                \Log::info($presentID);
                            }else{
                              //  dd($value);
                                $charges[] = [
                                    'examination_id'=>$value['id'],
                                    'academic_exam_type_id'=>$values['id'],
                                    'direct_result_input'=>$value['direct_result_input']?true:false,
                                    'admit_card_permission_with_due_payment'=>$value['admit_card_permission_with_due_payment']?true:false,
                                    'retack_allow'=>$value['retack_allow']?true:false,
                                    'exam_day'=>$values['exam_day'],
                                    'position_show'=>$values['position_show'],
                                    'type_access_owner'=>$values['type_access_owner'],
                                    'status'=>true,
                                    'site_id'=>Session::get('SITE_ID'),
                                    'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                    'academic_year_id'=>$request->academic_year_id,
                                    'academic_class_id'=>$request->academic_class_id,
                                    'academic_department_id'=>$request->academic_department_id,

                                ];
                            }

                        }

                    }

                }

                $presentTableIDArray[$key]=array_merge($presentID);

            }


            if(count($charges)>0){
                SiteExaminationExamTypeSetting::insert($charges);
            }

            $collection = collect($presentTableIDArray);
            $examinationArrayCollapsed = ($collection->collapse())->unique();

            $examinationAbsentCheck=array_diff($presentIDArray->toArray(), $examinationArrayCollapsed->toArray());

            $checkExamTypeSet=SiteSubjectExaminationExamTypeMark::whereIn('site_subject_examination_mark_id',$examinationAbsentCheck)
                ->where('status',true)
                ->get();
            $alert_message=null;
            if($checkExamTypeSet){
                $alert_message='this is tset';
            }else{
                SiteExaminationExamTypeSetting::whereIn('id', $examinationAbsentCheck)->delete();
            }


        }
        if($alert_message){
            return Response::json(['message' => $alert_message, 'mode' => 'Saved!'], 200);
        }else{
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
        }
    }

    
    public function subjectListForExamTypeMarksSetup(Request $request)
    {

        $data=$request->all();

        try {


            if (!$data['academic_class_id'] || !$data['academic_year_id']) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }

            $subjectWithMarks = SubjectGroupConditionSetting::with(['SiteSubjectExaminationMark'=>function($q) use ($data){
                    return $q->with(['siteSubjectExaminationExamTypeMark'=>function($qu){
                        $qu->with('academicExamType');
                    }])->where('examination_id',$data['examination_id']);
                },'academicSubject'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('status', true)
                ->get();


             //  dd($subjectWithMarks);
                $subject_list=[];
                foreach($subjectWithMarks as $key=>$item){

                    //return $item;

                    $prisentExamTypelist=SiteExaminationExamTypeSetting::with(['academicExamType', 'examination'])
                        ->where('academic_class_id', $data['academic_class_id'])
                        ->where('academic_year_id', $data['academic_year_id'])
                        ->where('examination_id', $data['examination_id'])
                        ->when($data['academic_department_id'], function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->where('direct_result_input', false)
                        ->where('status', true)
                        ->get();

                    $exam_type=[];
                    foreach($prisentExamTypelist as $keyss=>$prisent_exam_type){

                        if(count($item->SiteSubjectExaminationMark)){
                            $exam_type_list = $item->SiteSubjectExaminationMark[0]->siteSubjectExaminationExamTypeMark;

                        if(count($exam_type_list)){
                        //    dd('11111');
                            $exam_type_item=$exam_type_list->where('academic_exam_type_id', $prisent_exam_type->academic_exam_type_id)->first();

                            if($exam_type_item){

                                if($exam_type_item->status){

                                    $exam_type[$keyss]['marks']=$exam_type_item->marks;
                                    $exam_type[$keyss]['pass_marks']=$exam_type_item->pass_marks;
                                    $exam_type[$keyss]['exam_type_name']=$exam_type_item->academicExamType->marks_type;
                                    $exam_type[$keyss]['academic_exam_type_id']=$exam_type_item->academic_exam_type_id;
                                    $exam_type[$keyss]['select_exam_type']=true;
                                    $exam_type[$keyss]['countable_marks_status']=$exam_type_item->countable_marks_status;
                                    $exam_type[$keyss]['countable_marks']=$exam_type_item->countable_marks;
                                    $exam_type[$keyss]['countable_persent_of_obtain_marks']=$exam_type_item->countable_persent_of_obtain_marks;
                                }

                            }else{

                                $exam_type[$keyss]['marks']="";
                                $exam_type[$keyss]['pass_marks']="";
                                $exam_type[$keyss]['exam_type_name']=$prisent_exam_type->academicExamType->marks_type;
                                $exam_type[$keyss]['academic_exam_type_id']=$prisent_exam_type->academic_exam_type_id;
                                $exam_type[$keyss]['select_exam_type']=false;
                                $exam_type[$keyss]['countable_marks_status']=false;
                                $exam_type[$keyss]['countable_marks']=null;
                                $exam_type[$keyss]['countable_persent_of_obtain_marks']=null;
                            }
                        }else{
                            $exam_type[$keyss]['marks']="";
                            $exam_type[$keyss]['pass_marks']="";
                            $exam_type[$keyss]['exam_type_name']=$prisent_exam_type->academicExamType->marks_type;
                            $exam_type[$keyss]['academic_exam_type_id']=$prisent_exam_type->academic_exam_type_id;
                            $exam_type[$keyss]['select_exam_type']=false;
                            $exam_type[$keyss]['countable_marks_status']=false;
                            $exam_type[$keyss]['countable_marks']=null;
                            $exam_type[$keyss]['countable_persent_of_obtain_marks']=null;
                        }
                    }else{
                        $exam_type[$keyss]['marks']="";
                        $exam_type[$keyss]['pass_marks']="";
                        $exam_type[$keyss]['exam_type_name']=$prisent_exam_type->academicExamType->marks_type;
                        $exam_type[$keyss]['academic_exam_type_id']=$prisent_exam_type->academic_exam_type_id;
                        $exam_type[$keyss]['select_exam_type']=false;
                        $exam_type[$keyss]['countable_marks_status']=false;
                        $exam_type[$keyss]['countable_marks']=null;
                        $exam_type[$keyss]['countable_persent_of_obtain_marks']=null;
                    }


                }
                if(count($item->SiteSubjectExaminationMark)){
                    $subject_list[$key]['site_subject_group_condition_setting_id']=$item->SiteSubjectExaminationMark[0]->site_subject_group_condition_setting_id;
                    $subject_list[$key]['marks']=$item->SiteSubjectExaminationMark[0]->marks;
                    $subject_list[$key]['pass_marks']=$item->SiteSubjectExaminationMark[0]->pass_marks;

                }else{
                    $subject_list[$key]['site_subject_group_condition_setting_id']="";
                    $subject_list[$key]['marks']="";
                    $subject_list[$key]['pass_marks']="";

                }
                     $subject_list[$key]['subject_name']=$item->academicSubject->subject_name;
                     $subject_list[$key]['academic_subject_id']=$item->academic_subject_id;
                     $subject_list[$key]['subject_exam_type']=$exam_type;
            }

               // dd($subject_list);
            return response()->json(['subject_list'=>$subject_list]);
       } catch (Exception $exception) {
           return $exception->getMessage();

       }
    }

    public function subjectListForExamTypeMarksSetupSubmit(Request $request){

        DB::beginTransaction();
        try {

        $this->validate($request, [
            'academic_class_id' => 'required',
            'academic_year_id' => 'required',
            'examination_id' => 'required',
        ]);

        $data=$request->all();

        $examination=Examination::where('id',$request->examination_id)->where('use_key','site')->first();
        if(!$examination){
           return Response::json(['message'=>'You have no permission'],401); 
        }

        $class_id = $request->academic_class_id;
        $department_id = $request->academic_department_id;
        $year_id = $request->academic_year_id;
        $examinationId = $request->examination_id;
        $subjects = $request->subject_list;
        //$countable_marks_status = $request->countable_marks_status;

        $groupCondition = SubjectGroupConditionSetting::where('academic_class_id', $data['academic_class_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->get();

        $alert_array=null;

        if (count($subjects) > 0) {
            foreach ($subjects as $key => $val) {
                $subject_id = $val['academic_subject_id'];

                if(is_null($val['site_subject_group_condition_setting_id'])){
                    $groupCnditionSetting=$groupCondition->where('academic_subject_id',$subject_id)->first();
                    if($groupCnditionSetting){
                        $SubjectGroupConditionSettingID = $groupCnditionSetting->id;
                    }
                }else{
                    $SubjectGroupConditionSettingID = $val['site_subject_group_condition_setting_id'];
                }

                $examExist = $this->siteSubjectExaminationMark
                    ->with('siteSubjectExaminationExamTypeMark')
                    ->where('examination_id', $examinationId)
                    ->where('site_subject_group_condition_setting_id', $SubjectGroupConditionSettingID)
                    ->first();

                if($examExist){

                    $examExist->update([
                        'marks' => $val['marks'],
                        'pass_marks' => $val['pass_marks'],
                        'status' => true,
                    ]);

                    $siteSubjectExaminationMarkId=$examExist->id;
                }else{

                    $this->siteSubjectExaminationMark= new $this->siteSubjectExaminationMark;

                    $this->siteSubjectExaminationMark->site_subject_group_condition_setting_id=$SubjectGroupConditionSettingID;
                    $this->siteSubjectExaminationMark->examination_id=$examinationId;
                    $this->siteSubjectExaminationMark->marks=$val['marks']?$val['marks']:0;
                    $this->siteSubjectExaminationMark->status=true;
                    $this->siteSubjectExaminationMark->pass_marks=$val['pass_marks']?$val['pass_marks']:0;
                    $this->siteSubjectExaminationMark->save();

                    $siteSubjectExaminationMarkId=$this->siteSubjectExaminationMark->id;

                }

                foreach ($val['subject_exam_type'] as $keyl => $valuel) {


                    if($valuel['select_exam_type']){

                        $examTypeExist = $this->siteSubjectExaminationExamTypeMark
                            ->where('academic_exam_type_id', $valuel['academic_exam_type_id'])
                            ->where('site_subject_examination_mark_id', $siteSubjectExaminationMarkId)
                            ->first();

                        if(is_null($valuel['marks'])){
                            $countable_percent=100;

                        }else{
                            if(is_null($valuel['countable_marks'])){
                                $countable_percent=100;
                            }else{
                                $countable_percent=($valuel['countable_marks']/$valuel['marks'])*100;

                            }
                        }

                        if($examTypeExist){

                            $examTypeExist->marks       =   $valuel['marks'];
                            $examTypeExist->status      =   true;
                            $examTypeExist->pass_marks  =   $valuel['pass_marks'];
                            $examTypeExist->countable_marks_status  =   $valuel['countable_marks_status'];

                            if($examTypeExist->countable_marks_status){

                                if(!is_null($valuel['countable_marks'])){
                                    $examTypeExist->countable_marks=$valuel['countable_marks']?$valuel['countable_marks']:0;
                                    $examTypeExist->countable_persent_of_obtain_marks=$countable_percent?$countable_percent:100;

                                }else{
                                    $examTypeExist->countable_marks=$valuel['marks']?$valuel['marks']:null;
                                    $examTypeExist->countable_persent_of_obtain_marks=100;
                                }
                            }else{
                                $examTypeExist->countable_marks = $valuel['marks']?$valuel['marks']:0;
                                $examTypeExist->countable_persent_of_obtain_marks=$countable_percent?$countable_percent:100;
                            }

                            $examTypeExist->save();

                        }else{
                            $this->siteSubjectExaminationExamTypeMark=new $this->siteSubjectExaminationExamTypeMark;

                            $this->siteSubjectExaminationExamTypeMark->site_subject_examination_mark_id=$siteSubjectExaminationMarkId;
                            $this->siteSubjectExaminationExamTypeMark->academic_exam_type_id=$valuel['academic_exam_type_id'];
                            $this->siteSubjectExaminationExamTypeMark->marks=$valuel['marks']?$valuel['marks']:0;
                            $this->siteSubjectExaminationExamTypeMark->status=true;
                            $this->siteSubjectExaminationExamTypeMark->pass_marks=$valuel['pass_marks']?$valuel['pass_marks']:0;
                            $this->siteSubjectExaminationExamTypeMark->countable_marks_status=$valuel['countable_marks_status']?$valuel['countable_marks_status']:false;

                            if($valuel['countable_marks_status']){

                                if(!is_null($valuel['countable_marks'])){
                                    $this->siteSubjectExaminationExamTypeMark->countable_marks=$valuel['countable_marks']?$valuel['countable_marks']:0;
                                    $this->siteSubjectExaminationExamTypeMark->countable_persent_of_obtain_marks=$countable_percent?$countable_percent:100;

                                }else{
                                    $this->siteSubjectExaminationExamTypeMark->countable_marks=$valuel['marks']?$valuel['marks']:null;
                                    $this->siteSubjectExaminationExamTypeMark->countable_persent_of_obtain_marks=100;
                                }
                            }else{
                                $this->siteSubjectExaminationExamTypeMark->countable_marks=$valuel['marks']?$valuel['marks']:null;
                                $this->siteSubjectExaminationExamTypeMark->countable_persent_of_obtain_marks=100;
                            }

                            $this->siteSubjectExaminationExamTypeMark->save();
                        }

                    }else{

                        $examTypeExists = $this->siteSubjectExaminationExamTypeMark
                            ->where('academic_exam_type_id', $valuel['academic_exam_type_id'])
                            ->where('site_subject_examination_mark_id', $siteSubjectExaminationMarkId)
                            ->first();

                         //   dd($examExist);

                        if($examTypeExists){
                            $checkRoutine=SiteExamRoutine::where('site_subject_group_condition_setting_id',$examExist->site_subject_group_condition_setting_id)
                                ->where('examination_id',$examExist->examination_id)
                                ->where('academic_exam_type_id',$valuel['academic_exam_type_id'])
                                ->first();

                                if($checkRoutine){
                                    $alert_array='Oops! Some of the selected items are already scheduled in the routine. Please review and try again.';
                                }else{
                                    $examTypeExists->delete();
                                }
                        }

                    }

                }

                $examExist = $this->siteSubjectExaminationMark
                    ->with('siteSubjectExaminationExamTypeMark')
                    ->where('examination_id', $examinationId)
                    ->where('site_subject_group_condition_setting_id', $SubjectGroupConditionSettingID)
                    ->first();


                if($examExist){

                    if(count($examExist->siteSubjectExaminationExamTypeMark)<=0){
                        $examExist->delete();
                    }

                }

            }

           // dd($alert_array);

           


        }
        DB::commit();
        if($alert_array){
            return Response::json(['message' =>$alert_array],200);
        }
        return Response::json(['message' => 'Exam Marks Update' . ' Successfully!'],200);


    }  catch (ValidationException $exception) {
        DB::rollBack();
        return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (Exception $exception) {
        DB::rollBack();
        return Response::json(['message' => $exception->getMessage()], 410);
    }

    }



}
