<?php

namespace App\Http\Controllers\Site\Fee;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicMonthName;
use App\Models\Academic\AcademicSection;
use App\Models\Examinations\Examination;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\SiteInfo;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\SiteStudentWaiverHistory;
use App\Models\Site\Student\Student;
use App\Models\Site\StudentPaySlip\SiteStudentPaymentSlip;
use App\Models\Student\StudentHistory;
use App\User;
use PDF;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Carbon;
use Response;
use Session;

class SiteStudentPaymentHistoryController extends ProjectController
{
    private $studentPaymentHistory;

    public function __construct(SiteStudentFeePaymentHistory $studentPaymentHistory)
    {
        $this->middleware('auth');
        //$this->middleware('eduworlduserchecker');
        $this->middleware('sitepagechecker');
        $this->studentPaymentHistory = $studentPaymentHistory;

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Student Payment';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.sites.fee.student-payment.view', compact('viewType'));
    }



    public function store(Request $request)
    {

        $slip = new SiteStudentPaymentSlip();
        $pay_slip_no=$this->generateVoucher();
        $slip->voucher_no = $pay_slip_no;

        $slip->total_amount = $request->total_amount;
        $slip->status = 1;
        $slip->payment_status = 'paid';
        $slip->save();

        $slip = new SiteStudentPaymentSlip();
        $slip_list = $slip->orderBy('id', 'DESC')->first();
        $slip_id = $slip_list->id;


        $site_std_payment = new SiteStudentPaymentHistory();

        $std_payment = $site_std_payment->orderBy('id', 'DESC')->first();
        if ($std_payment) {
            $std_payment_first_id = $std_payment->id;
        }


        //=====================save admission fee details to student payment history========================

        foreach ($request->admission_fee_details as $key => $value) {

            if ($value['status'] == true) {
                $now = Carbon::now();
                $month_number = $now->month;
                $head_id = $value['academic_fee_sub_head_id'];
                $payment_history = new SiteStudentPaymentHistory();

                $payment_history->academic_fee_head_id = $value['head_id'];
                $payment_history->user_id = $request->user_id;
                $payment_history->academic_version_id = $request->academic_version_id;
                $payment_history->academic_shift_id = $request->academic_shift_id;
                $payment_history->academic_fee_sub_head_id = $head_id['id'];
//                $payment_history->academic_fee_group_id = $value['group_id'];
                $payment_history->academic_year_id = $request->academic_year_id;
                $payment_history->academic_class_id = $request->academic_class_id ?? null;
                $payment_history->academic_department_id = $request->academic_department_id ?? null;
                $payment_history->academic_class_group_id = $request->academic_class_group_id ?? null;
                $payment_history->academic_section_id = $request->academic_class_group_id ?? null;
                $payment_history->academic_session_id = $request->academic_session_id ?? null;
                $payment_history->payment_date = $request->admission_payment_date;
                $payment_history->payment_type = $request->payment_type;
                $payment_history->month = $month_number;
                $payment_history->voucher_no = $slip_id;
                $payment_history->amount = $value['payable_amount'];
                $payment_history->status = $value["status"];

                $payment_history->save();


            } else {

            }

        }

        //=====================save monthly fee details to student payment history========================

        foreach ($request->monthly_fee_details as $key => $value) {

//            return $value['user_id'];

            if ($value['status'] == true) {

                foreach ($value['month'] as $ke => $val) {

                    $head_id = $value['academic_fee_sub_head_id'];

                    $std_waiver = new SiteStudentWaiverHistory();
                    $std_waiver_history = $std_waiver->where
                    (
                        [
                            'user_id' => $value['user_id'],
                            'academic_fee_sub_head_id' => $head_id['id'],
                            'month' => $val['id'],
                            'academic_year_id' => $request->academic_year_id,
                        ]

                    )->first();

//                    return $std_waiver_history;

                    if ($std_waiver_history) {

                        $waiver_amount = $std_waiver_history->amount;

                        $payable_amount = $value['amount'] - $waiver_amount;


                    } else {

                        $payable_amount = $value['amount'];

                    }

                    $payment_history = new SiteStudentPaymentHistory();

                    $payment_history->academic_fee_head_id = $value['head_id'];
                    $payment_history->user_id = $value['user_id'];
                    $payment_history->academic_version_id = $request->academic_version_id;
                    $payment_history->academic_shift_id = $request->academic_shift_id;
                    $payment_history->academic_fee_sub_head_id = $head_id['id'];
//                  $payment_history->academic_fee_group_id = $value['group_id'];
                    $payment_history->academic_year_id = $request->academic_year_id;
                    $payment_history->academic_class_id = $request->academic_class_id ?? null;
                    $payment_history->academic_department_id = $request->academic_department_id ?? null;
                    $payment_history->academic_class_group_id = $request->academic_class_group_id ?? null;
                    $payment_history->academic_section_id = $request->academic_class_group_id ?? null;
                    $payment_history->academic_session_id = $request->academic_session_id ?? null;
                    $payment_history->payment_date = $request->admission_payment_date;
                    $payment_history->payment_type = $request->payment_type;;
                    $payment_history->month = $val['id'];
                    $payment_history->voucher_no = $slip_id;
                    $payment_history->amount = $payable_amount;
                    $payment_history->status = $value["status"];

                    $payment_history->save();

                }
//                $now = Carbon::now();
//                $month_number = $now->month;


            } else {

            }

        }

        //=====================save examination fee details to student payment history========================

        foreach ($request->examintaion_fee_details as $key => $value) {


            if ($value['status'] == true) {
                $now = Carbon::now();
                $month_number = $now->month;
                $sub_head_id = $value['academic_fee_sub_head_id'];
                $exam_id = $value['exam_list'];

                $std_waiver = new SiteStudentWaiverHistory();
                $std_waiver_history = $std_waiver->where
                (
                    [
                        'user_id' => $request->user_id,
                        'academic_fee_sub_head_id' => $sub_head_id['id'],
                        'academic_year_id' => $request->academic_year_id,
                        'examination_id' => $exam_id['id'],
                    ]

                )->first();

//                    return $std_waiver_history;

                if ($std_waiver_history) {

                    $waiver_amount = $std_waiver_history->amount;

                    $payable_amount = $value['amount'] - $waiver_amount;


                } else {

                    $payable_amount = $value['amount'];

                }

                $payment_history = new SiteStudentPaymentHistory();

                $payment_history->academic_fee_head_id = $value['head_id'];
                $payment_history->user_id = $request->user_id;
                $payment_history->academic_version_id = $request->academic_version_id;
                $payment_history->academic_shift_id = $request->academic_shift_id;
                $payment_history->academic_fee_sub_head_id = $sub_head_id['id'];
//                $payment_history->academic_fee_group_id = $value['group_id'];
                $payment_history->academic_year_id = $request->academic_year_id;
                $payment_history->academic_class_id = $request->academic_class_id ?? null;
                $payment_history->academic_department_id = $request->academic_department_id ?? null;
                $payment_history->academic_class_group_id = $request->academic_class_group_id ?? null;
                $payment_history->academic_section_id = $request->academic_class_group_id ?? null;
                $payment_history->academic_session_id = $request->academic_session_id ?? null;
                $payment_history->examination_id = $exam_id['id'];
                $payment_history->payment_date = $request->examination_payment_date;
                $payment_history->payment_type = $request->payment_type;;
                $payment_history->month = $month_number;
                $payment_history->voucher_no = $slip_id;
                $payment_history->amount = $payable_amount;
                $payment_history->status = true;

                $payment_history->save();


            } else {

            }
        }
        return $slip_id;


    }

    public function generateVoucher()
    {

        $ran_number = mt_rand(100000, 999999);
        $slip = new SiteStudentPaymentSlip();
        $slip_list = $slip->where('voucher_no', $ran_number)->first();
        if ($slip_list) {
            $this->generateVoucher();
        } else {
            return $ran_number;

        }
    }


}
