<?php

namespace  App\Http\Controllers\Site\Fine;

use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Event\Event;
use App\Models\Site\Accounts\AccountsGroup;
use App\Models\Site\Fine\SiteStudentFineSetting;
use App\Models\Site\Fine\StudentFineType;
use App\Models\Site\SiteInfo;
use App\Models\Site\Student\Manual\SiteStudentManualCount;
use App\Models\Site\Student\SiteStudentFineCollect;
use App\Models\Site\Student\SiteStudentManuallyCountAttendance;
use App\Models\Student\StudentHistory;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Error;
use Exception;
use Illuminate\Support\Facades\DB;
use PDF;
use Illuminate\Support\Facades\Session;

class StudentFineController extends Controller
{
    private $SiteStudentFineSetting;
    private $studentFineType;
    private $StudentHistory;
    public function __construct(SiteStudentFineSetting $SiteStudentFineSetting, StudentFineType $studentFineType)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->SiteStudentFineSetting = $SiteStudentFineSetting;
        $this->studentFineType = $studentFineType;
    }
    public function index()
    {
        $viewType = 'Fine List';
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function StoreSiteStudentFineType(Request $request)
    {
        $data = [];
        $data['id'] =  $request->id;
        $data['fine_type_name'] =  $request->fine_type_name;
        $data['status'] =  $request->status;
        $request->validate([
            'fine_type_name' => 'required',
        ]);
        if (!$data['id']) {
            $StudentFineType = new StudentFineType();
            $StudentFineType->fine_type_name = $data['fine_type_name'];
            $StudentFineType->fine_type_name_key = strtolower(str_replace(' ', '_', $data['fine_type_name']));
            $StudentFineType->status = $data['status'];
            $StudentFineType->save();
        } else {
            $StudentFineType =   $this->studentFineType->find($data['id']);
            $StudentFineType->fine_type_name = $data['fine_type_name'];
            $StudentFineType->fine_type_name_key = strtolower(str_replace(' ', '_', $data['fine_type_name']));
            $StudentFineType->status = $data['status'];
            $StudentFineType->save();
        }
        return 'done';
    }
    public function getSiteStudentFineType()
    {
        return $this->studentFineType
            ->orderByRaw("FIELD(fine_type_name_key, 'attendance', 'exam') DESC")

            ->paginate(10);
    }
    public function getSiteStudentFineTypeForSettings()
    {
        return $this->studentFineType
            ->orderByRaw("FIELD(fine_type_name_key, 'attendance', 'exam') DESC")
            ->where('status', 1)
            ->get();
    }

    public function StoreSiteStudentFineSettings(Request $request)
    {

        $data = [];
        $data['academic_class_group_id'] = $request->academic_class_group_id;
        $data['academic_class_id']       = $request->academic_class_id;
        $data['academic_year_id']        = $request->academic_year_id;
        $data['academic_shift_id']       = $request->academic_shift_id;
        $data['academic_section_id']     = $request->academic_section_id;
        $data['academic_version_id']     = $request->academic_version_id;
        $data['fine_amount']             = $request->fine_amount;
        $data['fine_type_id']            = $request->fine_type_id;
        $data['fine_amount_type']        = $request->fine_amount_type;
        $data['countable_absent']        = $request->selectedCountableAbsent;
        $data['academic_group_id']       = session()->get('ACADEMIC_GROUP_ID');
        $data['site_id']                 = session()->get('SITE_ID');

        if (!$data['academic_class_id'] || !$data['academic_shift_id'] || !$data['academic_year_id']) {
            throw new Error('Please Select Class, Shift, Year');
        }
        if (!$data['fine_amount']) {
            throw new Error('Please Enter Fine Amount');
        }
        if (!$data['fine_type_id']) {
            throw new Error('Select Fine Type');
        }
        if (!$data['fine_amount_type']) {
            throw new Error('Select Fine amount Type');
        }


        if ($data['academic_class_id'] && $data['academic_shift_id'] && $data['academic_year_id'] && $data['academic_section_id'] && $data['academic_class_group_id'] && $data['fine_type_id']) {

            $SiteStudentFeeFine =  $this->SiteStudentFineSetting::where('academic_group_id', $data['academic_group_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_class_group_id', $data['academic_class_group_id'])
                ->where('academic_section_id', $data['academic_section_id'])
                ->where('fine_type_id', $data['fine_type_id'])
                ->first();
            if (!$SiteStudentFeeFine) {
                $SiteStudentFeeFine = new SiteStudentFineSetting();
            }

            $SiteStudentFeeFine->academic_group_id       = $data['academic_group_id'];
            $SiteStudentFeeFine->site_id                 = $data['site_id'];
            $SiteStudentFeeFine->academic_class_id       = $data['academic_class_id'];
            $SiteStudentFeeFine->academic_year_id        = $data['academic_year_id'];
            $SiteStudentFeeFine->academic_shift_id       = $data['academic_shift_id'];
            $SiteStudentFeeFine->academic_class_group_id = $data['academic_class_group_id'];
            $SiteStudentFeeFine->academic_section_id     = $data['academic_section_id'];
            $SiteStudentFeeFine->fine_amount             = $data['fine_amount'];
            $SiteStudentFeeFine->fine_type_id            = $data['fine_type_id'];
            $SiteStudentFeeFine->fine_amount_type        = $data['fine_amount_type'];
            $SiteStudentFeeFine->countable_absent        = $data['countable_absent'];
            $SiteStudentFeeFine->save();
        } elseif ($data['academic_class_id'] && $data['academic_shift_id'] && $data['academic_year_id'] &&  $data['academic_class_group_id'] && $data['fine_type_id']) {

            $SiteStudentFeeFine =  $this->SiteStudentFineSetting::where('academic_group_id', $data['academic_group_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('fine_type_id', $data['fine_type_id'])
                ->where('academic_class_group_id', $data['academic_class_group_id'])
                ->first();
            if (!$SiteStudentFeeFine) {
                $SiteStudentFeeFine = new SiteStudentFineSetting();
            }

            $SiteStudentFeeFine->academic_group_id       = $data['academic_group_id'];
            $SiteStudentFeeFine->site_id                 = $data['site_id'];
            $SiteStudentFeeFine->academic_class_id       = $data['academic_class_id'];
            $SiteStudentFeeFine->academic_year_id        = $data['academic_year_id'];
            $SiteStudentFeeFine->academic_shift_id       = $data['academic_shift_id'];
            $SiteStudentFeeFine->academic_class_group_id = $data['academic_class_group_id'];
            $SiteStudentFeeFine->fine_amount             = $data['fine_amount'];
            $SiteStudentFeeFine->fine_type_id            = $data['fine_type_id'];
            $SiteStudentFeeFine->fine_amount_type        = $data['fine_amount_type'];
            $SiteStudentFeeFine->countable_absent        = $data['countable_absent'];
            $SiteStudentFeeFine->save();
        } elseif ($data['academic_class_id'] && $data['academic_shift_id'] && $data['academic_year_id'] && $data['academic_section_id'] && $data['fine_type_id']) {

            $SiteStudentFeeFine =  $this->SiteStudentFineSetting::where('academic_group_id', $data['academic_group_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_section_id', $data['academic_section_id'])
                ->where('fine_type_id', $data['fine_type_id'])
                ->first();
            if (!$SiteStudentFeeFine) {
                $SiteStudentFeeFine = new SiteStudentFineSetting();
            }

            $SiteStudentFeeFine->academic_group_id       = $data['academic_group_id'];
            $SiteStudentFeeFine->site_id                 = $data['site_id'];

            $SiteStudentFeeFine->academic_class_id       = $data['academic_class_id'];
            $SiteStudentFeeFine->academic_year_id        = $data['academic_year_id'];
            $SiteStudentFeeFine->academic_shift_id       = $data['academic_shift_id'];
            $SiteStudentFeeFine->academic_section_id     = $data['academic_section_id'];

            $SiteStudentFeeFine->fine_amount       = $data['fine_amount'];
            $SiteStudentFeeFine->fine_type_id      = $data['fine_type_id'];
            $SiteStudentFeeFine->fine_amount_type  = $data['fine_amount_type'];
            $SiteStudentFeeFine->countable_absent  = $data['countable_absent'];
            $SiteStudentFeeFine->save();
        } else {

            $SiteStudentFeeFine =  $this->SiteStudentFineSetting::where('academic_group_id', $data['academic_group_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('fine_type_id', $data['fine_type_id'])
                ->first();
            if (!$SiteStudentFeeFine) {
                $SiteStudentFeeFine = new SiteStudentFineSetting();
            }
            $SiteStudentFeeFine->academic_group_id = $data['academic_group_id'];
            $SiteStudentFeeFine->site_id           = $data['site_id'];
            $SiteStudentFeeFine->academic_class_id = $data['academic_class_id'];
            $SiteStudentFeeFine->academic_year_id  = $data['academic_year_id'];
            $SiteStudentFeeFine->academic_shift_id = $data['academic_shift_id'];
            $SiteStudentFeeFine->fine_amount       = $data['fine_amount'];
            $SiteStudentFeeFine->fine_type_id      = $data['fine_type_id'];
            $SiteStudentFeeFine->fine_amount_type  = $data['fine_amount_type'];
            $SiteStudentFeeFine->countable_absent  = $data['countable_absent'];
            $SiteStudentFeeFine->save();
        }
    }
    public function GetSiteStudentFineSettings(Request $request)
    {


        $data = [];
        $data['academic_class_group_id'] = $request->academic_class_group_id;
        $data['academic_class_id']       = $request->academic_class_id;
        $data['academic_year_id']        = $request->academic_year_id;
        $data['academic_shift_id']       = $request->academic_shift_id;
        $data['academic_section_id']     = $request->academic_section_id;
        $data['academic_version_id']     = $request->academic_version_id;
        $data['fine_amount']             = $request->fine_amount;
        $data['fine_type_id']            = $request->fine_type_id;
        $data['fine_amount_type']        = $request->fine_amount_type;
        $data['academic_group_id']       = session()->get('ACADEMIC_GROUP_ID');
        $data['site_id']                 = session()->get('SITE_ID');

        if (!$data['academic_class_id'] || !$data['academic_shift_id'] || !$data['academic_year_id']) {
            throw new Error('Please Select Class, Shift, Year');
        }
        $SiteStudentFeeFine =  $this->SiteStudentFineSetting::when(isset($data['academic_group_id']), function ($query) use ($data) {
            $query->where('academic_group_id', $data['academic_group_id']);
        })
            ->when(isset($data['academic_class_id']), function ($query) use ($data) {
                $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(isset($data['academic_shift_id']), function ($query) use ($data) {
                $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(isset($data['academic_class_group_id']), function ($query) use ($data) {
                $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(isset($data['academic_section_id']), function ($query) use ($data) {
                $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(isset($data['fine_type_id']), function ($query) use ($data) {
                $query->where('fine_type_id', $data['fine_type_id']);
            })
            ->first();
        if (!$SiteStudentFeeFine) {
            throw new Error('Set up your fine settings first!');
        }
        return $SiteStudentFeeFine;
    }
    public function GetSiteStudentFineData(Request $request)
    {


        $data = $request->all();
        if (!$request->fine_type_id) {
            throw new Exception('Select Fine Type!');
        }

        $year             = $request->selectedYear;
        $month            = $request->selectedMonth;
        $targetMonth      = Carbon::create($year, $month, 1)->format('Y-m');


        $fineSetting =  $this->SiteStudentFineSetting::when(isset($data['academic_group_id']), function ($query) use ($data) {
            $query->where('academic_group_id', $data['academic_group_id']);
        })
            ->when(isset($data['academic_class_id']), function ($query) use ($data) {
                $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(isset($data['academic_shift_id']), function ($query) use ($data) {
                $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(isset($data['academic_class_group_id']), function ($query) use ($data) {
                $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(isset($data['academic_section_id']), function ($query) use ($data) {
                $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(isset($data['fine_type_id']), function ($query) use ($data) {
                $query->where('fine_type_id', $data['fine_type_id']);
            })
            ->first();

        if (!$fineSetting) {
            throw new Exception('Set up your fine settings first!');
        }
        $Class_group_name =  AcademicClassGroup::where('id',$data['academic_class_group_id'])->first()->group_name ?? null;
        $class_name =  AcademicClass::where('id',$data['academic_class_id'])->first()->class_name ?? null;


        $StudentQuery = StudentHistory::
            when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->with('student:id')

            ->with([
                'attendances' => function ($query) use ($year, $month) {
                    $query->select('student_history_id')
                        ->selectRaw('COUNT(*) as total_attendance')
                        ->selectRaw('SUM(late_status) as total_late_status')
                        ->where('present_year', $year)
                        ->where('present_month', $month)
                        ->groupBy('student_history_id');
                }
            ])
            ->with([
                'StudentFineCollect' => function ($query) use ($year, $month, $data) {
                    $query
                        ->where('fine_type_id', $data['fine_type_id'])
                        ->where('year', $year)
                        ->where('month', $month);
                }
            ])
            ->with([
                'studentAttendance' => function ($query) use ($year, $month, $data) {
                    $query

                        ->where('year', $year)
                        ->where('month', $month);
                }
            ])
            ->where('status', true)
            ->orderBy('student_roll_number');

         $Students = $request->user_id ? $StudentQuery->where('user_id', $request->user_id)->get() : $StudentQuery->get();

        $firstDayOfMonth = mktime(0, 0, 0, $month, 1, $year);
        $TotlaDayOfMonth = date('t', $firstDayOfMonth);

        $offDayOfMonth = Event::whereYear('activate_date', '=', $year)
            ->whereMonth('activate_date', '=', $month)
            ->where('status', 1)
            ->count();


        $Students->transform(function ($student) use ($TotlaDayOfMonth, $offDayOfMonth, $fineSetting) {

            $student_fine_collect      = $student->StudentFineCollect->first();
            $studentAttendance         = $student->studentAttendance->first();
            $total_manually_attendance = $studentAttendance ? $studentAttendance->manually_attendance : 0;


            $StudentAttendances      = $student->attendances->first();
            $total_device_attendence = $StudentAttendances ? $StudentAttendances->total_attendance : 0;
            $total_absent            = $TotlaDayOfMonth - ($total_device_attendence  + $offDayOfMonth + $total_manually_attendance);

            if ($total_absent >= $fineSetting->countable_absent && $fineSetting->countable_absent != 0) {
                $countable_absent_result = floor($total_absent / $fineSetting->countable_absent);
                $total_fine              = $fineSetting->fine_amount * $countable_absent_result;
            } else {
                $total_fine = 0;
            }

            return [
                'id'                  => $student->id ?? null,
                'full_name'           => $student->full_name ?? null,
                'user_id'             => $student->user_id ?? null,
                'student_full_roll_number'  => $student->student_full_roll_number ?? null,
                'device_present'      => $total_device_attendence,
                'total_present'       => $total_device_attendence + $offDayOfMonth,
                'offDayOfMonth'       => $offDayOfMonth ?? 0,
                'total_absent'        => $total_absent,
                'academicDay'         => $TotlaDayOfMonth - $offDayOfMonth,
                'waiver'              => 0,
                'manually_attendance' => $total_manually_attendance ?? null,
                'fine_amount'         => $fineSetting->fine_amount  ?? 0,
                'fine_amount_type'    => $fineSetting->fine_amount_type == 'round' ? '' : '%',
                'countable_absent'    => $fineSetting->countable_absent ?? 0,
                'total_fine'          => $total_fine ?? 0,
                'total_count_absent'  => $countable_absent_result ?? 0,
                'TotlaDayOfMonth'     => $TotlaDayOfMonth ?? 0,
                'payment_status'      => $student_fine_collect ? $student_fine_collect->payment_status : false,
                'student_fine_exists' => $student_fine_collect ? true : false,
                'student_fine_waiver' => $student_fine_collect ? $student_fine_collect->total_waiver : false,
                'student_total_fine'  => $student_fine_collect ? ($student_fine_collect->total_fine - $student_fine_collect->total_waiver) : false,
            ];
        });
        $site_id = Session::get('SITE_ID');
        $site_info =  SiteInfo::select('id', 'site_logo', 'site_phone')->findOrFail($site_id);
        $StudentFineType =   StudentFineType::where('id', $data['fine_type_id'])->first();

        if ($request->pdf_report_download) {
            $pdf = PDF::loadView(
                'default.site.student.fine.site-student-month-fine-pdf',
                compact(
                    'Students',
                    'StudentFineType',
                    'year',
                    'month',
                    'site_info',
                    'Class_group_name',
                    'class_name',
                    // 'StudentFineType',
                )
            )
                ->setPaper('a4', 'landscape')
                ->setWarnings(false);


            $path = storage_path() . '/pdf';
            $time = \Auth::user()->id . '-' . Carbon::now()->unix();
            $pdf->save($path . '/' . $time .'.pdf', 'UTF-8');
            $name = $time . '.pdf';
            $route_name = route('open-pdf-file-storage', [$name]);
        } else {
            $route_name = null;
        }

        return response()->json([
            'students'        => $Students,
            'link'             => $route_name,
        ], 200);

    }
    public function ChangeSiteStudentFineStatus(Request $request)
    {
        $studentID = $request->params['student']['id'];
        $payment_status = $request->params['student']['payment_status'];

        $year            = $request->params['selectedYear'];
        $month           = $request->params['selectedMonth'];
        $SiteStudentFineCollect = SiteStudentFineCollect::where('student_history_id', $studentID)
            ->where('month', $month)
            ->where('year', $year)
            ->first();
        if ($SiteStudentFineCollect) {
            $SiteStudentFineCollect->payment_status = $payment_status;
            $SiteStudentFineCollect->save();
        }

        return 'Done';
    }
    public function StoreSiteStudentFineData(Request $request)
    {

        $year            = $request->selectedYear;
        $month           = $request->selectedMonth;
        $fine_type_id    = $request->fine_type_id;
        $fineCollectDate = Carbon::now();

        $selectedStudentsFine = is_array($request->SelectedStudentsFine) ? $request->SelectedStudentsFine : json_decode($request->SelectedStudentsFine, true);
        $studentsFineArray = [];
        foreach ($selectedStudentsFine as $item) {
            $studentsFineArray[] = is_string($item) ? json_decode($item, true) : $item;
        }

        foreach ($studentsFineArray as $student) {

            $SiteStudentFineCollect = SiteStudentFineCollect::where('student_history_id', $student['id'])
                ->where('fine_type_id', $fine_type_id)
                ->where('month', $month)
                ->where('year', $year)
                ->first();

            if (!$SiteStudentFineCollect) {
                $SiteStudentFineCollect = new SiteStudentFineCollect();
            }
            $total_manually_attendance = isset($student['total_manually_attendance']) ? $student['total_manually_attendance'] : 0;


            $total_absent     = $student['TotlaDayOfMonth'] - ($student['device_present'] +  $student['offDayOfMonth']  +  $total_manually_attendance);
            $countable_absent = $student['countable_absent'];

            if ($total_absent >= $countable_absent && $countable_absent != 0) {
                $countable_absent_result = floor($total_absent / $countable_absent);
                $total_attendence_fine   = $student['fine_amount'] * $countable_absent_result;
            } else {
                $total_attendence_fine = 0;
            }
            $fine_type =   StudentFineType::where('id', $fine_type_id)->first();

            if ($fine_type->fine_type_name_key == 'attendance') {
                $total_fine = $total_attendence_fine;
            } else {
                $total_fine = $student['fine_amount'];
            }



            $SiteStudentFineCollect->student_history_id = $student['id'];
            $SiteStudentFineCollect->total_fine         = $total_fine;
            $SiteStudentFineCollect->total_waiver       = $student['waiver'];
            $SiteStudentFineCollect->fine_collect_date  = $fineCollectDate;
            $SiteStudentFineCollect->month              = $month;
            $SiteStudentFineCollect->year               = $year;
            $SiteStudentFineCollect->fine_type_id       = $fine_type_id;

            if ($SiteStudentFineCollect->save()) {

                if ($fine_type->fine_type_name_key == 'attendance') {

                    $SiteStudentFineCollect = SiteStudentManuallyCountAttendance::where('student_history_id', $student['id'])
                        ->where('month', $month)
                        ->where('year', $year)
                        ->first();
                        
                    if (!$SiteStudentFineCollect) {
                        $SiteStudentFineCollect = new SiteStudentManuallyCountAttendance();
                    }
                    $total_present = $student['device_present'] + $student['offDayOfMonth'] + $total_manually_attendance;
                    $SiteStudentFineCollect->student_history_id  = $student['id'];
                    $SiteStudentFineCollect->total_present       = $total_present;
                    $SiteStudentFineCollect->total_absent        = $total_absent;
                    $SiteStudentFineCollect->total_days_of_month = $student['TotlaDayOfMonth'];
                    $SiteStudentFineCollect->year                = $year;
                    $SiteStudentFineCollect->month               = $month;
                    $SiteStudentFineCollect->off_day             = $student['offDayOfMonth'];
                    $SiteStudentFineCollect->academic_day        = $student['academicDay'];
                    $SiteStudentFineCollect->manually_attendance = $student['total_manually_attendance'] ?? 0;
                    $SiteStudentFineCollect->save();
                }
            }
        }
    }
    public function GetSiteStudentFineDataRangeWise(Request $request)
    {


        $date_range = is_string($request->date_range) ? json_decode($request->date_range) : $request->date_range;

        $start_date = $request->date_range['start'] ?? null;
        $end_date = $request->date_range['end'] ?? null;

        if ($date_range) {
            if (!$start_date || !$end_date) {
                throw new Error('Please Select Both Date');
            }
        }
        $data = $request->all();
        if (!$request->fine_type_id) {
            throw new Exception('Select Fine Type!');
        }

        $year             = $request->selectedYear;
        $month            = $request->selectedMonth;
        $targetMonth      = Carbon::create($year, $month, 1)->format('Y-m');


        $StudentQuery = StudentHistory::when($data['academic_year_id'], fn($query) => $query->where('academic_year_id', $data['academic_year_id']))
            ->when($data['academic_class_id'], fn($query) => $query->where('academic_class_id', $data['academic_class_id']))
            ->when($data['academic_version_id'], fn($query) => $query->where('academic_version_id', $data['academic_version_id']))
            ->when($data['academic_shift_id'], fn($query) => $query->where('academic_shift_id', $data['academic_shift_id']))
            ->when($data['academic_class_group_id'], fn($query) => $query->where('academic_class_group_id', $data['academic_class_group_id']))
            ->when($data['academic_section_id'], fn($query) => $query->where('academic_section_id', $data['academic_section_id']))
            ->when($data['academic_department_id'], fn($query) => $query->where('academic_department_id', $data['academic_department_id']))
            ->with(['StudentFineCollect' => function ($query) use ($data) {
                $query->where('fine_type_id', $data['fine_type_id']);
            }])
            ->with(['student'])
            ->whereHas('StudentFineCollect', function ($query) use ($start_date, $end_date, $data) {
                $query->where('fine_type_id', $data['fine_type_id'])
                    ->whereBetween('fine_collect_date', [$start_date, $end_date]);
            })
            ->where('status', true)
            ->orderBy('student_roll_number')
            ->get();


        $StudentFineType =   StudentFineType::where('id', $data['fine_type_id'])->first();

        $StudentQuery->transform(function ($student) use ($data) {
            $student_fine_collect      = $student->StudentFineCollect->first();
            $SiteStudentManuallyCountAttendance = SiteStudentManuallyCountAttendance::where('student_history_id', $student_fine_collect->student_history_id)
                ->where('month', $student_fine_collect->month)
                ->where('year', $student_fine_collect->year)
                ->first();

            $fine_type =   StudentFineType::where('id', $student_fine_collect->fine_type_id)->first();

            return [
                'id'                      => $student->id ?? null,
                'full_name'               => $student->full_name ?? null,
                'user_id'                 => $student->user_id ?? null,
                'student_full_roll_number'=> $student->student_full_roll_number ?? null,
                'datafine_type_id'        => $data['fine_type_id'] ?? null,
                'fine_type_id'            => $fine_type->id ?? null,
                'fine_Type_name'          => $fine_type->fine_type_name ?? null,
                'fine_collect_date'       => Carbon::create($student_fine_collect->fine_collect_date)->format('d-M-Y') ?? null,

                'student_fine_waiver' => $student_fine_collect ? $student_fine_collect->total_waiver : false,
                'student_total_fine'  => $student_fine_collect ? ($student_fine_collect->total_fine - $student_fine_collect->total_waiver) : false,
                'student_fine_payment_status' => $student_fine_collect ? $student_fine_collect->payment_status : null,
                'total_absent'                => $SiteStudentManuallyCountAttendance ? $SiteStudentManuallyCountAttendance->total_absent : null,
                'total_days_of_month'         => $SiteStudentManuallyCountAttendance ? $SiteStudentManuallyCountAttendance->total_days_of_month : null,
            ];
        });
        $site_id = Session::get('SITE_ID');
        $site_info =  SiteInfo::select('id', 'site_logo', 'site_phone')->findOrFail($site_id);

        if ($request->pdf_report_download) {
            $pdf = PDF::loadView(
                'default.site.student.fine.site-student-fine-date-wise-pdf',
                compact(
                    'StudentQuery',
                    'start_date',
                    'end_date',
                    'site_info',
                    'StudentFineType',
                )
            )
                ->setPaper('a4', 'landscape')
                ->setWarnings(false);


            $path = storage_path() . '/pdf';
            $time = \Auth::user()->id . '-' . Carbon::now()->unix();
            $pdf->save($path . '/' . $time . '-' . $start_date . '-' . $end_date . '.pdf', 'UTF-8');
            $name = $time . '-' . $start_date . '-' . $end_date . '.pdf';
            $route_name = route('open-pdf-file-storage', [$name]);
        } else {

            $route_name = null;
        }

        return response()->json([
            'students'        => $StudentQuery,
            'link'             => $route_name,
        ], 200);
    }
}
