<?php

namespace App\Http\Controllers\Site\HelpDesk;

use App\Models\Edu\HelpDesk\EduSiteHelpDeskMenu;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskSetting;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskSettingDetail;
use App\Models\Role\Role;
use App\Models\Site\Role\SiteRole;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;

class SiteHelpDeskController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        // $this->middleware('sitepagechecker');
    }


    public function index()
    {
        $viewType = 'Help Desk page';

        return view('default.admin.layouts.master', compact('viewType'));

    }


    public function getSiteHelpDeskList(){
        // return 'jahin';

        $user_id=\Auth::user()->id;

        $roles=SiteRole::with(['users'=>function($query) use ($user_id){
            $query->where('user_id', $user_id);
        }])
            ->whereIn('key', ['admin', 'student', 'employee', 'guardian'])
            ->get();



        $check_admin=$roles->where('key', 'admin')->first();
        $check_employee=$roles->where('key', 'employee')->first();
        $check_student=$roles->where('key', 'student')->first();
        $check_guardian=$roles->where('key', 'guardian')->first();


        if(count($check_admin->users)>=1){
            $setting_detail_ids=EduSiteHelpDeskSettingDetail::where('menu_for', 'site')
                ->where('menu_role', 'admin')
                ->pluck('edu_site_help_desk_setting_id')
                ->unique()
                ->values();
        }
        else if(count($check_employee->users)>=1){
            $setting_detail_ids=EduSiteHelpDeskSettingDetail::where('menu_for', 'site')
                ->where('menu_role', 'employee')
                ->pluck('edu_site_help_desk_setting_id')
                ->unique()
                ->values();
        }
        else if(count($check_student->users)>=1){
            $setting_detail_ids=EduSiteHelpDeskSettingDetail::where('menu_for', 'site')
                ->where('menu_role', 'student')
                ->pluck('edu_site_help_desk_setting_id')
                ->unique()
                ->values();
        }
        else if(count($check_guardian->users)>=1){
            $setting_detail_ids=EduSiteHelpDeskSettingDetail::where('menu_for', 'site')
                ->where('menu_role', 'guardian')
                ->pluck('edu_site_help_desk_setting_id')
                ->unique()
                ->values();
        }




        $setting_list=EduSiteHelpDeskSetting::whereIn('id', $setting_detail_ids)
            ->get();

        $setting_list_ids=$setting_list
            ->pluck('edu_site_help_desk_menu_id')
            ->unique();

        $menu_list=EduSiteHelpDeskMenu::with(['eduSiteHelpDeskSetting'=>function($query) use ($setting_detail_ids){
            $query->whereIn('id', $setting_detail_ids);
            $query->orderBy('serial');
        }])
            ->whereIn('id', $setting_list_ids)
            ->orderBy('menu_serial')
            ->get();


        return $menu_list;
    }



}
