<?php

namespace App\Http\Controllers\Site\JobApplication;

use App\Http\Controllers\Controller;
use App\Models\job\job;
use App\Models\JobApplication\GlobalJobApplication;
use App\Models\JobApplication\JobApplication;
use App\Models\JobApplication\JobCircular;
use Carbon\Carbon;
use Illuminate\Http\Request;
use PDF;

class JobApplicationController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        // $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Help Desk page';
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function UpdateCricular(Request $request)
    {

        $id = $request->id;
        $job = JobCircular::find($id);
        if ($job) {
            $request->validate([
                'title'      => 'required|string|max:255',
                'location'   => 'required|string|max:255',
                'type'       => 'required|string|max:255',
                'category'   => 'required|string|max:255',
                'salary'     =>  'required',
                'salaryType' => 'required|string|max:255',
                'education'  => 'required|string|max:255',
                'skills'     => 'required|string|max:255',
                'deadline'   => 'required|date|',


            ]);
            $job->fill($request->only($job->getFillable()));
            $job->save();

            return response()->json(['success' => true, 'message' => 'job saved successfully.']);
        } else {
            return response()->json(['success' => false, 'message' => 'Job Circular not found.'], 404);
        }
    }
    public function store(Request $request)
    {

        $job = new JobCircular();
        $request->validate([
            'title'      => 'required|string|max:255',
            'location'   => 'required|string|max:255',
            'type'       => 'required|string|max:255',
            'category'   => 'required|string|max:255',
            'salary'     =>  'required',
            'salaryType' => 'required|string|max:255',
            'education'  => 'required|string|max:255',
            'skills'     => 'required|string|max:255',
            'deadline'   => 'required|date',


        ]);

        $job->fill($request->only($job->getFillable()));
        $job->save();

        return response()->json(['success' => true, 'message' => 'job saved successfully.']);
    }

    public function GetJobCricular()
    {
        $JobCircular = JobCircular::paginate(10);

        return response()->json($JobCircular);
    }
    public function GetJobPosition(Request $request)
    {
        $positions = JobCircular::select('title')
            ->distinct()
            ->whereNotNull('title')
            ->where('title', '!=', '')
            ->get();

        return response()->json($positions);
    }
    public function CandidatePdfDownload(Request $request)
    {
        $candidate_profile =  $request->all();

        $pdf = PDF::loadView(
            'default.admin.site.jobapplication.candidate_pdf',
            compact('candidate_profile')
        )
            ->setPaper('a4')->setWarnings(false);

        $time = auth()->user()->id . '-' . Carbon::now()->unix();
        $name = $time . '.pdf';

        return $pdf->stream($name);
    }
    public function GetJobApplication(Request $request)
    {
        $pagination    = $request->SearchFilters['pagination'] ?? 10;;
        $status        = $request->SearchFilters['status'] ?? null;
        $apliedDate    = $request->SearchFilters['apliedDate'] ?? null;
        $position   = $request->SearchFilters['position'] ?? null;
        $search     = $request->SearchFilters['search'] ?? null;

        $jobApplications = GlobalJobApplication::where('site_id', session()->get('SITE_ID'))->with('latestPhoto')
            ->when($status, function ($query, $status) {
                $query->where('status', $status);
            })
            ->when($apliedDate, function ($query, $appliedDate) {
                $today = Carbon::today();

                switch ($appliedDate) {
                    case 'today':
                        $query->whereDate('created_at', $today);
                        break;

                    case 'this_week':
                        $query->whereBetween('created_at', [
                            $today->copy()->startOfWeek(),
                            $today->copy()->endOfWeek()
                        ]);
                        break;

                    case 'this_month':
                        $query->whereBetween('created_at', [
                            $today->copy()->startOfMonth(),
                            $today->copy()->endOfMonth()
                        ]);
                        break;

                    case 'last_month':
                        $query->whereBetween('created_at', [
                            $today->copy()->subMonth()->startOfMonth(),
                            $today->copy()->subMonth()->endOfMonth()
                        ]);
                        break;
                }
            })
            ->when($position, function ($query, $position) {
                $query->where('position', 'like', "%$position%");
            })
            ->when($search, function ($query, $search) {
                $query->where(function ($q) use ($search) {
                    $q->where('fullName', 'like', "%$search%")
                        ->orWhere('email', 'like', "%$search%")
                        ->orWhere('phone', 'like', "%$search%");
                });
            })
            ->paginate($pagination);



        $jobApplications->getCollection()->transform(function ($application) {
            $application->appliedDate = $application->created_at->format('Y-m-d H:i:s');
            return $application;
        });



        $counts = GlobalJobApplication::where('site_id', session()->get('SITE_ID'))
            ->selectRaw('
                COUNT(*) as total,
                SUM(CASE WHEN status = "Approved" THEN 1 ELSE 0 END) as approved,
                SUM(CASE WHEN status = "Rejected" THEN 1 ELSE 0 END) as rejected,
                SUM(CASE WHEN status = "Pending" THEN 1 ELSE 0 END) as pending
            ')
            ->first();

        return response()->json(
            [
                'jobApplications' => $jobApplications,
                 'counts' => $counts
            ]);
    }
    public function UpdateApplicationStatus(Request $request)
    {
        $id     = $request->id;
        $status = $request->status;

        $application = JobApplication::find($id);
        if ($application) {
            $application->status = $status;
            $application->save();
            return response()->json(['success' => true, 'message' => 'Application status updated successfully.']);
        } else {
            return response()->json(['success' => false, 'message' => 'Application not found.'], 404);
        }
    }
    public function delete(Request $request)
    {
        $id = $request->id;
        $job = JobCircular::find($id);
        if ($job) {
            $job->delete();
            return response()->json(['success' => true, 'message' => 'Job Circular deleted successfully.']);
        } else {
            return response()->json(['success' => false, 'message' => 'Job Circular not found.'], 404);
        }
    }
}
