<?php

namespace App\Http\Controllers\Site\Progress;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicProgress;
use App\Models\Academic\AcademicSubject;
use App\Models\Site\Progress\SiteClassSubjectProgressArea;
use App\Models\Site\Progress\SiteProgressSetting;
use App\Models\Site\Progress\SiteProgressSubjectAreasSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use Exception;
use Response;
use Session;
use DB;

class SiteProgressCategorySettingController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Site Progress Type Setting Page';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function getProgressList(Request $request){

        $progressList = AcademicProgress::where('use_key','site')->get();
     
        $data = $request->all();
        $progressSettingPresent=SiteProgressSetting::
            where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('status',true)
            ->get();
        $progressArray=[];
        foreach($progressList as $key=>$value){

            $progressArray[$key]=[
                'academic_year_id'=>$request->academic_year_id,
                'academic_class_id'=>$request->academic_class_id,
                'progress_id'=>$value->id,
                'progress_name'=>$value->progress_name,
                'select_progress_id'=>$progressSettingPresent->where('progress_id',$value->id)->first()?true:false,
            ];
        }
        
        return Response::json($progressArray);

    }

    public function createUpdateSiteProgressSettings(Request $request){

        $data = $request->all();
        $progressSettingPresent=SiteProgressSetting::
            where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->get();

        foreach($data['progressList'] as $progress){
            $checkSetting=$progressSettingPresent->where('progress_id',$progress['progress_id'])->first();

            if($checkSetting){
             //   dd($progress['select_progress_id']);
                $checkSetting->status=$progress['select_progress_id'];
                $checkSetting->save();
            }else{
                if($progress['select_progress_id']){
                    $progressSetting=new SiteProgressSetting;

                    $progressSetting->academic_year_id=$progress['academic_year_id'];
                    $progressSetting->academic_class_id=$progress['academic_class_id'];
                    $progressSetting->progress_id=$progress['progress_id'];
                    $progressSetting->status=true;
                    $progressSetting->save();
                }
            }
        }

          return Response::json(['message'=>'Settings Update Successfully',],200);

    }

    
    public function getSiteClassAndSubjectList(Request $request){
       
        $academicClass_ids = SiteShiftClassGroupSectionSetting::pluck('academic_class_id');

        $classList = AcademicClass::whereIn('id', $academicClass_ids)
            ->orderBy('serial_no', 'ASC')
            ->get();
   
        $academic_subject_ids = SubjectGroupConditionSetting::with(['academicClass', 'academicSubject'])
                ->whereIn('academic_class_id', $academicClass_ids)
                ->where('status', true)
                ->pluck('academic_subject_id');


        $subjectList = AcademicSubject::with('classes')
            ->whereIn('id',$academic_subject_ids)
            ->get();;

        return [$classList,$subjectList];

    }

    public function getSiteClassWiseSubjectList(Request $request){

        $data=$request->all();

        $academic_subject_ids = SubjectGroupConditionSetting::with(['academicClass', 'academicSubject'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->where('status', true)
            ->pluck('academic_subject_id');

        $academic_subject_list = AcademicSubject::with('classes')
            ->whereIn('id',$academic_subject_ids)
            ->get();;

        return [$academic_subject_list];

    }


    public function createUpdateProgressSubjectArea(Request $request){

        $progressArea=SiteClassSubjectProgressArea::where('academic_class_id',$request->academic_class_id)
            ->where('academic_subject_id',$request->academic_subject_id)
            ->when(!empty($request->id),function($q) use ($request){
                $q->where('id',$request->id);
            })
            ->where('subject_area',$request->subject_area)
            ->first();

        if($progressArea){
           $progressArea->serial=$request->serial;
           $progressArea->status=$request->status;
           $progressArea->description=$request->description;
           $progressArea->save();
        }else{
             SiteClassSubjectProgressArea::create([
                'site_id'=>Session::get('SITE_ID'),
                'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                'academic_class_id'=>$request->academic_class_id,
                'academic_subject_id'=>$request->academic_subject_id,
                'subject_area'=>$request->subject_area,
                'serial'=>$request->serial,
                'description'=>$request->description,
                'status'=>$request->status,
            ]);
        }

        return Response::json(['message'=>'Settings Update Successfully',],200);

     //   dd($request->all());
    }


    public function getProgressSubjectAreaList(Request $request){

        $data=$request->all();

        $areaList=SiteClassSubjectProgressArea::with(['academicClass','academicSubject'])
            ->when($request->academic_class_id!='null',function($q) use ($data){
                    $q->where('academic_class_id',$data['academic_class_id']);
                })  
            ->when($data['academic_subject_id']!='null',function($q) use ($data){
                    $q->where('academic_subject_id',$data['academic_subject_id']);
                })
      
            // ->where('academic_class_id',$request->academic_class_id)
            // ->where('academic_subject_id',$request->academic_subject_id)
          //  ->whereIn('expertise_id',$expertise_ids)
        //    ->orderBy('expertise_id')
            ->orderBy('serial')
            ->paginate(20);
        
        return response()->json($areaList);
    }


    public function getSiteClassProgressList(Request $request){

         $progressSettingIds=SiteProgressSetting::
            where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->pluck('progress_id')
            ->unique()
            ->values();

        $academicProgress=AcademicProgress::whereIn('id',$progressSettingIds)->get();

        return $academicProgress;

    }



    
    public function subjectSettingListProgressSubjectAreasSetup(Request $request)
    {

        $this->validate($request, [
            'academic_class_id' => 'required',
            'academic_year_id' => 'required',
            'progress_id' => 'required',
        ]);

        $data=$request->all();

        try {

            $subjectList = SubjectGroupConditionSetting::where('academic_class_id', $data['academic_class_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('status', true)
                ->get();

            $presentSubjectAreas=SiteProgressSubjectAreasSetting::with(['academicProgress'])
                    ->where('academic_class_id', $data['academic_class_id'])
                    ->where('academic_year_id', $data['academic_year_id'])
                    ->where('progress_id', $data['progress_id'])
                //    ->where('academic_subject_id', $item['academic_subject_id'])
                    ->where('status', true)
                    ->get();

            $progressAreaList=SiteClassSubjectProgressArea::where('academic_class_id',$request->academic_class_id)->get();

            
                $subject_list=[];
                foreach($subjectList as $key=>$item){

                    $subject_list[$key]['academic_class_id']=$item->academic_class_id;
                    $subject_list[$key]['academic_subject_id']=$item->academic_subject_id;
                    $subject_list[$key]['subject_name']=$item->subject_name;
                    $subject_list[$key]['progress_id']=$request->progress_id;

                    $subjectWiseAreas=$progressAreaList->where('academic_subject_id',$item['academic_subject_id']);
                    $subjectWiseAreaSettings=$presentSubjectAreas->where('academic_subject_id',$item['academic_subject_id']);
                    $area_array=[];
                    $area_key=0;
                    foreach($subjectWiseAreas as $subjectArea){

                        $checkAreaSetting=$subjectWiseAreaSettings->where('subject_learning_area_id',$subjectArea->id)->first();

                        if($checkAreaSetting){
                            $area_array[$area_key]['select_sbuject_area']=true;
                        }else{
                            $area_array[$area_key]['select_sbuject_area']=false;
                        }

                        $area_array[$area_key]['subject_learning_area_id']=$subjectArea->id;
                        $area_array[$area_key]['subject_area']=$subjectArea->subject_area;

                        $area_key++;
                    }

                    $subject_list[$key]['area_array']=$area_array;

            }

            return response()->json(['subject_list'=>$subject_list]);
       } catch (Exception $exception) {
           return $exception->getMessage();

       }
    }

    public function subjectProgressAreasSetupSubmit (Request $request){

        DB::beginTransaction();
        try {

        $this->validate($request, [
            'academic_class_id' => 'required',
            'academic_year_id' => 'required',
            'progress_id' => 'required',
        ]);

        $data=$request->all();

        foreach($data['subject_list'] as $subject){
            if(count($subject['area_array'])){
                foreach($subject['area_array'] as $area){
                   $checkSetting = SiteProgressSubjectAreasSetting::where('academic_year_id',$data['academic_year_id'])
                        ->where('academic_class_id',$subject['academic_class_id'])
                        ->where('progress_id',$subject['progress_id'])
                        ->where('academic_subject_id',$subject['academic_subject_id'])
                        ->where('subject_learning_area_id',$area['subject_learning_area_id'])
                        ->first();
                    if($checkSetting){
                        $checkSetting->status=$area['select_sbuject_area'];
                        $checkSetting->save();
                    }else{
                        if($area['select_sbuject_area']){
                             SiteProgressSubjectAreasSetting::create([
                                'site_id'=>Session::get('SITE_ID'),
                                'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                'academic_year_id'=>$data['academic_year_id'],
                                'academic_class_id'=>$subject['academic_class_id'],
                                'progress_id'=>$subject['progress_id'],
                                'academic_subject_id'=>$subject['academic_subject_id'],
                                'subject_learning_area_id'=>$area['subject_learning_area_id'],
                                'status'=>true,
                            ]);
                        }
                    }
                }
            }
        }

     
        DB::commit();
        // if($alert_array){
        //     return Response::json(['message' =>$alert_array],200);
        // }
        return Response::json(['message' => 'Settings Update Successfully!'],200);


    }  catch (ValidationException $exception) {
        DB::rollBack();
        return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (Exception $exception) {
        DB::rollBack();
        return Response::json(['message' => $exception->getMessage()], 410);
    }

    }



}
