<?php

namespace App\Http\Controllers\Site\Quiz;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Quiz\QuizTopics;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use Response;
use DB;
use Exception;

class QuizTopicsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }
    public function index()
    {
        $viewType = "Quiz";
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function createQuizTopics(Request $request){
   
    try{
        $this->validate($request, [
            'topic_name' => 'required|unique:quiz_topics_translations',
        ]);
      
        $quizTopic = new QuizTopics();
        $quizTopic->topic_name = $request->topic_name;
        $quizTopic->status = $request->status;
        $quizTopic->save();

        return response()->json(['message'=>'Quiz Topics Add Successfully', 'status'=>true]);

    }catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }


    public function getQuizTopiclist(){
       $topic_list = QuizTopics::orderBy('id', 'DESC')->paginate(10);

       return response()->json(['topic_list'=>$topic_list]);
    }


    public function quizTopicEdit(Request $request){
        $topic_item = QuizTopics::findOrFail($request->topic_id);

        return response()->json(['topic_item'=>$topic_item],200);

    }


    public function quizTopicUpate(Request $request){
        try{
            $this->validate($request, [
                'topic_name' => 'required|unique:quiz_topics_translations,topic_name,'.$request->id,
            ]);

          
            $quizTopic =  QuizTopics::findOrFail($request->id);
            $quizTopic->topic_name = $request->topic_name;
            $quizTopic->status = $request->status;
            $quizTopic->save();
    
            return response()->json(['message'=>'Quiz Topics Update Successfully', 'status'=>true]);
    
        }catch (ValidationException $exception) {
                DB::rollBack();
                return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
            } catch (Exception $exception) {
                DB::rollBack();
                return Response::json(['message' => $exception->getMessage()], 410);
            }

        }


        public function quizTopicDelete(Request $request){
           // dd($request->all());
            $quizTopic =  QuizTopics::findOrFail($request->topic_id);
            $quizTopic->delete();
            return response()->json(['message'=>'Quiz Topics Delete Successfully', 'status'=>true]);
        }
    

    }


    

