<?php

namespace App\Http\Controllers\Site\Result\Protyonpotro;


use App\Http\Controllers\Controller;
use App\Models\Academic\ClassType;
use App\Models\Academic\Section;
use App\Models\Academic\StudentClass;
use App\Models\Site\Result\protyonpotro\SiteProtyonpotro;
use App\Models\Site\Result\protyonpotro\SiteProtyonpotroSetting;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\Site\Employee\Employee;
use App\Models\Student\StudentHistory;
use App\Models\User\EmployeeHistory;
use Carbon\Carbon;
use Image;
use File;
use PDF;


use Illuminate\Http\Request;

class SiteProtyonpotroController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }
    public function index()
    {
        $viewType = 'Site Result Report';

        return view('default.admin.layouts.master', compact('viewType'));
        //        return view('default.admin.site.result.site-base-result-report', compact('viewType'));

    }

    public function CreateSiteProtyonpotroSetting(Request $request, SiteProtyonpotroSetting $siteProtyonpotroSetting)
    {
        if (!$request->logo_position) {
            throw new \Exception('Logo Position is required');
        }

        if (!$request->initial_referance_number) {
            throw new \Exception('Initial Referance Number is required');
        }

        $data = $request->all();

        $existing_setting_list = SiteProtyonpotroSetting::when(!empty($data['user_type']), function ($query) use ($data) {
            return $query->where('user_type', $data['user_type']);
        })->first();

        // Handle images
        $border_image = $this->handleImage(
            $request->border_image ?? null,
            $existing_setting_list ? $existing_setting_list->border_image : null,
            'border'
        );

        $watermark_image = $this->handleImage(
            $request->watermark_image ?? null,
            $existing_setting_list ? $existing_setting_list->watermark_image : null,
            'watermark'
        );

        if ($existing_setting_list) {
            foreach ($existing_setting_list->ownFields as $ownFields) {
                if ($request->{$ownFields}) {
                    $existing_setting_list->{$ownFields} = $request->{$ownFields};
                }
            }

            $existing_setting_list->border_image        = $border_image;
            $existing_setting_list->watermark_image     = $watermark_image;
            $existing_setting_list->address_present_status = $request->address_present_status;
            $existing_setting_list->eiin_show_status    = $request->eiin_show_status;
            $existing_setting_list->college_code_show_status = $request->college_code_show_status;
            $existing_setting_list->nu_code_show_status = $request->nu_code_show_status;
            $existing_setting_list->written_by_show_status = $request->written_by_show_status;
            $existing_setting_list->printed_date_show   = $request->printed_date_show;
            $existing_setting_list->parents_title_status = $request->parents_title_status;
            $existing_setting_list->border_image_status = $request->border_image_status;
            $existing_setting_list->watermark_status    = $request->watermark_status;
            $existing_setting_list->session_show_status = $request->session_show_status;
            $existing_setting_list->exam_center_show_status = $request->exam_center_show_status;
            $existing_setting_list->user_type = $request->user_type;
            $existing_setting_list->description = $request->description;

            $existing_setting_list->save();
        } else {
            foreach ($siteProtyonpotroSetting->ownFields as $ownFields) {
                if ($request->{$ownFields}) {
                    $siteProtyonpotroSetting->{$ownFields} = $request->{$ownFields};
                }
            }

            $siteProtyonpotroSetting->border_image        = $border_image;
            $siteProtyonpotroSetting->watermark_image     = $watermark_image;
            $siteProtyonpotroSetting->address_present_status = $request->address_present_status;
            $siteProtyonpotroSetting->eiin_show_status    = $request->eiin_show_status;
            $siteProtyonpotroSetting->college_code_show_status = $request->college_code_show_status;
            $siteProtyonpotroSetting->nu_code_show_status = $request->nu_code_show_status;
            $siteProtyonpotroSetting->written_by_show_status = $request->written_by_show_status;
            $siteProtyonpotroSetting->printed_date_show   = $request->printed_date_show;
            $siteProtyonpotroSetting->parents_title_status = $request->parents_title_status;
            $siteProtyonpotroSetting->border_image_status = $request->border_image_status;
            $siteProtyonpotroSetting->watermark_status    = $request->watermark_status;
            $siteProtyonpotroSetting->session_show_status = $request->session_show_status;
            $siteProtyonpotroSetting->exam_center_show_status = $request->exam_center_show_status;
            $siteProtyonpotroSetting->user_type = $request->user_type;
            $existing_setting_list->description = $request->description;

            $siteProtyonpotroSetting->save();
        }

        return response()->json(['message' => 'Protyonpotro Setup Successfully!', 'mode' => 'Saved!'], 200);
    }
    public function protyonpotroPdfDownload(Request $request, SiteProtyonpotro $siteProtyonpotro)
    {


        ini_set('memory_limit', '-1');

        $data = $request->all();
        $setting_list = SiteProtyonpotroSetting::where('user_type', $data['user_type'])
            ->first();

        $site = SiteInfo::with(['district', 'photo', 'academicBoard'])
            ->where('id', session()->get('SITE_ID'))
            ->select('id', 'site_logo', 'district_id', 'board_id', 'eiin', 'college_code', 'nu_code')
            ->first();

        $institute_head = Employee::where('institute_head', 1)->first();

        $signature = $institute_head->signature ?? '/img/signature/signature.png';
        $designation = $institute_head->designation->name ?? 'Institution Head';


        $page_tittle = "To Whom It May Concern ";
        $report_tittle = "<b>To Whom It May Concern </b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Testimonial";

        if ($request->user_type == 'student') {

            $detail = StudentHistory::with([
                'student' => function ($q) {
                    $q->with(['gender', 'permanentDistrict', 'permanentThana']);
                    $q->select('id', 'gender_id', 'permanent_district_id', 'permanent_thana_id', 'date_of_birth');
                },
                'year',
                'department',
                'stClass',
                'shift',
                'classGroup',
                'session',
                'siteProtyonpotro'
            ])
                ->select(
                    'id',
                    'user_id',
                    'student_roll_number',
                    'academic_year_id',
                    'academic_department_id',
                    'academic_class_id',
                    'academic_class_group_id',
                    'academic_session_id',
                    'board_registration_number',
                    'board_roll_number'
                )
                ->findOrFail($request->id);



            $pdf = PDF::loadView(
                'default.admin.site.result.protyonpotro.site-protyonpotro-pdf',
                compact(
                    'detail',
                    'site',
                    'setting_list',
                    'signature',
                    'designation',
                    'report_tittle',
                    'page_tittle',
                    'report_tittle2',
                    'title_view'
                )
            )
                ->setPaper('a4', 'landscape')
                ->setWarnings(false);


            $path = storage_path() . '/pdf';
            $time = auth()->user()->id . '-' . Carbon::now()->unix();
            $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
            $name = $time . '.pdf';
        } else {
            $detail = EmployeeHistory::with(['designation', 'SiteProtyonpotro', 'employee'])->where('status', 1)->find($request->id);
            $pdf = PDF::loadView(
                'default.admin.site.result.protyonpotro.site-protyonpotro-pdf',
                compact(
                    'detail',
                    'site',
                    'setting_list',
                    'signature',
                    'designation',
                    'report_tittle',
                    'page_tittle',
                    'report_tittle2',
                    'title_view'
                )
            )
                ->setPaper('a4', 'landscape')
                ->setWarnings(false);


            $path = storage_path() . '/pdf';
            $time = auth()->user()->id . '-' . Carbon::now()->unix();
            $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
            $name = $time . '.pdf';
        }


        return response()->json([
            'link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }

    public function GetEmployeeListForProtyonpotro(Request $request)
    {
        return EmployeeHistory::with(['designation', 'SiteProtyonpotro', 'employee'])->where('status', 1)->get()
            ->sortBy(function ($history) {
                return $history->employee ? $history->employee->employee_serial : PHP_INT_MAX;
            })
            ->values(); // reindex after sorting;
    }
    public function GetSiteStudentListForProtyonpotro(Request $request)
    {
        $data = $request->all();


        return $student_ids = StudentHistory::with(['student' => function ($query) {

            $query->with('bloodGroup');
            $query->where('user_type', 'student');
        }])
            ->with(['classGroup', 'section', 'SiteProtyonpotro'])
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->get();
        // ->pluck('id')
        // ->unique();



    }
    public function createUpdateSiteProtyonpotro(
        Request $request,
        SiteProtyonpotroSetting $siteProtyonpotroSetting,
        SiteProtyonpotro $siteProtyonpotro
    ) {
        // Validate required input
        if (!$request->user_type) {
            throw new \Exception('User Type is required');
        }

        $data = $request->all();
        if ($request->user_type == 'student') {
            // Filter selected students
            $SelectedStudentList = collect($data['StudentList'])
                ->where('select', true)
                ->toArray();

            if (empty($SelectedStudentList)) {
                throw new \Exception('At least one student must be selected');
            }

            // Get existing protyonpotro settings for this user type
            $existing_protyonpotro = $siteProtyonpotroSetting
                ->where('user_type', $request->user_type)
                ->first();

            if (!$existing_protyonpotro) {
                throw new \Exception('Please set up Protyonpotro settings first for the selected user type.');
            }

            // Get max reference number for this user type
            $max_ref_number = $siteProtyonpotro
                ->where('user_type', $request->user_type)
                ->max('referance_number');

            // Ensure numeric values
            $initial_ref = is_numeric($existing_protyonpotro->initial_referance_number)
                ? (int) $existing_protyonpotro->initial_referance_number
                : 1;

            $ref_num = $max_ref_number ? ((int) $max_ref_number + 1) : $initial_ref;

            foreach ($SelectedStudentList as $student) {
                // Check if student already has a Protyonpotro
                $student_protyonpotro = $siteProtyonpotro
                    ->where('user_id', $student['user_id'])
                    ->first();

                if (!$student_protyonpotro) {
                    $student_protyonpotro = new SiteProtyonpotro();
                }

                $placeholders = [
                    'student_name'        => $student['full_name'] ?? '',
                    'student_roll'        => $student['student_roll_number'] ?? '',
                    'student_number'      => $student['student']['contact_number'] ?? '',
                    'student_blood_group' => $student['student']['bloodGroup']['blood_group_name'] ?? '',
                    'student_session'     => $student['session']['session_name'] ?? '',
                    'academic_group'      => $student['classGroup']['group_name'] ?? '',
                    'student_section'     => $student['section']['section_name'] ?? '',
                    'student_father_name' => $student['student']['father_name'] ?? '',
                    'student_mother_name' => $student['student']['mother_name'] ?? '',
                ];


                // Replace placeholders in the template
                $descriptionTemplate = $existing_protyonpotro->description;
                foreach ($placeholders as $key => $value) {
                    $descriptionTemplate = str_replace($key, $value, $descriptionTemplate);
                }

                // Set all fields
                $student_protyonpotro->user_id = $student['user_id'];
                $student_protyonpotro->user_type = $request->user_type;
                $student_protyonpotro->referance_prefix = $existing_protyonpotro->initial_referance_prefix;
                $student_protyonpotro->referance_number = $ref_num;
                $student_protyonpotro->referance_suffix = $existing_protyonpotro->initial_referance_suffix;
                $student_protyonpotro->protyonpotro_created_by = auth()->user()->id;
                $student_protyonpotro->status = 1;
                $student_protyonpotro->site_id = auth()->user()->site_id;
                $student_protyonpotro->description = $descriptionTemplate;
                $student_protyonpotro->save();

                // Increment reference number for next student
                $ref_num++;
            }
        } else {

            $SelectedEmployeeList = collect($data['employeeList'])
                ->where('select', true)
                ->toArray();

            if (empty($SelectedEmployeeList)) {
                throw new \Exception('At least one employee must be selected');
            }
            foreach ($SelectedEmployeeList as $employee) {
                // Check if student already has a Protyonpotro
                $employee_protyonpotro = $siteProtyonpotro
                    ->where('user_id', $employee['user_id'])
                    ->first();

                if (!$employee_protyonpotro) {
                    $employee_protyonpotro = new SiteProtyonpotro();
                }

                $placeholders = [
                    'employee_name'        => $employee['full_name'] ?? '',
                    'employee_designation' => $employee['designation_name'] ?? '',
                    'employee_number'      => $employee['employee']['contact_number'] ?? '',
                    'employee_join_date'   => $employee['dept_join_date'] ?? '',
                    'employee_department'  => $employee['department']['department_name'] ?? '',
                    'employee_position'    => $employee['empPosition']['position_name'] ?? '',


                ];

                // Get existing protyonpotro settings for this user type
                $existing_protyonpotro = $siteProtyonpotroSetting
                    ->where('user_type', $request->user_type)
                    ->first();
                if (!$existing_protyonpotro) {
                    throw new \Exception('Please set up Protyonpotro settings first for the selected user type.');
                }
                // Get max reference number for this user type
                $max_ref_number = $siteProtyonpotro
                    ->where('user_type', $request->user_type)
                    ->max('referance_number');
                // Ensure numeric values
                $initial_ref = is_numeric($existing_protyonpotro->initial_referance)
                    ? (int) $existing_protyonpotro->initial_referance_number
                    : 1;
                $ref_num = $max_ref_number ? ((int) $max_ref_number + 1) : $initial_ref;
                // Replace placeholders in the template
                $descriptionTemplate = $existing_protyonpotro->description;
                foreach ($placeholders as $key => $value) {
                    $descriptionTemplate = str_replace($key, $value, $descriptionTemplate);
                }

                // Set all fields
                $employee_protyonpotro->user_id = $employee['user_id'];
                $employee_protyonpotro->user_type = $request->user_type;
                $employee_protyonpotro->referance_prefix = $existing_protyonpotro->initial_referance_prefix;
                $employee_protyonpotro->referance_number = $ref_num;
                $employee_protyonpotro->referance_suffix = $existing_protyonpotro->initial_referance_suffix;
                $employee_protyonpotro->protyonpotro_created_by = auth()->user()->id;
                $employee_protyonpotro->status = 1;
                $employee_protyonpotro->site_id = auth()->user()->site_id;
                $employee_protyonpotro->description = $descriptionTemplate;
                $employee_protyonpotro->save();
                // Increment reference number for next student
                $ref_num++;
            }
        }
    }

    private function handleImage($newImage, $oldImage, $type)
    {
        $folder = public_path('img/site/protyonpotro/');

        if (!File::exists($folder)) {
            File::makeDirectory($folder, 0777, true, true);
        }

        if (!$newImage) {
            return null;
        }

        if ($newImage === "{$type}image.png") {
            return $newImage;
        }

        if ($newImage === $oldImage) {
            return $oldImage;
        }

        if ($oldImage && File::exists($folder . $oldImage)) {
            File::delete($folder . $oldImage);
        }

        $extension = explode('/', explode(':', substr($newImage, 0, strpos($newImage, ';')))[1])[1];
        $filename  = time() . "_{$type}." . $extension;

        Image::make($newImage)->save($folder . $filename);

        return $filename;
    }


    public function getResultTypeBaseProtyonpotroSetting(Request $request)
    {

        $data = $request->all();


        if (empty($data['user_type'])) {
            throw new \Exception('User type is required');
        }


        $existing_setting_list = SiteProtyonpotroSetting::when(!empty($data['user_type']), function ($query) use ($data) {
            return $query->where('user_type', $data['user_type']);
        })->first();



        if ($existing_setting_list) {

            $prefix_present = SiteProtyonpotroSetting::where('referance_prefix', $existing_setting_list->initial_referance_prefix)
                ->Where('referance_suffix', $existing_setting_list->initial_referance_suffix)
                ->where('referance_number', $existing_setting_list->initial_referance_number)
                ->first();


            if ($prefix_present) {
                $arr = [
                    'ref_apply_status' => true,
                ];
            } else {
                $arr = [
                    'ref_apply_status' => false,
                ];
            }

            $setup_list = array_merge($existing_setting_list->toArray(), $arr);
        } else {
            $setup_list = [
                'logo_position' => null,
                'border_image' => null,
                'border_image_status' => false,
                'watermark_image' => null,
                'watermark_status' => false,
                'address_present_status' => true,
                'eiin_show_status' => false,
                'college_code_show_status' => false,
                'nu_code_show_status' => false,
                'initial_referance_number' => null,
                'initial_referance_prefix' => null,
                'initial_referance_suffix' => null,
                'ref_apply_status' => false,

                'session_show_status' => false,
                'testimonial_background_color' => null,
                'exam_center_show_status' => false,
                'exam_center' => null,
                'exam_center_code' => null,
            ];
        }


        return $setup_list;
    }
}
