<?php

namespace App\Http\Controllers\Site\Result\Report;

use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicResultCombineType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicShift;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Academic\AcademicReportCardDesignation;
use App\Models\Site\Result\SiteResultCombineSetting;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteResultPrimarySetting;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteStudentPrimaryResultDetailForTabulation;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject; ///test
use App\Models\Site\Exam\SiteSubjectExaminationExamTypeMark;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\Site\Employee\Employee;

use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Result\SiteExamResultReportSetting;
use Exception;
use Illuminate\Support\Facades\Schema;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicClassGroup;
use Illuminate\Support\Facades\Log;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSection;
use App\Models\Attendance\StudentAttendance;
use App\Models\Site\Employee\EmployeeAttendance;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Result\SiteStudentCombineResultDetail;

use Auth;
use PDF;
use Response;
use Illuminate\Support\facades\Http;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPermission;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPrimarySettingStore;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultSystemSettingStore;
use DateInterval;
use DatePeriod;
use DateTime;
use Session;
class SiteBaseCombineResultReportController extends ProjectController
{
    private $siteExamCommitteeSetting;
    private $simpleSiteExamCommitteeSetting;

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

    public function index()
    {
        $viewType = 'Site Result Report';

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.site.result.site-base-result-report', compact('viewType'));

    }




    public function getSiteBaseStudentAndCombineResultList(Request $request){
        $data = $request->all();

        $studentList=$this->getStudenthistoryList($request);
        $student_ids=$studentList->pluck('id');

        $resultSettingList = SiteResultCombineSetting::with(['academicResultCombineType'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //     return $query->where('academic_department_id', $data['academic_department_id']);
            // })
            // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            // })
            ->where('status', true)
            ->get();

    $academic_result_combine_type_Ids=$resultSettingList->pluck('academic_result_combine_type_id')->unique()->filter();
    $combine_array=[];
    foreach ($academic_result_combine_type_Ids as $key => $value){

        $check_primary_type_Ids=$resultSettingList->where('academic_result_combine_type_id', $value)
            ->pluck('academic_result_primary_type_id')->unique();
           
        $siteExamDeclares_primary_type_ids=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
            ->whereIn('academic_result_primary_type_id', $check_primary_type_Ids)
            ->pluck('academic_result_primary_type_id')->unique();

        if(count($check_primary_type_Ids)==count($siteExamDeclares_primary_type_ids)){
            $combine_list=$resultSettingList->where('academic_result_combine_type_id', $value)->first();
            $combine_array[]=$combine_list->academic_result_combine_type_id;
        }
    }
   
    $academic_result_combine_type=AcademicResultCombineType::whereIn('id', $combine_array)->get();

    $test_arr=Array();
    $resultlist=[];
    foreach ($academic_result_combine_type as $key => $value){

        $test_arr['loading_result_generate_image']=false;
        $resultlist[$key]=array_merge($test_arr, $value->toArray());
    }

    return [$studentList, $resultlist];

    }



    public function getSiteStudentAndCombineResultTypeBaseResultDetail(Request $request){

        $data = $request->all();

        $combine_result_list=SiteStudentCombineResultDetail::with(['studentHistory'=>function($q){
                        $q->with('student','stClass','year','classGroup','session','section');
                    }])
                        ->where('academic_result_combine_type_id',$data['academic_result_combine_type_id'])
                        ->whereIn('student_history_id',$data['select_student_user_ids'])
                        ->get();

        $student_result_array=[];
        foreach($combine_result_list as $key=>$combine_result){

            $student_result_array[$key]['student_name']=$combine_result->studentHistory->full_name;
            $student_result_array[$key]['student_roll']=$combine_result->studentHistory->student_full_roll_number;
            $student_result_array[$key]['father_name']=$combine_result->studentHistory->student->father_name;
            $student_result_array[$key]['mother_name']=$combine_result->studentHistory->student->mother_name;
            $student_result_array[$key]['academic_year_name']=$combine_result->studentHistory->year?$combine_result->studentHistory->year->year_name:'N/A';
            $student_result_array[$key]['academic_shift_name']=$combine_result->studentHistory->shift?$combine_result->studentHistory->shift->shift_name:'N/A';
            $student_result_array[$key]['class_name']=$combine_result->studentHistory->stClass?$combine_result->studentHistory->stClass->class_name:'N/A';
       
            $student_result_array[$key]['class_group_name']=$combine_result->studentHistory->classGroup?$combine_result->studentHistory->classGroup->group_name:'N/A';
            $student_result_array[$key]['section_name']=$combine_result->studentHistory->section?$combine_result->studentHistory->section->section_name:'N/A';
            $student_result_array[$key]['session_name']=$combine_result->studentHistory->session?$combine_result->studentHistory->session->session_name:'N/A';

            $student_result_array[$key]['result_type_name']=$combine_result->academicResultCombineType->name;

            $student_result_array[$key]['student_history']=$combine_result->studentHistory;
            $student_result_array[$key]['student_history_id']=$combine_result->student_history_id;
            $student_result_array[$key]['academic_result_combine_type_id']=$combine_result->academic_result_combine_type_id;
            $student_result_array[$key]['gpa']=$combine_result->gpa;
            $student_result_array[$key]['grade']=$combine_result->grade;
            $student_result_array[$key]['student_rank']=$combine_result->student_rank;
            $student_result_array[$key]['average_total_marks']=$combine_result->average_total_marks;
            $student_result_array[$key]['average_marks']=$combine_result->average_marks;
            $student_result_array[$key]['individual_primary_result_list']=json_decode($combine_result->individual_primary_result_list);

            $primary_result_type_list=[];
            foreach(json_decode($combine_result->table_header)->primary_result_type_list as $keys=>$pri_result){
              
                $primary_result_type_list[$keys]['academic_result_primary_type_id']=$pri_result->academic_result_primary_type_id;
                $primary_result_type_list[$keys]['academic_result_primary_type_name']=$pri_result->academic_result_primary_type_name;
              
            }
            $table_header['primary_result_type_list']=$primary_result_type_list;


            $student_result_array[$key]['table_header']=$table_header;

            $subject_array=[];
            foreach(json_decode($combine_result->result_detail) as $keys=>$subject){
                $subject_array[$keys]['exam_dependent_academic_subject']=$subject->exam_dependent_academic_subject;
                $subject_array[$keys]['raw_total_marks']=$subject->raw_total_marks;
                $subject_array[$keys]['total_pass_marks']=$subject->total_pass_marks;
                $subject_array[$keys]['subject_point']=$subject->subject_point;
                $subject_array[$keys]['subject_grade']=$subject->subject_grade;
                $subject_array[$keys]['average_subject_mark']=$subject->average_subject_mark;
                $subject_array[$keys]['total_subject_mark']=$subject->total_subject_mark;

                $primary_result_array=[];

                foreach(json_decode($subject->primary_result_list) as $keyss=>$primary_result){
                    $primary_result_array[$keyss]['obtain_percent_total_marks']=$primary_result->obtain_percent_total_marks;
                    $primary_result_array[$keyss]['obtain_subject_total_marks']=$primary_result->obtain_subject_total_marks;
                    $primary_result_array[$keyss]['subject_grade']=$primary_result->subject_grade;
                    $primary_result_array[$keyss]['subject_point']=$primary_result->subject_point;
                    $primary_result_array[$keyss]['academic_result_primary_type_id']=$primary_result->academic_result_primary_type_id;
                    $primary_result_array[$keyss]['exam_dependent_academic_subject_id']=$primary_result->exam_dependent_academic_subject_id;
                    $primary_result_array[$keyss]['subject_base_pass_fail_status']=$primary_result->subject_base_pass_fail_status;
                    $primary_result_array[$keyss]['subject_count']=$primary_result->subject_count;
                }

                $subject_array[$keys]['primary_result_array']=$primary_result_array;
            }

            $student_result_array[$key]['average_marks']=$combine_result->average_marks;
            $student_result_array[$key]['subject_list']=$subject_array;

        }


        return $student_result_array;

    }

    
    public function getSiteStudentAndCombineResultTypeBaseResultDetailOne(Request $request){
       
        $data = $request->all();

        $combine_result_list=SiteStudentCombineResultDetail::with(['studentHistory'=>function($q){
                        $q->with('student','stClass','year','classGroup','session','section');
                    }])
                        ->where('academic_result_combine_type_id',$data['academic_result_combine_type_id'])
                        ->whereIn('student_history_id',$data['select_student_user_ids'])
                      //  ->where('student_history_id',71255)
                        ->get();

        
        $student_result_array=[];
        foreach($combine_result_list as $key=>$combine_result){

            $student_result_array[$key]['student_name']=$combine_result->studentHistory->full_name;
            $student_result_array[$key]['student_roll']=$combine_result->studentHistory->student_full_roll_number;
            $student_result_array[$key]['father_name']=$combine_result->studentHistory->student->father_name;
            $student_result_array[$key]['mother_name']=$combine_result->studentHistory->student->mother_name;
            $student_result_array[$key]['academic_year_name']=$combine_result->studentHistory->year?$combine_result->studentHistory->year->year_name:'';
            $student_result_array[$key]['academic_shift_name']=$combine_result->studentHistory->shift?$combine_result->studentHistory->shift->shift_name:'';
            $student_result_array[$key]['class_name']=$combine_result->studentHistory->stClass?$combine_result->studentHistory->stClass->class_name:'';
            $student_result_array[$key]['class_group_name']=$combine_result->studentHistory->classGroup?$combine_result->studentHistory->classGroup->group_name:'';
            $student_result_array[$key]['section_name']=$combine_result->studentHistory->section?$combine_result->studentHistory->section->section_name:'';
            $student_result_array[$key]['session_name']=$combine_result->studentHistory->session?$combine_result->studentHistory->session->session_name:'';
            $student_result_array[$key]['result_type_name']=$combine_result->academicResultCombineType->name;
            $student_result_array[$key]['student_history']=$combine_result->studentHistory;
            $student_result_array[$key]['student_history_id']=$combine_result->student_history_id;
            $student_result_array[$key]['academic_result_combine_type_id']=$combine_result->academic_result_combine_type_id;
            $student_result_array[$key]['average_percent_total_marks']=$combine_result->average_percent_total_marks;
            $student_result_array[$key]['gpa']=$combine_result->gpa;
            $student_result_array[$key]['grade']=$combine_result->grade;
            $student_result_array[$key]['student_rank']=$combine_result->student_rank;
            $student_result_array[$key]['average_total_marks']=$combine_result->average_total_marks;
            $student_result_array[$key]['average_marks']=$combine_result->average_marks;
            $student_result_array[$key]['individual_primary_result_list']=json_decode($combine_result->individual_primary_result_list);

            $primary_result_type_list=[];
            foreach(json_decode($combine_result->table_header)->primary_result_type_list as $keys=>$pri_result){
              
                $primary_result_type_list[$keys]['academic_result_primary_type_id']=$pri_result->academic_result_primary_type_id;
                $primary_result_type_list[$keys]['academic_result_primary_type_name']=$pri_result->academic_result_primary_type_name;
              
            }
            $table_header['primary_result_type_list']=$primary_result_type_list;


            $student_result_array[$key]['table_header']=$table_header;

            $subject_array=[];

           
            foreach(json_decode($combine_result->result_detail) as $keys=>$subject){
                $subject_array[$keys]['exam_dependent_academic_subject']=$subject->exam_dependent_academic_subject;
                $subject_array[$keys]['raw_total_marks']=$subject->raw_total_marks;
                $subject_array[$keys]['total_pass_marks']=$subject->total_pass_marks;
                $subject_array[$keys]['subject_point']=$subject->subject_point;
                $subject_array[$keys]['subject_grade']=$subject->subject_grade;
                $subject_array[$keys]['average_subject_mark']=$subject->average_subject_mark;
                $subject_array[$keys]['total_subject_mark']=$subject->total_subject_mark;

                $primary_result_array=[];

                foreach(json_decode($subject->primary_result_list) as $keyss=>$primary_result){
                    $primary_result_array[$keyss]['obtain_percent_total_marks']=$primary_result->obtain_percent_total_marks;
                    $primary_result_array[$keyss]['obtain_subject_total_marks']=$primary_result->obtain_subject_total_marks;
                    $primary_result_array[$keyss]['subject_grade']=$primary_result->subject_grade;
                    $primary_result_array[$keyss]['subject_point']=$primary_result->subject_point;
                    $primary_result_array[$keyss]['academic_result_primary_type_id']=$primary_result->academic_result_primary_type_id;
                    $primary_result_array[$keyss]['exam_dependent_academic_subject_id']=$primary_result->exam_dependent_academic_subject_id;
                    $primary_result_array[$keyss]['subject_base_pass_fail_status']=$primary_result->subject_base_pass_fail_status;
                    $primary_result_array[$keyss]['subject_count']=$primary_result->subject_count;
                }

               

                $subject_array[$keys]['primary_result_array']=$primary_result_array;
            }

            $student_result_array[$key]['average_marks']=$combine_result->average_marks;
            $student_result_array[$key]['subject_list']=$subject_array;
        }

    //    dd($student_result_array);

        return $student_result_array;
    }
    public function getSiteStudentAndCombineResultTypeBaseResultDetailTwo(Request $request){

        $data = $request->all();
        $combine_result_list=SiteStudentCombineResultDetail::with(['studentHistory'=>function($q){
            $q->with('student','stClass','year','classGroup','session','section');
        }])
            ->where('academic_result_combine_type_id',$data['academic_result_combine_type_id'])
            ->whereIn('student_history_id',$data['select_student_user_ids'])
            ->get();

        $student_result_array=[];
        foreach($combine_result_list as $key=>$combine_result){
          
            $student_result_array[$key]['student_name']=$combine_result->studentHistory->full_name;
            $student_result_array[$key]['student_roll']=$combine_result->studentHistory->student_full_roll_number;
            $student_result_array[$key]['father_name']=$combine_result->studentHistory->student->father_name;
            $student_result_array[$key]['mother_name']=$combine_result->studentHistory->student->mother_name;
            $student_result_array[$key]['academic_year_name']=$combine_result->studentHistory->year?$combine_result->studentHistory->year->year_name:'';
            $student_result_array[$key]['academic_shift_name']=$combine_result->studentHistory->shift?$combine_result->studentHistory->shift->shift_name:'';
            $student_result_array[$key]['class_name']=$combine_result->studentHistory->stClass?$combine_result->studentHistory->stClass->class_name:'N/A';
            $student_result_array[$key]['class_group_name']=$combine_result->studentHistory->classGroup?$combine_result->studentHistory->classGroup->group_name:'';
            $student_result_array[$key]['section_name']=$combine_result->studentHistory->section?$combine_result->studentHistory->section->section_name:'';
            $student_result_array[$key]['session_name']=$combine_result->studentHistory->session?$combine_result->studentHistory->session->session_name:'';
            $student_result_array[$key]['result_type_name']=$combine_result->academicResultCombineType->name;
            $student_result_array[$key]['student_history']=$combine_result->studentHistory;
            $student_result_array[$key]['student_history_id']=$combine_result->student_history_id;
            $student_result_array[$key]['academic_result_combine_type_id']=$combine_result->academic_result_combine_type_id;
            $student_result_array[$key]['average_percent_total_marks']=$combine_result->average_percent_total_marks;
            $student_result_array[$key]['gpa']=$combine_result->gpa;
            $student_result_array[$key]['grade']=$combine_result->grade;
            $student_result_array[$key]['student_rank']=$combine_result->student_rank;
            $student_result_array[$key]['average_total_marks']=$combine_result->average_total_marks;
            $student_result_array[$key]['average_marks']=$combine_result->average_marks;
            $student_result_array[$key]['student_combine_subject_present_status']=$combine_result->combine_subject_present_status;
            $student_result_array[$key]['individual_primary_result_list']=json_decode($combine_result->individual_primary_result_list);
            $student_result_array[$key]['table_header']=json_decode($combine_result->table_header);
            $subject_array=[];
            foreach(json_decode($combine_result->result_detail) as $keys=>$subject){
                //dd($subject);
                $subject_array[$keys]['exam_dependent_academic_subject']=$subject->exam_dependent_academic_subject;
                $subject_array[$keys]['raw_total_marks']=$subject->raw_total_marks;
                $subject_array[$keys]['total_pass_marks']=$subject->total_pass_marks;
                $subject_array[$keys]['subject_point']=$subject->subject_point;
                $subject_array[$keys]['subject_grade']=$subject->subject_grade;
                $subject_array[$keys]['average_subject_mark']=$subject->average_subject_mark;
                $subject_array[$keys]['total_subject_mark']=$subject->total_subject_mark;
                $subject_array[$keys]['individual_subject_array']=$subject->individual_subject_array;
                $subject_array[$keys]['combine_subject_present_status']=$subject->combine_subject_present_status;
            }
            $student_result_array[$key]['average_marks']=$combine_result->average_marks;
            $student_result_array[$key]['subject_list']=$subject_array;
    
        }

        return $student_result_array;
       
    }


    public function siteBaseMultipleStudentDetailsCombineResultPdf(Request $request){
        ini_set('memory_limit', '-1');
        $data = $request->all();

         $resultSetting = SiteExamResultReportSetting::where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->first();

        if(!$resultSetting){
            $resultSetting = SiteExamResultReportSetting::first();
        }
        if(!$resultSetting){
           return Response::json(['message'=>'Please Make Result Settings'],410);
        }

        $result_system_list=SiteResultSystemSetting::with(['academicResultSystem'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->orderBy('point', 'DESC')
            ->get()
            ->sortBy(function ($item) {
                return $item->academicResultSystem->serial ?? 0;
            });


        // $result_system_list=$combne_result[1];
        // $combineResultSettingList=$combne_result[2];

     //  dd($student_array);

              //============ domain name =============
        $site_info =  SiteInfo::find(Session::get('SITE_ID'));
        if($site_info->domain_name==null){
             $alias = $site_info->site_alias;
            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $host = $parsedUrl['host'];
            $host_names = explode(".", $host);
            $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

            if ($host_names[count($host_names) - 1] == 'bd') {
                $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
            }
            if (count($host_names) == 2) {
                $bottom_host_name = $host_names[count($host_names) - 1];
            }
            $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;
      
        }else{
            $domain = $site_info->domain_name;
        }

        $institute_head = Employee::where('institute_head', 1)->first();

        $institute_head_signature = $institute_head->signature ?? '/img/signature/signature.png';
        $institute_head_designation = $institute_head->designation->name ?? 'Institution Head';
  
     
       $report_tittle='Final Result';
       $report_tittle2='';

       if($request->page_orientaion=='landscape'){

       if($resultSetting->combine_result_sheet_no=='one'){
        $student_array=$this->getSiteStudentAndCombineResultTypeBaseResultDetailOne($request);
        $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-multiple-student-combine-result-detail-report-card-one',
            compact('student_array', 'site_info', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain',
            'data','site_info','resultSetting','institute_head_signature','institute_head_designation'))
        ->setPaper('a4', 'landscape')->setWarnings(false);
       }else{
        $student_array=$this->getSiteStudentAndCombineResultTypeBaseResultDetailTwo($request);

        $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-multiple-student-combine-result-detail-report-card-two',
            compact('student_array', 'site_info', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain',
            'data','site_info','resultSetting','institute_head_signature','institute_head_designation'))
        ->setPaper('a4', 'landscape')->setWarnings(false);
       }
           
           
        }
       

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);
    
    }


    //================================Tabulation Sheet======================

    private function getStudenthistoryList(Request $request){
      
        
        $data = $request->all();
        $studentList = StudentHistory::select('id', 'user_id','student_roll_number','site_batch_detail_id')
            ->with(['student' => function ($q) {
                $q->with('latestPhoto');
                $q->select('id');
                $q->where('user_type', 'student');
            },
                'year', 'shift','department','batch','stClass','classGroup','session','section'
            ])
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            // ->when(!empty($data['status']), function ($query) use ($data) {
            //     return $query->where('status', $data['status']);
            // })
            //->where('status',true)
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_department_id')
            ->orderBy('site_batch_detail_id')
            ->orderBy('academic_class_group_id')
            ->get();

    //    dd($studentList);
        return $studentList;
    
    }





}
