<?php

namespace App\Http\Controllers\Site\Result;


use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicResultSystem;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class SiteBaseResultSystemSettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

//    public function index()
//    {
//        $viewType = 'Site Result Setting Page';
//
//
//        return view('default.admin.site.result.site-base-result-setting', compact('viewType'));
//
//    }


    public function getSiteBaseResultSystemList(Request $request){

        $data = $request->all();
        $siteInfoSetting=SiteInfoSetting::select('academic_result_system_ids')
            ->first();

        $academic_result_system=AcademicResultSystem::
            whereIn('id', explode(',', $siteInfoSetting->academic_result_system_ids))
            ->orderBy('serial','ASC')
            ->get();


        $sClassLi=SiteShiftClassGroupSectionSetting::where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })

            ->distinct('academic_class_id')
            ->pluck('academic_class_id');

        $academic_class_list=AcademicClass::whereIn('id', $sClassLi)
            ->get();

        $siteResultSystemSettingPresent=SiteResultSystemSetting::where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status',true)
            ->get();




        $class_list_arr=Array();
        $class_list_array=[];
        foreach ($academic_class_list as $key => $value) {

            $result_system_arr=Array();
            $result_system_array=[];
            foreach ($academic_result_system as $k => $v) {

                if(count($siteResultSystemSettingPresent)>0){
                    $check= $siteResultSystemSettingPresent->where('academic_class_id', $value['id'])
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->where('academic_result_system_id',$v['id'])
                        ->first();

                    if($check){
                        $result_system_arr['select_result_system']=true;
                        $result_system_arr['number_from']=$check->number_from;
                        $result_system_arr['number_to']=$check->number_to;
                        $result_system_arr['point']=$check->point;
                        $result_system_arr['point_from']=$check->point_from;
                        $result_system_arr['point_to']=$check->point_to;
                        $result_system_arr['pass_fail_status']=$check->pass_fail_status?'pass':'fail';
                        $result_system_arr['performance']=$check->performance;
                        $result_system_arr['description']=$check->description;
                    }
                    else{
                        $result_system_arr['select_result_system']=false;
                        $result_system_arr['number_from']=null;
                        $result_system_arr['number_to']=null;
                        $result_system_arr['point']=null;
                        $result_system_arr['point_from']=null;
                        $result_system_arr['point_to']=null;
                        $result_system_arr['pass_fail_status']=null;
                        $result_system_arr['performance']=null;
                        $result_system_arr['description']=null;
                    }
                }
                else{
                    $result_system_arr['select_result_system']=false;
                    $result_system_arr['number_from']=null;
                    $result_system_arr['number_to']=null;
                    $result_system_arr['point']=null;
                    $result_system_arr['point_from']=null;
                    $result_system_arr['point_to']=null;
                    $result_system_arr['pass_fail_status']=null;
                    $result_system_arr['performance']=null;
                    $result_system_arr['description']=null;
                }

                $result_system_array[$k]=array_merge($v->toArray(), $result_system_arr);
            }



            if(count($siteResultSystemSettingPresent)>0) {
                $checks = $siteResultSystemSettingPresent->where('academic_class_id', $value['id'])
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->first();

                if($checks){
                    $class_list_arr['select_class']=true;
                }else{
                    $class_list_arr['select_class']=false;
                }
            }else{
                $class_list_arr['select_class']=false;
            }



            $class_list_arr['result_system_list']=$result_system_array;


            $class_list_array[$key]=array_merge($value->toArray(), $class_list_arr);
        }

        return $class_list_array;

    }








    public function createUpdateResultSystemSetting(Request $request){


        $data = $request->all();

        $siteResultSystemSettingPresent=SiteResultSystemSetting::where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->get();



        $present_ids=[];
        if(count($siteResultSystemSettingPresent)>0){

            $present_ids=$siteResultSystemSettingPresent->pluck('id');
        }


        $charges=[];
        $check_ids=[];
        foreach ($request->ResultSystemTypeList as $key => $value) {

            if($value['select_class']){

                foreach ($value['result_system_list'] as $k => $v) {

                    if($v['select_result_system']){



                        if(count($siteResultSystemSettingPresent)>0){

                          $check= $siteResultSystemSettingPresent->where('academic_class_id', $value['id'])
                              ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                                  return $query->where('academic_department_id', $data['academic_department_id']);
                              })
                              ->where('academic_result_system_id',$v['id'])
                              ->first();

                            if($check){

                                $check_ids[]=$check->id;

                                $check->update([
                                    'number_from'=>$v['number_from'],
                                    'number_to'=>$v['number_to'],
                                    'point'=>$v['point'],
                                    'point_from'=>$v['point_from'],
                                    'point_to'=>$v['point_to'],
                                    'pass_fail_status'=>$v['pass_fail_status']=='pass'?true:false,
                                    'performance'=>$v['performance'],
                                    'description'=>$v['description'],
                                    'status'=>true,
                                ]);



                            }
                            else{
                                $charges[] = [
                                    'academic_department_id'=>$request->academic_department_id,
                                    'academic_class_id'=>$value['id'],
                                    'academic_shift_id'=>$request->academic_shift_id,
                                    'academic_version_id'=>$request->academic_version_id,
                                    'academic_year_id'=>$request->academic_year_id,

                                    'academic_result_system_id'=>$v['id'],

                                    'number_from'=>$v['number_from'],
                                    'number_to'=>$v['number_to'],
                                    'point'=>$v['point'],
                                    'point_from'=>$v['point_from'],
                                    'point_to'=>$v['point_to'],
                                    'pass_fail_status'=>$v['pass_fail_status']=='pass'?true:false,
                                    'performance'=>$v['performance'],
                                    'description'=>$v['description'],
                                    'status'=>true,
                                    'site_id'=>Session::get('SITE_ID'),
                                    'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                ];

                            }


                        }
                        else{
                            $charges[] = [
                                'academic_department_id'=>$request->academic_department_id,
                                'academic_class_id'=>$value['id'],
                                'academic_shift_id'=>$request->academic_shift_id,
                                'academic_version_id'=>$request->academic_version_id,
                                'academic_year_id'=>$request->academic_year_id,

                                'academic_result_system_id'=>$v['id'],
                                'number_from'=>$v['number_from'],
                                'number_to'=>$v['number_to'],
                                'point'=>$v['point'],
                                'point_from'=>$v['point_from'],
                                'point_to'=>$v['point_to'],
                                'pass_fail_status'=>$v['pass_fail_status']=='pass'?true:false,
                                'performance'=>$v['performance'],
                                'description'=>$v['description'],
                                'status'=>true,
                                'site_id'=>Session::get('SITE_ID'),
                                'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                            ];

                        }

                    }

                }




            }

        }



        if(count($charges)>0){
            SiteResultSystemSetting::insert($charges);
        }


        if(count($present_ids)>0){
            $resultSystemAbsentCheck=array_diff($present_ids->toArray(), $check_ids);

            SiteResultSystemSetting::whereIn('id', $resultSystemAbsentCheck)->update(['status'=>false]);
        }





        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);


    }




}
