<?php

namespace App\Http\Controllers\Site;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Fee\GlobalSiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use DB;
use Error;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use JsonSchema\Exception\ValidationException;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo;
use Response;
use Session;

class SiteFeeAllocationController extends ProjectController
{
    private $siteFeeAllocation;
    private $siteInfoSetting;

    public function __construct(SiteStudentFeeFineAllocation $siteFeeAllocation, SiteInfoSetting $siteInfoSetting)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->siteFeeAllocation = $siteFeeAllocation;
        $this->siteInfoSetting = $siteInfoSetting;

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Fee Head List';
        return view('default.admin.sites.site-fee-allocation.view', compact('viewType'));
    }

    public function getSiteFeeHeadAllocationList()
    {

        $fee_allocation = new SiteFeeAllocation();
        $fee_allocation_list = $fee_allocation->get();
        return $fee_allocation_list;

    }

    public function checkExistFeeAllocation(Request $request)
    {
//        return $request;
//        $academic_version_id = $request->academic_version_id;
//        $academic_year_id = $request->academic_year_id;
//        $academic_shift_id = $request->academic_shift_id;
//        $academic_class_id = $request->academic_class_id;
//        $academic_department_id = $request->academic_department_id;
//        $academic_session_id = $request->academic_session_id;
//        $academic_student_admission_type_id = $request->academic_student_admission_type_id;
//        $academic_student_category_id = $request->academic_student_category_id;
//        $academic_student_type_id = $request->academic_student_type_id;
//        $academic_class_group_id= $request->academic_class_group_id;

        $data = $request->all();

        $exist_fee_allocation = SiteStudentFeeFineAllocation::where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->where('academic_student_category_id', $data['academic_student_category_id']);
            })
            ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_type_id', $data['academic_student_type_id']);
            })
            ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
            })

            ->when(empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->whereNull('academic_department_id');
            })
            ->when(empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->whereNull('academic_class_id');
            })
            ->when(empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->whereNull('academic_section_id');
            })
            ->when(empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->whereNull('academic_class_group_id');
            })
            ->when(empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->whereNull('academic_session_id');
            })
            ->when(empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->whereNull('academic_student_category_id');
            })
            ->when(empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->whereNull('academic_student_type_id');
            })
            ->when(empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->whereNull('academic_student_admission_type_id');
            })
            ->where('status', true)
            ->get();
        if(count($exist_fee_allocation)>0){
            return 'proceed';
        }else{
            $exist_another_fee_allocation = SiteStudentFeeFineAllocation::where('academic_year_id', $request->academic_year_id)
                ->where('academic_version_id', $request->academic_version_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('status', true)
                ->get();
            if(count($exist_another_fee_allocation)>0){
                return 'notproceed';
            }else{
                return 'proceed';
            }
        }
    }

    public function getSubHeadListByVersionIdYearidShiftIdClassId($offerType = null,
                                                                  $versionID = null, $yearID = null, $shiftId = null,
                                                                  $departmentId = null, $classId = null, $sectionId = null,
                                                                  $classGroupId = null, $sessionId = null)
    {
        $data = [];
        $data['site_student_fee_offer_type_id'] = $offerType == 'null' ? null : $offerType;
        $data['academic_version_id'] = $versionID == 'null' ? null : $versionID;
        $data['academic_year_id'] = $yearID == 'null' ? null : $yearID;
        $data['academic_shift_id'] = $shiftId == 'null' ? null : $shiftId;
        $data['academic_department_id'] = $departmentId == 'null' ? null : $departmentId;
        $data['academic_class_id'] = $classId == 'null' ? null : $classId;
        $data['academic_section_id'] = $sectionId == 'null' ? null : $sectionId;
        $data['academic_class_group_id'] = $classGroupId == 'null' ? null : $classGroupId;
        $data['academic_session_id'] = $sessionId == 'null' ? null : $sessionId;


        $this->checkClassSectionGroup($data['academic_version_id'], $data['academic_year_id'], $data['academic_shift_id'], $data['academic_department_id'],
            $data['academic_class_id'], $data['academic_class_group_id'], $data['academic_section_id'], $data['academic_session_id']);
        if (!$data['site_student_fee_offer_type_id']) {
            throw new Error("Please Select Offer Type Fields!");
        }

        $fee_allocation = new SiteFeeAllocation();
        $fee_allocation_list = $fee_allocation
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })->pluck('academic_fee_sub_head_id');

        $academic_sub_head = new AcademicFeeSubHead();
        $academic_sub_head_list = $academic_sub_head->whereIn('id', $fee_allocation_list)->get();
        return $academic_sub_head_list;

    }

    public function getSiteVersionYearShiftBaseDepartmentClass($version_id, $year_id, $shift_id)
    {

        $academicDepartmentList=GlobalSiteShiftClassGroupSectionSetting::with(['academicDepartment'])
            ->where('academic_version_id',$version_id)
            ->where('academic_year_id',$year_id)
            ->where('academic_shift_id',$shift_id)
            ->whereNotNull('academic_department_id')
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->where('site_id', Session::get('SITE_ID'))
            ->distinct()
            ->get(['academic_department_id']);


        $academicClassList=[];
        if(count($academicDepartmentList)<=0){
            $academic_class_ids=GlobalSiteShiftClassGroupSectionSetting::with(['academicClass'])
                ->where('academic_version_id',$version_id)
                ->where('academic_year_id',$year_id)
                ->where('academic_shift_id',$shift_id)
                ->whereNotNull('academic_class_id')
                ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                ->where('site_id', Session::get('SITE_ID'))
                ->distinct()
                ->pluck('academic_class_id')
                ->unique()
                ->values();

                $academicClassList=AcademicClass::whereIn('id',$academic_class_ids)->get();
              
        }


        return [$academicClassList, $academicDepartmentList];
    }

    public function getSiteGlobalFeeHeadAllocation(Request $request){

        $FeeGroupsID=AcademicFeeGroup::whereIn('head_key', ['global'])->pluck('id');
        $siteSettings=SiteInfoSetting::first();

        $feeHeadList= AcademicFeeHead::whereIn('id', explode(',', $siteSettings->academic_fee_head_ids))->get();

        $siteGroupsFeeHead=SiteStudentFeeSubHeadAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
            ->where('academic_fee_group_id', $FeeGroupsID)
            ->get();

        $headArray=[];
        foreach ($feeHeadList as $key => $value) {

            $feeheadArr=Array();
            foreach ($siteGroupsFeeHead as $keys => $values) {

                if($values->academic_fee_head_id==$value->id){
                    $feeheadArr['id']=$values->academic_fee_head_id;
                    $feeheadArr['name']=$values->academicFeeHead->name;

                    $headArray[$key]=$feeheadArr;
                }
            }
        }

        $academicFeeGroup=AcademicFeeGroup::get();

        $feeheadidsArray=[];
        $feeheadidsArr=Array();
        foreach ($headArray as $key => $value) {
            $feegroupids=$siteGroupsFeeHead->where('academic_fee_head_id', $value['id'])->pluck('academic_fee_group_id');
            $academicFeeGroupList=$academicFeeGroup->whereIn('id', $feegroupids);
            $feeheadidsArr['academic_fee_group_list']=$academicFeeGroupList;
            $feeheadidsArray[$key]=array_merge($feeheadidsArr, $value);
        }

        $siteFeeAllocationPresent=SiteStudentFeeFineAllocation::whereIn('academic_fee_group_id',$FeeGroupsID)
            ->where('academic_version_id',$request->academic_version_id)
            ->where('academic_shift_id',$request->academic_shift_id)
            ->where('academic_year_id',$request->academic_year_id)
            ->whereNull('academic_class_id')
            ->whereNull('academic_department_id')
            ->where('status', 1)
            ->get();

        $cFeeHeadArr=Array();
        $cFeeHeadArray=[];
        foreach ($feeheadidsArray as $key => $value) {

            $bArr=Array();
            $bArray=[];
            foreach ($value['academic_fee_group_list'] as $keys => $values) {

                $feeGroupPresent=$siteFeeAllocationPresent
                    ->where('academic_fee_head_id', $value['id'])
                    ->where('academic_fee_group_id', $values['id'])
                    ->first();
                if($feeGroupPresent){
                    $bArr['select_fee_group_id']=true;
                }else{
                    $bArr['select_fee_group_id']=false;
                }

                $checkfeegroupid=$siteGroupsFeeHead
                    ->where('academic_fee_head_id', $value['id'])
                    ->where('academic_fee_group_id', $values['id']);

                $aArr=Array();
                $aArray=[];
                foreach ($checkfeegroupid as $ke => $val) {
                    $aArr['id']=$val->academic_fee_sub_head_id;
                    $aArr['name']=$val->academicFeeSubHead->name;

                    $feeSubHeadPresent=$siteFeeAllocationPresent
                        ->where('academic_fee_head_id', $value['id'])
                        ->where('academic_fee_group_id', $values['id'])
                        ->where('academic_fee_sub_head_id', $val->academic_fee_sub_head_id)
                        ->first();
                    if($feeSubHeadPresent){
                        $aArr['select_fee_sub_head_id']=true;
                        $aArr['amount']=$feeSubHeadPresent->amount;
                        $aArr['fine_amount']=$feeSubHeadPresent->fine_amount;
                        $aArr['fine_applicable_day']=$feeSubHeadPresent->fine_applicable_day;
                    }else{
                        $aArr['select_fee_sub_head_id']=false;
                        $aArr['amount']=null;
                        $aArr['fine_amount']=null;
                        $aArr['fine_applicable_day']=null;
                    }

                    $aArray[$ke]=array_merge($aArr);
                }
                $bArr['academic_fee_sub_head']=$aArray;

                $bArray[$keys]=array_merge($bArr, $values->toArray());

            }
            $cFeeHeadArr['academic_fee_group']=$bArray;

            $feeheadPresent=$siteFeeAllocationPresent->where('academic_fee_head_id', $value['id'])->first();
            if($feeheadPresent){
                $cFeeHeadArr['select_fee_head_id']=true;
            }else{
                $cFeeHeadArr['select_fee_head_id']=false;
            }

            $cFeeHeadArray[$key]=array_merge($cFeeHeadArr, $value);

        }

//
//
//
//        $cFeeHeadArr=Array();
//        $cFeeHeadArray=[];
//        foreach ($feeheadidsArray as $key => $value) {
//
//            $bArr=Array();
//            $bArray=[];
//            foreach ($value['academic_fee_group_list'] as $keys => $values) {
//                $bArr['select_fee_group_id']=false;
//
//                $checkfeegroupid=$siteGroupsFeeHead
//                    ->where('academic_fee_head_id', $value['id'])
//                    ->where('academic_fee_group_id', $values['id']);
//
//                $aArr=Array();
//                $aArray=[];
//
//                foreach ($checkfeegroupid as $ke => $val) {
//                    $aArr['id']=$val->academic_fee_sub_head_id;
//                    $aArr['name']=$val->academicFeeSubHead->name;
//
//                    $aArr['select_fee_sub_head_id']=false;
//                    $aArr['amount']=null;
//                    $aArr['fine_amount']=null;
//                    $aArr['fine_applicable_day']=null;
//
//                    $aArray[$ke]=array_merge($aArr);
//                }
//                $bArr['academic_fee_sub_head']=$aArray;
//
//                $bArray[$keys]=array_merge($bArr, $values->toArray());
//
//            }
//            $cFeeHeadArr['academic_fee_group']=$bArray;
//            $cFeeHeadArr['select_fee_head_id']=false;
//
//            $cFeeHeadArray[$key]=array_merge($cFeeHeadArr, $value);
//
//        }

        return [$cFeeHeadArray];





    }


    public function getHeadAndFeeGroupList()
    {
        $SiteInfoTableData = SiteInfoSetting::first();

        $fee_head_ids = explode(',', $SiteInfoTableData->academic_fee_head_ids);
        $fee_head_list = AcademicFeeHead::whereIn('id', $fee_head_ids)->get();

        $fee_group_ids = explode(',', $SiteInfoTableData->academic_fee_group_ids);
        $feeGrouplist = AcademicFeeGroup::whereIn('id', $fee_group_ids)->get();

        return [$fee_head_list, $feeGrouplist];

    }

    public function getSubHeadListByFeeHeadFeeGroupYearSessionShiftClassGroupSection($versionID = null, $yearID = null,
                                                                                     $shiftId = null, $departmentId = null,
                                                                                     $classId = null, $sectionId = null,
                                                                                     $classGroupId = null, $sessionId = null)
    {

        $data = [];
        $data['academic_version_id'] = $versionID == 'null' ? null : $versionID;
        $data['academic_year_id'] = $yearID == 'null' ? null : $yearID;
        $data['academic_shift_id'] = $shiftId == 'null' ? null : $shiftId;
        $data['academic_department_id'] = $departmentId == 'null' ? null : $departmentId;
        $data['academic_class_id'] = $classId == 'null' ? null : $classId;
        $data['academic_section_id'] = $sectionId == 'null' ? null : $sectionId;
        $data['academic_class_group_id'] = $classGroupId == 'null' ? null : $classGroupId;
        $data['academic_session_id'] = $sessionId == 'null' ? null : $sessionId;
//        $data['academic_fee_head_id'] = $feeHeadId == 'null' ? null : $feeHeadId;
//        $data['academic_fee_group_id'] = $feeGroupId == 'null' ? null : $feeGroupId;

        $final = Array();
        $head_array = Array();
        $acad_fee_head = new AcademicFeeHead();
        $acad_fee_head_list = $acad_fee_head->get();
        foreach ($acad_fee_head_list as $key => $value){

//            $fee_fine_allocation = new SiteStudentFeeFineAllocation();
//            $fee_fine_allocation_list = $fee_fine_allocation
//                ->where('academic_version_id', $data['academic_version_id'])
//                ->where('academic_year_id', $data['academic_year_id'])
//                ->where('academic_shift_id', $data['academic_shift_id'])
//                ->where('academic_class_id', $data['academic_class_id'])
//                ->where('academic_fee_head_id', $value->id)
//                ->when($data['academic_department_id'], function ($query) use ($data) {
//                    return $query->where('academic_department_id', $data['academic_department_id']);
//                })->when($data['academic_section_id'], function ($query) use ($data) {
//                    return $query->where('academic_section_id', $data['academic_section_id']);
//                })->when($data['academic_class_group_id'], function ($query) use ($data) {
//                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//                })->when($data['academic_session_id'], function ($query) use ($data) {
//                    return $query->where('academic_session_id', $data['academic_session_id']);
//                })->get();
//
//            if (count($fee_fine_allocation_list)>0){
//                foreach ($fee_fine_allocation_list as $k => $v){
//                    $final[$k]['head'] = $value->name;
//                    $fee_group = new AcademicFeeGroup();
//                    $final[$k]['fee_group'] = $fee_group->where('id', $v->academic_fee_group_id)->first();
//                    $acad_fee_sub_head = new AcademicFeeSubHead();
//                    $final[$k]['sub_head'] = $acad_fee_sub_head->where('id',$v->academic_fee_sub_head_id)->first();
//                    $final[$k]['status'] = true;
//                    $final[$k]['head_id'] = $value->id;
//                    $final[$k]['fee_allocation_id'] = $v->id;
//                    $final[$k]['amount'] = $v->amount;
//                }
//
//            }else{
//
//
//            }
            $sub_head_allocation = new SiteStudentFeeSubHeadAllocation();
            $sub_head_allocation_list = $sub_head_allocation->where('academic_fee_head_id', $value->id)->get();
            \Log::info($sub_head_allocation_list);
            if (count($sub_head_allocation_list)>0){
                foreach ($sub_head_allocation_list as $kk => $vv){

                    $feeSubHeadlistsplite = explode(',', $vv->academic_fee_sub_head_ids);
                    $sub_head_list = AcademicFeeSubHead::whereIn('id', $feeSubHeadlistsplite)->get();
//                    return $sub_head_list;
                    $final[$kk]['head'] = $value->name;
                    $fee_group = new AcademicFeeGroup();
                    $final[$kk]['fee_group'] = $fee_group->where('id', $vv->academic_fee_group_id)->first()?? null;
                    $final[$kk]['sub_head'] = $sub_head_list;
                    $final[$kk]['status'] = true;
                    $final[$kk]['id'] = $vv->id;
                    $final[$kk]['head_id'] = $value->id;
                    $final[$kk]['amount'] = "";
//                    if (count($sub_head_list)>0){
//                        foreach ($sub_head_list as $ke => $val){
//
//
//                        }
//
//                    }
                }
                $head_array[$key][$kk]= $final;
            }

        }
//        dd($head_array);
//        return $head_array;


        $siteFeeSubHeadAllocation = new SiteStudentFeeSubHeadAllocation();
        $subHeadIds = $siteFeeSubHeadAllocation
            ->where('academic_fee_head_id', $data['academic_fee_head_id'])
            ->where('academic_fee_group_id', $data['academic_fee_group_id'])
            ->first();

        if (!$subHeadIds) {
           return JsonResponse::create(['message'=>"No Allocation Found!"],410);
        }


        $feeSubHeadlistsplite = explode(',', $subHeadIds->academic_fee_sub_head_ids);
        $feeSubHeadlist = AcademicFeeSubHead::whereIn('id', $feeSubHeadlistsplite)->get();

        foreach ($feeSubHeadlist as $key => $value) {

            $feeAllocation = new SiteStudentFeeFineAllocation();
            $feeAllocationList = $feeAllocation
                ->where('academic_fee_head_id', $data['academic_fee_head_id'])
                ->where('academic_fee_sub_head_id', $value->id)
                ->where('academic_fee_group_id', $data['academic_fee_group_id'])
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
           ->get();


            if (count($feeAllocationList) > 0) {
                foreach ($feeAllocationList as $kkk => $vvv) {
                    $final[$key]['name'] = $value->name;
                    $final[$key]['status'] = true;
                    $final[$key]['id'] = $value->id;
                    $final[$key]['fee_allocation_id'] = $vvv->id;
                    $final[$key]['amount'] = $vvv->amount;
                }
            } else {
                    $final[$key]['name'] = $value->name;
                    $final[$key]['status'] = false;
                    $final[$key]['id'] = $value->id;
                    $final[$key]['fee_allocation_id'] = "";
                    $final[$key]['amount'] = null;

            }

        }

        return $final;

    }


    public function getSiteClassbaseStudentbaseFeeHeadAllocation(Request $request){

        $academicFeeGroup=AcademicFeeGroup::get();

        $FeeGroupsID=$academicFeeGroup->whereIn('head_key', ['classbase','studentbase'])->pluck('id');

        $siteSettings=SiteInfoSetting::first();
        $feeHeadList= AcademicFeeHead::whereIn('id', explode(',', $siteSettings->academic_fee_head_ids))->get();

        $siteFeeHead=SiteStudentFeeSubHeadAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
            ->whereIn('academic_fee_group_id', $FeeGroupsID)
            ->get();

        $headArray=[];
        foreach ($feeHeadList as $key => $value) {

            $feeheadArr=Array();
            foreach ($siteFeeHead as $keys => $values) {

                if($values->academic_fee_head_id==$value->id){
                    $feeheadArr['id']=$values->academic_fee_head_id;
                    $feeheadArr['name']=$values->academicFeeHead->name;

                    $headArray[$key]=$feeheadArr;
                }
            }
        }
   
        $feeheadidsArray=[];
        $feeheadidsArr=Array();
        foreach ($headArray as $key => $value) {
            $feegroupids=$siteFeeHead->where('academic_fee_head_id', $value['id'])->pluck('academic_fee_group_id');
            $academicFeeGroupList=$academicFeeGroup->whereIn('id', $feegroupids);
            $feeheadidsArr['academic_fee_group_list']=$academicFeeGroupList;
            $feeheadidsArray[$key]=array_merge($feeheadidsArr, $value);
        }

        $data = $request->all();

        $siteFeeAllocationPresent=SiteStudentFeeFineAllocation::whereIn('academic_fee_group_id',$FeeGroupsID)
                ->where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })

                ->when(empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_department_id');
                })
                ->when(empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_class_id');
                })
                ->when(empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_section_id');
                })
                ->when(empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_class_group_id');
                })
                ->when(empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_session_id');
                })
                ->when(empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_student_category_id');
                })
                ->when(empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_student_type_id');
                })
                ->when(empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_student_admission_type_id');
                })
                ->where('status', true)
                ->get();

            $cFeeHeadArr=Array();
            $cFeeHeadArray=[];
            $keey=0;
            foreach ($feeheadidsArray as $key => $value) {

                $bArr=Array();
                $bArray=[];
                
                foreach ($value['academic_fee_group_list'] as $keys => $values) {

                    $feeGroupPresent=$siteFeeAllocationPresent
                        ->where('academic_fee_head_id', $value['id'])
                        ->where('academic_fee_group_id', $values['id'])
                        ->first();
                    if($feeGroupPresent){
                        $bArr['select_fee_group_id']=true;
                    }else{
                        $bArr['select_fee_group_id']=false;
                    }

                    $checkfeegroupid=$siteFeeHead
                        ->where('academic_fee_head_id', $value['id'])
                        ->where('academic_fee_group_id', $values['id']);
                     //   dd($checkfeegroupid);

                    $aArr=Array();
                    $aArray=[];
                   
                    foreach ($checkfeegroupid as $ke => $val) {
                        $aArr['id']=$val->academic_fee_sub_head_id;
                        $aArr['name']=$val->academicFeeSubHead->name;
                      //  $aArr['vat_amount']=$val->academicFeeSubHead->vat_amount;

                        $feeSubHeadPresent=$siteFeeAllocationPresent
                            ->where('academic_fee_head_id', $value['id'])
                            ->where('academic_fee_group_id', $values['id'])
                            ->where('academic_fee_sub_head_id', $val->academic_fee_sub_head_id)
                            ->first();
                        if($feeSubHeadPresent){
                            $aArr['select_fee_sub_head_id']=true;
                            $aArr['amount']=$feeSubHeadPresent->amount;
                            $aArr['fine_amount']=$feeSubHeadPresent->fine_amount;
                            $aArr['fine_applicable_day']=$feeSubHeadPresent->fine_applicable_day;
                        }else{
                            $aArr['select_fee_sub_head_id']=false;
                            $aArr['amount']=$val->vat_amount;
                            $aArr['fine_amount']=null;
                            $aArr['fine_applicable_day']=null;
                        }

                        $aArray[$ke]=array_merge($aArr);
                      
                    }
                    $bArr['academic_fee_sub_head']=$aArray;

                    $bArray[$keys]=array_merge($bArr, $values->toArray());
                }
                $cFeeHeadArr['academic_fee_group']=$bArray;

                $feeheadPresent=$siteFeeAllocationPresent->where('academic_fee_head_id', $value['id'])->first();
                if($feeheadPresent){
                    $cFeeHeadArr['select_fee_head_id']=true;
                }else{
                    $cFeeHeadArr['select_fee_head_id']=false;
                }


                $cFeeHeadArray[$keey]=array_merge($cFeeHeadArr, $value);
                $keey++;
            }

        return [$cFeeHeadArray];

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    public function createUpdateSiteFeeAllocation(Request $request){

//return $request;
        DB::beginTransaction();
        try {


       // $siteFeeList=SiteStudentFeeFineAllocation::get();


        $data = $request->all();

        $siteFeeSetPresentList=SiteStudentFeeFineAllocation::where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->where('academic_student_category_id', $data['academic_student_category_id']);
            })
            ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_type_id', $data['academic_student_type_id']);
            })
            ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
            })

            ->when(empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->whereNull('academic_department_id');
            })
            ->when(empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->whereNull('academic_class_id');
            })
            ->when(empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->whereNull('academic_section_id');
            })
            ->when(empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->whereNull('academic_class_group_id');
            })
            ->when(empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->whereNull('academic_session_id');
            })
            ->when(empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->whereNull('academic_student_category_id');
            })
            ->when(empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->whereNull('academic_student_type_id');
            })
            ->when(empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->whereNull('academic_student_admission_type_id');
            })
            ->where('status', true)
            ->get();

            $fee_exist_ids=[];
            foreach ($siteFeeSetPresentList as $kkk => $vvv){
                $fee_exist_ids[$kkk] = $vvv->id;
            }

            $charges=[];
            $siteFeeSubHeadCheckIDs=[];

            foreach ($request->FeeHeadSubHeadGroupList as $key => $value) {

                if($value['select_fee_head_id']){

                    $siteFeeGroupCheckIDs=[];
                    foreach ($value['academic_fee_group'] as $keys => $values) {

                        if($values['select_fee_group_id']){

                            foreach ($values['academic_fee_sub_head'] as $keyst => $valuest) {

                                if($valuest['select_fee_sub_head_id']){

                                    $siteGroupFeeCheck=null;
                                    if(count($siteFeeSetPresentList)) {
                                        $siteGroupFeeCheck = $siteFeeSetPresentList
                                            ->where('academic_fee_head_id', $value['id'])
                                            ->where('academic_fee_group_id', $values['id'])
                                            ->where('academic_fee_sub_head_id', $valuest['id'])
                                            ->first();
                                    }


                                    if($siteGroupFeeCheck){
                                            if ($siteGroupFeeCheck->site_group_id == null){
                                                $siteFeeSubHeadCheckIDs[$keyst]=$siteGroupFeeCheck->id;
                                                if($siteGroupFeeCheck->amount != $valuest['amount']){

                                                    $checkFeeIDuse = SiteStudentFeeGenerate::
                                                    where('site_student_fee_fine_allocation_id', $siteGroupFeeCheck->id)
                                                        ->where('demand_slip_create_status', 0)
                                                        ->get();

//
                                                    if(count($checkFeeIDuse)){

                                                        $siteGroupFeeCheck->status = false;
                                                        $siteGroupFeeCheck->update();

                                                        foreach ($checkFeeIDuse as $kk => $vv){
                                                            $vv->update([
                                                                'status' => false,
                                                            ]);
                                                        }

                                                        $siteFeeAllocation = new SiteStudentFeeFineAllocation();
                                                        $siteFeeAllocation->academic_fee_head_id=$value['id'];
                                                        $siteFeeAllocation->academic_fee_group_id=$values['id'];
                                                        $siteFeeAllocation->academic_fee_sub_head_id=$valuest['id'];
                                                        $siteFeeAllocation->academic_group_id=Session::get('ACADEMIC_GROUP_ID');
                                                        $siteFeeAllocation->academic_shift_id=$request->academic_shift_id;
                                                        $siteFeeAllocation->academic_version_id=$request->academic_version_id;
                                                        $siteFeeAllocation->academic_year_id=$request->academic_year_id;
                                                        $siteFeeAllocation->academic_department_id=$request->academic_department_id;
                                                        $siteFeeAllocation->academic_class_id=$request->academic_class_id;
                                                        $siteFeeAllocation->academic_section_id=$request->academic_section_id;
                                                        $siteFeeAllocation->academic_class_group_id=$request->academic_class_group_id;
                                                        $siteFeeAllocation->academic_session_id=$request->academic_session_id;
                                                        $siteFeeAllocation->academic_student_category_id=$request->academic_student_category_id;
                                                        $siteFeeAllocation->academic_student_type_id=$request->academic_student_type_id;
                                                        $siteFeeAllocation->academic_student_admission_type_id=$request->academic_student_admission_type_id;

                                                        $siteFeeAllocation->amount=$valuest['amount']?$valuest['amount']:0;
                                                        $siteFeeAllocation->fine_amount=$valuest['fine_amount']?$valuest['fine_amount']:0;
//
                                                        $siteFeeAllocation->fine_applicable_day=$valuest['fine_applicable_day']?$valuest['fine_applicable_day']:0;
                                                        $siteFeeAllocation->status=true;
                                                        $siteFeeAllocation->save();
                                                    }
                                                    else{
                                                        $checkFeeIDUseForDemandSlip = SiteStudentFeeGenerate::
                                                        where('site_student_fee_fine_allocation_id', $siteGroupFeeCheck->id)
                                                            ->where('demand_slip_create_status', 1)
                                                            ->get();

                                                        if(count($checkFeeIDUseForDemandSlip)){
                                                            return Response::json(['message' => 'Sorry! Fee has been used for demand slip!'], 411);
                                                        }else{
                                                            $siteGroupFeeCheck->amount = $valuest['amount']?$valuest['amount']:0;
                                                            $siteGroupFeeCheck->update();
                                                        }

                                                    }
                                                }

                                            }

                                    }else{
                                        $charges[] = [

                                            'academic_fee_head_id'=>$value['id'],
                                            'academic_fee_group_id'=>$values['id'],
                                            'academic_fee_sub_head_id'=>$valuest['id'],
                                            'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                            'academic_shift_id'=>$request->academic_shift_id,
                                            'academic_version_id'=>$request->academic_version_id,
                                            'academic_year_id'=>$request->academic_year_id,
                                            'academic_department_id'=>$request->academic_department_id,
                                            'academic_class_id'=>$request->academic_class_id,
                                            'academic_section_id'=>$request->academic_section_id,
                                            'academic_class_group_id'=>$request->academic_class_group_id,
                                            'academic_session_id'=>$request->academic_session_id,
                                            'academic_student_category_id'=>$request->academic_student_category_id,
                                            'academic_student_type_id'=>$request->academic_student_type_id,
                                            'academic_student_admission_type_id'=>$request->academic_student_admission_type_id,
                                            'amount'=>$valuest['amount']?$valuest['amount']:0,
                                            'fine_amount'=>$valuest['fine_amount']?$valuest['fine_amount']:0,
                                            'fine_applicable_day'=>$valuest['fine_applicable_day']?$valuest['fine_applicable_day']:0,
                                            'status'=>true,
                                            'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                            'site_id'=>Session::get('SITE_ID'),

                                        ];
                                    }
                                }else{
                                    $siteGroupFeeCheck=null;
                                    if(count($siteFeeSetPresentList)) {
                                        $siteGroupFeeCheck = $siteFeeSetPresentList
                                            ->where('academic_fee_head_id', $value['id'])
                                            ->where('academic_fee_group_id', $values['id'])
                                            ->where('academic_fee_sub_head_id', $valuest['id'])
                                            ->where('status',true)
                                            ->first();
                                    }
                                    if($siteGroupFeeCheck){
                                        if ($siteGroupFeeCheck->site_group_id == null){
                                            $siteGroupFeeCheck->status=false;
                                            $siteGroupFeeCheck->update();
                                        }

                                    }

                                }

                            }

                        }

                    }


                }

            }

            $status_updatable_ids = array_diff($fee_exist_ids, $siteFeeSubHeadCheckIDs);

            $updated_data = SiteStudentFeeFineAllocation::whereIn('id', $status_updatable_ids)->get();

           foreach ($updated_data as $kkkk => $vvvv) {

               $checkFeeIDuse = SiteStudentFeeGenerate::
               where('site_student_fee_fine_allocation_id', $vvvv->id)
                   ->where('demand_slip_create_status', 1)
                   ->first();

                  // dd($checkFeeIDuse);

               if ($checkFeeIDuse) {
                   return Response::json(['message' => 'Sorry! Can not change! Fee has been used in demand slip!'], 411);
               }

               $checkFeeIDuse = SiteStudentFeeGenerate::
               where('site_student_fee_fine_allocation_id', $vvvv->id)
                   ->where('demand_slip_create_status', 0)
                   ->get();

               if (count($checkFeeIDuse)) {
                   foreach ($checkFeeIDuse as $kkky => $vvvl) {
                       $vvvl->update([
                           'status' => false,
                       ]);
                   }
                   $vvvv->update([
                       'status' => false,
                   ]);

               }else{
                   $vvvv->update([
                       'status' => false,
                   ]);
               }

           }

            if(count($charges)>0){
                SiteStudentFeeFineAllocation::insert($charges);
            }

            DB::commit();
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);

        }  catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
