<?php

namespace App\Http\Controllers\Site;

use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use DB;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use JsonSchema\Exception\ValidationException;
use Illuminate\Http\JsonResponse;
use App\Models\Site\SiteInfo;
//use Illuminate\Http\Response;
use Session;
use Response;

class SiteFeeSubHeadAllocationController extends Controller
{

    private $siteFeeSubHeadAllocation;
    private $siteInfoSetting;

    public function __construct(SiteStudentFeeSubHeadAllocation $siteFeeSubHeadAllocation, SiteInfoSetting $siteInfoSetting)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->siteFeeSubHeadAllocation = $siteFeeSubHeadAllocation;
        $this->siteInfoSetting = $siteInfoSetting;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Fee Head List';
        return view('default.admin.sites.site-fee-sub-head-allocation.view', compact('viewType'));
    }

    public function feeSettings()
    {
      // $fbb=SiteStudentFeeGenerate::whereIn('id', [392,393,394])->update(['demand_slip_create_status'=>true]);


        $viewType = 'Fee Settings';
        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.sites.fee.fee-settings.view', compact('viewType'));
    }

    public function waiverOfferSettings()
    {
        $viewType = 'Fee Settings';
        return view('default.admin.sites.waiver-offer-view.view', compact('viewType'));
    }

    public function getSiteFeeHeadAllocationList()
    {
        $siteFeeSubHeadAllocations = new SiteFeeSubHeadAllocation();
        $siteFeeSubHeadAllocationList = $siteFeeSubHeadAllocations->get();

        return $siteFeeSubHeadAllocationList;
    }

    public function getFeeHeadList()
    {
        //$siteInfos = new SiteInfoSetting();
        $siteInfo = $this->siteInfoSetting->first();
        $siteFeeHeadId = $siteInfo->academic_fee_head_ids;
        $explode_id = array_map('intval', explode(',', $siteFeeHeadId));//array_map function is used to convert array string
        $feeHeads = new AcademicFeeHead();
        $feeHeadList = $feeHeads->whereIn('id', $explode_id)->get();
        return $feeHeadList;

    }
    public function getFeeGroupList()
    {
        //$siteInfos = new SiteInfoSetting();
        $siteInfo = $this->siteInfoSetting->first();
        $siteFeeGroupId = $siteInfo->academic_fee_group_ids;
        $explode_id = array_map('intval', explode(',', $siteFeeGroupId));//array_map function is used to convert array string
        $feeGroup = new AcademicFeeGroup();
        $feeGroupList = $feeGroup->whereIn('id', $explode_id)->get();
        return $feeGroupList;


    }



    public function siteFeeHeadGroupSubHeadList()
    {

        $siteInfoSettinglist=SiteInfoSetting::select('academic_fee_head_ids','academic_fee_group_ids', 'academic_fee_sub_head_ids')
            ->where('site_id',Session::get('SITE_ID'))
            ->first();

        $feeheadSplite = explode(',', $siteInfoSettinglist->academic_fee_head_ids);
        $feeheadList = AcademicFeeHead::whereIn('id', $feeheadSplite)->get();

        $feegroupSplite = explode(',', $siteInfoSettinglist->academic_fee_group_ids);
        $feegroupList = AcademicFeeGroup::whereIn('id', $feegroupSplite)->get();

        $feeSubHeadSplite = explode(',', $siteInfoSettinglist->academic_fee_sub_head_ids);
        $feeSubHeadList = AcademicFeeSubHead::whereIn('id', $feeSubHeadSplite)->get();

        $siteFeeSetCheck=SiteStudentFeeSubHeadAllocation::where('site_id',Session::get('SITE_ID'))->get();

        if(count($siteFeeSetCheck)<=0){

            $headArr=Array();
            $headArray=[];
            foreach ($feeheadList as $key => $value) {

                $headArr['select_fee_head_id']=false;

                $groupArr=Array();
                $groupArray=[];
                foreach ($feegroupList as $keys => $values) {

                    $groupArr['id']=$values->id;
                    $groupArr['name']=$values->name;
                    $groupArr['select_fee_group_id']=false;

                    $subheadArr=Array();
                    $subHeadArray=[];
                    foreach ($feeSubHeadList as $keyst => $valuest) {
                        $subheadArr['select_fee_sub_head_id']=false;
                        $subheadArr['vat_amount']=0;

                        $subHeadArray[$keyst]=array_merge($valuest->toArray(), $subheadArr);
                    }

                    $groupArr['fee_sub_head']=$subHeadArray;

                    $groupArray[$keys]= array_merge($groupArr);
                }
                $headArr['fee_group']=$groupArray;


                $headArray[$key]= array_merge($value->toArray(), $headArr);
            }
        }
        else{

            $headArr=Array();
            $headArray=[];
            foreach ($feeheadList as $key => $value) {

                $feeHeadPresent= $siteFeeSetCheck->where('academic_fee_head_id', $value['id'])->first();

                if($feeHeadPresent){
                    $headArr['select_fee_head_id']=true;
                }else{
                    $headArr['select_fee_head_id']=false;
                }

                $groupArr=Array();
                $groupArray=[];
                foreach ($feegroupList as $keys => $values) {

                    $feeGrouPresent= $siteFeeSetCheck->where('academic_fee_head_id', $value['id'])
                        ->where('academic_fee_group_id', $values['id'])
                        ->first();

                    if($feeGrouPresent){
                        $groupArr['select_fee_group_id']=true;

                    }else{
                        $groupArr['select_fee_group_id']=false;
                    }

                    $groupArr['id']=$values->id;
                    $groupArr['name']=$values->name;

                    $subheadArr=Array();
                    $subHeadArray=[];
                    foreach ($feeSubHeadList as $keyst => $valuest) {
                        $feeSubHeadPresent= $siteFeeSetCheck->where('academic_fee_head_id', $value['id'])
                            ->where('academic_fee_group_id', $values['id'])
                            ->where('academic_fee_sub_head_id', $valuest['id'])->first();

                        if($feeSubHeadPresent){
                            $subheadArr['select_fee_sub_head_id']=true;
                            $subheadArr['vat_amount']=$feeSubHeadPresent->vat_amount;

                        }else{
                            $subheadArr['select_fee_sub_head_id']=false;
                            $subheadArr['vat_amount']=0;
                        }

                        $subHeadArray[$keyst]=array_merge($valuest->toArray(), $subheadArr);
                    }

                    $groupArr['fee_sub_head']=$subHeadArray;

                    $groupArray[$keys]= array_merge($groupArr);

                }

                $headArr['fee_group']=$groupArray;


                $headArray[$key]= array_merge($value->toArray(), $headArr);

            }

        }

        return response()->json($headArray, 200, [], JSON_NUMERIC_CHECK);

    }



    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function createUpdateFeeHeadGroupSubHead(Request $request)
    {

        DB::beginTransaction();
        try {

        $siteFeeSetPresentIDArr=SiteStudentFeeSubHeadAllocation::get();

        $siteFeeSetPresentIDs=$siteFeeSetPresentIDArr->where('site_group_id', null)->pluck('id');

        $checkedIDs=[];
        $charges=[];
        foreach ($request->FeeHeadSubHeadGroupList as $key => $value) {

            if($value['select_fee_head_id']){

                foreach ($value['fee_group'] as $keys => $values) {

                    if($values['select_fee_group_id']){

                        foreach ($values['fee_sub_head'] as $keyst => $valuest) {

                            if($valuest['select_fee_sub_head_id']){

                                $siteFeeCheckt= $siteFeeSetPresentIDArr
                                    ->where('academic_fee_head_id', $value['id'])
                                    ->where('academic_fee_group_id', $values['id'])
                                    ->where('academic_fee_sub_head_id', $valuest['id'])
                                    ->first();

                                if ($siteFeeCheckt){

                                    if ($siteFeeCheckt->site_group_id == null){

                                        $checkedIDs[]=$siteFeeCheckt->id;

                                        $siteFeeCheckt->vat_amount = $valuest['vat_amount'];
                                        $siteFeeCheckt->update();
                                    }

                                }else{

                                    $charges[] = [
                                        'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                        'site_id'=>Session::get('SITE_ID'),
                                        'academic_fee_head_id'=>$value['id'],
                                        'academic_fee_group_id'=>$values['id'],
                                        'academic_fee_sub_head_id'=>$valuest['id'],
                                        'vat_amount'=>$valuest['vat_amount']?$valuest['vat_amount']:0,
                                        'status'=>true,

                                    ];

                                }

                            }

                        }
                    }
                }
            }
        }



        $siteFeeidCheck=array_diff($siteFeeSetPresentIDs->toArray(), $checkedIDs);

        foreach($siteFeeidCheck as $feeId){
            $studentFee=SiteStudentFeeSubHeadAllocation::where('id', $feeId)->first();

            $checkFeeAllocation=SiteStudentFeeFineAllocation::where('academic_fee_head_id',$studentFee->academic_fee_head_id)
                ->where('academic_fee_group_id',$studentFee->academic_fee_group_id)
                ->where('academic_fee_sub_head_id',$studentFee->academic_fee_sub_head_id)
                ->where('status',true)
                ->first();

            if($checkFeeAllocation){
                return Response::json(['message' => 'Sorry! Can not change! Fee has been used in subhead allocation!'], 411);
            }
            SiteStudentFeeSubHeadAllocation::where('id', $feeId)->delete();

        }

        //dd($siteFeeidCheck);


        if(count($charges)>0){
            SiteStudentFeeSubHeadAllocation::insert($charges);
        }

            DB::commit();
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);

        }  catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }


    }

   
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $siteFeeSubHeadAllocationUpdate = $this->siteFeeSubHeadAllocation->findOrFail($id);

        $siteFeeSubHeadAllocationUpdate->update([
            'name'=>$request->get('name'),
            'status'=>$request->get('status'),
        ]);

        return ['message' => 'Successfully Updated!'];
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $siteFeeSubHeadAllocationDelete = $this->siteFeeSubHeadAllocation->findOrFail($id);

        $siteFeeSubHeadAllocationDelete->delete();
        return ['message' => 'Successfully Deleted!'];

    }
}
