<?php

namespace App\Http\Controllers\Site;

use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Batch\BatchDetail;
use App\Models\Site\GlobalSiteClassSessionSerialSetting;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\SiteClassSessionSerialSetting;
use App\Models\Site\SiteGroupSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;

class SiteVersionYearShiftDeptClassGroupController extends Controller
{
   
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }
    public function getSiteClassBaseGroupSession(Request $request){

        $data = $request->all();
        $sessionPresentCheck = SiteClassSessionSerialSetting::where('site_id', Session::get('SITE_ID'))
            ->where('academic_class_id', $request->academic_class_id)
            ->distinct()
            ->get(['academic_class_id', 'session_present']);

        $SiteInfoTableData = SiteInfoSetting::select('id','batch_present_status')
            ->first();

        if($SiteInfoTableData->batch_present_status){
            $batch_list=BatchDetail::where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('academic_class_id', $request->academic_class_id)
                ->select('id', 'batch_name', 'batch_code')
                ->get();
        }else{
            $batch_list=[];
        }

        $Sessionlist = [];
        if(count($sessionPresentCheck)==1){

            if ($sessionPresentCheck[0]->session_present) {
                $SiteTableData = SiteInfoSetting::where('site_id',Session::get('SITE_ID'))->first();
                $Sessionlistsplite = explode(',', $SiteTableData->academic_session_ids);
                $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
            } else {
                $Sessionlist = [];
            }
        }else if(count($sessionPresentCheck)>1){
            $SiteTableData = SiteInfoSetting::where('site_id',Session::get('SITE_ID'))->first();
            $Sessionlistsplite = explode(',', $SiteTableData->academic_session_ids);
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
        }

        $classGroupList = SiteShiftClassGroupSectionSetting::with(['academicClassGroup'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->whereNotNull('academic_class_group_id')
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('academic_class_id', $request->academic_class_id)
            ->distinct()
            ->get(['academic_class_group_id']);

        $SiteInfoSetting=SiteInfoSetting::get();

        //academic_student_category List
        $categoryIds=$SiteInfoSetting->pluck('academic_student_category_ids');
        $categoryStringIDs = implode(',', $categoryIds->toArray());
        $categoryIntegerIDs = array_unique(array_map('intval', explode(',', $categoryStringIDs)));
        $studentCategoryList=AcademicStudentCategory::whereIn('id', $categoryIntegerIDs)->get();

        //academic_student_category List
        $studentTypeIds=$SiteInfoSetting->pluck('academic_student_type_ids');
        $studentTypeStringIDs = implode(',', $studentTypeIds->toArray());
        $studentTypeIntegerIDs = array_unique(array_map('intval', explode(',', $studentTypeStringIDs)));
        $studentTypeList=AcademicStudentType::whereIn('id', $studentTypeIntegerIDs)->get();

        //academic_student_admission_type List
        $studentAdmissionList = AcademicAdmissionType::where('status', 1)->get();


        $classSectionList = SiteShiftClassGroupSectionSetting::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('academic_class_id', $request->academic_class_id)
            ->pluck('academic_section_ids');


        $section_ids = implode(',', $classSectionList->toArray());
        $sectionStringIds =array_unique(array_map('intval', explode(',', $section_ids)));

        $section_list = AcademicSection::whereIn('id',$sectionStringIds)->get();

        return [$classGroupList, $Sessionlist, $studentCategoryList, $studentTypeList, $studentAdmissionList, $section_list, $batch_list];


    }

    public function getSiteDepartmentBaseClassList($department_id){

        $academicClassList=SiteShiftClassGroupSectionSetting::with(['academicClass'])
            ->where('academic_department_id',$department_id)
            ->whereNotNull('academic_class_id')
            ->distinct()
            ->get(['academic_class_id']);

        return $academicClassList;

    }

}
