<?php

namespace App\Http\Controllers\Site\Sms;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Auth;
use Carbon\Carbon;
use Error;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use App\Traits\RequestHandlingWithMachine;
use App\Models\Edu\Device\DeviceLog;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Traits\SmsFunctionsTrait;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Guardian\Guardian;
use App\Models\Site\Notice\Notice;
use App\Models\Site\Sms\SiteSms;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use App\Models\Site\Student\Student;
use Illuminate\Validation\ValidationException;
use Response;
use Session;

class StudentController extends Controller
{
 //   use  SmsFunctionsTrait, RequestHandlingWithMachine;


    /**
     * NoticesController constructor.
     * @param Notice $notice
     */

    private $sms;
    private $employee;
    private $studentHistory;

    public function __construct(SiteSms $sms, Employee $employee, StudentHistory $studentHistory)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->sms = $sms;
        $this->employee = $employee;
        $this->studentHistory = $studentHistory;
    }

    public function getStudentListContractList(Request $request){

        $data=$request->all();
        try {

            $student_history = $this->studentHistory
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            // ->when($picture, function ($query) use ($data) {
            //     return $query->with(['student.latestPhoto']);
            // })
        //    ->where('status', 1)
            ->whereHas('student', function ($q) {
                $q->where('status', 1);
            })
            ->with(['student' => function ($q) {
                $q->select('user_type', 'id', 'username', 'contact_number');
            }])
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->where('status', $request->status)
            ->select('id', 'user_id','student_roll_number')
            ->get();

            return response()->json(['student_list'=>$student_history]);

            if (count($data) < 1) {
                throw new Error('No Data Found!');
            }

            return response()->json($data, 200, []);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }
}
