<?php

namespace App\Http\Controllers\Site\Student\IDCard;


use App\Models\Site\Employee\Employee;
use App\Models\Site\Student\IDCard\IdCardSetting;
use App\Models\Site\Student\IDCard\StudentIDCard;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Error;
use App\Models\Site\SiteInfo;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Response;
use Session;
use PDF;
use Image;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;

class StudentIDCardController extends Controller
{

    private $carbon_now;

    private $studentHistory;
    private $student;
    private $IdCard;
    private $employee;
    private $cardSetting;

    public function __construct(Student $student, StudentHistory $studentHistory, StudentIDCard $IdCard, IdCardSetting $cardSetting, Employee $employee)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->carbon_now = Carbon::now();

        $this->studentHistory = $studentHistory;
        $this->student = $student;
        $this->IdCard = $IdCard;
        $this->cardSetting = $cardSetting;
        $this->employee = $employee;
    }

    public function master()
    {
        $viewType = 'Student Id Card ';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.site.student.id-card.master', compact('viewType'));
    }


    public function getStudentsForCardOrder(Request $request)
    {

        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id;
            $data['academic_section_id'] = $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id;
            $data['list_type'] = $request->list_type;
            $data['academic_student_category_id'] = $request->academic_student_category_id;
            $data['academic_admission_type_id'] = $request->academic_admission_type_id;


            $paginate = $request->paginate ?? 20;

            $search_txt = $request->search_txt;
            $status = $request->status;
            $txt = '%' . $search_txt . '%';


            $student_list = $this->studentHistory
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when($data['academic_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_admission_type_id']);
                })
                ->when($search_txt, function ($qu) use ($txt) {
                    $qu->whereHas('student', function ($q) use ($txt) {
                        return $q->where(function ($query) use ($txt) {
                            $query->where('username', 'LIKE', $txt)
                                ->orWhere('email', 'LIKE', $txt)
                                ->orWhere('contact_number', 'LIKE', $txt)
                                ->orWhereTranslationLike('first_name', $txt)
                                ->orWhereTranslationLike('last_name', $txt);
                        });
                    });
                })
                ->when($data['list_type'] == 0, function ($q) {
                    $q->whereDoesntHave('idCard');
                })->when($data['list_type'] == 1, function ($q) {
                    $q->whereHas('idCard');
                })
                ->orderBy('academic_class_id', 'ASC')
                ->orderBy('academic_section_id', 'ASC')
                ->orderBy('student_roll_number', 'ASC')
                ->where('status', $status)
                ->paginate($paginate);

            $student_list->getCollection()->transform(function ($st_history) {
                return [
                    'id' => $st_history->user_id,
                    'details' => ($st_history->stClass->class_name ?? '') . '-' . ($st_history->section->section_name ?? ''),
                    'user_id' => $st_history->user_id,
                    'history_id' => $st_history->id,
                    'full_name' => $st_history->full_name,
                    'username' => $st_history->student->username ?? '',
                    'cancelling' => false,
                    'checked' => false,
                    'will_order' => $st_history->idCard ? 0 : 1,
                    'student_roll_number' => $st_history->student_full_roll_number ?? '',
                    'id_card_id' => $st_history->idCard->id ?? null,
                    'card_status' => $st_history->idCard->card_status ?? 0,
                    'status' => $st_history->idCard ? 1 : 0,
                    'contact_number' => $st_history->student->contact_number ?? '',

                ];
            });

            if (count($student_list) < 1) {
                throw new Error('No Student Assigned For Card!');
            }

            $id_array = $this->IdCard
                ->whereIn('history_id', $student_list->pluck('id'))
                ->pluck('id')
                ->toArray();

            return Response::json([$student_list, $id_array], 200);
        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function getCardViewData(Request $request)
    {

        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id;
            $data['academic_section_id'] = $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id;
            $paginate = $request->paginate ?? 20;

            $data['academic_student_category_id'] = $request->academic_student_category_id;
            $data['academic_admission_type_id'] = $request->academic_admission_type_id;

            $search_txt = $request->search_txt;
            $status = $request->status;
            $txt = '%' . $search_txt . '%';


            $student_list = $this->studentHistory
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when($data['academic_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_admission_type_id']);
                })
                ->when($search_txt, function ($qu) use ($txt) {
                    $qu->whereHas('student', function ($q) use ($txt) {
                        return $q->where(function ($query) use ($txt) {
                            $query->where('username', 'LIKE', $txt)
                                ->orWhere('email', 'LIKE', $txt)
                                ->orWhere('contact_number', 'LIKE', $txt)
                                ->orWhereTranslationLike('first_name', $txt)
                                ->orWhereTranslationLike('last_name', $txt);
                        });
                    });
                })
                ->with(['student' => function ($query) {
                    $query->with('bloodGroup');
                }])

                ->whereHas('idCard')
                ->orderBy('academic_class_id', 'ASC')
                ->orderBy('academic_section_id', 'ASC')
                ->orderBy('student_roll_number', 'ASC')
                ->where('status', $status)
                ->paginate($paginate);

            if (count($student_list) < 1) {
                throw new Error('No Order Found For Student ID Card Yet!' . $data['academic_class_id']);
            }

            $subjectCondition = SubjectGroupConditionSetting::select('id', 'subject_code')
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('academic_department_id', $request->academic_department_id)
                ->get();


            $student_list->getCollection()->transform(function ($st_history) use ($request) {


                if ($st_history->selective_compulsory_subject_ids[1]) {
                    $compulsory_subject_lsit = SubjectGroupConditionSetting::select('id', 'subject_code')
                        ->where('academic_year_id', $request->academic_year_id)
                        ->where('academic_class_id', $request->academic_class_id)
                        ->where('academic_department_id', $request->academic_department_id)
                        ->whereIn('academic_subject_id', $st_history->selective_compulsory_subject_ids[1])->get();
                }
                if ($st_history->optional_subject_ids[1]) {
                    $optional_subject_lsit = SubjectGroupConditionSetting::select('id', 'subject_code')
                        ->where('academic_year_id', $request->academic_year_id)
                        ->where('academic_class_id', $request->academic_class_id)
                        ->where('academic_department_id', $request->academic_department_id)
                        ->whereIn('academic_subject_id', $st_history->optional_subject_ids[1])->get();
                }


                return [
                    'id' => $st_history->user_id,
                    'compulsory_subject_lsit' => $compulsory_subject_lsit ?? '',
                    'optional_subject_lsit' => $optional_subject_lsit ?? '',
                    'details' => ($st_history->stClass->class_name ?? '') . '-' . ($st_history->section->section_name ?? ''),
                    'history_id' => $st_history->id,
                    'username' => $st_history->student->username ?? '',
                    'full_name' => $st_history->full_name,
                    'father_name' => $st_history->student->father_name ?? '',
                    'mother_name' => $st_history->student->mother_name ?? '',
                    'shift_name' => $st_history->shift->shift_name ?? '',
                    'department_name' => $st_history->department->name ?? '',
                    'class_name' => $st_history->stClass->class_name ?? '',
                    'group_name' => $st_history->classGroup->group_name ?? '',
                    'section_name' => $st_history->section->section_name ?? '',
                    'session_name' => $st_history->session->session_name ?? '',
                    'blood_group' => $st_history->student->bloodGroup->blood_group_name        ?? '',
                    'date_of_birth' => $st_history->student->date_of_birth ?? null,
                    'cancelling' => false,
                    'checked' => false,
                    'student_roll_number' => $st_history->student_full_roll_number ?? '',
                    'latest_photo' => $st_history->student->latestPhoto->name ?? '',
                    'id_card' => $st_history->idCard->id ?? null,
                    'card_status' => $st_history->idCard->card_status ?? 0,
                    'contact_number' => $st_history->student->contact_number ?? '',
                    'site_name' => $st_history->site->site_name ?? '',
                    'site_logo' => ($st_history->site->site_logo) ?? '',
                    'house_name' => $st_history->house->name ?? '',

                ];
            });
            // dd($student_list);

            $institute_head = $this->employee->where('institute_head', 1)->first();

            $get_signature = $institute_head->signature ?? '/img/signature/signature.png';
            $get_designation = $institute_head->designation->name ?? 'Institution Head';
            //============ domain name =============
            $site_info =  SiteInfo::findOrFail(Session::get('SITE_ID'));
            if ($site_info->domain_name == null) {
                $alias = $site_info->site_alias;
                $url = config('app.url');
                $parsedUrl = parse_url($url);
                $host = $parsedUrl['host'];
                $host_names = explode(".", $host);
                $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

                if ($host_names[count($host_names) - 1] == 'bd') {
                    $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
                }
                if (count($host_names) == 2) {
                    $bottom_host_name = $host_names[count($host_names) - 1];
                }
                $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;
            } else {
                $domain = $site_info->domain_name;
            }


            return Response::json([$student_list, $get_signature, $get_designation, $domain], 200);
        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function saveCardOrder(Request $request)
    {

        try {

            $students = $request->will_ordered_students;
            $cancel_students = $request->student;


            if (count($cancel_students)) {
                foreach ($cancel_students as $k => $student) {

                    $existed = $this->IdCard
                        ->where('history_id', $student['history_id'])
                        ->first();


                    if ($existed) { //ordered before

                        if ($existed->card_status == 'confirmed') {
                            return Response::json(['message' => 'The Card Is confirmed, Can"t Cancelled!'], 410);
                        } else {
                            $existed->delete();
                            return Response::json(['message' => 'Successfully Revoked The Card!'], 200);
                        }
                    }

                    return Response::json(['message' => 'Not Found The Student Card!'], 410);
                }
            }


            if (count($students) < 1) {
                throw new Error('No Student Found!');
            }

            $total = 0;
            foreach ($students as $k => $student) {

                $existed = $this->IdCard
                    ->where('history_id', $student['history_id'])
                    ->first();


                if ($existed) {
                } else {
                    $this->IdCard = new StudentIDCard();
                    $this->IdCard->user_id = $student['user_id'];
                    $this->IdCard->history_id = $student['history_id'];
                    $this->IdCard->card_status = 'ordered';
                    $this->IdCard->save();
                    $total++;
                }
            }
            return Response::json(['message' => 'Successfully Taken The Order For :' . $total . ' Students'], 200);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function createUpdateIdcardSettingData(Request $request)
    {
        $data = $this->cardSetting->active()->first();

        // Handle Site Logo
        if ($request->site_logo_path) {
            if (strlen($request->site_logo_path) < 200) {
                $bg_img = explode('/', $request->site_logo_path);
                $siteLogoFileName = $bg_img[2];
            } else {
                $name = 'logo' . time() . '.' . explode('/', explode(':', substr($request->site_logo_path, 0, strpos($request->site_logo_path, ';')))[1])[1];
                $siteLogoFileName = $name;
                Image::make($request->site_logo_path)->resize(440, 442)->save(public_path('uploads/') . $name);

                if ($data && $data->site_logo_path && file_exists('uploads/' . $data->site_logo_path)) {
                    unlink('uploads/' . $data->site_logo_path);
                }
            }
        } else {
            $siteLogoFileName = '';
        }

        // Handle Front Background
        if ($request->bg_path) {
            if (strlen($request->bg_path) < 200) {
                $bg_img = explode('/', $request->bg_path);
                $bgPathFileName = $bg_img[2];
            } else {
                $name = 'bg' . time() . '.' . explode('/', explode(':', substr($request->bg_path, 0, strpos($request->bg_path, ';')))[1])[1];
                $bgPathFileName = $name;
                Image::make($request->bg_path)->save(public_path('uploads/') . $name);

                if ($data && $data->bg_path && file_exists('uploads/' . $data->bg_path)) {
                    unlink('uploads/' . $data->bg_path);
                }
            }
        } else {
            $bgPathFileName = '';
        }

        // Handle Back Background
        if ($request->back_bg_path) {
            if (strlen($request->back_bg_path) < 200) {
                $back_bg_path = explode('/', $request->back_bg_path);
                $back_bgPathName = $back_bg_path[2] ?? '';
            } else {
                $name = 'back' . time() . '.' . explode('/', explode(':', substr($request->back_bg_path, 0, strpos($request->back_bg_path, ';')))[1])[1];
                $back_bgPathName = $name;
                Image::make($request->back_bg_path)->save(public_path('uploads/') . $name);

                if ($data && !empty($data->back_bg_path)) {
                    $filePath = public_path('uploads/' . $data->back_bg_path);
                    if (file_exists($filePath) && is_file($filePath)) {
                        unlink($filePath);
                    }
                }
            }
        } else {
            $back_bgPathName = '';
        }

        // Save or Update Data
        if ($data) {
            $data->site_logo_path = $siteLogoFileName;
            $data->bg_path = $bgPathFileName;
            $data->back_bg_path = $back_bgPathName;
            $data->card_template = $request->card_template;
            $data->signature_text = $request->signature_text;
            $data->status = $request->status;
            $data->body_font_size = $request->body_font_size;
            $data->institute_name_font_size = $request->institute_name_font_size;
            $data->name_font_size = $request->name_font_size;
            $data->save();
        } else {
            $idcard = new IdCardSetting;
            $idcard->site_logo_path = $siteLogoFileName;
            $idcard->bg_path = $bgPathFileName;
            $idcard->back_bg_path = $back_bgPathName;
            $idcard->card_template = $request->card_template;
            $idcard->signature_text = $request->signature_text;
            $idcard->status = $request->status;
            $idcard->body_font_size = $request->body_font_size;
            $idcard->institute_name_font_size = $request->institute_name_font_size;
            $idcard->name_font_size = $request->name_font_size;
            $idcard->save();
        }

        return response()->json(['message' => 'ID card saved successfully'], 200);
    }

    public function getSettingData()
    {
        $data = $this->cardSetting->active()->first();
        return response()->json($data, 200);
    }

    //report==========================report==================
    public function idCardViewPdf(Request $request)
    {

        ini_set('memory_limit', '-1');



        $page_tittle = "Student ID Card View Report";
        $report_tittle = "<b>Student ID Card View Report</b> <br/>";
        $report_tittle2 = " ";
        $card_data = $request->studentList;
        $signature = $request->signature;
        $designation = $request->designation;

        //============ domain name =============
        $site_id = Session::get('SITE_ID');
        $site_info =  SiteInfo::findOrFail($site_id);
        if ($site_info->domain_name == null) {
            $alias = $site_info->site_alias;
            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $host = $parsedUrl['host'];
            $host_names = explode(".", $host);
            $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

            if ($host_names[count($host_names) - 1] == 'bd') {
                $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
            }
            if (count($host_names) == 2) {
                $bottom_host_name = $host_names[count($host_names) - 1];
            }
            $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;
        } else {
            $domain = $site_info->domain_name;
        }

        $showQRCode = $request->showQRCode;

        //    dd($card_data);

        if (count($card_data) < 1) {
            return Response::json(['message' => 'Please Select Student To See PDF'], 410);
        }

        $card_setting = $this->cardSetting->active()->first();



        //{{asset("/img/site/idcard/".Session::get('ALIAS1').".jpg")}}
        if ($request->type == 1) {

            if (!$card_setting) {
                return Response::json(['message' => 'First make ID card setting'], 410);
            }

            if (file_exists("/img/site/idcard/" . Session::get('ALIAS1') . ".jpg")) {
                $default_bg = "/img/site/idcard/" . Session::get('ALIAS1') . ".jpg";
            } else {
                $default_bg = '/uploads/image-not.png';
            }
            if (!file_exists(Session::get('LOGO_PATH'))) {
                $default_logo = Session::get('LOGO_PATH');
            } else {
                $default_logo = '/uploads/image-not.png';
            }

            $site_logo_path = $card_setting->site_logo_path ? 'uploads/' . $card_setting->site_logo_path : $default_logo;
            $site_name = $site_info->site_name ?? "";

            //    dd($site_info->site_name);
            $bg_path = $card_setting->bg_path ? 'uploads/' . $card_setting->bg_path : $default_bg;
            $institute_name_font_size  = $card_setting->institute_name_font_size ? $card_setting->institute_name_font_size . 'px' : 10 . 'px';
            $body_font_size            = $card_setting->body_font_size ? $card_setting->body_font_size . 'px' : 10 . 'px';
            $name_font_size            = $card_setting->name_font_size ? $card_setting->name_font_size . 'px' : 10 . 'px';


            if ($card_setting->card_template == 'epson_l805') { //id card view pdf

                if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-in-epson-l805')) {
                    $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-in-epson-l805', compact('site_id', 'bg_path', 'site_logo_path', 'card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2', 'domain', 'showQRCode'))->setPaper('a4', 'landscape');
                } else {
                    $pdf = PDF::loadView('default.site.student.id-card.card-view-report-in-epson-l805', compact('site_id', 'bg_path', 'site_logo_path', 'card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2', 'domain', 'showQRCode'))->setPaper('a4', 'landscape');
                }
            } elseif ($card_setting->card_template == 'zebra') {

                if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-in-zebra')) {
                    $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-in-zebra', compact('site_id', 'site_name', 'bg_path', 'site_logo_path', 'name_font_size', 'body_font_size', 'institute_name_font_size', 'card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2', 'domain', 'showQRCode'))->setWarnings(false);;
                } else {
                    $pdf = PDF::loadView('default.site.student.id-card.card-view-report-in-zebra', compact('site_id', 'bg_path', 'site_logo_path', 'card_data', 'signature', 'designation', 'body_font_size', 'report_tittle', 'page_tittle', 'report_tittle2', 'domain', 'showQRCode'))->setWarnings(false);;
                }
            } elseif ($card_setting->card_template == 'uv') {
                if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-uv')) {
                    $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-uv', compact('site_id', 'bg_path', 'site_name', 'site_logo_path', 'card_data', 'signature', 'name_font_size', 'body_font_size', 'institute_name_font_size', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2', 'domain', 'showQRCode'))->setPaper('a4', 'landscape');
                } else {
                    $pdf = PDF::loadView('default.site.student.id-card.card-view-report-vertical', compact('site_id', 'bg_path', 'site_logo_path',  'card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2', 'domain', 'showQRCode'))->setPaper('a4', 'landscape');
                }
            } else {
                if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-vertical')) {


                    $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-vertical', compact('site_id', 'bg_path', 'site_logo_path', 'card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2', 'domain', 'showQRCode'))->setPaper('a4', 'landscape');
                } else {
                    $pdf = PDF::loadView('default.site.student.id-card.card-view-report-vertical', compact('site_id', 'bg_path', 'site_logo_path',  'card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2', 'domain', 'showQRCode'))->setPaper('a4', 'landscape');
                }
            }
        } else {
            $page_tittle = "Student ID Card Proof Report";

            $report_tittle = "<b>Student ID Card Proof Report</b> <br/>";

            $pdf = PDF::loadView('default.site.student.id-card.card-view-report-proof', compact('card_data', 'report_tittle', 'page_tittle', 'report_tittle2'))->setPaper('a4', 'landscape');
        }


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]), 'message' => 'Successfully Created Card Report'], 200);
    }
    public function idCardBackViewPdf(Request $request)
    {

        ini_set('memory_limit', '-1');

        $page_tittle = "Student ID Card View Report";
        $report_tittle = "<b>Student ID Card View Report</b> <br/>";
        $report_tittle2 = " ";
        $card_data = $request->studentList;
        $signature = $request->signature;
        $designation = $request->designation;

        //============ domain name =============
        $site_id = Session::get('SITE_ID');
        $site_info =  SiteInfo::findOrFail($site_id);
        if ($site_info->domain_name == null) {
            $alias = $site_info->site_alias;
            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $host = $parsedUrl['host'];
            $host_names = explode(".", $host);
            $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

            if ($host_names[count($host_names) - 1] == 'bd') {
                $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
            }
            if (count($host_names) == 2) {
                $bottom_host_name = $host_names[count($host_names) - 1];
            }
            $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;
        } else {
            $domain = $site_info->domain_name;
        }

        $showQRCode = $request->showQRCode;



        if (count($card_data) < 1) {
            return Response::json(['message' => 'Please Select Student To See PDF'], 410);
        }

        $card_setting = $this->cardSetting->active()->first();

        if ($request->type == 1) {

            if (!$card_setting) {
                return Response::json(['message' => 'First make ID card setting'], 410);
            }

            if (file_exists("/img/site/idcard/" . Session::get('ALIAS1') . ".jpg")) {
                $default_bg = "/img/site/idcard/" . Session::get('ALIAS1') . ".jpg";
            } else {
                $default_bg = '/uploads/image-not.png';
            }
            if (!file_exists(Session::get('LOGO_PATH'))) {
                $default_logo = Session::get('LOGO_PATH');
            } else {
                $default_logo = '/uploads/image-not.png';
            }

            $site_logo_path = $card_setting->site_logo_path ? 'uploads/' . $card_setting->site_logo_path : $default_logo;
            $site_name = $site_info->site_name ?? "";


            $bg_path                  = $card_setting->back_bg_path ? 'uploads/' . $card_setting->back_bg_path : $default_bg;
            $institute_name_font_size = $card_setting->institute_name_font_size ? $card_setting->institute_name_font_size . 'px' : 10 . 'px';
            $body_font_size           = $card_setting->body_font_size ? $card_setting->body_font_size . 'px' : 10 . 'px';
            $name_font_size           = $card_setting->name_font_size ? $card_setting->name_font_size . 'px' : 10 . 'px';


            if ($card_setting->card_template == 'epson_l805') { //id card view pdf

                // if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-in-epson-l805')) {
                //     $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-in-epson-l805', compact('site_id','bg_path','site_logo_path','card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2','domain','showQRCode'))->setPaper('a4', 'landscape');
                // } else {
                //     $pdf = PDF::loadView('default.site.student.id-card.card-view-report-in-epson-l805', compact('site_id','bg_path','site_logo_path', 'card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2','domain','showQRCode'))->setPaper('a4', 'landscape');

                // }
            } elseif ($card_setting->card_template == 'zebra') {

                // if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-in-zebra')) {
                //     $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-in-zebra', compact('site_id','site_name','bg_path','site_logo_path','name_font_size','body_font_size','institute_name_font_size','card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2','domain','showQRCode'))->setWarnings(false);;

                // } else {
                //     $pdf = PDF::loadView('default.site.student.id-card.card-view-report-in-zebra', compact('site_id','bg_path','site_logo_path', 'card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2','domain','showQRCode'))->setWarnings(false);;

                // }
            } elseif ($card_setting->card_template == 'uv') {
                if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.id-card.card-back-view-report-uv')) {


                    $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.student.id-card.card-back-view-report-uv', compact('site_id', 'bg_path', 'site_logo_path', 'card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2', 'domain', 'showQRCode'))->setPaper('a4', 'landscape');
                } else {
                    $pdf = PDF::loadView('default.site.student.id-card.card-view-report-vertical', compact('site_id', 'bg_path', 'site_logo_path',  'card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2', 'domain', 'showQRCode'))->setPaper('a4', 'landscape');
                }
            } else {
                if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-vertical')) {


                    $pdf = PDF::loadView('custom.' . Session::get('ALIAS1') . '.student.id-card.card-view-report-vertical', compact('site_id', 'bg_path', 'site_logo_path', 'card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2', 'domain', 'showQRCode'))->setPaper('a4', 'landscape');
                } else {
                    $pdf = PDF::loadView('default.site.student.id-card.card-view-report-vertical', compact('site_id', 'bg_path', 'site_logo_path',  'card_data', 'signature', 'designation', 'report_tittle', 'page_tittle', 'report_tittle2', 'domain', 'showQRCode'))->setPaper('a4', 'landscape');
                }
            }
        } else {
            $page_tittle = "Student ID Card Proof Report";

            $report_tittle = "<b>Student ID Card Proof Report</b> <br/>";

            $pdf = PDF::loadView('default.site.student.id-card.card-view-report-proof', compact('card_data', 'report_tittle', 'page_tittle', 'report_tittle2'))->setPaper('a4', 'landscape');
        }


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]), 'message' => 'Successfully Created Card Report'], 200);
    }
}
