<?php

namespace App\Http\Controllers\Site\Student\Manual;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Student\Manual\SiteStudentManualCount;
use App\Models\Academic\AcademicVersion;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\AcademicYear\AcademicYear;

use Response;

class SiteStudentManualCountController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Student Form Quick Update';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function addManualNumberOfStudent(Request $requests, SiteStudentManualCount $manualStudentCount){

        $this->validate($requests, [
            "academic_version_id" => "required",
            "academic_year_id" => "required",
            "academic_shift_id" => "required",
            "academic_class_id" => "required",
            "total_number_of_studnet" => "required",
        ]);

       $checkData = $manualStudentCount->where('academic_version_id', $requests->academic_version_id)
                    ->where('academic_year_id', $requests->academic_year_id)
                    ->where('academic_shift_id', $requests->academic_shift_id)
                    ->where('academic_class_id', $requests->academic_class_id)
                    ->when(!empty($requests->academic_department_id), function($query) use ($requests){
                       return $query->where('academic_department_id',$requests->academic_department_id);
                    })
                    ->when(!empty($requests->academic_class_group_id), function($query) use ($requests){
                       return $query->where('academic_class_group_id',$requests->academic_class_group_id);
                    })
                    ->when(!empty($requests->academic_session_id), function($query) use ($requests){
                       return $query->where('academic_session_id',$requests->academic_session_id);
                    })
                    ->when(!empty($requests->site_batch_detail_id), function($query) use ($requests){
                       return $query->where('site_batch_detail_id',$requests->site_batch_detail_id);
                    })
                    ->when(!empty($requests->academic_section_id), function($query) use ($requests){
                       return $query->where('academic_section_id',$requests->academic_section_id);
                    })
                    ->first(); 

                //    dd($checkData);

                    if($checkData){
                        foreach ($checkData->ownFields as $countField) {
                            if ($requests->{$countField}) {
                                $checkData->{$countField} = $requests->{$countField};
                            }
                        }
                        if($checkData->save()){
                            return Response::json(['message'=>'Update Successfully'],200);
                        }
                    }else{
                        foreach ($manualStudentCount->ownFields as $countField) {
                            if ($requests->{$countField}) {
                                $manualStudentCount->{$countField} = $requests->{$countField};
                            }
                        }
                
                        if($manualStudentCount->save()){
                            return Response::json(['message'=>'Save Successfully'],200);
                        }
                    }

       
        
        


    }

    public function manualStudentCountList(){
        //
        $count_list=SiteStudentManualCount::with('shift','year','stClass','accGroup','session','department','section')->get();

        $totalStudent = SiteStudentManualCount::sum('total_number_of_studnet');

        $version_ids = $count_list->pluck('academic_version_id')->unique()->filter();
        $version_list = AcademicVersion::whereIn('id', $version_ids)->get();

        $check_department_ids = $count_list->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $count_list->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $count_list->pluck('academic_section_id')->unique()->filter();


        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }

        
        $version_arr = Array();
        $student_count_array = [];
        foreach ($version_list as $keyVersion => $valueVersion) {

            $filtered_version_list = $count_list
                ->where('academic_version_id', $valueVersion->id);

            $version_arr['version_name'] = $valueVersion->version_name;
            $version_arr['version_student_count'] = $filtered_version_list->sum('total_number_of_studnet');

            ////////
            $year_ids = $filtered_version_list->pluck('academic_year_id')
            ->unique()
            ->filter();

        $yearList = AcademicYear::whereIn('id', $year_ids)
            ->get();

        $year_arr = Array();
        $year_array = [];
        foreach ($yearList as $keyYear => $valueYear) {

            $filtered_year_list = $filtered_version_list
                ->where('academic_year_id', $valueYear->id);

            $year_arr['year_name'] = $valueYear->year_name;
            $year_arr['year_student_count'] =$filtered_year_list->sum('total_number_of_studnet');

            ///////

            $shift_ids = $filtered_year_list->pluck('academic_shift_id')
                ->unique()
                ->filter();

            $shiftList = AcademicShift::whereIn('id', $shift_ids)
                ->get();

            $shift_arr = Array();
            $shift_array = [];
            foreach ($shiftList as $keyShift => $valueShift) {

                $filtered_shift_list = $filtered_version_list
                    ->where('academic_shift_id', $valueShift->id);

                $shift_arr['shift_name'] = $valueShift->shift_name;
                $shift_arr['shift_student_count'] = $filtered_shift_list->sum('total_number_of_studnet');


                $department_ids = $filtered_shift_list->pluck('academic_department_id')
                    ->unique()
                    ->filter();

                if (count($department_ids) > 0) {
                    $departmentList = AcademicDepartment::whereIn('id', $department_ids)->get();

                    $department_arr = Array();
                    $department_array = [];
                    foreach ($departmentList as $keyDepartment => $valueDepartment) {

                        $filtered_department_list = $filtered_shift_list
                            ->where('academic_department_id', $valueDepartment->id);

                        $department_arr['department_name'] = $valueDepartment->name;
                        $department_arr['department_student_count'] = $filtered_department_list->sum('total_number_of_studnet');


                        $class_ids = $filtered_department_list->pluck('academic_class_id')
                            ->unique()
                            ->filter();

                        $classList = AcademicClass::whereIn('id', $class_ids)->get();

                        $class_array = $this->getClassGroupSectionCount($classList, $filtered_department_list, $class_group_present);

                        $department_arr['class_array'] = $class_array;

                        $department_arr['count_class_row'] = collect($class_array)->sum('count_class_row') + count($class_array);

                        $department_array[$keyDepartment] = $department_arr;

                    }


                } else {

                    $class_ids = $filtered_shift_list->pluck('academic_class_id')
                        ->unique()
                        ->filter();

                    $classList = AcademicClass::whereIn('id', $class_ids)->get();
                    $class_array = $this->getClassGroupSectionCount($classList, $filtered_shift_list, $class_group_present);

                }

                if (count($department_ids) > 0) {

                    $shift_arr['class_array'] = [];
                    $shift_arr['department_array'] = $department_array;

                    $shift_arr['shift_array_row'] = (collect($department_array)->sum('count_class_row')) + count($department_array);

                } else {
                    $shift_arr['class_array'] = $class_array;
                    $shift_arr['department_array'] = [];

                    $shift_arr['shift_array_row'] = (collect($class_array)->sum('count_class_row')) + count($class_array);
                }


                $shift_array[$keyShift] = $shift_arr;


            }
        ////

        $year_arr['shift_array'] = $shift_array;

        $year_arr['year_array_row'] = (collect($shift_array)->sum('shift_array_row')) + count($shift_array);
    
        $year_array[$keyYear] = $year_arr;

        }

        //////


            $version_arr['version_array_row'] = (collect($year_array)->sum('year_array_row')) + count($year_array);

            $version_arr['year_array'] = $year_array;

            $student_count_array[$keyVersion] = $version_arr;

        }

        return [$student_count_array, $department_present, $class_group_present, $section_present, $totalStudent];

           // return Response::json($student_count_list,200);

    }

        
    private function getClassGroupSectionCount($classList, $filtered_shift_list, $class_group_present)
    {
        $class_arr = Array();
        $class_array = [];
        foreach ($classList as $keyClass => $valueClass) {

            $filtered_class_list = $filtered_shift_list
                ->where('academic_class_id', $valueClass->id);


            $class_arr['class_name'] = $valueClass->class_name;
            $class_arr['class_student_count'] = $filtered_class_list->sum('total_number_of_studnet');


            $class_group_ids = $filtered_class_list->pluck('academic_class_group_id')
                ->unique()
                ->filter();


            if (count($class_group_ids) > 0) {

                $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


                $class_group_arr = Array();
                $class_group_array = [];
                foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

                    $filtered_class_group_list = $filtered_class_list
                        ->where('academic_class_group_id', $valueClassGroup->id);


                    $class_group_arr['group_name'] = $valueClassGroup->group_name;
                    $class_group_arr['class_group_student_count'] = $filtered_class_group_list->sum('total_number_of_studnet');


                    $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                        ->unique()
                        ->filter();

                    $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                    $class_group_arr['count_class_group_row'] = count($sectionList);


                    $section_arr = Array();
                    $section_array = [];
                    foreach ($sectionList as $keySection => $valueSection) {

                      $singleData = $filtered_section_list = $filtered_class_group_list
                            ->where('academic_section_id', $valueSection->id);

                        $singleData=$singleData->select('id')->first();

                        $section_arr['section_name'] = $valueSection->section_name;
                        $section_arr['class_section_count'] = $filtered_section_list->sum('total_number_of_studnet');
                        $section_arr['id'] = $singleData->id;


                        $section_array[$keySection] = $section_arr;
                    }

                    $class_group_arr['section_array'] = $section_array;

                    $class_group_array[$keyClassGroup] = $class_group_arr;


                }


            } else {

                $section_ids = $filtered_class_list->pluck('academic_section_id')
                    ->unique()
                    ->filter();

                $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                $section_arr = Array();
                $section_array = [];
                foreach ($sectionList as $keySection => $valueSection) {

                    $filtered_section_list = $filtered_class_list
                        ->where('academic_section_id', $valueSection->id);


                    $section_arr['section_name'] = $valueSection->section_name;
                    $section_arr['class_section_count'] = $filtered_section_list->sum('total_number_of_studnet');

                    $section_array[$keySection] = $section_arr;

                }

//                            $class_group_arr['section_array']=$section_array;
//                            $class_group_array[]=$class_group_arr;


            }


            if (count($class_group_ids) > 0) {
                $class_arr['class_group_array'] = $class_group_array;
                $class_arr['section_array'] = [];

                $class_arr['count_class_row'] = (collect($class_group_array)->sum('count_class_group_row')) + count($class_group_array);
            } else {
                $class_arr['section_array'] = $section_array;
                $class_arr['class_group_array'] = [];

//                if($class_group_present){
//                    $class_arr['count_class_row']=count($section_array)*2;
//                }else{
                $class_arr['count_class_row'] = count($section_array);
//                }

            }

            $class_array[$keyClass] = $class_arr;

        }

        return $class_array;
    }



}
