<?php

namespace App\Http\Controllers\Site\StudentAdmission;

use App\Imports\Site\SiteAdmissionRollImport;
use App\Models\Academic\AcademicBank;
use App\Models\Academic\AcademicBoard;
use App\Models\Site\SiteClassSessionSerialSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionBoardApprove;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionBoardApproveExcel;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionDeclare;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicShift;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Fee\GlobalSiteStudentFeeSubHeadAllocation;
use App\Models\Site\Fee\SiteAdmissionFeeGatewaySetting;
use App\Models\Site\Fee\SiteStudentFeeGatewaySetting;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\Payment\SitePaymentGateway;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionBoardApprove;
use App\Models\Site\StudentAdmission\SiteAdmissionFeeSubHeadAllocation;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionFeeGenerate;
use Illuminate\Http\JsonResponse;
use Exception;
use Illuminate\Validation\ValidationException;
use Maatwebsite\Excel\Facades\Excel;
use Session;
use Response;
use Carbon\Carbon;
use PDF;
use Auth;

class SiteAdmissionSubheadSettingsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

    public function index()
    {
        $viewType = 'Student Admission Declaration Page';
        return view('default.admin.layouts.master', compact('viewType'));

    }


//    Roll Reg Validation


    /**
     * @param $group_id
     * @return \Illuminate\Database\Eloquent\Model|null|object|static
     */

     public function siteFeeSubHeadList()
     {
 
         $siteInfoSettinglist=SiteInfoSetting::select('academic_fee_head_ids','academic_fee_group_ids', 'academic_fee_sub_head_ids')
             ->where('site_id',Session::get('SITE_ID'))
             ->first();
 
         $feeSubHeadSplite = explode(',', $siteInfoSettinglist->academic_fee_sub_head_ids);
         $feeSubHeadList = AcademicFeeSubHead::whereIn('id', $feeSubHeadSplite)->get();
 
       
       
         $subhadArray=[];
         foreach ($feeSubHeadList as $key => $value) {
             $subhadArray[$key]['id']=$value->id;
             $subhadArray[$key]['name']=$value->name;

            $checkSubhead=SiteAdmissionFeeSubHeadAllocation::where('academic_fee_sub_head_id',$value['id'])->where('status',true)->first();
            if($checkSubhead){
                $subhadArray[$key]['amount']=$checkSubhead->amount;
                $subhadArray[$key]['select_fee_sub_head_id']=true;
            }else{

                $checkSubhead=SiteAdmissionFeeSubHeadAllocation::where('academic_fee_sub_head_id',$value['id'])->first();
                if($checkSubhead){
                    $subhadArray[$key]['amount']=$checkSubhead->amount;
                }else{
                    $subhadArray[$key]['amount']='';
                }
                $subhadArray[$key]['select_fee_sub_head_id']=false;
               
            }

             
         }
 
         return response()->json($subhadArray, 200, [], JSON_NUMERIC_CHECK);
 
     }

     public function createStudentAdmissionSubhead(Request $request)
     {

    //    dd($request['FeeSubHeadList']);
        foreach($request['FeeSubHeadList'] as $subheadItem){
            if($subheadItem['select_fee_sub_head_id']){

                $checkSubhead=SiteAdmissionFeeSubHeadAllocation::where('academic_fee_sub_head_id',$subheadItem['id'])->first();
                if($checkSubhead){
                  //  dd($subheadItem['amount']);
                    $checkSubhead->amount=$subheadItem['amount'];
                    $checkSubhead->status=true;
                    $checkSubhead->save();
                }else{
                    $admissionFeeSubhead=new SiteAdmissionFeeSubHeadAllocation;
                    $admissionFeeSubhead->academic_fee_sub_head_id=$subheadItem['id'];
                    $admissionFeeSubhead->amount=$subheadItem['amount'];
                    $admissionFeeSubhead->status=true;
                    $admissionFeeSubhead->save();
                }
               
            }else{

                $checkSubhead=SiteAdmissionFeeSubHeadAllocation::where('academic_fee_sub_head_id',$subheadItem['id'])->first();
                if($checkSubhead){
                    $checkSubhead->status=false;
                    $checkSubhead->save();
                }
            }
         
        }


        return JsonResponse::create(['message' => 'Successfuly Saved!'], 200);

     }



     public function getSitePaymentGateway()
     {
 
         // payment gateway list
         $payment_gateway_list =  SitePaymentGateway::with(['academicOnlinePaymentMethod','academicOnlinePaymentMarchentType',
                     'academicFeeType'])
                     ->get();
         $payment_gateway_array=[];
         foreach($payment_gateway_list as $key=>$item){
             $payment_gateway_array[$key]['id']=$item->id;
             $payment_gateway_array[$key]['fee_type_name']=$item->academicFeeType?$item->academicFeeType->name:'';
             $payment_gateway_array[$key]['academic_payment_method_name']=$item->academicOnlinePaymentMethod?$item->academicOnlinePaymentMethod->name:'';
             $payment_gateway_array[$key]['academic_payment_type_key']=$item->academic_payment_type_key;
             $payment_gateway_array[$key]['iid']=$item->iid;
             $payment_gateway_array[$key]['user_name']=$item->user_name;
         }
 
         return $payment_gateway_array;
 
     }


     
    public function getHeadWiseSubheadList(Request $request){

        $generated_sub_head_ids = SiteStudentAdmissionFeeGenerate::pluck('academic_fee_sub_head_id')
                ->unique()
                ->filter();

        $allocationList=SiteAdmissionFeeSubHeadAllocation::where('status',true)->get();

        $academic_fee_sub_head_ids=$allocationList->pluck('academic_fee_sub_head_id')->unique()->filter();

        $all_unique_ids = $academic_fee_sub_head_ids
            ->merge($generated_sub_head_ids)
            ->unique()
            ->values(); 
     
        $academic_fee_sub_head_ids = SiteStudentAdmissionFeeGenerate::pluck('academic_fee_sub_head_id')->unique();

        $sitefeeHead=SiteAdmissionFeeSubHeadAllocation::whereIn('academic_fee_sub_head_id',$all_unique_ids)->get();
        

     //   dd($sitefeeHead);


        // $sitefeeHead=SiteAdmissionFeeSubHeadAllocation::get();

        // $sitefeeHeadIDs=$sitefeeHead->pluck('academic_fee_head_id')
        //         ->unique()
        //         ->values();
        
        $siteFeeHeadList=AcademicFeeHead::where('id', 1)->get();

        $payment_gateway_list =  SitePaymentGateway::with(['academicOnlinePaymentMethod','academicOnlinePaymentMarchentType','academicFeeType'])
                ->where('academic_payment_type_key','online')
                ->where('status',true)
                ->get();

        $payment_method_keys=$payment_gateway_list->pluck('academic_payment_method_key')->unique()->values();

        $gateway_array=[];
       
        foreach($payment_method_keys as $acc_typ_key=>$item){
         
            $total_row_count=0;
            $gateway_account=$payment_gateway_list->where('academic_payment_method_key',$item)->values();
            $account_array=[];
          
            foreach($gateway_account as $acc_key=>$items){
                $account_array[$acc_key]['id']=$items->id;
                $account_array[$acc_key]['partner_number']=$items->partner_number;
                $account_array[$acc_key]['academic_payment_method_name']=$items->academicOnlinePaymentMethod?$items->academicOnlinePaymentMethod->name:'';
                $account_array[$acc_key]['academic_payment_type_key']=$items->academic_payment_type_key;
                $account_array[$acc_key]['iid']=$items->iid;
                $account_array[$acc_key]['user_name']=$items->user_name;

                ///=== fee head list===

            $data_array=[];

            foreach($siteFeeHeadList as $keyys=>$fee_head){

                //    $subHeadWiseHead=$sitefeeHead->where('academic_fee_head_id',$fee_head->id)->pluck('academic_fee_sub_head_id')->unique();
            
                    $gateway_setting_list=SiteStudentFeeGatewaySetting::where('site_payment_gateway_id',$items->id)
                            ->where('academic_fee_head_id',$fee_head->id)
                            ->where('Fee_type_key','admission_fee')
                            ->where('status',true)
                            ->get();
                         //   dd($gateway_setting_list);

                    if(count($gateway_setting_list)){
                        $data_array[$keyys]['select_academic_fee_head_id']=true;
                    }else{
                        $data_array[$keyys]['select_academic_fee_head_id']=false;
                    }

                    $data_array[$keyys]['academic_fee_head_id']=$fee_head->id;
                    $data_array[$keyys]['academic_fee_head_name']=$fee_head->name;

                    $subHeadWiseHead=$sitefeeHead->pluck('academic_fee_sub_head_id')->unique();

                 //   dd($sitefeeHead);
                
                    $fee_sub_head_list=AcademicFeeSubHead::whereIn('id',$subHeadWiseHead)->get();

                    $sub_head_array=[];

                    foreach($fee_sub_head_list as $keyysy=>$sub_head){
                        $gateway_setting=$gateway_setting_list->where('academic_fee_sub_head_id',$sub_head['id'])->first();
                        if($gateway_setting){
                            $sub_head_array[$keyysy]['select_sub_head']=true;
                        }else{
                            $sub_head_array[$keyysy]['select_sub_head']=false;

                        }

                        $sub_head_array[$keyysy]['id']=$sub_head->id;
                        $sub_head_array[$keyysy]['name']=$sub_head->name;
                        $sub_head_array[$keyysy]['head_key']=$sub_head->head_key;
                        $sub_head_array[$keyysy]['head_key_base_id']=$sub_head->head_key_base_id;

                        $data_array[$keyys]['academic_fee_sub_head_list']=$sub_head_array;

                    }
                }

                $account_array[$acc_key]['fee_head_array']=$data_array;

                $total_row_count++;
            }

            $gateway_array[$acc_typ_key]['row_count']=$total_row_count;
            $gateway_array[$acc_typ_key]['academic_payment_method_key']=$item;
            $gateway_array[$acc_typ_key]['account_list']=$account_array;
           
        }

        return $gateway_array;

    }



    public function siteStudentFeePaymentGatewaySettigSave(Request $request){

        

                //===== temporary permission =====
                $headTeacher= Employee::where('site_id',Session::get('SITE_ID'))
                    ->where('institute_head',true)
                    ->where('status',true)
                    ->where('id',Auth::user()->id)
                    ->first();

                if( !in_array(Auth::user()->username, ['rayhan','Hriday']) || $headTeacher ) {
                    return response()->json(['message' => 'You have no permission!'], 410);
                }
                ///====

                $duplicate_head_ids=[];
                $duplicate_sub_head_ids=[];
                $keyss=0;

                $duplicateMessages=[];

                foreach($request->GatewayArray as $item){

                    foreach($item['account_list'] as $account){

                        foreach($account['fee_head_array'] as $fee_head){

                                foreach($fee_head['academic_fee_sub_head_list'] as $sub_head){

                                  $checkSetting=SiteStudentFeeGatewaySetting::where('fee_type_key','admission_fee')
                                        ->where('academic_payment_method_key',$item['academic_payment_method_key'])
                                        ->where('site_payment_gateway_id',$account['id'])
                                        ->where('academic_fee_head_id',$fee_head['academic_fee_head_id'])
                                        ->where('academic_fee_sub_head_id',$sub_head['id'])
                                     //   ->where('status',true)
                                        ->first();

                                     if($sub_head['select_sub_head']==false || $fee_head['select_academic_fee_head_id']==false){
                                        $checkUnselectAnother=SiteStudentFeeGatewaySetting::where('fee_type_key','admission_fee')
                                            ->where('site_payment_gateway_id',$account['id'])
                                            ->where('academic_payment_method_key',$item['academic_payment_method_key'])
                                            ->where('academic_fee_head_id',$fee_head['academic_fee_head_id'])
                                            ->where('academic_fee_sub_head_id',$sub_head['id'])
                                            ->where('status',true)
                                            ->first();
                                        if($checkUnselectAnother){
                                            $checkUnselectAnother->update([
                                                'status'=>false,
                                                'updated_by'=>Auth::user()->id
                                            ]);

                                        }
                                       

                                     }

                                    if($sub_head['select_sub_head'] && $fee_head['select_academic_fee_head_id']){
                                      

                                         $checkAnother=SiteStudentFeeGatewaySetting::where('fee_type_key','admission_fee')
                                            ->where('site_payment_gateway_id','!=',$account['id'])
                                            ->where('academic_payment_method_key',$item['academic_payment_method_key'])
                                            ->where('academic_fee_head_id',$fee_head['academic_fee_head_id'])
                                            ->where('academic_fee_sub_head_id',$sub_head['id'])
                                            ->where('status',true)
                                            ->first();

                                        if($checkAnother){
                                            $head = AcademicFeeHead::where('id',$checkAnother->academic_fee_head_id)->first();
                                            $subhead = AcademicFeeSubHead::where('id',$checkAnother->academic_fee_sub_head_id)->first();
                                            $gateway = SitePaymentGateway::where('id',$checkAnother->site_payment_gateway_id)->first();
                                          

                                           // $duplicate_head_ids[$keyss][$checkAnother->academic_fee_head_id];
                                           // $duplicate_sub_head_ids[$keyss][$checkAnother->academic_fee_sub_head_id];
                                            $duplicateMessages[] = "{$head->name} into {$subhead->name} is already set in {$gateway->iid}";

                                            $keyss++;
                                            continue;

                                        //   return response()->json(['message'=>$head->name.' into '.$subhead->name.' is aleady set in '.$gateway->iid], 411);
                                        }
                                   
                                    if($checkSetting){
                                        if($checkSetting->status==false){
                                            $checkSetting->updated_by=Auth::user()->id;
                                            $checkSetting->academic_payment_method_key=$item['academic_payment_method_key'];
                                            $checkSetting->status=true;
                                            $checkSetting->save();
                                        }
                                    }else{
                                        $gateway_setting=new SiteStudentFeeGatewaySetting();
                                        $gateway_setting->site_payment_gateway_id=$account['id'];
                                        $gateway_setting->fee_type_key='admission_fee';
                                        $gateway_setting->academic_payment_method_key=$item['academic_payment_method_key'];
                                        $gateway_setting->academic_fee_head_id=$fee_head['academic_fee_head_id'];
                                        $gateway_setting->academic_fee_sub_head_id=$sub_head['id'];
                                        $gateway_setting->created_by=Auth::user()->id;
                                        $gateway_setting->status=true;
                                        $gateway_setting->save();
                                    }

                                 
                               
                            }
                    }
                }
                }
                }


            if(count($duplicateMessages)){
                return response()->json(['message'=>'Save Successfully, and '.implode(', ', $duplicateMessages)], 200);
            }

            return response()->json(['message'=>'Save Successfully'], 200);

        ////////////////

        $this->validate($request, [
            "site_payment_gateway_id" => "required",
        ]);

        //===== temporary permission =====
        if(Auth::user()->username!='rayhan'){
            return response()->json(['message'=>'You have no permission!'], 410);
        }
        ///====

        foreach($request->FeeHeadWiseSubHead as $item){

              $key=0;
              foreach($item['academic_fee_sub_head_list'] as $sub_head){

                $checkSetting=SiteAdmissionFeeGatewaySetting::where('site_payment_gateway_id',$request->site_payment_gateway_id)
                    ->where('fee_type_key','admission_fee')
                    ->where('academic_fee_head_id',$item['academic_fee_head_id'])
                    ->where('academic_fee_sub_head_id',$sub_head['id'])
                    ->where('status',true)
                    ->first();

                if($sub_head['select_sub_head']){
                if($item['select_academic_fee_head_id']){

                $checkAnother=SiteAdmissionFeeGatewaySetting::where('site_payment_gateway_id','!=',$request->site_payment_gateway_id)
                    ->where('fee_type_key','admission_fee')
                    ->where('academic_fee_head_id',$item['academic_fee_head_id'])
                    ->where('academic_fee_sub_head_id',$sub_head['id'])
                    ->where('status',true)
                    ->first();

                    if($checkAnother){
                       $head = AcademicFeeHead::where('id',$checkAnother->academic_fee_head_id)->first();
                       $subhead = AcademicFeeSubHead::where('id',$checkAnother->academic_fee_sub_head_id)->first();
                       $gateway = SitePaymentGateway::where('id',$request->site_payment_gateway_id)->first();

                       return response()->json(['message'=>'There are slips by '.$subhead->name.' subhead inside the '.$head->name], 411);

                        return response()->json(['message'=>$head->name.' into '.$subhead->name.' is aleady set in '.$gateway->iid], 411);
                    }


                if($checkSetting){
                    if($checkSetting->status==false){
                        $checkSetting->updated_by=Auth::user()->id;
                        $checkSetting->status=true;
                        $checkSetting->save();
                    }
                   
                }else{
                    $gateway_setting=new SiteAdmissionFeeGatewaySetting();
                    $gateway_setting->fee_type_key='admission_fee';
                    $gateway_setting->site_payment_gateway_id=$request->site_payment_gateway_id;
                    $gateway_setting->academic_fee_head_id=$item['academic_fee_head_id'];
                    $gateway_setting->academic_fee_sub_head_id=$sub_head['id'];
                    $gateway_setting->created_by=Auth::user()->id;
                    $gateway_setting->status=true;
                    $gateway_setting->save();
                }   
              }

            }else{
                if($checkSetting){
                    $checkSetting->status=false;
                    $checkSetting->updated_by=Auth::user()->id;
                    $checkSetting->save();
                }
            }
        }

        }

        return response()->json(['message'=>'Save Successfully'], 200);


    }



}
