<?php

namespace App\Http\Controllers\Site\StudentAdmission;

use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\SubjectCondition;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Designation\Designation;
use App\Models\Image\Photo;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteInfo;
use App\Models\Site\Student\Student;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionApplication;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionDeclare;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionEducationQualification;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\User\UserForUsername;
use Auth;
use Carbon\Carbon;
use DB;
use Error;
use Exception;
use File;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Collection;
use Illuminate\Validation\ValidationException;
use PDF;
use Response;
use Session;
use View;

class SiteStudentAdmissionListController extends Controller
{

    private $appliedStudent;
    public function __construct(SiteStudentAdmissionApplication $appliedStudent)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->appliedStudent = $appliedStudent;
    }


    public function getAdmissionAppliedStudentList(Request $request)
    {

        ini_set('memory_limit', '-1');

//        try {


            $data = [];
            $data['academic_version_id'] = $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id;
//            $data['academic_section_id'] = $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id;
            $data['type'] = $request->type ?? 'data';// data req or pdf
            $data['approve_as_student'] = $request->approve_as_student;// data req or pdf


            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $status = $request->status;
            $txt = '%' . $search_txt . '%';


            if (!$data['academic_version_id'] || !$data['academic_year_id']) {
                throw new Error('Select Version || Year');
            }
            $student_list = [];


            $student_list = $this->appliedStudent
                ->with([
                    'siteStudentAdmissionEducationQualification' => function ($query) {
                        $query->with(['academicBoard', 'academicSession']);
                    },
                    'year', 'shift', 'department', 'stClass', 'classGroup', 'session', 'approved' => function ($q) {
                    $q->select('id');
                }])
                ->where('academic_version_id', $data['academic_version_id'])
                ->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                /*     ->when($search_txt, function ($q) use ($txt) {
                         return $q->where('student_roll_number', $txt)
                             ->orWhere('student_contact_number', 'LIKE', $txt)
                             ->orWhere('first_name', 'LIKE', $txt)
                             ->orWhere('last_name', 'LIKE', $txt);
                     })*/
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                            $query->where('email', 'LIKE', $txt)
                            ->orWhere('student_contact_number', 'LIKE', $txt)
                            ->orWhere('first_name','LIKE', $txt)
                            ->orWhere('transaction_number','LIKE', $txt)
                            ->orWhere('board_roll_number','LIKE', $txt)
                            ->orWhere('unique_code','LIKE', $txt)
                            ->orWhere('last_name','LIKE', $txt)
                            ->orWhere('admission_form_no','LIKE', $txt);
                    });
                })->when($data['approve_as_student']!=2, function ($query) use ($data) {
                    return $query->where('approve_as_student', $data['approve_as_student']);
                })
                ->where('status', $status)
                ->orderBy('student_roll_number')
                ->orderBy('menual_form_number')
                ->paginate($paginate);

            if (count($student_list) < 1) {
                throw new Error('No Student Found!');
            }


            if ($data['type'] == 'pdf') {

                $page_tittle = "Applied Student List Report";
                $report_tittle = "<b>Applied Student  Report</b> <br/>";

                if ($data['academic_version_id']) {
                    $report_tittle .= ' <b> Version:</b>' . ($student_list[0]->version->version_name ?? 'n/a');
                }
                if ($data['academic_year_id']) {
                    $report_tittle .= '<b> Year:</b>' . ($student_list[0]->year->year_name ?? 'n/a');
                }

                if ($data['academic_shift_id']) {
                    $report_tittle .= ' <b> Shift:</b>' . ($student_list[0]->shift->shift_name ?? 'n/a');
                }

                if ($data['academic_department_id'] && $student_list[0]->department) {
                    $report_tittle .= ' <b>Dept:</b>' . ($student_list[0]->department->name ?? 'n/a');
                }

                if ($data['academic_class_id'] && $student_list[0]->stClass) {
                    $report_tittle .= ' <br/><b>Class:</b>' . ($student_list[0]->stClass->class_name ?? 'n/a');
                }

                if ($data['academic_class_group_id'] && $student_list[0]->classGroup) {
                    $report_tittle .= ' <b>Group:</b>' . ($student_list[0]->classGroup->group_name ?? 'n/a');
                }

//                if ($data['academic_section_id'] && $student_list[0]->section) {
//                    $report_tittle .= ' <b>Section:</b>' . ($student_list[0]->section->section_name ?? 'n/a');
//                }

                $report_tittle2 = '';
                //  view('default.site.student_registration.applied-student-report', compact('student_list', 'report_tittle', 'page_tittle', 'report_tittle2'))->setPaper('a4', 'landscape');
                $pdf = PDF::loadView('default.site.student_admission.applied-student-report', compact('student_list', 'report_tittle', 'page_tittle', 'report_tittle2'))->setPaper('a4', 'landscape');


                $path = storage_path() . '/pdf';
                $time = \Auth::user()->id . '-' . Carbon::now()->unix();
                $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
                $name = $time . '.pdf';

                return Response::json(['link' => route('open-pdf-file-storage', [$name]), 'message' => 'Successfully Created  Report'], 200);

            }



            $student_list->getCollection()->transform(function ($applied_st) {

                return [

                    'id' => $applied_st->id ?? 0,
                    'full_name' => $applied_st->full_name ?? '',
                    'student_image' => $applied_st->student_image ?? '',
                    'father_name' => $applied_st->father_name ?? '',
                    'mother_name' => $applied_st->mother_name ?? '',
                    'student_roll_number' => $applied_st->student_roll_number ?? '',

//                    'menual_form_number' => sprintf("%09d", $applied_st->menual_form_number),
                    'admission_form_no' => $applied_st->admission_form_no ?? '--',


                    'unique_code' => $applied_st->unique_code ?? '',
                    'class_name' => $applied_st->stClass->class_name ?? '',
                    'group_name' => $applied_st->classGroup->group_name ?? '',
                    'section_name' => $applied_st->section->section_name ?? '',
                    'board_roll_number' => $applied_st->board_roll_number?? '',
                    'transaction_number' => $applied_st->transaction_number?? '',
//                    'admission_type_name' => $applied_st->academic_admission_type->admission_type_name ?? '',
                    'date_of_birth' => $applied_st->date_of_birth ?? '',
                    'created_at' => $applied_st->created_at ?? '',
                    'approve_as_student' => $applied_st->approve_as_student ?? 0,
                    'approved_at' => $applied_st->approved_at ?? '',
                    'approved_by' => $applied_st->approved->full_name ?? '',
                    'approvingImg' => false,
                    'loadingdownloadpdf' => false,
//                    'menual_form_number' =>  $applied_st->menual_form_number ?? '',
                    'site_can_approve_student' =>  $applied_st->site_can_approve_student,
                    //'applied_student' => $applied_st,
                    'student_qua_info' => $applied_st->siteStudentAdmissionEducationQualification,
                ];
            });

         //   dd($student_list);


            return Response::json($student_list, 200);

//        } catch (ModelNotFoundException $exception) {
//            throw new Error($exception->getMessage());
//
//        } catch (Exception $exception) {
//            throw new Error($exception->getMessage());
//        }
    }



    public function activeateStudentFromAdmissionApplied(Request $request)
    {

        $studentCheckList = $this->appliedStudent
            ->where('id', $request->id)
            ->first();


        $studentCheckList->status = 1;
        $studentCheckList->save();


        return Response::json(['message' => 'Student Activate Successfully!', 'mode' => 'Active!']);

    }


    public function pauseStudentFromAdmissionApplied(Request $request)
    {


        $studentCheckList = $this->appliedStudent
            ->where('id', $request->id)
            ->first();


        $studentCheckList->status = 0;
        $studentCheckList->save();


        return Response::json(['message' => 'Student Pause Successfully!', 'mode' => 'Pause!']);
    }

    public function deleteStudentFromAdmissionApplied(Request $request)
    {

        $studentCheckList = $this->appliedStudent
            ->where('id', $request->site_student_admission_application_id)
            ->first();


        if ($studentCheckList->student_image != 'image-not.png') {
            $image_path = "uploads/" . $studentCheckList->student_image;  // Value is not URL but directory file path
            if (File::exists($image_path)) {
                File::delete($image_path);
            }

        }

        $studentCheckList->delete();

        return Response::json(['message' => 'Student Delete Successfully!', 'mode' => 'Delete!']);
    }





    public function downloadSingleStudentAdmissionFormPdf(Request $request){

        $date_formate = Carbon::today();
        $today = $date_formate->format('Y-m-d');

        $site_list = SiteInfo::where('id',  Session::get('SITE_ID'))->first();


        $student_list = SiteStudentAdmissionApplication::with(['siteStudentAdmissionEducationQualification' => function ($query) {
            $query->with(['examination', 'academicBoard', 'academicSession']);
        },
            'presentCountry', 'presentDivision', 'presentDistrict', 'presentThana',
            'permanentCountry', 'permanentDivision', 'permanentDistrict', 'permanentThana',
            'religion', 'gender', 'bloodGroup', 'relation',

            'year', 'shift', 'department', 'stClass', 'classGroup', 'session','fatherOccupation','motherOccupation'])
            ->where('id', $request->id)
            ->where('status', true)
            ->first();


        $getDeclaredList = $this->getDeclaredList();

        $language_set = $getDeclaredList->admission_form_language;

        \Log::info($student_list);

        $roll_number = sprintf("%0" . $getDeclaredList->auto_roll_digit . "d", $student_list->student_roll_number);


        $subject_arr = $this->studentSelectedSubject($student_list);

        $general_subject_list = $subject_arr[0];
        $compulsory_subject_list = $subject_arr[1];
        $optional_subject_list = $subject_arr[2];

      //  dd($subject_arr[1]);



        $emp_designation = Employee::where('institute_head', true)->where('site_id', Session::get('SITE_ID'))->pluck('designation_id');
        $designation_list = Designation::whereIn('id', $emp_designation)->first();
        $designation_name = $designation_list->name ?? '';

        $term_condition = $getDeclaredList->term_condition;


        $viewType = 'Dashboard';
        $report_tittle = 'Admission Form';
        $report_tittle2 = '';

        $file_name_combination = $student_list->unique_code;

        $view = View::make('default.admin.site.admission.admission-form-details-pdf',
            compact('viewType', 'student_list', 'getDeclaredList', 'term_condition', 'report_tittle', 'report_tittle2', 'general_subject_list',
                'compulsory_subject_list', 'optional_subject_list', 'designation_name', 'site_list', 'language_set',
                'roll_number'));

        $contents = $view->render();

        $path = storage_path() . '/pdf';

        $mpdf = new \Mpdf\Mpdf();
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;
        $mpdf->allow_charset_conversion = false;
        $mpdf->WriteHTML($contents);
        $time = $file_name_combination . '-' . Carbon::now()->unix();
        $mpdf->Output($path . '/' . $time . '.pdf', 'F');
        $time = $file_name_combination . '-' . Carbon::now()->unix();
        //$mpdf->Output($time . '.pdf', 'D');

        $name = $time . '.pdf';


        return Response::json(['link' => route('web-open-pdf-file', [$name]), 'message' => 'Successfully Created Report'], 200);

    }
    


    private function getDeclaredList()
    {
        $registration_declare_list = SiteStudentAdmissionDeclare::
            where('status', true)
            ->first();

        return $registration_declare_list;
    }



    private function studentSelectedSubject($student_list)
    {

        $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', ['onlyforexam', 'forclassandexam'])
            ->pluck('id');

        $academic_class_group_ids=$student_list['academic_class_group_id'];
      //  dd($academic_class_group_ids);
       // $academic_class_group_ids=explode(',',$student_list['academic_department_id']);
        $subjectList = SubjectGroupConditionSetting::where('academic_class_id', $student_list->academic_class_id)
            ->where('academic_year_id', $student_list->academic_year_id)
            ->when(!empty($student_list['academic_department_id']), function ($query) use ($student_list) {
                return $query->where('academic_department_id', $student_list['academic_department_id']);
            })
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
        //    ->where('academic_class_group_ids', $academic_class_group_ids)
            ->where('status', true)
            ->orderBy('subject_position')
            ->get();


            //====Geleral Subject
            $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

            $general_subject_ids = [];
            foreach ($subjectList as $key => $value) {

                $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                    $general_subject_ids[$key] = $value->academic_subject_id;
                }
            }


            $general_subject_list = $subjectList->whereIn('academic_subject_id', $general_subject_ids)
                ->values();

        //====Compulsory Subject

        $compulsory_subject_ids = [];
        $sielective_compulsory_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $subjectCompulsoryCondition = SubjectCondition::where('condition_key', 'compulsory')->first();
            $subjectSelectiveCompulsoryCondition = SubjectCondition::where('condition_key', 'selectiveCompulsory')->first();

            if (in_array($subjectCompulsoryCondition->id, $academicCompulsorySubjectConditionIds)) {
                $compulsory_subject_ids[$key] = $value->academic_subject_id;
            }
            if (in_array($subjectSelectiveCompulsoryCondition->id, $academicCompulsorySubjectConditionIds)) {
                $sielective_compulsory_subject_ids[$key] = $value->academic_subject_id;
            }

        }
        $student_compulsory_subject_ids = ($student_list->compulsory_subject_ids)[1]?? [];
        $student_selective_compulsory_subject_ids = ($student_list->selective_compulsory_subject_ids)[1]?? [];

        $student_selective_compulsory_subject_ids = $student_list->selective_compulsory_subject_ids[1] ?? [];


        if (count($student_selective_compulsory_subject_ids) > 0) {
            $compulsory_subject_final_ids = collect(array_merge($student_compulsory_subject_ids,
                $student_selective_compulsory_subject_ids))->unique();
        } else {
            $compulsory_subject_final_ids = $student_compulsory_subject_ids;
        }

        $compulsory_subject_list = $subjectList->whereIn('academic_subject_id', $compulsory_subject_final_ids)
            ->values();

        //====Optional Subject

        $optional_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $subjectOptionalCondition = SubjectCondition::where('condition_key', 'optional')->first();

            if (in_array($subjectOptionalCondition->id, $academicOptionalSubjectConditionIds)) {
                $optional_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $student_selective_optional_subject_ids = ($student_list->optional_subject_ids)[1];


        $optional_subject_list = $subjectList->whereIn('academic_subject_id', $student_selective_optional_subject_ids)
            ->whereIn('academic_subject_id', $optional_subject_ids)
            ->values();

            return [$general_subject_list, $compulsory_subject_list, $optional_subject_list];


    }


    public function approveStudentFromAdmissionApplied(Student $student, StudentHistory $studentHistory, Request $request)
    {

      //  try {


        DB::beginTransaction();

        $applied_student = $this->appliedStudent
            ->where('id', $request->id)
            // ->where('approve_as_student', false)
            ->where('status', true)
            ->first();

        $data = $applied_student;

        $date_format = Carbon::parse($applied_student->date_of_birth);
        $date_of_birth = $date_format->format('Y-m-d');


//        $studentList = User::whereHas('translations', function ($query) use ($student_list, $data) {
//            $query->where('locale', 'en')
//                ->where('first_name', $student_list->first_name)
//                ->where('father_name', $student_list->father_name)
//                ->where('mother_name', $student_list->mother_name)
//                ->when(!empty($data[$student_list->last_name]), function ($query) use ($data) {
//                    return $query->where('last_name', $data['last_name']);
//                });
//        })->where('date_of_birth', $date_of_birth)->first();


        $getStudentSameBirthDate = $student
            ->where('date_of_birth', $date_of_birth)
            // ->select('id')
            ->get();

        $site_id = Session::get('SITE_ID');


        if (count($getStudentSameBirthDate) > 0) {

            foreach ($getStudentSameBirthDate as $key => $value) {
                //  \Log::info($value);

                $full_name_with_out_space = strtoupper(str_replace(' ', '', $value->full_name));
                $father_name_with_out_space = strtoupper(str_replace(' ', '', $value->father_name));
                $mother_name_with_out_space = strtoupper(str_replace(' ', '', $value->mother_name));


                $present_full_name_with_out_space = strtoupper(str_replace(' ', '', $applied_student->full_name));
                $present_father_name_with_out_space = strtoupper(str_replace(' ', '', $applied_student->father_name));
                $present_mother_name_with_out_space = strtoupper(str_replace(' ', '', $applied_student->mother_name));

//                    return [$full_name_with_out_space, $father_name_with_out_space, $mother_name_with_out_space,
//                    $present_full_name_with_out_space, $present_father_name_with_out_space,
//                        $present_mother_name_with_out_space];

                if ($full_name_with_out_space == $present_full_name_with_out_space &&
                    $father_name_with_out_space == $present_father_name_with_out_space &&
                    $mother_name_with_out_space == $present_mother_name_with_out_space
                ) {

                    $student_birth_date_present_array[] = 1;

                } else {
                    $student_birth_date_present_array[] = 0;
                }


            }

        } else {
            $student_birth_date_present_array[] = 0;
        }


        $student_birth_date_present_count = collect($student_birth_date_present_array)->unique()->filter();
        if (count($student_birth_date_present_count) > 0) {
            $student_birth_date_present = 1;
        } else {
            $student_birth_date_present = 0;
        }



        if ($applied_student->local_gurdian_name) {
            $check_guardian = UserForUsername::where('contact_number', $applied_student->local_gurdian_mobile)->first();

            if (!$check_guardian) {
                $guardianUsername = $this->guardianUserNameCreateUseName($applied_student);
                $guardianPassword = mt_rand(10000, 99999);

                $guardian_id = $student->create([
                    'username' => $guardianUsername,
                    'password' => $guardianPassword,
                    'user_type' => 'guardian',
                    'first_name' => $applied_student->local_guardian_name,
                    'contact_number' => $applied_student->local_gurdian_mobile,
                    'address' => $applied_student->local_gurdian_address,
                    'email' => $applied_student->local_gurdian_email,
                    'created_by' => Auth::user()->id,
                    'site_student_registration_application_id' => $request->id,
                    'status' => 1,
                ]);
                $guardianID = $guardian_id->id;

                $roleGuardian = SiteRole::where('key', 'guardian')->first();
                $guardian_id->siteRoles()->attach([$roleGuardian->id]);


            } else {
                $guardianID = $check_guardian->id;
            }

        } else {
            $guardianID = 0;

        }

        $studentUsername = $this->studentUserNameCreateUseCode($applied_student);

        $studentpassword = mt_rand(10000, 99999);
        $academicSubjectIDs = $this->academicSubjectList($applied_student);


//            return $academicSubjectIDs;

        $compulsory_subject_imploded = null;
        if ($applied_student->compulsory_subject_ids) {
            $compulsory_subject_idLists = $applied_student->compulsory_subject_ids[0];
            if (count($compulsory_subject_idLists) > 0) {
                $compulsory_subject_idList = $compulsory_subject_idLists->pluck('id');

                $compulsory_subject_collection = new Collection($compulsory_subject_idList);
                $compulsory_subject_imploded = $compulsory_subject_collection->implode(',');
            }
        }
      ///  dd($applied_student->selective_compulsory_subject_ids[0]);
        $selective_compulsory_subject_imploded = null;
        if ($applied_student->selective_compulsory_subject_ids) {
            $selective_compulsory_idLists = $applied_student->selective_compulsory_subject_ids[0];
            if (count($selective_compulsory_idLists) > 0) {
                $selective_compulsory_idLists = $selective_compulsory_idLists->pluck('id');

                $selective_compulsory_subject_collection = new Collection($selective_compulsory_idLists);
                $selective_compulsory_subject_imploded = $selective_compulsory_subject_collection->implode(',');
            }
        }



        $optional_subject_imploded = null;
        if ($applied_student->optional_subject_ids) {
            $optional_subject_idLists = $applied_student->optional_subject_ids[0];
            if (count($optional_subject_idLists) > 0) {
                $optional_subject_idList = $optional_subject_idLists->pluck('id');

                $optional_subject_collection = new Collection($optional_subject_idList);
                $optional_subject_imploded = $optional_subject_collection->implode(',');
            }
        }


        $selective_markingless_subject_imploded = null;
        if ($applied_student->selective_markingless_subject_ids) {
            $selective_markingless_subject_idLists = $applied_student->selective_markingless_subject_ids[0];
            if (count($selective_markingless_subject_idLists) > 0) {
                $selective_markingless_subject_idList = $selective_markingless_subject_idLists->pluck('id');


                $selective_markingless_subject_collection = new Collection($selective_markingless_subject_idList);
                $selective_markingless_subject_imploded = $selective_markingless_subject_collection->implode(',');
            }

        }


        if (isset($student->studentFields)) {
            foreach ($student->studentFields as $studentField) {
                if ($applied_student->{$studentField}) {

                    if (is_array($applied_student->{$studentField})) {
                        $student->{$studentField} = collect($applied_student->{$studentField})->implode(',');
//                        $student->academic_subject_ids = null;
//                        $student->optional_subject_ids = null;
//                        $student->compulsory_subject_ids = null;
//                        $student->selective_markingless_subject_ids = null;
                    } else {
                        $student->{$studentField} = $applied_student->{$studentField};

                    }
                }

            }

            $student->username = $studentUsername;
            $student->password = $studentpassword;
            $student->local_guardian_user_id = $guardianID;
            $student->contact_number = $applied_student->student_contact_number;
            $student->address = $applied_student->present_address;
            $student->user_type = 'student';
            $student->site_id = $site_id;
            $student->academic_subject_ids = $academicSubjectIDs;
            $student->status = 1;
            $student->created_by = Auth::user()->id;

            $student->site_student_registration_application_id = $request->id;

            $student->compulsory_subject_ids = $compulsory_subject_imploded;
            $student->selective_compulsory_subject_ids = $selective_compulsory_subject_imploded;
            $student->optional_subject_ids = $optional_subject_imploded;
            $student->selective_markingless_subject_ids = $selective_markingless_subject_imploded;

            $student->ex_id_card_code = $applied_student->id_card_code;
            $student->father_nid = $applied_student->father_nid;


        }


        if ($student->save()) {
            $roleStudent = SiteRole::where('key', 'student')->first();
            $student->siteRoles()->attach([$roleStudent->id]);

        }

            SiteStudentAdmissionEducationQualification::where('site_student_admission_application_id', $request->id)
                ->update([
                    'user_id'=>$student->id
                ]);


        if (isset($studentHistory)) {
            foreach ($studentHistory->ownFields as $ownField) {
                if ($applied_student->{$ownField}) {
                    if (is_array($applied_student->{$ownField})) {
                        $studentHistory->{$ownField} = collect($applied_student->{$ownField})->implode(',');
//                        $studentHistory->academic_subject_ids = null;
//                        $studentHistory->optional_subject_ids = null;
//                        $studentHistory->compulsory_subject_ids = null;
//                        $studentHistory->selective_markingless_subject_ids = null;
                    } else {
                        $studentHistory->{$ownField} = $applied_student->{$ownField};
                    }
                }
            }

//            $studentHistory->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
            $studentHistory->user_id = $student->id;
            $studentHistory->local_guardian_id = $guardianID;
            $studentHistory->previous_exam_mark = $applied_student->previous_marks;
            $studentHistory->board_roll_number = $applied_student->board_roll_number;
            $studentHistory->academic_subject_ids = $academicSubjectIDs;
            $studentHistory->status = 1;
            $studentHistory->created_by = Auth::user()->id;

            $studentHistory->site_student_registration_application_id = $request->id;

            $studentHistory->compulsory_subject_ids = $compulsory_subject_imploded;
            $studentHistory->selective_compulsory_subject_ids = $selective_compulsory_subject_imploded;

            $studentHistory->optional_subject_ids = $optional_subject_imploded;
            $studentHistory->selective_markingless_subject_ids = $selective_markingless_subject_imploded;

            $studentHistory->ex_id_card_code = $applied_student->id_card_code;
            $studentHistory->site_student_admission_application_id = $applied_student->id;

            $studentHistory->academic_student_category_id = 1;
            $studentHistory->academic_student_admission_type_id = 1;

        }

//        return $studentHistory;

        $studentHistory->save();
            $studentHistory->subjects()->sync(explode(',', $academicSubjectIDs));



        $photo = new Photo();
        $photo->name = $applied_student->student_image;
        $photo->user_id = $student->id;

        $student->photo()->save($photo);


        $the_applied_student = $this->appliedStudent
            ->where('id', $request->id)
            ->first();

        if ($the_applied_student) {

            $the_applied_student->approve_as_student = true;
            $the_applied_student->approved_at = Carbon::now()->toDateTimeString();
            $the_applied_student->approved_by = Auth::user()->id;
            $the_applied_student->save();
        }


        $message = 'Student(' . $studentUsername . ') Approved Successfully!';


        DB::commit();
        return Response::json(['message' => $message, 'applied_student' => $the_applied_student, 'mode' => 'Update!']);

        // } catch (ValidationException $exception) {
        //     DB::rollBack();
        //     return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        // } catch (Exception $exception) {
        //     DB::rollBack();

        //     return Response::json(['message' => $exception->getMessage()], 410);


        // }


    }


    private function guardianUserNameCreateUseName($student_list)
    {
        if ($student_list->local_guardian_name) {
            $Name = $student_list->local_guardian_name;
            $NameSplite = explode(' ', $Name, 3);

            if (count($NameSplite) == 1) {
                $UserName = strtolower($NameSplite[0]);

            } else {
                $UserName = strtolower($NameSplite[0] . $NameSplite[1]);
            }

            $userLength = strlen($UserName);


            $userRows = UserForUsername::whereRaw("username REGEXP '^{$UserName}([0-9]*)?$'")
                ->orderBy('username', 'desc')
                ->first();

            if ($userRows) {
                $extructData = substr($userRows->username, $userLength);
                $countValue = (int)$extructData;
                $countUser = $countValue + 1;
                $UserNameCre = "{$UserName}{$countUser}";
            } else {
                $UserNameCre = $UserName;
            }
        } else {
            $UserNameCre = null;
        }

        return $UserNameCre;
    }


    private function studentUserNameCreateUseCode($student_list)
    {

        $academicYear = AcademicYear::where('id', $student_list->academic_year_id)->first();

        $start_date = Carbon::parse($academicYear->start_date)->format('d-m-Y');
        $onlyYear = explode("-", $start_date);
        $yearSelect = $onlyYear[2];


        $yearCode = substr($yearSelect, 2, 2);

        $siteCode = sprintf("%03d", Session::get('SITE_ID'));

        $yearSiteCode = $yearCode . $siteCode;
        $yearSiteCodeLength = strlen($yearSiteCode);

        $userRows = UserForUsername::whereRaw("username REGEXP '^{$yearSiteCode}([0-9]*)?$'")
            ->orderBy('username', 'desc')
            ->first();

        if ($userRows) {
            $extructData = substr($userRows->username, $yearSiteCodeLength);
            $countValue = (int)$extructData;
            $countUser = $countValue + 1;
            $studentUserNameCre = $yearSiteCode . sprintf("%05d", $countUser);
        } else {
            $studentUserNameCre = $yearSiteCode . sprintf("%05d", 1);
        }

        return $studentUserNameCre;
    }


    private function academicSubjectList($student_list)
    {
        $data = $student_list;

        $subjectList = SubjectGroupConditionSetting::where('academic_class_id', $student_list->academic_class_id)
            ->where('academic_year_id', $student_list->academic_year_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->get();

        $general_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                $general_subject_ids[$key] = $value->academic_subject_id;
            }
        }

//        $general_markingless_subject_ids = [];
//        foreach ($subjectList as $key => $value) {
//
//            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
//
//            $markinglessSubjectCondition = SubjectCondition::where('condition_key', 'generalMarkingless')->first();
//
//            if (in_array($markinglessSubjectCondition->id, $academicSubjectConditionIds)) {
//                $general_markingless_subject_ids[$key] = $value->academic_subject_id;
//            }
//        }


        $compulsory_subject_ids = [];
        if ($student_list->academic_class_group_id) {

            foreach ($subjectList as $key => $value) {

                if ($value->academic_class_group_ids) {
                    $academicClassGroupIds = explode(',', $value->academic_class_group_ids);


                    if (in_array($student_list->academic_class_group_id, $academicClassGroupIds)) {
                        $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                        $subjectCondition = SubjectCondition::where('condition_key', 'compulsory')->first();

                        if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                            $compulsory_subject_ids[$key] = $value->academic_subject_id;
                        }
                    }
                }
            }
        }

        $compulsory_subject_idList = [];
        if ($student_list->compulsory_subject_ids) {
            $compulsory_subject_idLists = $student_list->compulsory_subject_ids[0];
            if (count($compulsory_subject_idLists) > 0) {
                $compulsory_subject_idList = $compulsory_subject_idLists->pluck('id');
            }

        }

        $selective_compulsory_subject_idList = [];
        if ($student_list->selective_compulsory_subject_ids) {
            $selective_compulsory_subject_List = $student_list->selective_compulsory_subject_ids[0];
            if (count($selective_compulsory_subject_List) > 0) {
                $selective_compulsory_subject_idList = $selective_compulsory_subject_List->pluck('id');
            }

        }



        $Optional_subject_idList = [];
        if ($student_list->optional_subject_ids) {
            $Optional_subject_idLists = $student_list->optional_subject_ids[0];
            if (count($Optional_subject_idLists) > 0) {
                $Optional_subject_idList = $Optional_subject_idLists->pluck('id');
            }


        }


        $selective_markingless_subject_idList = [];
        if ($student_list->selective_markingless_subject_ids) {
            $selective_markingless_subject_idLists = $student_list->selective_markingless_subject_ids[0];
            if (count($selective_markingless_subject_idLists) > 0) {
                $selective_markingless_subject_idList = $selective_markingless_subject_idLists->pluck('id');
            }

        }


        $religion_subject = [];
        if ($student_list->religion_subject_id) {
            $religion_subject[] = $student_list->religion_subject_id;
        }

     //  dd($Optional_subject_idList);

        $Subjects = array_merge(
            $general_subject_ids,
            $compulsory_subject_ids,
            $selective_compulsory_subject_idList?$selective_compulsory_subject_idList->toArray():$general_subject_ids,
            $Optional_subject_idList?$Optional_subject_idList->toArray():$general_subject_ids,
            $selective_markingless_subject_idList,
            $religion_subject
        );


        $academicSubjectIds = (string)implode(',', $Subjects);
        $academicSubjectIdst = array_unique(explode(',', $academicSubjectIds));

       // dd($academicSubjectIds);

        $academicSubjectIdsts = new Collection($academicSubjectIdst);
        $finalAcademicSubjectIds = $academicSubjectIdsts->implode(',');


        return $finalAcademicSubjectIds;
    }













}
