<?php

namespace App\Http\Controllers\Site\StudentPanel\Exam;

use App\Models\Edu\Issue\IssueDetail;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\Question\SiteExamStudentQuestion;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExamInvigilatorRoomSetup;
use App\Models\Site\Exam\SiteExamQuestion;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Student\Student;
use Carbon\Carbon;
use DateTime;
use DateTimeZone;
use DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\YearShiftVersionSessionSectionClassWiseSiteSettings;
use App\Models\SiteGroup\Site\Employee\Employee;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use PhpOffice\PhpSpreadsheet\Chart\Layout;
use Response;
use Exception;
use Session;
use Auth;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use PDF;
use View;

class StudentExamController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('siteStudentchecker');

    }


    public function index()
    {
        $viewType = 'Student Exam';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function examStart($id)
    {
        $viewType = 'Student Exam';
        return view('default.admin.layouts.master', compact('viewType'));
    }




    public function getExamTypeListForStudent(Request $request){


        $examination_ids=SiteExamDeclareStudentSubject::where('student_history_id', $request->student_history_id)
            ->pluck('examination_id')
            ->unique()
            ->filter();

        $examination_list=Examination::whereIn('id', $examination_ids)->get();

        return $examination_list;

    }



    public function getExamSubjectDateForStudent(Request $request){

        $exam_routine_ids=SiteExamDeclareStudentSubject::where('student_history_id', $request->student_history_id)
            ->where('examination_id', $request->examination_id)
            ->pluck('site_exam_routine_id')
            ->unique()
            ->filter();

        $routine_list=SiteExamRoutine::with(['academicExamType',
            'subjectGroupConditionSetting'=>function($query){
                $query->select('id', 'academic_subject_id');
                $query->orderBy('subject_position');
            }])
            ->whereIn('id', $exam_routine_ids)
            ->select('id', 'site_subject_group_condition_setting_id',
                'academic_exam_type_id', 'exam_start_date', 'exam_start_time', 'exam_end_time',
                'examination_id')
            ->distinct('site_subject_group_condition_setting_id')
            ->where('online_exam_status', true)
            ->orderBy('exam_start_date')
            ->get();

        return $routine_list;
    }




    private function validationCheck($request){
        $exam_routine=SiteExamRoutine::where('id', $request->site_exam_routine_id)->first();



        $exam_date= Carbon::parse($exam_routine->exam_start_date)->format('Y-m-d');
        $examDateTime = Carbon::createFromFormat('Y-m-d H:i:s', "$exam_date $exam_routine->exam_start_time");


        $today=Carbon::now();
        $onlyCurrentTodate=$today->format('Y-m-d');

        $onlyCurrentTime=$today->toTimeString();


        if($onlyCurrentTodate==$exam_date){
            if($onlyCurrentTime<$exam_routine->exam_start_time){
                $minutes = $today->diffInSeconds($examDateTime)/60;
                if($minutes>21){
                    $left_time=$minutes-20;
                    return Response::json(['message' => 'You can apply after'. ' '.ceil($left_time).' minutes.', 'mode' => 'error'], 412);
                }
            }
            else if($onlyCurrentTime>$exam_routine->exam_end_time){
                return Response::json(['message' => 'Your Apply Time is Over', 'mode' => 'error'], 412);
            }
        }
        else{
            return Response::json(['message' => 'Please select today\'s exam.' , 'mode' => 'error'], 412);
        }
    }


    public function getExamClearenceDetailForStudent(Request $request){


        $validation=$this->validationCheck($request);
        if($validation){
            return $validation;
        }



        $exam_detail=SiteExamDeclareStudentSubject::where('student_history_id', $request->student_history_id)
            ->where('examination_id', $request->examination_id)
            ->where('site_exam_routine_id', $request->site_exam_routine_id)
            ->select('id', 'online_exam_present_by_student','online_exam_start_by_teacher',
                'online_exam_start', 'online_exam_end', 'online_exam_pause', 'online_exam_apply_for_restart',
                'online_exam_restart_apply_time', 'online_exam_restart_apply_amount', 'online_exam_restart_approve', 'room_id')
            ->first();

       $exam_routine_list= SiteExamRoutine::where('id', $request->site_exam_routine_id)
           ->where('examination_id', $request->examination_id)
           ->first();





        $invigilator_list=SiteExamInvigilatorRoomSetup::with('activeEmployee', 'rooms')
            ->where('examination_id', $request->examination_id)
            ->where('exam_start_date', $exam_routine_list->exam_start_date)
            ->where('exam_start_time', $exam_routine_list->exam_start_time)
            ->where('room_id', $exam_detail->room_id)
            ->get();



        $invigilator_array=[];
        if(count($invigilator_list)>0){
            $invigilator_arr=Array();

            foreach ($invigilator_list as $key => $value) {
                $invigilator_arr['id']=$value->id;
                $invigilator_arr['full_name']=$value->activeEmployee->full_name;
                $invigilator_arr['contact_number']=$value->activeEmployee->contact_number;
                $invigilator_arr['room_name_ex']=$value->rooms->room_name_ex;

                $invigilator_array[$key]=$invigilator_arr;
            }
        }




        return response()->json(
            [
                'exam_detail'=>$exam_detail,
                'invigilator_list'=>$invigilator_array


            ]);



    }


    public function ensurePreparedForExamByStudent(Request $request){


        SiteExamDeclareStudentSubject::where('site_exam_routine_id', $request->site_exam_routine_id)
            ->where('student_history_id', $request->student_history_id)
            ->update([
                'online_exam_present_by_student'=>true,
            ]);

        $exam_detail=SiteExamDeclareStudentSubject::where('site_exam_routine_id', $request->site_exam_routine_id)
            ->where('student_history_id', $request->student_history_id)
            ->select('id', 'online_exam_present_by_student','online_exam_start_by_teacher',
                'online_exam_start', 'online_exam_end', 'online_exam_pause', 'online_exam_apply_for_restart',
                'online_exam_restart_apply_time', 'online_exam_restart_apply_amount', 'online_exam_restart_approve')
            ->first();

        return $exam_detail;

    }



    public function applyForExamRestartByStudent(Request $request){


        $check_data=SiteExamDeclareStudentSubject::where('site_exam_routine_id', $request->site_exam_routine_id)
            ->where('student_history_id', $request->student_history_id)
            ->first();

        $apply_amount=$check_data->online_exam_restart_apply_amount==0?1:$check_data->online_exam_restart_apply_amount+1;


        $check_data->online_exam_apply_for_restart=true;
        $check_data->online_exam_restart_apply_time=true;
        $check_data->online_exam_restart_approve=false;
        $check_data->online_exam_restart_apply_amount=$apply_amount;
        $check_data->save();


        $exam_detail=SiteExamDeclareStudentSubject::where('site_exam_routine_id', $request->site_exam_routine_id)
            ->where('student_history_id', $request->student_history_id)
            ->select('id', 'online_exam_present_by_student','online_exam_start_by_teacher',
                'online_exam_start', 'online_exam_end', 'online_exam_pause', 'online_exam_apply_for_restart',
                'online_exam_restart_apply_time', 'online_exam_restart_apply_amount', 'online_exam_restart_approve')
            ->first();

        return $exam_detail;

    }


    public function getQuestionListForStudent(Request $request){


        try {

            $exam_detail = SiteExamDeclareStudentSubject::with(['examination',
                'subjectGroupConditionSetting' => function ($query) {
                    $query->select('id', 'academic_subject_id');
                },
                'academicExamType'])
                ->where('id', $request->site_exam_declare_student_subject_id)
                ->select('id', 'examination_id', 'site_exam_routine_id', 'site_subject_group_condition_setting_id',
                    'academic_exam_type_id', 'subject_exam_type_mark', 'pass_mark',
                    'online_exam_present_by_student', 'online_exam_start_by_teacher',
                    'online_exam_start', 'online_exam_end', 'online_exam_pause', 'online_exam_time',
                    'online_exam_time_left', 'online_exam_apply_for_restart',
                    'online_exam_restart_apply_time', 'online_exam_restart_apply_amount', 'online_exam_restart_approve')
                ->first();


            $exam_routine_list = SiteExamRoutine::where('id', $exam_detail->site_exam_routine_id)
                ->where('examination_id', $exam_detail->examination_id)
                ->first();


            $online_result_show_status = $exam_routine_list->online_result_show_student;


            $exam_date = Carbon::parse($exam_routine_list->exam_start_date)->format('Y-m-d');
            $examDateTimeStart = Carbon::createFromFormat('Y-m-d H:i:s', "$exam_date $exam_routine_list->exam_start_time");
            $examDateTimeEnd = Carbon::createFromFormat('Y-m-d H:i:s', "$exam_date $exam_routine_list->exam_end_time");


            $today = Carbon::now();
            $onlyCurrentTodate = $today->format('Y-m-d');

            $onlyCurrentTime = $today->toTimeString();
            if($onlyCurrentTodate==$exam_date) {
                if ($onlyCurrentTime <= $exam_routine_list->exam_end_time) {


                    if ($exam_detail->online_exam_start_by_teacher && !$exam_detail->online_exam_end) {
                        $exam_detail->online_exam_start = true;
                        $exam_detail->online_exam_start_time = $today->toTimeString();

                        if ($request->exam_start_type == 'restart') {
                            $exam_detail->online_exam_apply_for_restart = false;
                            $exam_detail->online_exam_restart_approve = false;
                        }
                        $exam_detail->save();



                        $question_primary_list=SiteExamStudentQuestion::
                            where('site_exam_declare_student_subject_id', $request->site_exam_declare_student_subject_id)
                            ->first();



                        $question_list_detail = SiteExamStudentQuestion::with(['siteExamQuestion' => function ($query) {
                            $query->with(['photo']);
                        }])
                            ->where('student_history_id', $question_primary_list->student_history_id)
                            ->where('site_exam_question_declare_id', $question_primary_list->site_exam_question_declare_id)
                            ->select('id', 'site_exam_question_id', 'site_exam_question_detail_ids',
                                'site_exam_declare_id', 'site_exam_declare_student_subject_id', 'answer_ids', 'student_answer_ids')
                            ->get();



                        $question_arr = Array();
                        $question_array = [];
                        foreach ($question_list_detail as $key => $value) {

                            $question_arr['id'] = $value->id;
                            $question_arr['question'] = $value->siteExamQuestion->question;
                            $question_arr['photo'] = $value->siteExamQuestion->photo;


                            $question_arr['multiple_answer'] = count(explode(',', $value->answer_ids)) > 1 ? true : false;

                            if ($request->exam_start_type == 'start') {
                                if (count(explode(',', $value->answer_ids)) > 1) {
                                    $question_arr['student_answer_ids'] = [];
                                } else {
                                    $question_arr['student_answer_ids'] = null;
                                }


                            } else {
                                if (count(explode(',', $value->answer_ids)) > 1) {

                                    $question_arr['student_answer_ids'] = array_map('intval', explode(',', $value->student_answer_ids));
                                } else {
                                    $question_arr['student_answer_ids'] = collect(array_map('intval', explode(',', $value->student_answer_ids)))->first();
                                }


                            }


                            $option_arr = Array();
                            $option_array = [];
                            foreach ($value->site_exam_question_detail_ids[1] as $keys => $values) {

                                $option_arr['id'] = $values->id;
                                $option_arr['question_option'] = $values->option;

                                $option_array[$keys] = $option_arr;
                            }

                            $question_arr['question_option_list'] = collect($option_array)->values();
                            $question_arr['question_show'] = false;
                            $question_arr['question_show_value'] = 0;

                            $question_array[$key] = $question_arr;
                        }

                        $question_list = collect($question_array)->values();

                        $backup_second = 60;


                        $user_name = Student::where('id', \Auth::user()->id)->first();
                        //=====Log Start
                        $issue = new    IssueDetail();
                        $issue->issue_type = 'exam:student-start';

                        $issue->bearer_type = 'site';
                        $issue->bearer_id = \Session::get('SITE_ID');
                        $issue->username = $user_name->username;
                        $issue->ip_address = request()->ip();

                        if ($request->exam_start_type == 'start') {
                            $issue->issue_details = " Student Start the exam ";
                        } else {

                            $issue->issue_details = " Student Restart the exam or Refresh the browser ";
                        }
                        $issue->save();

                        //=====Log End


                        return response()->json(
                            [
                                'question_list' => $question_list,
                                'exam_detail' => $exam_detail,
                                'backup_second' => $backup_second,
                                'online_result_show_status' => $online_result_show_status,


                            ]);
                    } else if ($exam_detail->online_exam_end) {
                        return Response::json(['message' => 'You Complete Your Exam.!',
                            'mode' => 'error!'], 412);
                    }


                }
                else{

                    return Response::json(['message' => 'Unexpected Entry. Your Exam Time is Over.!',
                        'mode' => 'error!'], 412);


                }
            }
            else{
                return Response::json(['message' => 'Unexpected Entry. This is not your Exam Date.!',
                    'mode' => 'error!'], 412);
            }


        }
        catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }



    }


    public function studentExamAnswerSilentSave(Request $request){


        $question_list=collect($request->QuestionList);


        SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->update([
            'online_exam_time_left'=>($request->time_left - ($request->time_left%60))/60,
        ]);


        $exam_details=SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->select('id', 'online_exam_end')
            ->first();

        if(!$exam_details->online_exam_end){

            foreach ($question_list as $key => $value) {


                $question_list_detail=SiteExamStudentQuestion::where('id', $value['id'])
                    ->first();

                if($value['multiple_answer']){


                    if($question_list_detail->student_answer_ids){


                        $present_answers=$value['student_answer_ids'];
                        $previous_answers=array_map('intval', explode(',', $question_list_detail->student_answer_ids));


                        $same_answer_check=array_diff($previous_answers, $present_answers);

//                        \Log::info($present_answers);

                        if(count($same_answer_check)>0){
                            $question_list_detail->student_answer_ids=$present_answers?collect($present_answers)->implode(','):'';
                            $question_list_detail->save();
                        }
                    }
                    else{
                        $question_list_detail->student_answer_ids=$value['student_answer_ids']?collect($value['student_answer_ids'])->implode(','):'';
                        $question_list_detail->save();
                    }


                }
                else{

                    if($question_list_detail->student_answer_ids){
                        if($question_list_detail->student_answer_ids!=$value['student_answer_ids']){

                            $question_list_detail->student_answer_ids=$value['student_answer_ids'];
                            $question_list_detail->save();

                        }
                    }
                    else{
                        $question_list_detail->student_answer_ids=$value['student_answer_ids'];
                        $question_list_detail->save();
                    }

                }

            }

        }

        $exam_condition=SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->select('id', 'online_exam_present_by_student', 'online_exam_start_by_teacher', 'online_exam_start',
                'online_exam_end', 'online_exam_pause', 'online_exam_apply_for_restart',
                'online_exam_restart_apply_time', 'online_exam_restart_apply_amount', 'online_exam_restart_approve',
                'online_exam_time_left')
            ->first();

        return response()->json(['exam_condition'=>$exam_condition]);

    }


    public function studentExamAnswerSubmit(Request $request){

        $exam_details=SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->select('id', 'online_exam_end')
            ->first();

        if(!$exam_details->online_exam_end){
            $this->studentExamAnswerSilentSave($request);

            $current_time=Carbon::now();


            $exam_detail=SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
                ->first();


            $question_list_ids=collect($request->QuestionList)->pluck('id');

            $question_list_detail=SiteExamStudentQuestion::whereIn('id', $question_list_ids)
                ->get();

            $question_ids=$question_list_detail->pluck('site_exam_question_id')->unique();

            $exam_question_all_list=SiteExamQuestion::whereIn('id', $question_ids)->get();

            $exam_question_total_number= $exam_question_all_list->sum('mark');

            $exam_obtain_mark=[];
            foreach ($question_list_detail as $key => $value) {

                $answer_check=array_diff(explode(',', $value->answer_ids), explode(',',$value->student_answer_ids));

                if(count($answer_check)==0){
                    $right_answere_marks=SiteExamQuestion::where('id', $value->site_exam_question_id)->first();
                    $exam_obtain_mark[]=$right_answere_marks->mark;
                }

            }

            $obtain_exam_marks_total=array_sum($exam_obtain_mark);

            if($exam_obtain_mark<=0){
                $obtain_final_marks=0;
            }else{
                $obtain_final_marks=($obtain_exam_marks_total * $exam_detail->subject_exam_type_mark) / $exam_question_total_number;
            }

            SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
                ->update([
                    'online_exam_end'=>true,
                    'online_exam_time_left'=>$request->online_exam_time_left,
                    'online_exam_end_time'=>$current_time->toTimeString(),
                    'obtaine_marks'=>$obtain_final_marks,
                ]);

            $user_name=Student::where('id', \Auth::user()->id)->first();

            //=====Log Start
            $issue = new    IssueDetail();
            $issue->issue_type = 'exam:student-end';
            $issue->issue_details = " Student End the exam ";
            $issue->bearer_type = 'site';
            $issue->bearer_id = \Session::get('SITE_ID');
            $issue->username = $user_name->username;
            $issue->ip_address = request()->ip();
            $issue->save();

            //=====Log End

            return response()->json(
                [
                    'obtain_exam_marks_total'=>$obtain_exam_marks_total,
                    'exam_question_total_number'=>$exam_question_total_number,

                    'obtain_final_marks'=>$obtain_final_marks,
                ]);

            return Response::json(['message' => 'Save Successfully!', 'mode' => 'save'], 200);
        }
        else{
            return Response::json(['message' => 'Exam Complete!', 'mode' => 'error'], 412);
        }

    }

    //     public function studentExamDetailForAdmitCard2(Request $request)
    // {

    //     $data = $request->all();

    //     $exam_declare_ids = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
    //         ->where('academic_year_id', $request->academic_year_id)
    //         ->where('academic_class_id', $request->academic_class_id)
    //         ->where('examination_id', $request->examination_id)
    //         ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
    //             return $query->where('academic_shift_id', $data['academic_shift_id']);
    //         })
    //         ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
    //             return $query->where('academic_department_id', $data['academic_department_id']);
    //         })
    //         ->where('status', true)
    //         ->pluck('id');

    //     //   dd($exam_declare_ids);

    //     $student_ids = SiteExamDeclareStudent::whereIn('site_exam_declare_id', $exam_declare_ids)
    //         ->where('status', true)
    //         ->pluck('student_history_id')
    //         ->unique()
    //         ->values();



    //     $student_list = StudentHistory::whereIn('id', $student_ids)
    //         ->where('academic_year_id', $request->academic_year_id)
    //         ->where('academic_shift_id', $request->academic_shift_id)
    //         ->where('academic_class_id', $request->academic_class_id)
    //         // ->where('student_roll_number', '>=', $request->roll_from)
    //         // ->where('student_roll_number', '<=', $request->roll_to)
    //         ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
    //             return $query->where('academic_department_id', $data['academic_department_id']);
    //         })
    //         ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
    //             return $query->where('academic_class_group_id', $data['academic_class_group_id']);
    //         })
    //         ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
    //             return $query->where('academic_section_id', $data['academic_section_id']);
    //         })
    //         ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
    //             return $query->where('academic_session_id', $data['academic_session_id']);
    //         })
    //         ->orderBy('student_roll_number')
    //         ->orderBy('academic_section_id')
    //         ->orderBy('academic_department_id')
    //         ->orderBy('academic_class_id')
    //         ->orderBy('academic_class_group_id')
    //         ->get();
    //     // ->pluck('id')
    //     // ->values();

    //     $student_range_ids = $student_list->when(!empty($data['roll_from']) && !empty($data['roll_to']), function ($query) use ($data) {
    //         return $query->where('student_full_roll_number', '>=', $data['roll_from'])
    //             ->where('student_full_roll_number', '<=', $data['roll_to']);
    //     })
    //         // ->where('student_full_roll_number', '>=', $request->roll_from)
    //         // ->where('student_full_roll_number', '<=', $request->roll_to)
    //         ->pluck('id')
    //         ->values();

    //     // dd($student_range_ids);

    //     $subject_settings_ids = SubjectGroupConditionSetting::where('academic_year_id', $request->academic_year_id)
    //         ->where('academic_class_id', $request->academic_class_id)
    //         ->orderBy('subject_position')
    //         ->orderBy('subject_code')
    //         ->get()
    //         ->pluck('id')
    //         ->values();

    //     // dd($subject_settings_ids);

    //     $placeholders = implode(',', array_fill(0, count($subject_settings_ids), '?'));

    //     $student_list = StudentHistory::with(['siteExamDeclareStudentSubject' => function ($query) use ($exam_declare_ids, $placeholders, $subject_settings_ids) {
    //         $query->with(['subjectGroupConditionSetting' => function ($q) {
    //             $q->select('id', 'academic_subject_id', 'subject_code', 'subject_position');
    //             $q->orderBy('id');
    //         }]);
    //         $query->with('academicExamType', 'routine');
    //         $query->whereIn('site_exam_declare_id', $exam_declare_ids);
    //         $query->distinct('student_history_id', 'site_subject_group_condition_setting_id');
    //         $query->select('student_history_id', 'site_subject_group_condition_setting_id', 'site_exam_routine_id');
    //         $query->groupBy('student_history_id', 'site_subject_group_condition_setting_id');

    //         $query->orderByRaw("field(site_subject_group_condition_setting_id,{$placeholders})", $subject_settings_ids);
    //     }, 'siteGroupStudentExamRoll' => function ($qww) use ($request) {
    //         return $qww->where('examination_id', $request->examination_id);
    //     }])
    //         ->with([
    //             'department',
    //             'stClass',
    //             'shift',
    //             'classGroup',
    //             'section',
    //             'session',
    //             'year',
    //             'academicStudentCategory',
    //             'student' => function ($query) {
    //                 $query->with(['gender', 'religion', 'latestPhoto' => function ($query) {
    //                     $query->select('name', 'path', 'imageable_id');
    //                 }]);
    //                 $query->select('id', 'gender_id', 'religion_id', 'username');
    //             }
    //         ])
    //         ->whereIn('id', $student_range_ids)
    //         ->select(
    //             'id',
    //             'user_id',
    //             'student_roll_number',
    //             'academic_year_id',
    //             'academic_department_id',
    //             'academic_class_id',
    //             'academic_shift_id',
    //             'optional_subject_ids',
    //             'academic_student_category_id',
    //             'academic_class_group_id',
    //             'academic_section_id',
    //             'academic_session_id',
    //             'student_roll_number_prefix'
    //         )

    //         ->orderBy('student_roll_number')
    //         ->orderBy('academic_section_id')
    //         ->orderBy('academic_department_id')
    //         ->orderBy('academic_class_id')
    //         ->orderBy('academic_class_group_id')
    //         ->get();

    //     $student_list->transform(function ($student_history) {
    //         $optional_ids = $student_history->optional_subject_ids[1] ?? [];

    //         $student_history->exam_declare_subjects = $student_history->siteExamDeclareStudentSubject

    //             // Then sort them by the raw date
    //             ->sortBy(function ($subject) {
    //                 return $subject->routine->exam_start_date;
    //             })
    //             // Now map the sorted subjects
    //             ->map(function ($subject) use ($optional_ids) {
    //                 $subject_name = $subject->subjectGroupConditionSetting->subject_name ?? '';

    //                 if (in_array($subject->subjectGroupConditionSetting->academic_subject_id ?? null, $optional_ids)) {
    //                     $subject_name .= ' (4th subject)';
    //                 }

    //                 return [
    //                     'site_subject_group_condition_setting_id' => $subject->site_subject_group_condition_setting_id,
    //                     'student_history_id' => $subject->student_history_id,
    //                     'subject_name' => $subject_name ?? '',
    //                     'subject_code' => $subject->subjectGroupConditionSetting->subject_code ?? '',
    //                     'exam_date' => isset($subject->routine->exam_start_date)
    //                         ? Carbon::parse($subject->routine->exam_start_date)->format('d-M-Y')
    //                         : '',
    //                 ];
    //             })
    //             ->values() // reset the keys
    //             ->toArray();

    //         return $student_history;
    //     });

    //     return $student_list;
    // }

    private function studentExamDetailForAdmitCard($request,$student_history){


      //  $student_history=StudentHistory::where('id',$request->student_history_id)->first();
        $exam_declare_ids = SiteExamDeclares::where('academic_version_id', $student_history->academic_version_id)
            ->where('academic_year_id', $student_history->academic_year_id)
            ->where('academic_class_id', $student_history->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($student_history->academic_shift_id), function ($query) use ($student_history) {
                return $query->where('academic_shift_id', $student_history->academic_shift_id);
            })
            ->when(!empty($student_history->academic_department_id), function ($query) use ($student_history) {
                return $query->where('academic_department_id', $student_history->academic_department_id);
            })
            ->where('status', true)
            ->pluck('id');

            if(count($exam_declare_ids)>1){
                return response()->json(['message'=>'Admit Card Not found', 'status'=>'404', 'mode'=>'errors'],404); 
            }


        $subject_settings_ids=SubjectGroupConditionSetting::where('academic_year_id', $student_history->academic_year_id)
                ->where('academic_class_id', $student_history->academic_class_id)
                ->orderBy('subject_position')
                ->orderBy('subject_code')
                ->get()
                ->pluck('id')
                ->values();


        $placeholders = implode(',',array_fill(0, count($subject_settings_ids), '?'));

        $student_list=StudentHistory::with(['siteExamDeclareStudentSubject'=>function($query) use ($exam_declare_ids,$placeholders,$subject_settings_ids){
                $query->with(['subjectGroupConditionSetting'=>function($q){
                    $q->select('id', 'academic_subject_id','subject_code','subject_position');
                    $q->orderBy('id');
                    }]);
                $query->with('academicExamType', 'routine');
                $query->whereIn('site_exam_declare_id', $exam_declare_ids);
                $query->distinct('student_history_id', 'site_subject_group_condition_setting_id');
                $query->select('student_history_id', 'site_subject_group_condition_setting_id');
                $query->groupBy('student_history_id', 'site_subject_group_condition_setting_id');
                $query->orderByRaw("field(site_subject_group_condition_setting_id,{$placeholders})", $subject_settings_ids);
            },'siteGroupStudentExamRoll'=>function($qww) use ($request){
               return $qww->where('examination_id',$request->examination_id);
            }])
            ->with(['department','stClass', 'shift', 'classGroup', 'section', 'session', 'year', 'academicStudentCategory',
                'student'=>function($query){
                    $query->with(['gender', 'religion', 'latestPhoto'=>function($query){
                        $query->select('name','path','imageable_id');
                    }]);
                    $query->select('id', 'gender_id', 'religion_id');

                }])
            ->where('id', $request->student_history_id)
            ->select('id', 'user_id', 'student_roll_number', 'academic_year_id',
                'academic_department_id', 'academic_class_id', 'academic_shift_id', 'optional_subject_ids',
                'academic_student_category_id',
                'academic_class_group_id', 'academic_section_id', 'academic_session_id', 'student_roll_number_prefix')
            
                ->orderBy('student_roll_number')
                ->orderBy('academic_section_id')
                ->orderBy('academic_department_id')
                ->orderBy('academic_class_id')
                ->orderBy('academic_class_group_id')
                ->get();

        //   $student_list->transform(function ($student_history) {
        //     $optional_ids = $student_history->optional_subject_ids[1] ?? [];

        //     $student_history->exam_declare_subjects = $student_history->siteExamDeclareStudentSubject

        //         // Then sort them by the raw date
        //         ->sortBy(function ($subject) {
        //             return $subject->routine->exam_start_date;
        //         })
        //         // Now map the sorted subjects
        //         ->map(function ($subject) use ($optional_ids) {
        //             $subject_name = $subject->subjectGroupConditionSetting->subject_name ?? '';

        //             if (in_array($subject->subjectGroupConditionSetting->academic_subject_id ?? null, $optional_ids)) {
        //                 $subject_name .= ' (4th subject)';
        //             }

        //             return [
        //                 'site_subject_group_condition_setting_id' => $subject->site_subject_group_condition_setting_id,
        //                 'student_history_id' => $subject->student_history_id,
        //                 'subject_name' => $subject_name ?? '',
        //                 'subject_code' => $subject->subjectGroupConditionSetting->subject_code ?? '',
        //                 'exam_date' => isset($subject->routine->exam_start_date)
        //                     ? Carbon::parse($subject->routine->exam_start_date)->format('d-M-Y')
        //                     : '',
        //             ];
        //         })
        //         ->values() // reset the keys
        //         ->toArray();

        //     return $student_history;
        // });

               // dd($student_list[0]->siteExamDeclareStudentSubject);

           return $student_list;


    }

    
    private function checkSiteClassSettings($request,$student_history){
        
        $data=$request->all();

        $admitSettings=YearShiftVersionSessionSectionClassWiseSiteSettings::where('academic_year_id', $student_history->academic_year_id)
            ->where('academic_shift_id', $student_history->academic_year_id)
            ->where('academic_class_id',$student_history->academic_year_id)
            ->first();

        return $admitSettings;
    }

    private function checkStudentPayment($request,$student_history){

      
        $examinationExamTypeCheck=SiteExaminationExamTypeSetting::
            where('academic_year_id', $student_history->academic_year_id)
             ->where('academic_class_id', $student_history->academic_class_id)
             ->where('examination_id', $request->examination_id)
            ->when(!empty($student_history->academic_department_id), function ($query) use ($student_history) {
                return $query->where('academic_department_id', $student_history->academic_department_id);
            })
            ->first();

      //  dd($examinationExamTypeCheck,$student_history);

        if(!$examinationExamTypeCheck){
              return ['mode'=>'errors', 'status'=>false]; 
        }

       // dd($examinationExamTypeCheck->admit_card_permission_with_due_payment);

        if($examinationExamTypeCheck->admit_card_permission_with_due_payment){ //admit_card_permission_with_due_payment
            $demand_slip = SiteStudentFeeDemandSlipDetails::where('student_history_id', $student_history->id)
                ->where('status', 1)
                ->get();

            if(count($demand_slip)>0){
                return ['mode'=>'success', 'status'=>true]; 
            }
        }

        return ['mode'=>'success', 'status'=>false]; 

    }
    
    public function studentExamDetailForAdmitCardPdfFroApi(Request $request){
        try{



        if(!$request->student_history_id || !$request->examination_id){
            return response()->json(['message'=>'Paramitter Missing', 'status'=>'422', 'mode'=>'errors', 422]); 
        }
    
        ini_set('memory_limit', '-1');

        $auth= Auth::user();
        $academic_group_id=$auth->academic_group_id;
        $site_id=$auth->site_id;

        Session::put('SITE_ID',$site_id);
        Session::put('ACADEMIC_GROUP_ID',$academic_group_id);

        $page_tittle = "Admit Card";
        $report_tittle = "<b>Admit Card</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Admit Card";

        $req_data=[
            'is_image_show'=>true,
            'is_subject_show'=>true,
            'is_description_show'=>true,
            'is_exam_date_show'=>false,
            'is_terms_and_condition_show'=>false,
        ];


        $student_history=StudentHistory::findOrFail($request->student_history_id);

       $checkPayment=$this->checkStudentPayment($request,$student_history);
       //  dd($checkPayment);
       if($checkPayment['mode']=='errors'){
            return Response::json(['message'=>'Admit card not found!'],410);
       }

       if($checkPayment['status']==true){
            return Response::json(['message'=>'You must make the remaining payment first.'],410);
       }

        $student_list=$this->studentExamDetailForAdmitCard($request,$student_history);

        $examination=Examination::where('id', $request->examination_id)->first();
        $examination_name=$examination->examination_name;

        $year=AcademicYear::where('id', $student_history->academic_year_id)->first();
        $year_name=$year->year_name;

        //description 
        $institute_head = Employee::where('institute_head', 1)->first();
        $signature = $institute_head->signature ?? '/img/signature/signature.png';
  
       // $data=$request->all();
        
        $admitSettings=$this->checkSiteClassSettings($request,$student_history);
       
        $admit_card_description=$admitSettings?$admitSettings->admit_card_description:"";

        $view = View::make('default.admin.site.exam.report.exam-admit-card-pdf',
            compact('student_list', 'examination_name', 'examination','year_name', 'report_tittle',
                'page_tittle', 'report_tittle2', 'admit_card_description', 'title_view','req_data','signature'));

            $contents = $view->render();

            $path = storage_path() . '/pdf';
    
            $mpdf = new \Mpdf\Mpdf();
            $mpdf->autoScriptToLang = true;
            $mpdf->autoLangToFont = true;
            $mpdf->allow_charset_conversion = false;
            $mpdf->WriteHTML($contents);
          //  $time = 'admission-form-'.$site_list->site_alias.'-'.$file_name_combination . '-' . Carbon::now()->unix();
            $time = \Auth::user()->id . '-' . Carbon::now()->unix();
            $mpdf->Output($path . '/' . $time . '.pdf', 'F');
            $name = $time . '.pdf';
    
            return Response::json(['link' => route('open-pdf-file-storage-for-public', [$name]),
                'message' => 'Successfully Created Card Report'], 200);
       
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
     
    }



}
