<?php

namespace App\Http\Controllers\Site\StudentPanel\Result;

use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Student\StudentHistory;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Result\SiteExamResultReportSetting;
use PDF;
use Response;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPermission;
use App\Traits\Site\Result\ExamResultTrait;
use Session;

class StudentExamResultController extends Controller
{

    use ExamResultTrait;

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('siteStudentchecker');

    }


    public function index()
    {
        $viewType = 'Student Exam Result';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function siteStudentAllHistoryList(){

        $student_detail=StudentHistory::where('user_id', \Auth::user()->id)
                ->with(['department','stClass', 'shift', 'classGroup', 'section', 'session'])
                ->select('id', 'user_id', 'student_roll_number', 'academic_department_id', 'academic_class_id', 'academic_shift_id',
                    'academic_class_group_id', 'academic_section_id', 'academic_session_id')
                ->get();

        return $student_detail;
    }



    public function getPrimaryResultListForStudent(Request $request){

        $data = $request->all();
        $data['site_id']=Session::get('SITE_ID');
        $data['academic_group_id']=Session::get('ACADEMIC_GROUP_ID');

        $studentHistory=StudentHistory::where('id', $data['student_history_id'])
            ->select('academic_version_id', 'academic_year_id', 'academic_shift_id', 'academic_class_id',
                'academic_section_id', 'academic_class_group_id', 'academic_session_id', 'site_batch_detail_id',
                'academic_group_id')
            ->first();

        $checkGroupPermission=GlobalSiteGroupResultPermission::where('academic_year_id',$studentHistory->academic_year_id)
            ->where('academic_class_id',$studentHistory->academic_class_id)
            ->where('site_id',$data['site_id'])
            ->where('academic_group_id',$data['academic_group_id'])
            ->where('student_result_permission_status', true)
            ->pluck('academic_result_primary_type_id');

        $primary_exam_type_ids = SiteStudentPrimaryResultDetail::where('student_history_id', $request->student_history_id)
            ->where(function ($query) use ($checkGroupPermission) {
                $query->where(function ($q) {
                    $q->where('result_generated_by', 'site')
                    ->where('result_student_publish_status', true);
                })->orWhere(function ($q) use ($checkGroupPermission) {
                    $q->where('result_generated_by', 'site_group')
                    ->whereIn('academic_result_primary_type_id', $checkGroupPermission);
                });
            })
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->filter();

        $result_primary_type_list=AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)->where('use_key', 'site')->get();


        return $result_primary_type_list;

    }


    public function getPrimaryResultTypeResultDetailForStudent(Request $request){

        $student_detail=StudentHistory::where('id', $request->student_history_id)->first();
        
        $checkGroupPermission=GlobalSiteGroupResultPermission::where('academic_year_id',$student_detail->academic_year_id)
            ->where('academic_class_id',$student_detail->academic_class_id)
            ->where('site_id',$student_detail->site_id)
            ->where('academic_group_id',$student_detail->academic_group_id)
            ->where('student_result_permission_status', true)
            ->pluck('academic_result_primary_type_id');
             

        $dataaa=SiteStudentPrimaryResultDetail::with(['studentHistory'=>function ($query) {
            $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
                'academic_session_id', 'academic_student_category_id', 'board_registration_number',
                'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number',
                'registration_no');
            $query->with(['student' => function ($q) {
                $q->with('latestPhoto');
                $q->select('id');
                $q->where('user_type', 'student');
            },
                'year', 'shift','department','stClass','classGroup','session','section'
            ]);
        }, 'academicResultPrimaryType'])
            ->where('student_history_id',$request->student_history_id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
             ->where(function ($query) use ($checkGroupPermission) {
                $query->where(function ($q) {
                    $q->where('result_generated_by', 'site')
                    ->where('result_student_publish_status', true);
                })->orWhere(function ($q) use ($checkGroupPermission) {
                    $q->where('result_generated_by', 'site_group')
                    ->whereIn('academic_result_primary_type_id', $checkGroupPermission);
                });
            })
            ->get();

      

        $a_arr=Array();
        $a_array=[];
        foreach ($dataaa as $key => $value){

            $b_array=[];
            foreach ($value->site_individual_combine_subject_result_store_ids as $keyt => $valuet){
                $b_array[]=$valuet->subject_detail;
            }

            $result_show_in_table_bellow_status_present=collect($b_array)->pluck('result_show_in_table_bellow_status')->unique()->filter();


            $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
        //    $a_arr['student_history_id']=$value->student_history_id;
            $a_arr['fail_subject_count']=$value->fail_subject_count;
            $a_arr['gpa']=$value->gpa;
            $a_arr['grade']=$value->grade;
            $a_arr['student_rank']=$value->student_rank;
            $a_arr['site_result_primary_setting_id']=$value->site_result_primary_setting_id;
            $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
            $a_arr['subject_list']=$b_array;
            $a_arr['table_header']=$value->table_header;
            $a_arr['student_history']=$value->studentHistory;

            $a_arr['student_photo']=$value->studentHistory->student->latestPhoto?
                $value->studentHistory->student->latestPhoto->name:'image-not.png';

            $a_arr['result_show_in_table_bellow_status_present']=count($result_show_in_table_bellow_status_present)>0?1:0;


            $a_arr['classtest_is_present']=$value->classtest_is_present;
            $a_arr['combine_subject_present']=$value->combine_subject_present;
        //    $a_arr['final_grade_without_optional']=$value->final_grade_without_optional;
        //    $a_arr['final_point_without_optional']=$value->final_point_without_optional;
            $a_arr['id']=$value->id;
        //    $a_arr['raw_obtain_marks_percentage']=number_format((float)$value->raw_obtain_marks_percentage, 2, '.', '');
        //    $a_arr['sum_of_obtain_percent_total_marks']=$value->sum_of_obtain_percent_total_marks;
        //    $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
        //    $a_arr['sum_of_raw_total_marks']=$value->sum_of_raw_total_marks;
        //    $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
        //    $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;

//            optional_subject_ids


            $a_array[$key]=array_merge($a_arr);

        }

        return $a_array;
    }


    public function getPrimaryResultTypeResultDetailForStudentPdf(Request $request){

         $data=[];
        $data=$request->all();
        $data['site_id']=Session::get('SITE_ID');
        $student_history_ids=[$data['student_history_id']];

        
        $studentHistory=StudentHistory::with('site')
            ->where('id', $data['student_history_id'])
        //    ->where('status',true)
            ->orderBy('id','DESC')
            ->first();
        
        $data['academic_version_id']=$studentHistory->academic_version_id;
        $data['academic_year_id']=$studentHistory->academic_year_id;
        $data['academic_shift_id']=$studentHistory->academic_shift_id;
        $data['academic_class_id']=$studentHistory->academic_class_id;
        $data['academic_section_id']=$studentHistory->academic_section_id;
        $data['academic_class_group_id']=$studentHistory->academic_class_group_id;
        $data['academic_session_id']=$studentHistory->academic_session_id;
        $data['site_batch_detail_id']=$studentHistory->site_batch_detail_id;
        $data['academic_group_id']=$studentHistory->academic_group_id;

        $resultPdf=$this->studentResulDetailsPdf($data,$student_history_ids,'site_student');

          if($resultPdf['status']==200){
            return Response::json([
                'link' => route('open-pdf-file-storage-for-public', [$resultPdf['file_name']]),
                'message' => 'Successfully Created Card Report',
                'status'=> $resultPdf['status']
            ],200);
        }else{
            return Response::json([
                'message' => 'Failed to Create Card Report',
                'status'=> $resultPdf['status']
            ],422);
        }
    
    }

}
