<?php

namespace App\Http\Controllers\Site\StudentPanel;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Examinations\Examination;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use App\Traits\Site\Payment\PaymentGatewayTrait;
use App\Traits\TransactionCheckApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\SiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Traits\Site\Fee\StudentFeeTrait;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Storage;
use Session;
use Response;
use File;
use Error;
use PDF;

class StudentPaymentDetailsController extends ProjectController
{
    use StudentFeeTrait;

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('siteStudentchecker');
        
    }




    public function index()
    {

      //  dd('sfsf');
        $viewType = 'Student Payment';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function studentPaymentList(Request $request){

        $user=Auth::user();
        $site_id=Session::get('SITE_ID');
        $pres_student_history_ids=GlobalStudentHistory::where('user_id',$user->id)->where('site_id',$site_id)->where('status',true)->pluck('id');
        $prev_student_history_ids=GlobalStudentHistory::where('user_id',$user->id)->where('site_id',$site_id)->where('status',false)->pluck('id');
      
        $prev_class_slip_ids=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id',$prev_student_history_ids)->where('status',false)->pluck('id');

        $prev_class_slip_due_ids=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id',$prev_student_history_ids)
            ->where('previous_academic_class_due_status',true)
            ->whereIn('due_transfer_to_promoted_student_history_id',$pres_student_history_ids)
            ->where('status',false)
            ->pluck('id');
       
        $class_slip_ids=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id',$pres_student_history_ids)->pluck('id');
        $all_slip_ids = $prev_class_slip_ids
            ->merge($class_slip_ids)
            ->merge($prev_class_slip_due_ids)
            ->unique()
            ->values();

        $slipList = GlobalSiteStudentFeeDemandSlipDetails::whereIn('id', $all_slip_ids)
                ->orderBy('id', 'desc')
                ->get();
        $student_history_ids=$pres_student_history_ids
            ->merge($class_slip_ids)
            ->merge($prev_class_slip_ids)
            ->unique()
            ->values();

        $payment_list_array=[];
        $key=0;
        foreach($slipList as $slip){
            if($slip->status){
               $slip_details=$this->getStudentFeeDetails($slip,$student_history_ids);

                $payment_list_array[$key]['slip_id']=$slip->id;
                $payment_list_array[$key]['class_name']=$slip->studentHistory->stClass->class_name;
                $payment_list_array[$key]['payment_status']='due';
                $payment_list_array[$key]['voucher_no']='';
                $payment_list_array[$key]['amount']=$slip_details['total_due_amount'];
                $payment_list_array[$key]['created_date']=$slip->created_date;
                $payment_list_array[$key]['payment_date']='';
                $payment_list_array[$key]['payment_time']='';
                $payment_list_array[$key]['payment_by']='';
                $payment_list_array[$key]['transaction_id']='';
                $payment_list_array[$key]['fee_details']=$slip_details;
                $payment_list_array[$key]['payment_history_id']='';
                $payment_list_array[$key]['bank_voucher_link']=null;

                $key++;
            }

            $checkPaymentList=GlobalSiteStudentFeePaymentHistory::with('paymentGateway')->where('site_student_fee_demand_slip_details_id',$slip->id)->get();
            foreach($checkPaymentList as $payment){

                $api_response=json_decode($payment->sonali_pay_api_response_details,true);

              //  dd($api_response);

                $payment_details=$this->getStudentFeeDetails($slip,$student_history_ids);

                $payment_by=$payment->paid_by?$payment->paid_by:$payment->created_by;

                $payment_list_array[$key]['payment_status']='paid';
                $payment_list_array[$key]['class_name']=$slip->studentHistory->stClass->class_name;

                $payment_list_array[$key]['voucher_no']=$payment->voucher_no;
                $payment_list_array[$key]['slip_id']=$slip->id;
                $payment_list_array[$key]['amount']=$payment->paid_amount;
                $payment_list_array[$key]['created_date']=$slip->created_date;
                $payment_list_array[$key]['payment_date']=$payment->payment_date;
                $payment_list_array[$key]['payment_time']=$payment->payment_time;
                $payment_list_array[$key]['payment_by']=$payment_by;
                $payment_list_array[$key]['transaction_id']=$payment->transaction_id;
                $payment_list_array[$key]['fee_details']=$payment_details;
                $payment_list_array[$key]['payment_history_id']=$payment->id;
                $payment_list_array[$key]['bank_voucher_link']=$api_response?$api_response['SonaliVoucherLink']:null;

                $key++;
            }
                
            
        }

        return $payment_list_array;

    }


  
    public function paymentDemandSlipDetails()
    {
//        return 'ok';
        $student_id = Auth::user()->id;
        $studentHistoryIDList=StudentHistory::where('user_id',$student_id)->where('status',true)->pluck('id');
        $demanSlipDetails = GlobalSiteStudentFeeDemandSlipDetails::where(function ($query) use ($studentHistoryIDList) {
                $query->whereIn('student_history_id', $studentHistoryIDList)
                    ->orWhereIn('due_transfer_to_promoted_student_history_id', $studentHistoryIDList);
                })
                ->where('status', 1)
                ->orderBy('id', 'desc')
                ->first();
     
          //  dd($demanSlipDetails);
        if(!$demanSlipDetails){
            return response()->json(['message'=>'Slip Not found', 'status'=>'404', 'mode'=>'errors'],404); 
        }

        $data = $this->getDemandSlipDetails($demanSlipDetails);

        if ($data){
            return $data;
        }else{
            throw new Error('There is no payable amount!');
        }
    }

    public function studentPaymentBankSlipPdf($voucher_no){
        $student_id = Auth::user()->id;
        $student_history_ids=StudentHistory::where('user_id',$student_id)->pluck('id');
        $check_payment = GlobalSiteStudentFeePaymentHistory::where('voucher_no',$voucher_no)
            ->whereIn('student_history_id',$student_history_ids)
            ->first();

        
        if(!$check_payment){
            return 'Data Not found'; 
        }

        $payment_details = $this->paymentSlipData($voucher_no);

        if($payment_details['status']!=200){
            return $payment_details['message'];
        }

        $payment_data=$payment_details['payment_data'];
        $student_info=$payment_details['student_info'];

        $report_tittle ='Student Fee Voucher';
        $report_tittle2  ='';
        $title_view='Student Fee Voucher';

        $siteInfo=SiteInfo::where('id', Session::get('SITE_ID'))
                ->select('id','web_student_fee_collection_status','show_subhead_in_payment_slip')
                ->first();
                
        $slip_key='student';
        
        $pdf = PDF::loadView('default.admin.site.student-fee.report.student-payment-voucher-pdf',
            compact('title_view','report_tittle','report_tittle2','payment_data','student_info','siteInfo','slip_key'));

        return $pdf->stream(time() . '-student-payment-slip.pdf');

    }

  
}

