<?php

namespace App\Http\Controllers\Site;

use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\SubjectCondition;
use App\Models\Academic\AcademicExamType;

use App\Models\AcademicYear\AcademicYear;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Exam\SiteSubjectExaminationExamTypeMark;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\Exam\SiteExamDeclares;

use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\SubjectGroupConditionSetting\SiteSubjectConditionLimit;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\Academic\AcademicClass;
use App\Models\Site\SiteInfo;
use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use Illuminate\Support\Facades\Log;
use Response;
use Session;
use DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Carbon;
use JsonSchema\Exception\ValidationException;
use PhpParser\Error;



class SubjectGroupConditionSettingController extends ProjectController
{

    use Lang, FormControll, DataHelper;


    private $siteInfo, $academicClass, $academicSubject, $subjectCondition, $academicClassGroup,
        $subjectGroupConditionSetting, $academicYear, $siteSubjectExaminationMark, $siteSubjectExaminationExamTypeMark;

    /**
     * @param AcademicSubject $academicSubject
     */


    public function __construct(SiteInfo $siteInfo, AcademicClass $academicClass, AcademicYear $academicYear,
                                AcademicSubject $academicSubject, SubjectCondition $subjectCondition,
                                AcademicClassGroup $academicClassGroup, SubjectGroupConditionSetting $subjectGroupConditionSetting,
                                SiteSubjectExaminationMark $siteSubjectExaminationMark,
                                SiteSubjectExaminationExamTypeMark $siteSubjectExaminationExamTypeMark)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->siteInfo = $siteInfo;
        $this->academicYear = $academicYear;
        $this->academicClass = $academicClass;
        $this->academicSubject = $academicSubject;
        $this->subjectCondition = $subjectCondition;
        $this->academicClassGroup = $academicClassGroup;
        $this->subjectGroupConditionSetting = $subjectGroupConditionSetting;
        $this->siteSubjectExaminationMark = $siteSubjectExaminationMark;
        $this->siteSubjectExaminationExamTypeMark = $siteSubjectExaminationExamTypeMark;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $viewType = 'Subject Group Condition Setting List';
        return view('default.admin.layouts.master', compact('viewType'));

        return view('default.admin.subject-group-condition-setting.create', compact('viewType'));
    }

    public function getSubjectGroupConditionSettingList()
    {
        $subGroConSett = $this->subjectGroupConditionSetting->with(['academicClass', 'academicSubject'])->orderBy('academic_class_id', 'DESC')->get();
        return $subGroConSett;
    }

    public function getSiteInfo(SiteInfo $siteInfo)
    {

        $siteInfo = $siteInfo->where('id', session()->get(SITE_ID))->with();
        return $siteInfo;
    }

    public function getYearDepartmentClassList()
    {


        $site_info_setting = SiteInfoSetting::first();
        if ($site_info_setting) {

        }

        $academicDepartmentList = [];
        $academicClassList = [];
        $academicYearList = null;


        $academic_year_ids = explode(',', $site_info_setting->academic_year_ids) ?? null;
        $academicYearList = $this->academicYear
            ->select('id', 'year_name')
            ->whereIn('id', $academic_year_ids)
            ->orderBy('id','DESC')
            ->get();

        if ($site_info_setting->academic_department_ids) {
            $academicDepartment = explode(',', $site_info_setting->academic_department_ids) ?? null;
            $academicDepartmentList = AcademicDepartment::select('id', 'name as department_name')
                ->whereIn('id', $academicDepartment)->get();
        } else {
            $academicClass = explode(',', $site_info_setting->academic_class_ids) ?? null;
            $academicClassList = AcademicClass::select('id', 'class_name')
                ->whereIn('id', $academicClass)
                ->orderBy('serial_no', 'ASC')
                ->get();
               // dd($academicClass);
        }

        return [$academicClassList, $academicDepartmentList, $academicYearList];

    }



    public function getSubjectsBasedOnSubjectClassExamCondition(Request $request)
    {
        try {



            $year_id = $request->academic_year_id == 'null' ? 0 : $request->academic_year_id;
            $department_id = $request->academic_department_id == 'null' ? 0 : $request->academic_department_id;
            $class_id = $request->academic_class_id == 'null' ? 0 : $request->academic_class_id;
            $class_exam_condition_keys = $request->class_exam_condition_keys ?? [];

            if (!$class_id || !$year_id) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }

            $sub_gr_cond_sett = SubjectGroupConditionSetting::with(['academicClass', 'academicSubject'])
                ->where('academic_class_id', $class_id)
                ->where('academic_year_id', $year_id)
                ->whereHas('academicSubjectClassExamCondition', function ($q)use($class_exam_condition_keys) {
                    $q->whereIn('name_key', $class_exam_condition_keys);
                })
                ->when($department_id, function ($query) use ($department_id) {
                    return $query->where('academic_department_id', $department_id);
                })->get();


            $subject_id_array = $sub_gr_cond_sett->pluck('academic_subject_id');
            $subjects = $this->academicSubject
                ->whereIn('academic_subjects.id', $subject_id_array)
                ->orderByTranslation('subject_name', 'ASC')
                ->get();

          //  dd($sub_gr_cond_sett);

            return response()->json($subjects, 200);


        } catch (Exception $exception) {
            return $exception->getMessage();

        }
    }

    public function getSiteDepartmentClassBaseExaminationList(Request $request){

        $data = $request->all();

            $examinationAll = SiteExaminationExamTypeSetting::
              where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('examination_id')
            ->unique();



        $examination_list=Examination::whereIn('id', $examinationAll)->where('use_key','site')->get();


        return $examination_list;
    }


    public function getSubjectList($class_id, $department_id, $year_id)
    {
//        return (int)session()->get('ACADEMIC_GROUP_ID');
        try {

            $department_id = $department_id == 'null' ? null : $department_id;
            $year_id = $year_id == 'null' ? null : $year_id;
            $class_id = $class_id == 'null' ? null : $class_id;


            if (!$class_id || !$year_id) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }

            $sGroupCondSettings = SubjectGroupConditionSetting::with(['academicClass', 'academicSubject'])
                ->where('academic_class_id', $class_id)
                ->where('academic_year_id', $year_id)
                ->when($department_id, function ($query) use ($department_id) {
                    return $query->where('academic_department_id', $department_id);
                })
                ->where('status', true)
                ->orderBy('subject_position', 'asc')
                ->get();

            $sGroupLi=SiteShiftClassGroupSectionSetting::where('academic_class_id', $class_id)
                ->where('academic_year_id', $year_id)
                ->when(!empty($department_id), function ($query) use ($department_id) {
                    return $query->where('academic_department_id', $department_id);
                })
//                ->where('status', true)
                ->distinct('academic_class_group_id')
                ->pluck('academic_class_group_id');

            //   return count($sGroupCondSettings);

            $final = [];
            if (count($sGroupCondSettings)) {

                $editMode = true;
                //=======================================================================
                //for getting subject from site_info table

                $siteInfos = SiteInfoSetting::first();
                $subjectIds = $siteInfos->academic_subject_ids ?? null;
                $subjectIdsArray = explode(',', $subjectIds) ?? [];
                //=========================================================================

                $accClass = AcademicClass::with(['subjects' => function ($query) use ($subjectIdsArray, $department_id) {
                        $query->whereIn('academic_subjects.id', $subjectIdsArray);
                    }])->findOrFail($class_id);//academic_subject_condition_ids



                $subject_list_for_dependance=$accClass->subjects;

                $subCon = $this->subjectCondition->whereIn('id', explode(',', $siteInfos->academic_subject_condition_ids ?? null))->get();

                $acGr = $this->academicClassGroup->whereIn('id', $sGroupLi)->get();
             
                $subject_class_exam_list = AcademicSubjectClassExamCondition::
                    whereIn('id', explode(',', $siteInfos->academic_subject_class_exam_condition_ids ?? null))
                    ->get();

                foreach ($accClass->subjects as $k => $value) {

                    $subjectArr = Array();
                    $subjectConditionArr = Array();
                    $mergedSubjectCondition = [];
                    $subjectGroupArr = Array();
                    $subjectGroupGroup = [];
                    $sub_id = $value->id;
                    $subjectClassExamArr=Array();
                    $subjectClassExamArray=[];
                    $sub = SubjectGroupConditionSetting::whereAcademicSubjectId($sub_id)
                        ->where('academic_class_id', $class_id)
                        ->where('academic_year_id', $year_id)
                        ->when($department_id, function ($query) use ($department_id) {
                            return $query->where('academic_department_id', $department_id);
                        })
                        ->where('status', true)
                        ->first();

                    $subjectArr['checked'] = $sub ? true : false;
                    $subjectArr['subject_code'] = $sub->subject_code ?? "";

                    foreach ($subCon as $keyCond => $condition) {
                        $dd = in_array($condition->id, explode(',', $sub->academic_subject_condition_ids ?? null));
                        $subjectConditionArr['checked'] = $dd;
                        $mergedSubjectCondition[$keyCond] = array_merge($subjectConditionArr, $condition->toArray());
                    }

                    if ($accClass->academic_group_present == 1) {

                        foreach ($acGr as $key => $group) {

                            $isFound = in_array($group->id, explode(',', $sub->academic_class_group_ids ?? null));
                            $subjectGroupArr['checked'] = $isFound;
                            $subjectGroupGroup[$key] = array_merge($subjectGroupArr, $group->toArray());

                        }
                    }


                    $mergedSubject = array_merge($subjectArr, $value->toArray());

                    $final[$k] = $mergedSubject;
                    $final[$k]['subCon'] = $mergedSubjectCondition;
                    $final[$k]['acGr'] = $subjectGroupGroup;
                    $final[$k]['subjectClassExamList'] = $subject_class_exam_list;
                    $final[$k]['checkedRadio'] = $sub['academic_subject_class_exam_condition_id'] ?? null;
                    $final[$k]['result_show_in_table_bellow'] = $sub['result_show_in_table_bellow']?? false;
                    $final[$k]['exam_type_wise_result_create'] = $sub['exam_type_wise_result_create']?? false;
                    $final[$k]['subject_position'] = $sub['subject_position'] ?? 0;

                    $final[$k]['exam_dependent_academic_subject_id'] =$sub['exam_dependent_academic_subject_id']??$sub_id;
                 //   Log::info($final[$k]['subjectClassExamList']);

                }


            } else {


                $editMode = false;
                //=======================================================================
                //for getting subject from site_info table
                $siteInfos = SiteInfoSetting::first();
                $subjectIds = $siteInfos->academic_subject_ids ?? null;
                $subjectIdsArray = explode(',', $subjectIds) ?? [];
                $subjects = $this->academicSubject->whereIn('id', $subjectIdsArray)->get();
                //=========================================================================

                $accClass = AcademicClass::with(['subjects' => function ($query) use ($subjectIdsArray, $department_id) {
                    $query->whereIn('academic_subjects.id', $subjectIdsArray);
//                    if ($department_id) {
//                        $query->where('academic_class_academic_subject.academic_department_id', $department_id);
//                    }
                }])->findOrFail($class_id);

                $subCon = $this->subjectCondition
                    ->whereIn('id', explode(',', $siteInfos->academic_subject_condition_ids ?? null))
                    ->get();

//                $subCon = $this->subjectCondition->all();
                $subject_list_for_dependance=$accClass->subjects;

                $acGr =  $this->academicClassGroup->whereIn('id', $sGroupLi)->get();

                $subject_class_exam_list = AcademicSubjectClassExamCondition::
                whereIn('id', explode(',', $siteInfos->academic_subject_class_exam_condition_ids ?? null))
                    ->get();

                foreach ($accClass->subjects as $k => $value) {
                    $subjectArr = Array();
                    $subjectConditionArr = Array();
                    $mergedSubjectCondition = [];
                    $subjectGroupArr = Array();
                    $subjectGroupGroup = [];
                    $sub_id = $value->id;
                    $sub = '';
                    $subjectArr['checked'] = false;
                    $subjectArr['status'] = "1";
                    $subjectArr['subject_code'] = "";

                    $subjectClassExamArr=Array();
                    $subjectClassExamArray=[];

                    foreach ($subCon as $keyCond => $condition) {
                        $dd = in_array($condition->id, explode(',', $sub->academic_subject_condition_ids ?? null));
                        $subjectConditionArr['checked'] = $dd;
                        $mergedSubjectCondition[$keyCond] = array_merge($subjectConditionArr, $condition->toArray());
                    }


                    if ($accClass->academic_group_present == 1) {
                        foreach ($acGr as $key => $group) {
                            $isFound = in_array($group->id, explode(',', $sub->academic_class_group_ids ?? null));
                            $subjectGroupArr['checked'] = $isFound;
                            $subjectGroupGroup[$key] = array_merge($subjectGroupArr, $group->toArray());
                        }
                    }

//                    foreach ($subject_class_exam_list as $key => $val) {
//                        if($val->id== $sub['academic_subject_class_exam_condition_id']){
//                            $subjectClassExamArr['checked'] =  $sub['academic_subject_class_exam_condition_id'];
//                        }else{
//                            $subjectClassExamArr['checked'] = 0;
//                        }
//
//                        $subjectClassExamArray[$key] = array_merge($subjectClassExamArr, $val->toArray());
//                    }


                    $mergedSubject = array_merge($subjectArr, $value->toArray());
                    $final[$k] = $mergedSubject;
                    $final[$k]['subCon'] = $mergedSubjectCondition;
                    $final[$k]['acGr'] = $subjectGroupGroup;
                    $final[$k]['subjectClassExamList'] = $subject_class_exam_list;
                    $final[$k]['result_show_in_table_bellow'] = false;
                    $final[$k]['exam_type_wise_result_create'] = false;
                    $final[$k]['subject_position'] = 0;
                    $final[$k]['checkedRadio'] = 0;

                    $final[$k]['exam_dependent_academic_subject_id'] =$sub_id;
//                    Log::info($subjectClassExamArray);
                }

            }

         //   return $final;

            $examlist=SiteExaminationExamTypeSetting::with(['academicExamType', 'examination'])
                ->where('academic_class_id', $class_id)
                ->where('academic_year_id', $year_id)
                ->when($department_id, function ($query) use ($department_id) {
                    return $query->where('academic_department_id', $department_id);
                })
                ->where('direct_result_input', false)
                ->where('status', true)
                ->get();
            $examid=$examlist->pluck('examination_id');
            $examinationList=Examination::whereIn('id',$examid)
//                ->where('status', true)
                ->get();


            $examinationexamArray=[];
            if(count($examlist)>0){


                $examinationexamArr=Array();
                foreach ($examinationList as $key => $value) {

                    $examtypeArr=Array();
                    $examTypeArray=[];
                    $countindex=0;
                    foreach ($examlist as $keys => $values) {

                        if($value->id==$values->examination_id){
                            $examtypeArr['academic_exam_type_id']=$values->academic_exam_type_id;
                            $examtypeArr['exam_type_name']=$values->academicExamType->marks_type;
                            $examtypeArr['select_exam_type_id']=false;
                            $examtypeArr['exam_type_marks']=0;
                            $examtypeArr['exam_type_pass_marks']=0;

                            $examTypeArray[$countindex]=array_merge($examtypeArr);
                            $countindex++;
                        }
                    }
                    $examinationexamArr['exam_type_list']=$examTypeArray;
                    $examinationexamArr['examination_name']=$value->examination_name;
                    $examinationexamArr['select_examination_id']=false;
                    $examinationexamArr['examination_marks']=null;
                    $examinationexamArr['examination_pass_marks']=null;
                    $examinationexamArr['id']=$value->id;

                    $examinationexamArray[$key]=array_merge($examinationexamArr);
                }
            }

            $examTestArr=Array();
            $examTestArray=[];
            foreach ($final as $key => $value) {

                $examTestArr['examination_exam_type_list']=$examinationexamArray;

                $examTestArray[$key]=array_merge($value, $examTestArr);
            }

            $subjectWithMarks = SubjectGroupConditionSetting::with(['siteSubjectExaminationMark.siteSubjectExaminationExamTypeMark',])
                ->where('academic_class_id', $class_id)
                ->where('academic_year_id', $year_id)
                ->when($department_id, function ($query) use ($department_id) {
                    return $query->where('academic_department_id', $department_id);
                })
                ->where('status', true)
                ->get();

            foreach ($examTestArray as $key=>&$value) {

                $checkSubject=$subjectWithMarks->where('academic_subject_id', $value['id'])->first();
                    foreach ($value['examination_exam_type_list'] as $keys=>&$values) {
                        $checkExamination=0;
                        if($checkSubject && count($checkSubject->siteSubjectExaminationMark)>0){
                            $checkExamination=$checkSubject->siteSubjectExaminationMark
                                ->where('examination_id', $values['id'])
                                ->where('status', true)
                                ->first();
                        }

                        if($checkExamination){

                            $value['examination_exam_type_list'][$keys]['select_examination_id']=true;
                            $value['examination_exam_type_list'][$keys]['examination_marks']=$checkExamination->marks;
                            $value['examination_exam_type_list'][$keys]['examination_pass_marks']=$checkExamination->pass_marks;


                            foreach ($values['exam_type_list'] as $keyt=>&$valuet) {


                                $checkExamType=$checkExamination->siteSubjectExaminationExamTypeMark
                                    ->where('academic_exam_type_id', $valuet['academic_exam_type_id'])
                                    ->where('status', true)
                                    ->first();

                                if($checkExamType){
                                    $values['exam_type_list'][$keyt]['select_exam_type_id']=true;
                                    $values['exam_type_list'][$keyt]['exam_type_marks']=$checkExamType->marks;
                                    $values['exam_type_list'][$keyt]['exam_type_pass_marks']=$checkExamType->pass_marks;


                                }
//                                else{
//
//                                    $values['exam_type_list'][$keyt]['select_exam_type_id']=false;
//                                    $values['exam_type_list'][$keyt]['exam_type_marks']=0;
//                                    $values['exam_type_list'][$keyt]['exam_type_pass_marks']=0;
//                                }


                            }


                        }

                    }

            }

    //    dd($examTestArray);

            return [$examTestArray, $editMode, $sGroupCondSettings, $subject_list_for_dependance];
       } catch (Exception $exception) {
           return $exception->getMessage();

       }
    }


    public function getActiveSubjectListByYearDepartmentClass($year_id, $department_id, $class_id)
    {
//        return 'ok';
        try {

            $department_id = $department_id == 'null' ? 0 : $department_id;
            $year_id = $year_id == 'null' ? 0 : $year_id;
            $class_id = $class_id == 'null' ? 0 : $class_id;

            $sGroupCondSettings = SubjectGroupConditionSetting::with(['academicClass', 'academicSubject'])
                ->where('academic_class_id', $class_id)
                ->where('academic_year_id', $year_id)
                ->when($department_id, function ($query) use ($department_id) {
                    return $query->where('academic_department_id', $department_id);
                })
                ->get();
            $subject_id_array=$sGroupCondSettings->pluck('academic_subject_id');
            $subjects = $this->academicSubject->whereIn('id',$subject_id_array)->get();

             //  dd($subjects);

            return [$subjects];
        } catch (Exception $exception) {
            return $exception->getMessage();

        }
    }



    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return JsonResponse
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'academic_class_id' => 'required',
        ]);

        $class_id = $request->academic_class_id;
        $department_id = $request->academic_department_id;
        $year_id = $request->academic_year_id;
        $subjects = $request->finalSubjectListArr;
        $edit_mode = $request->editMode ? 'Updated' : 'Saved';
        $unchecked_subject_ids = [];
        $checked_subject_names = [];
        $unchecked_exam_ids = [];
        $unchecked_exam_type_ids=[];


        if (count($subjects) > 0) {
            foreach ($subjects as $key => $val) {
                if ($val['checked']) {//if the subject is checked

                    $this->subjectGroupConditionSetting = new SubjectGroupConditionSetting();

                    $checked_subject_names[] = $val['subject_name'];
                    $subject_id = $val['id'];
                    $status = $val['checked'];
                    $subject_code = $val['subject_code'];
                    $subConditionIds = [];
                    $subGroupIds = [];

                //subject Conditions
                    if (count($val['subCon']) > 0) {
                        $condArr = [];
                        foreach ($val['subCon'] as $conKey => $condVal) {
                            if ($condVal['checked']) {
                                $condArr[] = $condVal['id'];
                            }
                        }
                        $subConditionIds = implode(",", $condArr);;
                    }
                    //subject Groups
                    $subGroupIds = null;
                    if (count($val['acGr']) > 0) {
                        $grArr = [];
                        foreach ($val['acGr'] as $conKey => $condVal) {
                            if ($condVal['checked']) {
                                $grArr[] = $condVal['id'];
                            }
                        }
                        $subGroupIds = implode(",", $grArr);
                    }


                    //academic_subject_class_exam_condition_id
//                    $subjectClassExamIds = null;
//                    if (count($val['subjectClassExamList']) > 0) {
//                        $clArr = [];
//                        foreach ($val['subjectClassExamList'] as $conKey => $condVal) {
//                            if ($condVal['checked']) {
//                                $clArr[] = $condVal['id'];
//                            }
//                        }
//                        $subjectClassExamIds = implode(",", $clArr);
//                    }


                    $subjectAndClassExist = SubjectGroupConditionSetting::where('academic_subject_id', $subject_id)
                        ->where('academic_class_id', $class_id)
                        ->where('academic_year_id', $year_id)
                        ->when($department_id, function ($query) use ($department_id) {
                            return $query->where('academic_department_id', $department_id);
                        })
                        ->first();


                    if ($subjectAndClassExist) {
                        $SubjectGroupConditionSettingID=$subjectAndClassExist->id;

                        $subjectAndClassExist->update([
                            'academic_subject_condition_ids' => $subConditionIds,
                            'academic_class_group_ids' => $subGroupIds,
                            'academic_subject_class_exam_condition_id' => $val['checkedRadio'],
                            'exam_dependent_academic_subject_id' => $val['exam_dependent_academic_subject_id'],
                            'subject_position' => $val['subject_position']??0,
                            'result_show_in_table_bellow' => $val['result_show_in_table_bellow']??false,
                            'exam_type_wise_result_create' => $val['exam_type_wise_result_create']??false,
                            'subject_code' => $subject_code,
                            'status' => true
                        ]);

                    } else {


                        $this->subjectGroupConditionSetting->academic_class_id = $class_id;
                        $this->subjectGroupConditionSetting->academic_year_id = $year_id;
                        $this->subjectGroupConditionSetting->academic_department_id = $department_id;
                        $this->subjectGroupConditionSetting->academic_subject_id = $subject_id;
                        $this->subjectGroupConditionSetting->academic_subject_condition_ids = $subConditionIds;
                        $this->subjectGroupConditionSetting->academic_class_group_ids = $subGroupIds;
                        $this->subjectGroupConditionSetting->academic_subject_class_exam_condition_id = $val['checkedRadio'];
                        $this->subjectGroupConditionSetting->exam_dependent_academic_subject_id = $val['exam_dependent_academic_subject_id'];
                        $this->subjectGroupConditionSetting->subject_code = $subject_code;

                        $this->subjectGroupConditionSetting->subject_position = $val['subject_position']??0;
                        $this->subjectGroupConditionSetting->result_show_in_table_bellow = $val['result_show_in_table_bellow']?? false;
                        $this->subjectGroupConditionSetting->exam_type_wise_result_create = $val['exam_type_wise_result_create']?? false;

                        $this->subjectGroupConditionSetting->status = true;
                        $this->subjectGroupConditionSetting->save();

                        $SubjectGroupConditionSettingID=$this->subjectGroupConditionSetting->id;

//                        Log::info($this->subjectGroupConditionSetting);

                    }

                    foreach ($val['examination_exam_type_list'] as $keys => $values) {

                        if($values['select_examination_id']){

                            $this->siteSubjectExaminationMark= new $this->siteSubjectExaminationMark;


                            $examExist = $this->siteSubjectExaminationMark->where('examination_id', $values['id'])
                                ->where('site_subject_group_condition_setting_id', $SubjectGroupConditionSettingID)
                                ->first();

                            if($examExist){
                                $examExist->update([
                                    'marks' => $values['examination_marks'],
                                    'pass_marks' => $values['examination_pass_marks'],
                                    'status' => true,
                                ]);

                                $siteSubjectExaminationMarkId=$examExist->id;
                            }else{
                                $this->siteSubjectExaminationMark->site_subject_group_condition_setting_id=$SubjectGroupConditionSettingID;
                                $this->siteSubjectExaminationMark->examination_id=$values['id'];
                                $this->siteSubjectExaminationMark->marks=$values['examination_marks'];
                                $this->siteSubjectExaminationMark->status=true;
                                $this->siteSubjectExaminationMark->pass_marks=$values['examination_pass_marks']?$values['examination_pass_marks']:0;
                                $this->siteSubjectExaminationMark->save();

                                $siteSubjectExaminationMarkId=$this->siteSubjectExaminationMark->id;

                            }

                            foreach ($values['exam_type_list'] as $keyl => $valuel) {

                                $this->siteSubjectExaminationExamTypeMark=new $this->siteSubjectExaminationExamTypeMark;

                                if($valuel['select_exam_type_id']){


                                    $examTypeExist = $this->siteSubjectExaminationExamTypeMark
                                        ->where('academic_exam_type_id', $valuel['academic_exam_type_id'])
                                        ->where('site_subject_examination_mark_id', $siteSubjectExaminationMarkId)
                                        ->first();

                                    if($examTypeExist){
                                        $examTypeExist->update([
                                            'marks' => $valuel['exam_type_marks'],
                                            'status' => true,
                                            'pass_marks' => $valuel['exam_type_pass_marks'],
                                        ]);
                                    }else{
                                        $this->siteSubjectExaminationExamTypeMark->site_subject_examination_mark_id=$siteSubjectExaminationMarkId;
                                        $this->siteSubjectExaminationExamTypeMark->academic_exam_type_id=$valuel['academic_exam_type_id'];
                                        $this->siteSubjectExaminationExamTypeMark->marks=$valuel['exam_type_marks'];
                                        $this->siteSubjectExaminationExamTypeMark->status=true;
                                        $this->siteSubjectExaminationExamTypeMark->pass_marks=$valuel['exam_type_pass_marks']?$valuel['exam_type_pass_marks']:0;
                                        $this->siteSubjectExaminationExamTypeMark->save();
                                    }


                                }
                                else{
                                    $examTypeExists = $this->siteSubjectExaminationExamTypeMark
                                        ->where('academic_exam_type_id', $valuel['academic_exam_type_id'])
                                        ->where('site_subject_examination_mark_id', $siteSubjectExaminationMarkId)
                                        ->first();
                                    if($examTypeExists){
                                        $examTypeExists->update(['status'=>false]);
                                    }

                                }

                            }
                        }
                        else{
                            $examExists = $this->siteSubjectExaminationMark->where('examination_id', $values['id'])
                                ->where('site_subject_group_condition_setting_id', $SubjectGroupConditionSettingID)
                                ->first();

                            if($examExists){
                                $this->siteSubjectExaminationExamTypeMark
                                    ->where('site_subject_examination_mark_id', $examExists->id)
                                    ->delete();
                                $examExists->update(['status'=>false]);
                            }

                        }

                    }


                } else {//if the subject is unchecked
                    $unchecked_subject_ids[] = $val['id'];
                }
            }
            SubjectGroupConditionSetting::whereIn('academic_subject_id', $unchecked_subject_ids)
                ->where('academic_class_id', $class_id)
                ->where('academic_year_id', $year_id)
                ->when($department_id, function ($query) use ($department_id) {
                    return $query->where('academic_department_id', $department_id);
                })
                ->update(['status'=>false]);

            $subject_names = implode(',', $checked_subject_names);

            return Response::json(['message' => $subject_names . ' ' . $edit_mode . ' Successfully!']);
        }

    }



    //==================Subject Limit===============

    public function getSiteGroupSectionBaseSubjectLimit(Request $request){

        $data = $request->all();

        $check_group_present=SiteShiftClassGroupSectionSetting::where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('academic_class_group_id')
            ->unique()
            ->filter();

        $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', ['onlyforexam', 'forclassandexam'])
            ->pluck('id');


        $get_subject_condition=SubjectGroupConditionSetting::with(['academicSubject'])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
            ->select('id','academic_subject_condition_ids', 'academic_class_group_ids', 'academic_subject_id')
//            ->where('academic_class_group_ids', '!=', '')
            ->get();

        $present_limit_data=SiteSubjectConditionLimit::where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->get();



        $sub_con_list=Array();
        $sub_condition_array=[];
        $count=0;
        foreach ($get_subject_condition as $key => $value) {

            if($value->academic_subject_condition_ids){


                foreach ($value->academic_subject_conditions as $keys => $values) {

                    if($values->condition_key=='optional' || $values->condition_key=='selectiveCompulsory' ||
                        $values->condition_key=='selectiveMarkingless'){


                        if(count($value->academic_class_groups)>0){
                            foreach ($value->academic_class_groups as $keyst => $valuest) {
                                $sub_con_list['condition_id']=$values->id;
                                $sub_con_list['condition_key']=$values->condition_key;
                                $sub_con_list['name']=$values->name;
                                $sub_con_list['group_name']=$valuest->group_name;
                                $sub_con_list['group_id']=$valuest->id;

                                $sub_con_list['id']=$value->id;
                                $sub_con_list['subject_name']=$value->subject_name;
                                $sub_con_list['academic_subject_id']=$value->academic_subject_id;

                                $sub_condition_array[$count]=$sub_con_list;
                                $count++;
//                                continue;
                            }
                        }
                        else{
                            $sub_con_list['condition_id']=$values->id;
                            $sub_con_list['condition_key']=$values->condition_key;
                            $sub_con_list['name']=$values->name;
                            $sub_con_list['group_name']=null;
                            $sub_con_list['group_id']=null;

                            $sub_con_list['id']=$value->id;
                            $sub_con_list['subject_name']=$value->subject_name;
                            $sub_con_list['academic_subject_id']=$value->academic_subject_id;

                            $sub_condition_array[$count]=$sub_con_list;
                            $count++;
//                            continue;
                        }




                    }
                    else{
                        $sub_con_list['condition_id']=0;
                        $sub_con_list['condition_key']=null;
                        $sub_con_list['name']=null;
                        $sub_con_list['group_name']=null;
                        $sub_con_list['group_id']=null;

                        $sub_con_list['id']=$value->id;
                        $sub_con_list['subject_name']=$value->subject_name;
                        $sub_con_list['academic_subject_id']=$value->academic_subject_id;

                        $sub_condition_array[$count]=$sub_con_list;
                        $count++;
//                        continue;
                    }

                }
            }
            else{
                $sub_con_list['condition_id']=0;
                $sub_con_list['condition_key']=null;
                $sub_con_list['name']=null;
                $sub_con_list['group_name']=null;
                $sub_con_list['group_id']=null;

                $sub_con_list['id']=$value->id;
                $sub_con_list['subject_name']=$value->subject_name;
                $sub_con_list['academic_subject_id']=$value->academic_subject_id;

                $sub_condition_array[$count]=$sub_con_list;
                $count++;
//                continue;
            }

        }


        $condition_group_list=collect($sub_condition_array)->where('condition_key', '!=', null);
        $academic_subject_condition=$this->subjectCondition->get();


        $condition_arr=Array();
        $condition_array=[];

        if(count($check_group_present)>0){

            foreach ($check_group_present as $key => $value) {

                $check_sub=$condition_group_list->where('group_id', $value)->values();


                if(count($check_sub)>0){
                    $first_data=$check_sub->first();


                    $condition_arr['id']=$value;
                    $condition_arr['group_name']=$first_data['group_name'];



                    $present_optional_limit=$present_limit_data
                        ->where('academic_class_group_id', $value)
                        ->whereIn('academic_subject_condition_id', $academic_subject_condition
                        ->where('condition_key', 'optional')->pluck('id'))
                        ->first();


                    $check_optional=$check_sub->where('condition_key', 'optional')->values();
                    if(count($check_optional)>0){
                        $condition_arr['optional_sub_limit']=$present_optional_limit?$present_optional_limit->limit_amount:1;
                        $condition_arr['select_optional_subject']=$present_optional_limit?
                            array_map('intval', explode(',', $present_optional_limit->not_show_academic_subject_ids)):[];
                        $condition_arr['optional_subject_list']=$check_optional;

                    }else{
                        $condition_arr['optional_sub_limit']=null;
                        $condition_arr['select_optional_subject']=[];
                        $condition_arr['subject_list']=[];
                    }



                    $present_compulsory_limit=$present_limit_data
                            ->where('academic_class_group_id', $value)
                        ->whereIn('academic_subject_condition_id', $academic_subject_condition
                        ->where('condition_key', 'selectiveCompulsory')->pluck('id'))
                        ->first();

                    $check_compulsory=$check_sub->where('condition_key', 'selectiveCompulsory')->values();
                    if(count($check_compulsory)>0){
                        $condition_arr['conpulsory_sub_limit']=$present_compulsory_limit?$present_compulsory_limit->limit_amount:1;
                        $condition_arr['compulsory_subject_list']=$check_compulsory;
                        $condition_arr['select_compulsory_subject']=$present_compulsory_limit?
                            array_map('intval', explode(',', $present_compulsory_limit->not_show_academic_subject_ids)):[];
                    }else{
                        $condition_arr['conpulsory_sub_limit']=null;
                        $condition_arr['compulsory_subject_list']=[];
                        $condition_arr['select_compulsory_subject']=[];
                    }

                    $present_markingless_limit=$present_limit_data
                        ->where('academic_class_group_id', $value)
                        ->whereIn('academic_subject_condition_id', $academic_subject_condition
                            ->where('condition_key', 'selectiveMarkingless')->pluck('id'))
                        ->first();

                    $check_markingless=$check_sub->where('condition_key', 'selectiveMarkingless')->values();
                    if(count($check_markingless)>0){
                        $condition_arr['markingless_sub_limit']=$present_markingless_limit?$present_markingless_limit->limit_amount:1;
                        $condition_arr['markingless_subject_list']=$check_markingless;
                        $condition_arr['select_markingless_subject']=$present_markingless_limit?
                            array_map('intval', explode(',', $present_markingless_limit->not_show_academic_subject_ids)):[];
                    }else{
                        $condition_arr['markingless_sub_limit']=null;
                        $condition_arr['markingless_subject_list']=[];
                        $condition_arr['select_markingless_subject']=[];
                    }

                    $condition_array[$key]=$condition_arr;

                }

            }
        }
        else{

            $check_sub=$condition_group_list->values();
            $subjct_list=AcademicSubject::whereIn('id', $check_sub->pluck('academic_subject_id')->unique())->get();

            $condition_arr['id']=0;
            $condition_arr['group_name']=null;

            $present_optional_limit=$present_limit_data
                ->whereIn('academic_subject_condition_id', $academic_subject_condition
                    ->where('condition_key', 'optional')->pluck('id'))
                ->first();

            $check_optional=$check_sub->where('condition_key', 'optional')->values();
            if(count($check_optional)>0){
                $condition_arr['optional_sub_limit']=$present_optional_limit?$present_optional_limit->limit_amount:1;
                $condition_arr['select_optional_subject']=$present_optional_limit?
                    array_map('intval', explode(',', $present_optional_limit->not_show_academic_subject_ids)):[];
                $condition_arr['optional_subject_list']=$check_optional;
            }else{
                $condition_arr['optional_sub_limit']=null;
                $condition_arr['select_optional_subject']=[];
                $condition_arr['subject_list']=[];
            }

            $present_compulsory_limit=$present_limit_data
                ->where('academic_class_group_id', $value)
                ->whereIn('academic_subject_condition_id', $academic_subject_condition
                    ->where('condition_key', 'selectiveCompulsory')->pluck('id'))
                ->first();

            $check_compulsory=$check_sub->where('condition_key', 'selectiveCompulsory')->values();
            if(count($check_compulsory)>0){

                $condition_arr['conpulsory_sub_limit']=$present_compulsory_limit?$present_compulsory_limit->limit_amount:1;
                $condition_arr['compulsory_subject_list']=$check_compulsory;
                $condition_arr['select_compulsory_subject']=$present_compulsory_limit?
                    array_map('intval', explode(',', $present_compulsory_limit->not_show_academic_subject_ids)):[];
            }else{
                $condition_arr['conpulsory_sub_limit']=null;
                $condition_arr['compulsory_subject_list']=[];
                $condition_arr['select_compulsory_subject']=[];
            }

            $present_markingless_limit=$present_limit_data
                ->where('academic_class_group_id', $value)
                ->whereIn('academic_subject_condition_id', $academic_subject_condition
                    ->where('condition_key', 'selectiveMarkingless')->pluck('id'))
                ->first();

            $check_markingless=$check_sub->where('condition_key', 'selectiveMarkingless')->values();
            if(count($check_markingless)>0){

                $condition_arr['markingless_sub_limit']=$present_markingless_limit?$present_markingless_limit->limit_amount:1;
                $condition_arr['markingless_subject_list']=$check_markingless;
                $condition_arr['select_markingless_subject']=$present_markingless_limit?
                    array_map('intval', explode(',', $present_markingless_limit->not_show_academic_subject_ids)):[];

            }else{
                $condition_arr['markingless_sub_limit']=null;
                $condition_arr['markingless_subject_list']=[];
                $condition_arr['select_markingless_subject']=[];
            }

            $condition_array[]=$condition_arr;

        }

        return response()->json(['subject_condition_array'=>$condition_array]);

    }



    public function createSubjectConditionLimit(Request $request){


        $data = $request->all();

        $checkSiteSubjectConditionList=SiteSubjectConditionLimit::where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
//            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
//                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//            })
            ->get();


        $present_limit_ids=$checkSiteSubjectConditionList->pluck('id');



        $condition_present_list=collect($request->condition_limit_list);

        $created=[];
        $present_limit_ids_array=[];

        foreach ($condition_present_list as $key => $value) {


            $group_base_limit_list=$checkSiteSubjectConditionList
                ->when(!empty($value['id']), function ($query) use ($value) {
                    return $query->where('academic_class_group_id', $value['id']);
                });


            $not_show_subject_list_optional=null;
            if(count($value['optional_subject_list'])>0){
                $not_show_subject_list_optional= $value['select_optional_subject'];


                $academic_subject_condition_list=collect($value['optional_subject_list'])
                    ->first();

                if($group_base_limit_list){
                    $check_present_data=$group_base_limit_list
                        ->where('academic_subject_condition_id', $academic_subject_condition_list['condition_id'])
                        ->first();

                    if($check_present_data){

                        $present_limit_ids_array[]=$check_present_data->id;

                        $check_present_data->limit_amount=$value['optional_sub_limit'];
                        $check_present_data->not_show_academic_subject_ids=collect($not_show_subject_list_optional)->implode(',');

                        $check_present_data->save();
                    }
                    else{
                        $created[] = [
                            'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                            'academic_year_id' => $request->academic_year_id,
                            'academic_class_id' => $request->academic_class_id,
                            'academic_department_id' => $request->academic_department_id,
                            'academic_class_group_id' => $value['id']?$value['id']:null,
                            'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                            'limit_amount' =>$value['optional_sub_limit'],
                            'not_show_academic_subject_ids' => collect($not_show_subject_list_optional)->implode(','),
                            'status' => true,
                            'site_id' => Session::get('SITE_ID'),

                        ];
                    }
                }
                else{
                    $created[] = [
                        'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                        'academic_year_id' => $request->academic_year_id,
                        'academic_class_id' => $request->academic_class_id,
                        'academic_department_id' => $request->academic_department_id,
                        'academic_class_group_id' => $value['id']?$value['id']:null,
                        'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                        'limit_amount' =>$value['optional_sub_limit'],
                        'not_show_academic_subject_ids' => collect($not_show_subject_list_optional)->implode(','),
                        'status' => true,
                        'site_id' => Session::get('SITE_ID'),

                    ];
                }






            }


            $not_show_subject_list_compulsory=null;
            if(count($value['compulsory_subject_list'])>0){

                $not_show_subject_list_compulsory=$value['select_compulsory_subject'];

                $academic_subject_condition_list=collect($value['compulsory_subject_list'])
                    ->first();


                if($group_base_limit_list){
                    $check_present_data=$group_base_limit_list
                        ->where('academic_subject_condition_id', $academic_subject_condition_list['condition_id'])
                        ->first();

                    if($check_present_data){

                        $present_limit_ids_array[]=$check_present_data->id;

                        $check_present_data->limit_amount=$value['conpulsory_sub_limit'];
                        $check_present_data->not_show_academic_subject_ids=collect($not_show_subject_list_compulsory)->implode(',');

                        $check_present_data->save();
                    }
                    else{
                        $created[] = [
                            'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                            'academic_year_id' => $request->academic_year_id,
                            'academic_class_id' => $request->academic_class_id,
                            'academic_department_id' => $request->academic_department_id,
                            'academic_class_group_id' => $value['id']?$value['id']:null,
                            'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                            'limit_amount' =>$value['conpulsory_sub_limit'],
                            'not_show_academic_subject_ids' => collect($not_show_subject_list_compulsory)->implode(','),
                            'status' => true,
                            'site_id' => Session::get('SITE_ID'),

                        ];
                    }
                }
                else{
                    $created[] = [
                        'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                        'academic_year_id' => $request->academic_year_id,
                        'academic_class_id' => $request->academic_class_id,
                        'academic_department_id' => $request->academic_department_id,
                        'academic_class_group_id' => $value['id']?$value['id']:null,
                        'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                        'limit_amount' =>$value['conpulsory_sub_limit'],
                        'not_show_academic_subject_ids' => collect($not_show_subject_list_compulsory)->implode(','),
                        'status' => true,
                        'site_id' => Session::get('SITE_ID'),

                    ];
                }






            }


            $not_show_subject_list_markingless=null;
            if(count($value['markingless_subject_list'])>0){
                $not_show_subject_list_markingless=$value['select_markingless_subject'];


                $academic_subject_condition_list=collect($value['markingless_subject_list'])
                    ->first();

                if($group_base_limit_list) {
                    $check_present_data = $group_base_limit_list
                        ->where('academic_subject_condition_id', $academic_subject_condition_list['condition_id'])
                        ->first();

                    if ($check_present_data) {

                        $present_limit_ids_array[] = $check_present_data->id;

                        $check_present_data->limit_amount = $value['markingless_sub_limit'];
                        $check_present_data->not_show_academic_subject_ids = collect($not_show_subject_list_markingless)->implode(',');

                        $check_present_data->save();
                    }
                    else {
                        $created[] = [
                            'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                            'academic_year_id' => $request->academic_year_id,
                            'academic_class_id' => $request->academic_class_id,
                            'academic_department_id' => $request->academic_department_id,
                            'academic_class_group_id' => $value['id']?$value['id']:null,
                            'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                            'limit_amount' =>$value['markingless_sub_limit'],
                            'not_show_academic_subject_ids' => collect($not_show_subject_list_markingless)->implode(','),
                            'status' => true,
                            'site_id' => Session::get('SITE_ID'),

                        ];
                    }
                }
                else{
                    $created[] = [
                        'academic_group_id' =>Session::get('ACADEMIC_GROUP_ID'),
                        'academic_year_id' => $request->academic_year_id,
                        'academic_class_id' => $request->academic_class_id,
                        'academic_department_id' => $request->academic_department_id,
                        'academic_class_group_id' => $value['id']?$value['id']:null,
                        'academic_subject_condition_id' => $academic_subject_condition_list?$academic_subject_condition_list['condition_id']:null,
                        'limit_amount' =>$value['markingless_sub_limit'],
                        'not_show_academic_subject_ids' => collect($not_show_subject_list_markingless)->implode(','),
                        'status' => true,
                        'site_id' => Session::get('SITE_ID'),

                    ];
                }




            }



        }


        if(count($present_limit_ids)>0){
            $siteSubjectLimitCheck=array_diff($present_limit_ids->toArray(), $present_limit_ids_array);


            SiteSubjectConditionLimit::whereIn('id', $siteSubjectLimitCheck)->delete();
        }

        if(count($created)>0){
            SiteSubjectConditionLimit::insert($created);
        }

        return Response::json(['message' => 'Save Successfully!', 'mode' => 'Update!'], 200);

    }


    //Api---------------------------------==========API==================================API-------------------------------------


    public function getYearAndShiftWiseAcademicSubjectList($version_id, $shift_id, $year_id)
    {
        $site_subject_ids = $this->subjectGroupConditionSetting
            ->where('academic_version_id', $version_id)
            ->where('academic_shift_id', $shift_id)
            ->where('academic_year_id', $year_id)
            ->pluck('');

        $subjects = AcademicSubject::whereIn('id', $site_subject_ids)->get();
        return $subjects;
    }


}
