<?php

namespace App\Http\Controllers\Site;

use App\Models\Modules\Module;
use App\Models\Package\EduPackage;
use App\Models\Site\Permission\SiteRoleAccess;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteInfo;
use Illuminate\Validation\ValidationException;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class UserPermissionController extends Controller
{


    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function assignPermissionForm()
    {
        $viewType = 'Assign Permission For User';
        return view('default.admin.sites.users.assign-permission', compact('viewType'));
    }




    public function assignSubModuleToUser(Request $req)
    {
        try {

            $this->validate($req, [
                'selected_role' => 'required',
            ]);
            $site_id = Session::get('SITE_ID');

            $sub_module_ids = $req->sub_module_ids;
            $role_id = $req->selected_role['id'];
            $get_all_users_with_role = SiteRole::findOrFail($role_id)->users()->get() ?? null;

            foreach ($get_all_users_with_role as $k => $value) {
                $user_id = $value->id;
                if (file_exists(base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('ALIAS1') . '/' . $user_id . '.blade.php'))) {
                    unlink(base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('ALIAS1') . '/' . $user_id . '.blade.php'));
                }
            }

            $sub_module_ids_exploded = implode($sub_module_ids, ',');
            $total = count($sub_module_ids);

            $userAlreadyAssigned = SiteRoleAccess::whereSiteRoleId($role_id)->first();

            if ($userAlreadyAssigned) {
                $userAlreadyAssigned->update([
                    'sub_module_ids' => $sub_module_ids_exploded
                ]);
            } else {
                SiteRoleAccess::create([
                    'sub_module_ids' => $sub_module_ids_exploded,
                    'site_role_id' => $role_id,
                    'site_id' => $site_id
                ]);
            }

            return Response::json(['message' => $total . ' Sub Module Attached Done Successfully!']);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 500);
        }
    }


}
