<?php

namespace App\Http\Controllers\SiteGroup\Exam;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Academic\AcademicClass;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Log;
use JsonSchema\Exception\ValidationException;
use App\Models\Examinations\Examination;
use App\Models\SiteGroup\Exam\SiteGroupExaminationExamTypeSettingStore;
use App\Models\Site\SiteInfo\GlobalSiteInfo;

use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\SiteGroup\Settings\SiteGroupSubjectGroupConditionSettingStore;

use App\Models\Site\Exam\GlobalSiteExaminationExamTypeSetting;

use App\Models\Site\Exam\GlobalSiteSubjectExaminationMark;
use App\Models\SiteGroup\Exam\SiteGroupSubjectExaminationMarkStore;

use App\Models\Site\Exam\GlobalSiteSubjectExaminationExamTypeMark;
use App\Models\SiteGroup\Exam\SiteGroupSubjectExaminationExamTypeMarkStore;
use App\Models\Academic\AcademicExamType;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Exam\GlobalSiteExamDeclares;
use App\Models\Site\Exam\GlobalSiteExamRoutine;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\SiteGroup\Exam\SiteGroupExamDeclareStore;
use App\Models\SiteGroup\Exam\SiteGroupExamRoutineStore;
use App\Models\SiteGroup\GlobalSiteGroup;
use Carbon\Carbon;
use Exception;
use Response;
use PDF;
use Session;


class SiteGroupBaseExamDeclareController extends SiteGroupProjectController
{
    private $siteGroupExaminationExamTypeSettingStore;
    private $globalSubjectGroupConditionSetting;
    private $siteGroupSubjectGroupConditionSettingStore;
    private $siteGroupExamRoutineStore;

    public function __construct(
        SiteGroupExaminationExamTypeSettingStore $siteGroupExaminationExamTypeSettingStore,
        GlobalSubjectGroupConditionSetting $globalSubjectGroupConditionSetting,
        SiteGroupSubjectGroupConditionSettingStore $siteGroupSubjectGroupConditionSettingStore,
        SiteGroupExamRoutineStore $siteGroupExamRoutineStore
    ) {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');

        $this->siteGroupExaminationExamTypeSettingStore = $siteGroupExaminationExamTypeSettingStore;
        $this->globalSubjectGroupConditionSetting = $globalSubjectGroupConditionSetting;
        $this->siteGroupSubjectGroupConditionSettingStore = $siteGroupSubjectGroupConditionSettingStore;
        $this->siteGroupExamRoutineStore = $siteGroupExamRoutineStore;
    }

    public function index()
    {
        $viewType = "Site Group Exam Declare";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function siteGroupExaminationList(Request $request)
    {

        $data = $request->all();

        $examinationAll = $this->siteGroupExaminationExamTypeSettingStore
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('examination_id')
            ->unique();
        //    dd($examinationAll);
        $examination_list = Examination::whereIn('id', $examinationAll)->get();
        return $examination_list;
    }

    public function siteGroupExaminationSiteList(Request $request)
    {

        $data = $request->all();
        // dd($data);
        $existing_site_ids = $this->globalSubjectGroupConditionSetting
            ->with(['globalSiteSubjectExaminationMark' => function ($q) use ($data) {
                return $q->with(['globalSiteSubjectExaminationExamTypeMark' => function ($qu) {
                    $qu->with('academicExamType');
                }])->where('examination_id', $data['examination_id']);
            }, 'academicSubject'])
            // ->whereHas('globalSiteSubjectExaminationMark',function($query2){
            //     $query2->whereHas('globalSiteSubjectExaminationExamTypeMark');
            // })
            ->whereHas('globalSiteSubjectExaminationMark', function ($query) use ($data) {
                $query->where('examination_id', $data['examination_id'])
                    ->whereHas('globalSiteSubjectExaminationExamTypeMark');
            })
            ->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->whereIn('site_id', $this->siteIds())
            ->where('status', true)
            ->groupBy('site_id')
            ->pluck('site_id')
            ->unique()
            ->values();

        $site_list = GlobalSiteInfo::whereIn('id', $existing_site_ids)->get();

        //=== site exam declare list===

        $existing_site_ids = GlobalSiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('exam_declared_by', 'site_group')
            ->pluck('site_id')
            ->unique();

        //=== site group declare list===
        $declaredSiteGroupExam = SiteGroupExamDeclareStore::with('version', 'year', 'shift', 'department', 'stClass', 'classGroup', 'session', 'section', 'examination')
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->get();

        $data = [
            'site_list' => $site_list,
            'existing_site_ids' => $existing_site_ids,
            'declare_list' => $declaredSiteGroupExam,
        ];

        return $data;
    }


    public function createUpdateSiteGroupBaseExamDeclare(Request $request)
    {

        $data = $request->all();
        DB::beginTransaction();
        try {

            //SiteGroupExamDeclareStore::where()->get();
            $declaredSiteGroupExam = SiteGroupExamDeclareStore::where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('examination_id', $request->examination_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->first();


            $subjects = [];

            if ($declaredSiteGroupExam) {


                //  $selected_subject_ids= collect($subjects)->unique()->values()->toArray();

                $declaredSiteGroupExam->academic_version_id = $request->academic_version_id;
                $declaredSiteGroupExam->academic_year_id = $request->academic_year_id;
                $declaredSiteGroupExam->academic_shift_id = $request->academic_shift_id;
                $declaredSiteGroupExam->academic_department_id = $request->academic_department_id;
                $declaredSiteGroupExam->academic_class_id = $request->academic_class_id;
                $declaredSiteGroupExam->academic_class_group_id = $request->academic_class_group_id;
                $declaredSiteGroupExam->academic_session_id = $request->academic_session_id;
                $declaredSiteGroupExam->academic_section_id = $request->academic_section_id;

                $declaredSiteGroupExam->examination_id = $request->examination_id;
                //     $declaredSiteExam->site_subject_group_condition_setting_ids=implode(',', $selected_subject_ids);
                $declaredSiteGroupExam->save();

                $siteExamDeclare_id = $declaredSiteGroupExam->id;
            } else {
                $siteGroupExamDeclares = new SiteGroupExamDeclareStore;;

                $siteGroupExamDeclares->academic_version_id = $request->academic_version_id;
                $siteGroupExamDeclares->academic_year_id = $request->academic_year_id;
                $siteGroupExamDeclares->academic_shift_id = $request->academic_shift_id;
                $siteGroupExamDeclares->academic_department_id = $request->academic_department_id;
                $siteGroupExamDeclares->academic_class_id = $request->academic_class_id;
                $siteGroupExamDeclares->academic_class_group_id = $request->academic_class_group_id;
                $siteGroupExamDeclares->academic_session_id = $request->academic_session_id;
                $siteGroupExamDeclares->academic_section_id = $request->academic_section_id;

                $siteGroupExamDeclares->examination_id = $request->examination_id;
                $siteGroupExamDeclares->created_by = Auth::user()->id;
                $siteGroupExamDeclares->status = true;

                if ($siteGroupExamDeclares->save()) {
                    $siteExamDeclare_id = $siteGroupExamDeclares->id;
                }
            }

            //==== site declare====
            if ($siteExamDeclare_id) {
                foreach ($request->selected_site_ids as $site_id) {

                    $declaredSiteExam = GlobalSiteExamDeclares::where('academic_version_id', $request->academic_version_id)
                        ->where('academic_year_id', $request->academic_year_id)
                        ->where('academic_shift_id', $request->academic_shift_id)
                        ->where('academic_class_id', $request->academic_class_id)
                        ->where('examination_id', $request->examination_id)
                        ->where('site_id', $site_id)
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                        })
                        ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        })
                        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                            return $query->where('academic_session_id', $data['academic_session_id']);
                        })
                        ->where('exam_declared_by', 'site_group')
                        ->first();

                    //  $selected_subject_ids= collect($subjects)->unique()->values()->toArray();
                    if ($declaredSiteExam) {
                        $declaredSiteExam->academic_version_id = $request->academic_version_id;
                        $declaredSiteExam->academic_year_id = $request->academic_year_id;
                        $declaredSiteExam->academic_shift_id = $request->academic_shift_id;
                        $declaredSiteExam->academic_department_id = $request->academic_department_id;
                        $declaredSiteExam->academic_class_id = $request->academic_class_id;
                        $declaredSiteExam->academic_class_group_id = $request->academic_class_group_id;
                        $declaredSiteExam->academic_session_id = $request->academic_session_id;
                        $declaredSiteExam->academic_section_id = $request->academic_section_id;
                        $declaredSiteExam->site_id = $site_id;
                        $declaredSiteExam->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                        $declaredSiteExam->examination_id = $request->examination_id;
                        $declaredSiteExam->exam_declared_by = 'site_group';
                        $declaredSiteExam->created_by = Auth::user()->id;
                        $declaredSiteExam->status = true;
                        $declaredSiteExam->save();
                    } else {
                        $declaredExam = new GlobalSiteExamDeclares;
                        $declaredExam->academic_version_id = $request->academic_version_id;
                        $declaredExam->academic_year_id = $request->academic_year_id;
                        $declaredExam->academic_shift_id = $request->academic_shift_id;
                        $declaredExam->academic_department_id = $request->academic_department_id;
                        $declaredExam->academic_class_id = $request->academic_class_id;
                        $declaredExam->academic_class_group_id = $request->academic_class_group_id;
                        $declaredExam->academic_session_id = $request->academic_session_id;
                        $declaredExam->academic_section_id = $request->academic_section_id;
                        $declaredExam->site_id = $site_id;
                        $declaredExam->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                        $declaredExam->examination_id = $request->examination_id;
                        $declaredExam->exam_declared_by = 'site_group';
                        $declaredExam->created_by = Auth::user()->id;
                        $declaredExam->status = true;
                        $declaredExam->save();
                    }
                }
            }
            DB::commit();
            return Response::json(['message' => 'Exam Declared Successfully!', 'mode' => 'Saved!'], 200);
        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }



    public function siteGroupExaminationDeclareList(Request $request)
    {

        try {

            $data = $request->all();

            $declaredSiteGroupExam = SiteGroupExamDeclareStore::with('examination')
                ->where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_class_id', $request->academic_class_id)
                //->where('examination_id', $request->examination_id)
                // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                //     return $query->where('academic_department_id', $data['academic_department_id']);
                // })
                // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                // })
                // ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                //     return $query->where('academic_section_id', $data['academic_section_id']);
                // })
                // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                //     return $query->where('academic_session_id', $data['academic_session_id']);
                // })
                ->get();

            //     dd($declaredSiteGroupExam);
            //     $examinationAll = $this->siteGroupExaminationExamTypeSettingStore
            //     ->where('academic_year_id', $request->academic_year_id)
            //     ->where('academic_class_id', $request->academic_class_id)
            //     ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //         return $query->where('academic_department_id', $data['academic_department_id']);
            //     })
            //     ->pluck('examination_id')
            //     ->unique();

            // $examination_list=Examination::whereIn('id', $examinationAll)->get();

            if (count($declaredSiteGroupExam)) {
                return $declaredSiteGroupExam;
            } else {
                return Response::json(['message' => 'Examination not Found', 'mode' => 'error'], 410);
            }
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }





    public function getExamRoutineSubjectList(Request $requests)
    {
        try {


            ini_set('memory_limit', '-1');

            $data = $requests->all();


            // dd($data);
            //    SiteSubjectExaminationMark::get();
            $checkSiteExamDeclared = SiteGroupExamDeclareStore::find($requests->examination_declared_id);

            $subjects = SiteGroupSubjectGroupConditionSettingStore::select('id', 'academic_subject_id', 'academic_class_group_ids', 'subject_code')
                ->with(
                    [
                        'siteGroupSubjectExaminationMarkStore' => function ($q) use ($data, $checkSiteExamDeclared) {
                            $q->where('examination_id', $checkSiteExamDeclared->examination_id);
                            $q->where('status', true);
                            $q->with(['siteGroupSubjectExaminationExamTypeMarkStore' => function ($que) {
                                $que->with(['academicExamType']);
                                $que->where('status', true);
                            }]);
                        },
                        'academicSubjectClassExamCondition'
                    ]
                )
                // ->whereHas('academicSubjectClassExamCondition', function ($q) {
                //     $q->where('name_key', 'onlyforexam')
                //         ->orWhere('name_key', 'forclassandexam');
                // })
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('status', true)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->get();



            $subjects_array = [];
            foreach ($subjects as $key => $value) {
                if (count($value->academic_class_groups) > 0) {

                    $check_subject_group = $value->academic_class_groups
                        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                            return $query->where('id', $data['academic_class_group_id']);
                        })
                        ->first();

                    if ($check_subject_group) {
                        $subjects_array[] = $value;
                    }
                } else {
                    $subjects_array[] = $value;
                }
            }

            //  $examtypesetting=SiteExaminationExamTypeSetting::where('examination_id', $requests->examination_id)->get();
            $examtypesetting = SiteGroupExaminationExamTypeSettingStore::where('examination_id', $checkSiteExamDeclared->examination_id)->get();

            $subject_list_array = [];
            $subject_list_arr = array();
            foreach ($subjects_array as $key => $value) {

                $def_array = [];
                $def_arr = array();
                foreach ($value->siteGroupSubjectExaminationMarkStore as $ke => $valu) {
                    $abc_arr = array();
                    $abc_array = [];
                    foreach ($valu->siteGroupSubjectExaminationExamTypeMarkStore as $k => $val) {

                        foreach ($examtypesetting as $ks => $vals) {

                            if ($vals->examination_id == $valu->examination_id && $vals->academic_exam_type_id == $val->academic_exam_type_id) {

                                $abc_arr['exam_day'] = $vals->exam_day;
                                $abc_arr['select_exam_type_id'] = false;
                                $abc_arr['online_exam_status'] = false;
                                $abc_arr['online_result_show_student'] = false;
                                $abc_arr['student_per_day'] = null;
                                $abc_arr['routine_id'] = null;

                                $abc_array[$k] = array_merge($val->toArray(), $abc_arr);
                            }
                        }
                    }

                    $def_arr['site_group_subject_examination_exam_type_mark'] = collect($abc_array)->values();
                    $def_arr['examination_id'] = $valu->examination_id;

                    $def_array[$ke] = array_merge($def_arr);
                }

                $subject_list_arr['site_group_subject_examination_mark'] = $def_array;
                $subject_list_arr['subject_name'] = $value->subject_name;
                $subject_list_arr['subject_code'] = $value->subject_code;
                $subject_list_arr['select_subject_id'] = false;
                $subject_list_arr['id'] = $value->id;
                $subject_list_arr['academic_subject_id'] = $value->academic_subject_id;
                $subject_list_array[$key] = array_merge($subject_list_arr);
            }

            $examSubjectids = $subjects->pluck('id')
                ->unique()
                ->filter();

            //  $examinationIDs=SiteSubjectExaminationMark::where('examination_id', $requests->examination_id)
            $examinationIDs = SiteGroupSubjectExaminationMarkStore::where('examination_id', $checkSiteExamDeclared->examination_id)
                ->whereIn('site_group_subject_group_condition_setting_id', $examSubjectids)
                ->pluck('id')
                ->unique()
                ->filter();


            //  $examTypeIDs=SiteSubjectExaminationExamTypeMark::whereIn('site_subject_examination_mark_id', $examinationIDs)
            $examTypeIDs = SiteGroupSubjectExaminationExamTypeMarkStore::whereIn('site_group_subject_examination_mark_id', $examinationIDs)
                ->pluck('academic_exam_type_id')
                ->unique()
                ->filter();
            //  dd($examTypeIDs);
            $examTypeLists = AcademicExamType::whereIn('id', $examTypeIDs)->get();

            $exam_type_list_arr = array();
            $exam_type_list_array = [];

            foreach ($examTypeLists as $key => $value) {

                $exam_type_list_arr['start_time'] = null;
                $exam_type_list_arr['end_time'] = null;
                $exam_type_list_arr['duration'] = null;

                $exam_type_list_array[$key] = array_merge($value->toArray(), $exam_type_list_arr);
            }



            $checkRoutine = SiteGroupExamRoutineStore::where('site_group_exam_declare_id', $checkSiteExamDeclared->id)->first();

            if ($checkRoutine) {
                $examTypeList = SiteGroupExamDeclareStore::with([
                    'version',
                    'year',
                    'shift',
                    'department',
                    'stClass',
                    'session',
                    'section',
                    'examRoutine',
                    'examination',
                    'academicExamTypeList' => function ($query) {
                        $query->groupBy('academic_exam_type_id');
                    },

                ])
                    //   ->withCount('declaredStudent')
                    ->where('academic_version_id', $requests->academic_version_id)
                    ->where('academic_year_id', $requests->academic_year_id)
                    ->where('academic_shift_id', $requests->academic_shift_id)
                    ->where('academic_class_id', $requests->academic_class_id)
                    ->where('examination_id', $checkSiteExamDeclared->examination_id)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->get();
            } else {

                $examTypeList = SiteGroupExamDeclareStore::with([
                    'version',
                    'year',
                    'shift',
                    'department',
                    'stClass',
                    'session',
                    'section',
                    'examRoutine',
                    'examination'
                ])
                    //  ->withCount('declaredStudent')
                    ->where('academic_version_id', $requests->academic_version_id)
                    ->where('academic_year_id', $requests->academic_year_id)
                    ->where('academic_shift_id', $requests->academic_shift_id)
                    ->where('academic_class_id', $requests->academic_class_id)
                    ->where('examination_id', $checkSiteExamDeclared->examination_id)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->get();
            }
            //    dd(count($studentList));
            return response()->json(
                [
                    'subject_list_array' => $subject_list_array,
                    'exam_type_list_array' => $exam_type_list_array,
                    'examTypeList' => $examTypeList,

                ]
            );
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    public function siteGroupBaseExamRoutinePdf(Request $request)
    {
        try {
            //new change con
            $data = $request->SubjectExamTypeList;
            $requestForm = $request->form;
            $examDeclar = SiteGroupExamDeclareStore::with('examination')->where('id', $requestForm['examination_declared_id'])->first();
            $examDeclar->year_name = AcademicYear::find($examDeclar->academic_year_id)->year_name;

            $academicClass = AcademicClass::find($examDeclar->academic_class_id);

            $transformedArray = collect($data)->map(function ($item) {
                return [
                    'subject_code'    => $item['subject_code'] ?? null,
                    'subject_name'    => $item['subject_name'] ?? null,
                    'exam_start_date' => $item['site_group_subject_examination_mark'][0]['site_group_subject_examination_exam_type_mark'][0]['start_date'] ?? null,
                ];
            });

            $groupedArray = collect($transformedArray)
                ->groupBy('exam_start_date')
                ->sortKeys()
                ->map(function ($items, $date) {
                    return [
                        'exam_start_date' => Carbon::parse($date)->format('d-M-Y'),
                        'dayName' => date('l', strtotime($date)),
                        'subjects' => $items->pluck('subject_name')->filter()->unique()->values()->all(),
                        'subject_code' => $items->pluck('subject_code')->filter()->unique()->values()->all(),
                    ];
                })
                ->values();

            $page_tittle = 'Exam Routine';
            $report_tittle = 'Exam Routine';
            $report_tittle .= '<br>';
            $report_tittle .= $examDeclar->examination->examination_name . ' - ' . $examDeclar->year_name;
            $report_tittle2 = 'Class: ' . $academicClass->class_name;


            $report_type = '';
            $site = '';
            $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();

            $pdf = PDF::loadView(
                'default.admin.site_group.exam.site-group-student-exam-routine-pdf',
                compact('SiteGroupInfo', 'groupedArray', 'page_tittle', 'report_tittle', 'report_tittle2', 'report_type')
            )
                ->setPaper('a4', 'portrait')
                ->setWarnings(false);

            $path = storage_path() . '/pdf';
            $time = Auth::user()->id . '-' . Carbon::now()->unix();
            $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
            $name = $time . '.pdf';

            return Response::json([
                'link' => route('site_group-open-pdf-file-storage', [$name]),
                'message' => 'Successfully Created Card Report'
            ], 200);
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    public function createUpdateSiteGroupBaseExamRoutine(SiteGroupExamDeclareStore $siteExamDeclares, Request $requests)
    {

        DB::beginTransaction();

        //  try {

        //  dd($requests->all());

        $data = $requests->all();

        $siteGroupExamDeclare = SiteGroupExamDeclareStore::find($requests->examination_declared_id);


        $siteExamDeclare_id = $siteGroupExamDeclare->id;
        $declaredRoutine = SiteGroupExamRoutineStore::where('site_group_exam_declare_id', $siteExamDeclare_id)->get();
        $declaredRoutineIds = $declaredRoutine->pluck('id')->toArray();

        $routineIDs = [];
        $unchecked_subject_routine_ids = [];
        $unchecked_exam_type_routine_ids = [];

        foreach ($requests->SubjectExamTypeList as $key => $value) {
            if ($value['select_subject_id']) {
                foreach ($value['site_group_subject_examination_mark'] as $keys => $values) {

                    foreach ($values['site_group_subject_examination_exam_type_mark'] as $keyst => $valuest) {

                        if ($valuest['select_exam_type_id']) {

                            if ($valuest['routine_id']) {

                                //  if($valuest['start_date']){
                                $Routines = $declaredRoutine->where('id', $valuest['routine_id'])->first();

                                $routineIDs[] = $valuest['routine_id'];

                                $Routines->site_group_subject_group_condition_setting_id = $value['id'];
                                $Routines->academic_subject_id = $value['academic_subject_id'];
                                $Routines->academic_exam_type_id = $valuest['academic_exam_type_id'];
                                $Routines->online_exam_status = $valuest['online_exam_status'] ? true : false;
                                //  $Routines->online_result_show_student=$valuest['online_result_show_student']?true:false;
                                $Routines->exam_start_date = $valuest['start_date'];
                                $Routines->exam_end_date = $valuest['end_date'];
                                $Routines->exam_start_time = date("H:i", strtotime($valuest['start_time']));
                                $Routines->exam_end_time = date("H:i", strtotime($valuest['end_time']));
                                $Routines->exam_duration = $valuest['duration'];
                                $Routines->per_day_student = $valuest['student_per_day'];
                                $Routines->save();
                                $siteExamRoutine_id =  $valuest['routine_id'];
                                //   }
                                // else{
                                //     $routineIDs[]=$valuest['routine_id'];

                                //     $siteExamRoutine_id =  $valuest['routine_id'];

                                //     $Routines1=$declaredRoutine->where('id', $valuest['routine_id'])->first();
                                //    // dd($value['academic_subject_id']);
                                //     $Routines1->academic_subject_id=$value['academic_subject_id'];
                                //     $Routines1->online_exam_status=$valuest['online_exam_status']?true:false;
                                //     $Routines1->save();
                                //  }
                                //dd($value['academic_subject_id']);
                            } else {
                                $routineCreate = new SiteGroupExamRoutineStore();

                                $routineCreate->site_group_exam_declare_id = $siteExamDeclare_id;
                                $routineCreate->site_group_subject_group_condition_setting_id = $value['id'];
                                $routineCreate->academic_subject_id = $value['academic_subject_id'];
                                $routineCreate->academic_exam_type_id = $valuest['academic_exam_type_id'];
                                $routineCreate->online_exam_status = $valuest['online_exam_status'] ? true : false;
                                $routineCreate->exam_start_date = $valuest['start_date'];
                                $routineCreate->exam_end_date = $valuest['end_date'];
                                $routineCreate->exam_start_time = date("H:i", strtotime($valuest['start_time']));
                                $routineCreate->exam_end_time = date("H:i", strtotime($valuest['end_time']));
                                $routineCreate->exam_duration = $valuest['duration'];
                                $routineCreate->per_day_student = $valuest['student_per_day'];

                                $routineCreate->examination_id = $siteGroupExamDeclare->examination_id;
                                $routineCreate->status = true;
                                $routineCreate->save();
                                $siteExamRoutine_id = $routineCreate->id;
                            }
                        } else {
                            if ($valuest['routine_id']) {
                                $unchecked_exam_type_routine_ids[] = $valuest['routine_id'];
                            }
                        }
                    }
                }
            } else {

                if ($declaredRoutine) {
                    $unchecked_subject_routine_ids[] = $declaredRoutine->where('site_group_subject_group_condition_setting_id', $value['id'])
                        ->pluck('id')
                        ->unique()
                        ->values();
                }
            }
        }

        $unchecked_subject_routine_ids_array = collect(array_merge($unchecked_subject_routine_ids))->collapse()->toArray();

        $unchecked_routine_ids = array_merge($unchecked_exam_type_routine_ids, $unchecked_subject_routine_ids_array);

        SiteGroupExamRoutineStore::whereIn('id', $unchecked_routine_ids)->delete();

        //    dd('sf');
        ////===== site exam routine declare===
        //  GlobalSiteExamDeclares::
        $check_site_declared_list = GlobalSiteExamDeclares::where('academic_version_id', $requests->academic_version_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('academic_shift_id', $requests->academic_shift_id)
            ->where('academic_class_id', $requests->academic_class_id)
            ->where('examination_id', $siteGroupExamDeclare->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->whereIn('site_id', $this->siteIds())
            ->where('exam_declared_by', 'site_group')
            ->get();
        foreach ($check_site_declared_list as $siteExmaDeclare) {

            $declaredGroupRoutineList = $this->siteGroupExamRoutineStore->where('site_group_exam_declare_id', $siteExamDeclare_id)->get();

            $site_routine_present_ids = [];
            foreach ($declaredGroupRoutineList as $groupRoutine) {
                $subjectsCondition = GlobalSubjectGroupConditionSetting::select('id', 'academic_subject_id', 'academic_class_group_ids')
                    ->with(
                        [
                            'globalSiteSubjectExaminationMark' => function ($q) use ($data, $siteExmaDeclare) {
                                $q->where('examination_id', $siteExmaDeclare->examination_id);
                                $q->where('status', true);
                                $q->with(['globalSiteSubjectExaminationExamTypeMark' => function ($que) {
                                    $que->with(['academicExamType']);
                                    $que->where('status', true);
                                }]);
                            },
                            'academicSubjectClassExamCondition'
                        ]
                    )
                    ->whereHas('academicSubjectClassExamCondition', function ($q) {
                        $q->where('name_key', 'onlyforexam')
                            ->orWhere('name_key', 'forclassandexam');
                    })
                    ->where('academic_year_id', $data['academic_year_id'])
                    ->where('academic_class_id', $data['academic_class_id'])
                    ->where('status', true)
                    ->where('academic_subject_id', $groupRoutine->academic_subject_id)
                    ->where('site_id', $siteExmaDeclare->site_id)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->first();
                //   dd($subjectsCondition);
                if ($subjectsCondition) {


                    $siteRoutines = GlobalSiteExamRoutine::where('site_subject_group_condition_setting_id', $subjectsCondition->id)
                        ->where('site_exam_declare_id', $siteExmaDeclare->id)
                        ->where('academic_group_id', $siteExmaDeclare->academic_group_id)
                        ->where('site_id', $siteExmaDeclare->site_id)
                        ->where('examination_id', $siteExmaDeclare->examination_id)
                        ->where('academic_exam_type_id', $groupRoutine->academic_exam_type_id)
                        ->first();
                    //dd($groupRoutine);
                    if ($siteRoutines) {
                        $siteRoutines->online_exam_status = $groupRoutine->online_exam_status;
                        $siteRoutines->exam_start_date = $groupRoutine->exam_start_date;
                        $siteRoutines->exam_end_date = $groupRoutine->exam_end_date;
                        $siteRoutines->exam_start_time = $groupRoutine->exam_start_time;
                        $siteRoutines->exam_end_time = $groupRoutine->exam_end_time;
                        $siteRoutines->exam_duration = $groupRoutine->exam_duration;
                        $siteRoutines->per_day_student = $groupRoutine->per_day_student;
                        $siteRoutines->save();
                        $site_routine_id = $siteRoutines->id;
                    } else {
                        //    if($siteExmaDeclare){
                        $routineCreate = new GlobalSiteExamRoutine();
                        $routineCreate->site_exam_declare_id = $siteExmaDeclare->id;
                        $routineCreate->academic_group_id = $siteExmaDeclare->academic_group_id;
                        $routineCreate->site_id = $siteExmaDeclare->site_id;
                        $routineCreate->examination_id = $siteExmaDeclare->examination_id;

                        $routineCreate->site_subject_group_condition_setting_id = $subjectsCondition->id;
                        $routineCreate->academic_exam_type_id = $groupRoutine->academic_exam_type_id;
                        $routineCreate->online_exam_status = $groupRoutine->online_exam_status;
                        $routineCreate->exam_start_date = $groupRoutine->exam_start_date;
                        $routineCreate->exam_end_date = $groupRoutine->exam_end_date;
                        $routineCreate->exam_start_time = $groupRoutine->exam_start_time;
                        $routineCreate->exam_end_time = $groupRoutine->exam_end_time;
                        $routineCreate->exam_duration = $groupRoutine->exam_duration;
                        $routineCreate->per_day_student = $groupRoutine->per_day_student;
                        // $routineCreate->online_result_show_student=false;
                        // $routineCreate->seat_plan_publish_for_employee=false;
                        // $routineCreate->seat_plan_publish_for_student=false;
                        $routineCreate->save();
                        $site_routine_id = $routineCreate->id;

                        //  }

                    }
                    $site_routine_present_ids[] = $site_routine_id;
                }
            }

            $site_all_routine_ids = GlobalSiteExamRoutine::where('site_exam_declare_id', $siteExmaDeclare->id)
                ->where('academic_group_id', $siteExmaDeclare->academic_group_id)
                ->where('site_id', $siteExmaDeclare->site_id)
                ->where('examination_id', $siteExmaDeclare->examination_id)
                //   ->where('academic_exam_type_id',$groupRoutine->academic_exam_type_id)
                ->pluck('id')
                ->unique();

            $uncheck_site_routine_ids = array_diff($site_all_routine_ids->toArray(), $site_routine_present_ids);
            GlobalSiteExamRoutine::whereIn('id', $uncheck_site_routine_ids)->delete();
        }

        // dd($check_declared_list);

        DB::commit();

        return Response::json(['message' => 'information Update Successfully!', 'mode' => 'Save'], 200);




        //    } catch (ValidationException $exception) {
        //        DB::rollBack();
        //        return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        //    } catch (Exception $exception) {
        //        DB::rollBack();
        //        return Response::json(['message' => $exception->getMessage()], 410);
        //    }


    }
}
