<?php

namespace App\Http\Controllers\SiteGroup\Exam;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSubject;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\GlobalSiteExamDeclares;
use App\Models\Site\Exam\GlobalSiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\Exam\GlobalSiteGroupStudentExamPeaperToken;
use App\Models\SiteGroup\Exam\SiteGroupExamDeclareStore;
use App\Models\SiteGroup\Exam\SiteGroupStudentExamPeaperToken;
use App\Models\SiteGroup\Exam\SiteGroupStudentExamRoll;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use Carbon\Carbon;
use Session;
use Response;
use PDF;
use Auth;
use Cache;

class SiteGroupExamPeaperTokenGenerateController extends SiteGroupProjectController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
    }

    public function getSiteGroupExamPeaperToten(Request $request)
    {
        $data = $request->all();

        $examDeclar = SiteGroupExamDeclareStore::find($request->examination_declared_id);
        if (!$examDeclar) {
            return response()->json(['message' => 'Exam declaration not found.'], 404);
        }

        $globalSiteExamDeclares = GlobalSiteExamDeclares::whereIn('site_id', $this->siteIds())
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $examDeclar->examination_id)
            ->where('exam_declared_by', 'site_group')
            ->get();

        $site_ids = $globalSiteExamDeclares->pluck('site_id')->values();
        $totalSites = $site_ids->count();

        $lastIndex = Cache::get('site_id_rotation_index', -1);
        $nextIndex = $lastIndex + 1;

        if ($nextIndex >= $totalSites) {
            Cache::forget('site_id_rotation_index');
            return response()->json(['message' => 'All site_ids processed.'], 200);
        }

        $selected_site_id = $site_ids[$nextIndex];
        Cache::put('site_id_rotation_index', $nextIndex, now()->addMinutes(10)); // adjust expiry as needed

        $site = GlobalSiteInfo::find($selected_site_id);
        if (!$site) {
            return response()->json(['message' => 'Site not found.'], 404);
        }

        $studentHistoryList = GlobalStudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('site_id', $selected_site_id)
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->when(!empty($data['academic_class_id']), fn($q) => $q->where('academic_class_id', $data['academic_class_id']))
            ->when(!empty($data['academic_department_id']), fn($q) => $q->where('academic_department_id', $data['academic_department_id']))
            ->when(!empty($data['academic_class_group_id']), fn($q) => $q->where('academic_class_group_id', $data['academic_class_group_id']))
            ->when(!empty($data['academic_section_id']), fn($q) => $q->where('academic_section_id', $data['academic_section_id']))
            ->when(!empty($data['academic_session_id']), fn($q) => $q->where('academic_session_id', $data['academic_session_id']))
            ->where('status', true)
            ->orderBy('student_roll_number')
            ->get();

        $site_exam_declare = $globalSiteExamDeclares->where('site_id', $selected_site_id)->first();
        $subjectCondition = GlobalSubjectGroupConditionSetting::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->where('site_id', $selected_site_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_subject_id', $request->academic_subject_id)
            ->first();

        if ($subjectCondition && $site_exam_declare) {
            $student_history_ids = $studentHistoryList->pluck('id')->unique();
            $student_declare_subject = GlobalSiteExamDeclareStudentSubject::whereIn('student_history_id', $student_history_ids)
                ->where('site_id', $selected_site_id)
                ->where('site_subject_group_condition_setting_id', $subjectCondition->id)
                ->where('examination_id', $examDeclar->examination_id)
                ->where('academic_exam_type_id', $data['academic_exam_type_id'])
                ->orderBy('student_history_id')
                ->get();

            $declaredStudentSubjectIds = [];
            $insertData = [];
            $lastToken = GlobalSiteGroupStudentExamPeaperToken::latest('id')->first();
            $peaper_token = $lastToken ? $lastToken->peaper_token_no + 1 : 100001;

            foreach ($student_declare_subject as $exam_subject) {
                $declaredStudentSubjectIds[] = $exam_subject->id;

                $checkToken = SiteGroupStudentExamPeaperToken::where('site_exam_declare_student_subject_id', $exam_subject->id)->first();
                if (!$checkToken) {
                    $insertData[] = [
                        'site_id' => $exam_subject->site_id,
                        'student_history_id' => $exam_subject->student_history_id,
                        'site_exam_declare_student_subject_id' => $exam_subject->id,
                        'peaper_token_no' => $peaper_token,
                    ];
                    $peaper_token++;
                }
            }

            if (!empty($insertData)) {
                SiteGroupStudentExamPeaperToken::insert($insertData);
            }

            $total_token_created_student = SiteGroupStudentExamPeaperToken::whereIn('student_history_id', $student_history_ids)
                ->where('site_id', $selected_site_id)
                ->whereIn('site_exam_declare_student_subject_id', $declaredStudentSubjectIds)
                ->count();

            $class = AcademicClass::find($request->academic_class_id);

            return response()->json([
                'site_id' => $site->id,
                'site_name' => $site->site_name,
                'class' => $class,
                'total_student' => $total_token_created_student,
                'totalSites' => $totalSites,
                'message' => 'Token generated successfully for site',
            ], 200);
        } else {
            return response()->json(['message' => 'No subject condition or site exam declaration found.'], 400);
        }
    }


    public function siteGroupExamTokenListPdf(Request $request)
    {

        $data = $request->all();
        $examDeclar = SiteGroupExamDeclareStore::with('examination')->where('id', $request->examination_declared_id)->first();

        $student_history_ids = GlobalStudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('site_id', $data['site_id'])
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->when(!empty($data['academic_class_id']), function ($q) use ($data) {
                $q->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_department_id')
            ->orderBy('site_batch_detail_id')
            ->orderBy('academic_class_group_id')
            ->pluck('id')
            ->unique();

        $subjectCondition = GlobalSubjectGroupConditionSetting::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->where('site_id', $data['site_id'])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_subject_id', $request->academic_subject_id)
            ->first();

        //  $student_history_ids=$studentHistoryList->pluck('id')->unique();
        //  $placeholders = implode(',',array_fill(0, count($student_history_ids), '?'));

        $student_declare_subject_ids = GlobalSiteExamDeclareStudentSubject::whereIn('student_history_id', $student_history_ids)
            ->where('site_id', $data['site_id'])
            ->where('site_subject_group_condition_setting_id', $subjectCondition->id)
            ->where('examination_id', $examDeclar->examination_id)
            ->where('academic_exam_type_id', $data['academic_exam_type_id'])
            // ->orderByRaw("field(student_history_id,{$placeholders})", $student_history_ids)
            ->pluck('id')
            ->unique();

        $total_token_created_student = SiteGroupStudentExamPeaperToken::with('studentHistory')
            ->whereIn('student_history_id', $student_history_ids)
            ->where('site_id', $data['site_id'])
            ->whereIn('site_exam_declare_student_subject_id', $student_declare_subject_ids)
            ->orderBy('id', 'ASC')
            ->get();

        $site = GlobalSiteInfo::where('id', $request->site_id)->first();

        $token_array = [];
        $key = 0;
        foreach ($total_token_created_student as $item) {

            $student_exam_roll = SiteGroupStudentExamRoll::where('student_history_id', $item->student_history_id)
                ->where('examination_id', $examDeclar->examination_id)
                ->orderBy('id', 'DESC')
                ->first();

            $token_array[$key]['id'] = $item->id;
            $token_array[$key]['peaper_token_no'] = $item->peaper_token_no;
            $token_array[$key]['student_full_name'] = $item->studentHistory->full_name;

            if ($student_exam_roll) {
                $token_array[$key]['exam_roll'] = $student_exam_roll->roll;
            } else {
                $token_array[$key]['exam_roll'] = '';
            }
            $key++;
        }

        $academicSubject = AcademicSubject::where('id', $request->academic_subject_id)->first();
        $examType = AcademicExamType::where('id', $request->academic_exam_type_id)->first();

        //     dd($subjectCondition);

        $page_tittle = 'Exam Paper Token';
        $report_tittle = 'Exam Paper Token';
        $report_tittle .= '<br>';
        $report_tittle .= $examDeclar->examination->examination_name;

        $report_tittle2  = 'Subject: ';
        $report_tittle2 .= $academicSubject->subject_name;
        $report_tittle2 .= ' / ';
        $report_tittle2 .= $examType->marks_type;

        $report_type = '';



        $pdf = PDF::loadView(
            'default.admin.site_group.exam.site-group-student-exam-paper-token',
            compact('site', 'token_array', 'page_tittle', 'report_tittle', 'report_tittle2', 'report_type')
        )
            ->setPaper('a4', 'landscape')
            ->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json([
            'link' => route('site_group-open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);

        //  return $total_token_array;
    }

    public function openReport($name)
    {
        try {

            $user_id = Auth::user()->id;

            $name_split = preg_split("/\-/", $name);

            if ($name_split[0] != $user_id) {
                return 'You are unauthorized!';
            }


            if (!file_exists(storage_path('pdf/' . $name))) {

                return "The file existed only for 1 day and deleted today!";
            }


            return response()->file(storage_path('pdf/' . $name));
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }
}
