<?php

namespace App\Http\Controllers\SiteGroup\Exam;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicExamType;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\GlobalSiteExaminationExamTypeSetting;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\SiteGroup\Settings\SiteGroupAcademicSettingsStore;
use App\Models\SiteGroup\Exam\SiteGroupExaminationExamTypeSettingStore;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;

use Response;
use Session;

class SiteGroupExaminationExamTypeSettingsController extends SiteGroupProjectController
{
    private $globalSiteExaminationExamTypeSetting;
    private $siteGroupExaminationExamTypeSettingStore;
    private $siteGroupSettings;

    public function __construct(SiteGroupAcademicSettingsStore $siteGroupSettings, SiteGroupExaminationExamTypeSettingStore $siteGroupExaminationExamTypeSettingStore,GlobalSiteExaminationExamTypeSetting $globalSiteExaminationExamTypeSetting)

    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->globalSiteExaminationExamTypeSetting = $globalSiteExaminationExamTypeSetting;
        $this->siteGroupExaminationExamTypeSettingStore = $siteGroupExaminationExamTypeSettingStore;
        $this->siteGroupSettings = $siteGroupSettings;
      
    }

    public function index()
    {
        $viewType = "Site Group Exam Settings";
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function getSiteGroupExaminationList(Request $request){

        $data = $request->all();

        $examination_ids=$this->siteGroupExaminationExamTypeSettingStore
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('examination_id')
            ->unique();

            $examinationList = Examination::
            //whereIn('id', $examination_ids)
            where('use_key','site_group')
            ->get();

            return $examinationList;

    }
    public function getSiteGroupExaminationExamTypeList(Request $request){

        $siteGroupSettinglist=$this->siteGroupSettings->select('examination_ids','academic_exam_type_ids')->first();

      //  dd($siteGroupSettinglist);

    $examinationSplite = explode(',', $siteGroupSettinglist->examination_ids);
    $examinationList = Examination::whereIn('id', $examinationSplite)
        ->where('id', $request->examination_id)
        ->where('use_key','site_group')
        ->get();

    $examTypeSplite = explode(',', $siteGroupSettinglist->academic_exam_type_ids);
    $examTypeList = AcademicExamType::whereIn('id', $examTypeSplite)->get();

    
    $data = $request->all();
    $siteGroupExaminationExamTypePresent=$this->siteGroupExaminationExamTypeSettingStore
        ->where('academic_year_id', $request->academic_year_id)
        ->where('academic_class_id', $request->academic_class_id)
        ->where('examination_id', $request->examination_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->get();

          // existing site ids
      if (count($siteGroupExaminationExamTypePresent)) {
        $existing_site_ids = $this->globalSiteExaminationExamTypeSetting->whereIn('site_id',$this->siteIds())
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->pluck('site_id')
            ->unique()
            ->values();
        }else{
            $existing_site_ids=[];
        }

        

    if(count($siteGroupExaminationExamTypePresent)<=0){

        $siteGroupSimpleExaminationExamTypePresent=$this->siteGroupExaminationExamTypeSettingStore
            ->where('examination_id', $request->examination_id)
            ->whereNull('academic_year_id')
            ->whereNull('academic_class_id')
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->whereNull('academic_department_id');
            })
            ->get();

        if(count($siteGroupSimpleExaminationExamTypePresent)<=0){

            $siteGroupExaminationExamTypeArray=[];
            $siteGroupExaminationExamTypeArr=Array();
            foreach ($examinationList as $key => $value) {

                $siteGroupExaminationExamTypeArr['select_examination_id']=false;
                $siteGroupExaminationExamTypeArr['retack_allow']=false;
                $siteGroupExaminationExamTypeArr['direct_result_input']=false;

                $siteGroupExaminationExamTypeArr['routine_wise_exam_attendace']=false;
                $siteGroupExaminationExamTypeArr['site_attendace_permission']=false;
                $siteGroupExaminationExamTypeArr['site_exam_mark_entry_permission']=false;
                $siteGroupExaminationExamTypeArr['examiner_exam_mark_entry_permission']=false;
                $siteGroupExaminationExamTypeArr['exam_mark_entry_deadline']=false;

                $examTypeArr=Array();
                $examTypeArray=[];
                foreach ($examTypeList as $keys => $values) {
                    $examTypeArr['select_exam_type_id']=false;
                    $examTypeArr['exam_day']=null;
                    $examTypeArr['position_show']=0;
                    $examTypeArr['type_access_owner']=null;

                    $examTypeArray[$keys]=array_merge($values->toArray(), $examTypeArr);
                }

                $siteGroupExaminationExamTypeArr['exam_type_list']=$examTypeArray;
                $siteGroupExaminationExamTypeArray[$key]=array_merge($value->toArray(), $siteGroupExaminationExamTypeArr);

            }

            return response()->json([$siteGroupExaminationExamTypeArray,$existing_site_ids], 200, [], JSON_NUMERIC_CHECK);
        }
        else{

            $examinationArray=[];
            $examinationArr=Array();
            foreach ($examinationList as $key => $value) {

                $examinationPresent=$siteGroupSimpleExaminationExamTypePresent->where('examination_id',$value['id'])->first();

                if($examinationPresent){
                    $examinationArr['select_examination_id']=true;
                    $examinationArr['retack_allow']=$examinationPresent['retack_allow'];
                    $examinationArr['direct_result_input']=$examinationPresent['direct_result_input'];

                    $examinationArr['routine_wise_exam_attendace']=$examinationPresent['routine_wise_exam_attendace'];
                    $examinationArr['site_attendace_permission']=$examinationPresent['site_attendace_permission'];
                    $examinationArr['site_exam_mark_entry_permission']=$examinationPresent['site_exam_mark_entry_permission'];
                    $examinationArr['examiner_exam_mark_entry_permission']=$examinationPresent['examiner_exam_mark_entry_permission'];
                    $examinationArr['exam_mark_entry_deadline']=$examinationPresent['exam_mark_entry_deadline'];
                
                }else{
                    $examinationArr['select_examination_id']=false;
                }
              
                $examTypeArr=Array();
                $examTypeArray=[];
                foreach ($examTypeList as $keys => $values) {
                    $examinationExamTypeList=$siteGroupSimpleExaminationExamTypePresent
                        ->where('examination_id',$value['id'])
                        ->where('academic_exam_type_id',$values['id'])
                        ->first();

                    if($examinationExamTypeList){
                        $examTypeArr['select_exam_type_id']=true;
                        $examTypeArr['exam_day']=$examinationExamTypeList['exam_day'];
                        $examTypeArr['position_show']=$examinationExamTypeList['position_show'];
                        $examTypeArr['type_access_owner']=$examinationExamTypeList['type_access_owner'];

                    }else{
                        $examTypeArr['select_exam_type_id']=false;
                    }

                    $examTypeArray[$keys]=array_merge($values->toArray(), $examTypeArr);
                }

                $examinationArr['exam_type_list']=$examTypeArray;
                $examinationArray[$key]=array_merge($value->toArray(), $examinationArr);
            }

        }
    }
    else{

        $examinationArray=[];
        $examinationArr=Array();
        foreach ($examinationList as $key => $value) {

            $examinationPresent=$siteGroupExaminationExamTypePresent->where('examination_id',$value['id'])->first();

            if($examinationPresent){
                $examinationArr['select_examination_id']=true;
                $examinationArr['retack_allow']=$examinationPresent['retack_allow'];
                $examinationArr['direct_result_input']=$examinationPresent['direct_result_input'];

                $examinationArr['routine_wise_exam_attendace']=$examinationPresent['routine_wise_exam_attendace'];
                $examinationArr['site_attendace_permission']=$examinationPresent['site_attendace_permission'];
                $examinationArr['site_exam_mark_entry_permission']=$examinationPresent['site_exam_mark_entry_permission'];
                $examinationArr['examiner_exam_mark_entry_permission']=$examinationPresent['examiner_exam_mark_entry_permission'];
                $examinationArr['exam_mark_entry_deadline']=$examinationPresent['exam_mark_entry_deadline'];
                
            }else{
                $examinationArr['select_examination_id']=false;
            }
           
            $examTypeArr=Array();
            $examTypeArray=[];
            foreach ($examTypeList as $keys => $values) {
                $examinationExamTypeList=$siteGroupExaminationExamTypePresent
                    ->where('examination_id',$value['id'])
                    ->where('academic_exam_type_id',$values['id'])
                    ->first();

                if($examinationExamTypeList){
                    $examTypeArr['select_exam_type_id']=true;
                    $examTypeArr['exam_day']=$examinationExamTypeList['exam_day'];
                    $examTypeArr['position_show']=$examinationExamTypeList['position_show'];
                    $examTypeArr['type_access_owner']=$examinationExamTypeList['type_access_owner'];
                }else{
                    $examTypeArr['select_exam_type_id']=false;
                }

                $examTypeArray[$keys]=array_merge($values->toArray(), $examTypeArr);
            }

            $examinationArr['exam_type_list']=$examTypeArray;
            $examinationArray[$key]=array_merge($value->toArray(), $examinationArr);
        }

        }

       
        return response()->json([$examinationArray, $existing_site_ids],200);

    }



    public function createUpdateSiteGroupExaminationExamType(Request $request){

        $data = $request->all();

        $site_group_id=Session::get('SITE_GROUP_ID');
        $academic_group_id=Session::get('ACADEMIC_GROUP_ID');

        $siteGroupExaminationExamTypePresent=$this->siteGroupExaminationExamTypeSettingStore
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                // ->where('examination_id', $request->examination_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->get();

        if(count($siteGroupExaminationExamTypePresent)<=0){

            $siteGroupSimpleExaminationExamTypePresent=$this->siteGroupExaminationExamTypeSettingStore
               // ->where('examination_id', $request->examination_id)
                ->whereNull('academic_year_id')
                ->whereNull('academic_class_id')
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->whereNull('academic_department_id');
                })
                ->get();

            if(count($siteGroupSimpleExaminationExamTypePresent)<=0){

                $charges=[];
                foreach ($request->examinationExamTypeList as $key => $value) {

                    if($value['select_examination_id']){

                        foreach ($value['exam_type_list'] as $keys => $values) {
                            if($values['select_exam_type_id']){
                                $charges[] = [
                                    'examination_id'=>$value['id'],
                                    'academic_exam_type_id'=>$values['id'],
                                    'direct_result_input'=>$value['direct_result_input']?true:false,
                                    'routine_wise_exam_attendace'=>$value['routine_wise_exam_attendace']?true:false,
                                    'site_attendace_permission'=>$value['site_attendace_permission']?true:false,
                                    'site_exam_mark_entry_permission'=>$value['site_exam_mark_entry_permission']?true:false,
                                    'examiner_exam_mark_entry_permission'=>$value['examiner_exam_mark_entry_permission']?true:false,
                                    'exam_mark_entry_deadline'=>$value['exam_mark_entry_deadline'],
                                    'retack_allow'=>$value['retack_allow'],
                                    'exam_day'=>$values['exam_day'],
                                    'position_show'=>$values['position_show'],
                                    'type_access_owner'=>$values['type_access_owner'],
                                    'status'=>true,
                                    'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                    'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                    'academic_year_id'=>$request->academic_year_id,
                                    'academic_class_id'=>$request->academic_class_id,
                                    'academic_department_id'=>$request->academic_department_id,
                                ];
                            }
                        }
                    }
                }

                if(count($charges)>0){
                    $this->siteGroupExaminationExamTypeSettingStore->insert($charges);
                }
            }
            else{

                $presentIDArray=$siteGroupSimpleExaminationExamTypePresent->pluck('id');
                $charges=[];
                $presentID=Array();
                $presentTableIDArray=[];
                foreach ($request->examinationExamTypeList as $key => $value) {
                    if($value['select_examination_id']){
                        foreach ($value['exam_type_list'] as $keys => $values) {
                            if($values['select_exam_type_id']){
                                $checkPresentData=$siteGroupSimpleExaminationExamTypePresent
                                    ->where('examination_id',$value['id'])
                                    ->where('academic_exam_type_id',$values['id'])
                                    ->first();

                                if($checkPresentData){
                                    $checkPresentData->retack_allow=$value['retack_allow'];
                                    $checkPresentData->direct_result_input=$value['direct_result_input']?true:false;
                                    $checkPresentData->routine_wise_exam_attendace=$value['routine_wise_exam_attendace']?true:false;
                                    $checkPresentData->site_attendace_permission=$value['site_attendace_permission']?true:false;
                                    $checkPresentData->site_exam_mark_entry_permission=$value['site_exam_mark_entry_permission']?true:false;
                                    $checkPresentData->examiner_exam_mark_entry_permission=$value['examiner_exam_mark_entry_permission']?true:false;
                                    $checkPresentData->exam_mark_entry_deadline=$value['exam_mark_entry_deadline'];
                                    $checkPresentData->exam_day=$values['exam_day'];
                                    $checkPresentData->position_show=$values['position_show'];
                                    $checkPresentData->type_access_owner=$values['type_access_owner'];
                                    $checkPresentData->academic_year_id=$request->academic_year_id;
                                    $checkPresentData->academic_class_id=$request->academic_class_id;
                                    $checkPresentData->academic_department_id=$request->academic_department_id;
                                    $checkPresentData->save();
                                    $presentID[$keys]=$checkPresentData->id;
                                }else{
                                    $charges[] = [
                                        'examination_id'=>$value['id'],
                                        'academic_exam_type_id'=>$values['id'],
                                        'direct_result_input'=>$value['direct_result_input']?true:false,
                                        'routine_wise_exam_attendace'=>$value['routine_wise_exam_attendace']?true:false,
                                        'site_attendace_permission'=>$value['site_attendace_permission']?true:false,
                                        'site_exam_mark_entry_permission'=>$value['site_exam_mark_entry_permission']?true:false,
                                        'examiner_exam_mark_entry_permission'=>$value['examiner_exam_mark_entry_permission']?true:false,
                                        'exam_mark_entry_deadline'=>$value['exam_mark_entry_deadline'],
                                        'retack_allow'=>$value['retack_allow'],
                                        'exam_day'=>$values['exam_day'],
                                        'position_show'=>$values['position_show'],
                                        'type_access_owner'=>$values['type_access_owner'],
                                        'status'=>true,
                                        'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                        'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                        'academic_year_id'=>$request->academic_year_id,
                                        'academic_class_id'=>$request->academic_class_id,
                                        'academic_department_id'=>$request->academic_department_id,
                                    ];
                                }
                            }
                        }
                    }

                    $presentTableIDArray[$key]=array_merge($presentID);
                }


                if(count($charges)>0){
                    $this->siteGroupExaminationExamTypeSettingStore->insert($charges);
                }

                $collection = collect($presentTableIDArray);
                $examinationArrayCollapsed = ($collection->collapse())->unique();
                $examinationAbsentCheck=array_diff($presentIDArray->toArray(), $examinationArrayCollapsed->toArray());
                $this->siteGroupExaminationExamTypeSettingStore->whereIn('id', $examinationAbsentCheck)->delete();

            }

        }
        else{

            $presentIDArray=$siteGroupExaminationExamTypePresent->pluck('id');
            $charges=[];
            $presentID=Array();
            $presentTableIDArray=[];
            foreach ($request->examinationExamTypeList as $key => $value) {

                if($value['select_examination_id']){
                    foreach ($value['exam_type_list'] as $keys => $values) {
                        if($values['select_exam_type_id']){
                            $checkPresentData=$siteGroupExaminationExamTypePresent
                                ->where('examination_id',$value['id'])
                                ->where('academic_exam_type_id',$values['id'])
                                ->first();

                            if($checkPresentData){
                                $checkPresentData->direct_result_input=$value['direct_result_input']?true:false;
                                $checkPresentData->routine_wise_exam_attendace=$value['routine_wise_exam_attendace']?true:false;
                                $checkPresentData->site_attendace_permission=$value['site_attendace_permission']?true:false;
                                $checkPresentData->site_exam_mark_entry_permission=$value['site_exam_mark_entry_permission']?true:false;
                                $checkPresentData->examiner_exam_mark_entry_permission=$value['examiner_exam_mark_entry_permission']?true:false;
                                $checkPresentData->exam_mark_entry_deadline=$value['exam_mark_entry_deadline'];
                                $checkPresentData->retack_allow=$value['retack_allow'];
                                $checkPresentData->exam_day=$values['exam_day'];
                                $checkPresentData->position_show=$values['position_show'];
                                $checkPresentData->type_access_owner=$values['type_access_owner'];
                                $checkPresentData->academic_year_id=$request->academic_year_id;
                                $checkPresentData->academic_class_id=$request->academic_class_id;
                                $checkPresentData->academic_department_id=$request->academic_department_id;
                                $checkPresentData->save();
                                $presentID[$keys]=$checkPresentData->id;
                            }else{
                                $charges[] = [
                                    'examination_id'=>$value['id'],
                                    'academic_exam_type_id'=>$values['id'],
                                    'direct_result_input'=>$value['direct_result_input']?true:false,
                                    'routine_wise_exam_attendace'=>$value['routine_wise_exam_attendace']?true:false,
                                    'site_attendace_permission'=>$value['site_attendace_permission']?true:false,
                                    'site_exam_mark_entry_permission'=>$value['site_exam_mark_entry_permission']?true:false,
                                    'examiner_exam_mark_entry_permission'=>$value['examiner_exam_mark_entry_permission']?true:false,
                                    'exam_mark_entry_deadline'=>$value['exam_mark_entry_deadline'],
                                    'retack_allow'=>$value['retack_allow']?true:false,
                                    'exam_day'=>$values['exam_day'],
                                    'position_show'=>$values['position_show'],
                                    'type_access_owner'=>$values['type_access_owner'],
                                    'status'=>true,
                                    'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                    'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                    'academic_year_id'=>$request->academic_year_id,
                                    'academic_class_id'=>$request->academic_class_id,
                                    'academic_department_id'=>$request->academic_department_id,
                                ];
                            }
                        }
                    }
                }

                $presentTableIDArray[$key]=array_merge($presentID);
            }

            if(count($charges)>0){
                $this->siteGroupExaminationExamTypeSettingStore->insert($charges);
            }

            $collection = collect($presentTableIDArray);
            $examinationArrayCollapsed = ($collection->collapse())->unique();
            $examinationAbsentCheck=array_diff($presentIDArray->toArray(), $examinationArrayCollapsed->toArray());
           $this->siteGroupExaminationExamTypeSettingStore->whereIn('id', $examinationAbsentCheck)->delete();
        }

        $examinationExamTypeAllPresent=$this->globalSiteExaminationExamTypeSetting
            ->where('academic_group_id', $academic_group_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
           // ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->whereHas('examination', function ($query) {
                $query->where('use_key', 'site_group');
            })
            ->get();

        $simpleAllExaminationExamTypePresent=$this->globalSiteExaminationExamTypeSetting
            ->where('academic_group_id', $academic_group_id)
          //  ->where('examination_id', $request->examination_id)
            ->whereNull('academic_year_id')
            ->whereNull('academic_class_id')
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->whereNull('academic_department_id');
            })
            ->get();

        foreach($request->site_ids as $site_id){

        $examinationExamTypePresent=$examinationExamTypeAllPresent->where('site_id',$site_id);
        if(count($examinationExamTypePresent)<=0){
            $simpleExaminationExamTypePresent=$simpleAllExaminationExamTypePresent->where('site_id',$site_id);
            if(count($simpleExaminationExamTypePresent)<=0){
                $charges=[];
                foreach ($request->examinationExamTypeList as $key => $value) {
                    if($value['select_examination_id']){
                        foreach ($value['exam_type_list'] as $keys => $values) {
                            if($values['select_exam_type_id']){
                                $charges[] = [
                                    'examination_id'=>$value['id'],
                                    'academic_exam_type_id'=>$values['id'],
                                    'direct_result_input'=>$value['direct_result_input']?true:false,
                                    'routine_wise_exam_attendace'=>$value['routine_wise_exam_attendace']?true:false,
                                    'site_attendace_permission'=>$value['site_attendace_permission']?true:false,
                                    'site_exam_mark_entry_permission'=>$value['site_exam_mark_entry_permission']?true:false,
                                    'examiner_exam_mark_entry_permission'=>$value['examiner_exam_mark_entry_permission']?true:false,
                                    'exam_mark_entry_deadline'=>$value['exam_mark_entry_deadline'],
                                    'retack_allow'=>$value['retack_allow'],
                                    'exam_day'=>$values['exam_day'],
                                    'position_show'=>$values['position_show'],
                                    'type_access_owner'=>$values['type_access_owner'],
                                    'status'=>true,
                                    'site_id'=>$site_id,
                                    'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                    'academic_year_id'=>$request->academic_year_id,
                                    'academic_class_id'=>$request->academic_class_id,
                                    'academic_department_id'=>$request->academic_department_id,
                                ];
                            }
                        }
                    }
                }

                if(count($charges)>0){
                    $this->globalSiteExaminationExamTypeSetting->insert($charges);
                }
            }
            else{

                $presentIDArray=$simpleExaminationExamTypePresent->pluck('id');
                $charges=[];
                $presentID=Array();
                $presentTableIDArray=[];
                foreach ($request->examinationExamTypeList as $key => $value) {
                    if($value['select_examination_id']){
                        foreach ($value['exam_type_list'] as $keys => $values) {
                            if($values['select_exam_type_id']){
                                $checkPresentData=$simpleExaminationExamTypePresent
                                    ->where('examination_id',$value['id'])
                                    ->where('academic_exam_type_id',$values['id'])
                                    ->first();
                                if($checkPresentData){
                                    $checkPresentData->retack_allow=$value['retack_allow'];
                                    $checkPresentData->direct_result_input=$value['direct_result_input']?true:false;
                                    $checkPresentData->routine_wise_exam_attendace=$value['routine_wise_exam_attendace']?true:false;
                                    $checkPresentData->site_attendace_permission=$value['site_attendace_permission']?true:false;
                                    $checkPresentData->site_exam_mark_entry_permission=$value['site_exam_mark_entry_permission']?true:false;
                                    $checkPresentData->examiner_exam_mark_entry_permission=$value['examiner_exam_mark_entry_permission']?true:false;
                                    $checkPresentData->exam_mark_entry_deadline=$value['exam_mark_entry_deadline'];
                                    $checkPresentData->exam_day=$values['exam_day'];
                                    $checkPresentData->position_show=$values['position_show'];
                                    $checkPresentData->type_access_owner=$values['type_access_owner'];
                                    $checkPresentData->academic_year_id=$request->academic_year_id;
                                    $checkPresentData->academic_class_id=$request->academic_class_id;
                                    $checkPresentData->academic_department_id=$request->academic_department_id;
                                    $checkPresentData->save();
                                    $presentID[$keys]=$checkPresentData->id;
                                }else{
                                    $charges[] = [
                                        'examination_id'=>$value['id'],
                                        'academic_exam_type_id'=>$values['id'],
                                        'direct_result_input'=>$value['direct_result_input']?true:false,
                                        'routine_wise_exam_attendace'=>$value['routine_wise_exam_attendace']?true:false,
                                        'site_attendace_permission'=>$value['site_attendace_permission']?true:false,
                                        'site_exam_mark_entry_permission'=>$value['site_exam_mark_entry_permission']?true:false,
                                        'examiner_exam_mark_entry_permission'=>$value['examiner_exam_mark_entry_permission']?true:false,
                                        'exam_mark_entry_deadline'=>$value['exam_mark_entry_deadline'],
                                        'retack_allow'=>$value['retack_allow'],
                                        'exam_day'=>$values['exam_day'],
                                        'position_show'=>$values['position_show'],
                                        'type_access_owner'=>$values['type_access_owner'],
                                        'status'=>true,
                                        'site_id'=>$site_id,
                                        'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                        'academic_year_id'=>$request->academic_year_id,
                                        'academic_class_id'=>$request->academic_class_id,
                                        'academic_department_id'=>$request->academic_department_id,
                                    ];
                                }

                            }

                        }

                    }

                    $presentTableIDArray[$key]=array_merge($presentID);

                }

                if(count($charges)>0){
                    $this->globalSiteExaminationExamTypeSetting->insert($charges);
                }
                $collection = collect($presentTableIDArray);
                $examinationArrayCollapsed = ($collection->collapse())->unique();
                $examinationAbsentCheck=array_diff($presentIDArray->toArray(), $examinationArrayCollapsed->toArray());
                $this->globalSiteExaminationExamTypeSetting->whereIn('id', $examinationAbsentCheck)->delete();
            }

        }
        else{

            $presentIDArray=$examinationExamTypePresent->pluck('id');
            $charges=[];
            $presentID=Array();
            $presentTableIDArray=[];
            foreach ($request->examinationExamTypeList as $key => $value) {
                if($value['select_examination_id']){
                    foreach ($value['exam_type_list'] as $keys => $values) {
                        if($values['select_exam_type_id']){
                            $checkPresentData=$examinationExamTypePresent
                                ->where('examination_id',$value['id'])
                                ->where('academic_exam_type_id',$values['id'])
                                ->first();
                            if($checkPresentData){
                                $checkPresentData->direct_result_input=$value['direct_result_input']?true:false;
                                $checkPresentData->routine_wise_exam_attendace=$value['routine_wise_exam_attendace']?true:false;
                                $checkPresentData->site_attendace_permission=$value['site_attendace_permission']?true:false;
                                $checkPresentData->site_exam_mark_entry_permission=$value['site_exam_mark_entry_permission']?true:false;
                                $checkPresentData->examiner_exam_mark_entry_permission=$value['examiner_exam_mark_entry_permission']?true:false;
                                $checkPresentData->exam_mark_entry_deadline=$value['exam_mark_entry_deadline'];
                                $checkPresentData->retack_allow=$value['retack_allow'];
                                $checkPresentData->exam_day=$values['exam_day'];
                                $checkPresentData->position_show=$values['position_show'];
                                $checkPresentData->type_access_owner=$values['type_access_owner'];
                                $checkPresentData->academic_year_id=$request->academic_year_id;
                                $checkPresentData->academic_class_id=$request->academic_class_id;
                                $checkPresentData->academic_department_id=$request->academic_department_id;
                                $checkPresentData->save();
                                $presentID[$keys]=$checkPresentData->id;
                            }else{
                                $charges[] = [
                                    'examination_id'=>$value['id'],
                                    'academic_exam_type_id'=>$values['id'],
                                    'direct_result_input'=>$value['direct_result_input']?true:false,
                                    'routine_wise_exam_attendace'=>$value['routine_wise_exam_attendace']?true:false,
                                    'site_attendace_permission'=>$value['site_attendace_permission']?true:false,
                                    'site_exam_mark_entry_permission'=>$value['site_exam_mark_entry_permission']?true:false,
                                    'examiner_exam_mark_entry_permission'=>$value['examiner_exam_mark_entry_permission']?true:false,
                                    'exam_mark_entry_deadline'=>$value['exam_mark_entry_deadline'],
                                    'retack_allow'=>$value['retack_allow']?true:false,
                                    'exam_day'=>$values['exam_day'],
                                    'position_show'=>$values['position_show'],
                                    'type_access_owner'=>$values['type_access_owner'],
                                    'status'=>true,
                                    'site_id'=>$site_id,
                                    'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                    'academic_year_id'=>$request->academic_year_id,
                                    'academic_class_id'=>$request->academic_class_id,
                                    'academic_department_id'=>$request->academic_department_id,
                                ];
                            }

                        }

                    }

                }

                $presentTableIDArray[$key]=array_merge($presentID);
            }

            if(count($charges)>0){
                $this->globalSiteExaminationExamTypeSetting->insert($charges);
            }

            $collection = collect($presentTableIDArray);
            $examinationArrayCollapsed = ($collection->collapse())->unique();
            $examinationAbsentCheck=array_diff($presentIDArray->toArray(), $examinationArrayCollapsed->toArray());
            $this->globalSiteExaminationExamTypeSetting->whereIn('id', $examinationAbsentCheck)->delete();
        }
      }
        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
    }
}