<?php

namespace App\Http\Controllers\SiteGroup\Fee\Report;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Academic\AcademicClass;
use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\GlobalSiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\SiteGroup\GlobalSiteGroup;
use Error;
use PDF;
use Exception;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class SiteGroupStudentFeeController extends SiteGroupProjectController
{
    public $StudentAttendance;
    private $site, $GlobalStudentHistory;
    public function __construct(GlobalStudentHistory $GlobalStudentHistory)
    {
        $this->GlobalStudentHistory = $GlobalStudentHistory;
    }
    public function index()
    {
        $viewType = "Site Group Student List";
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function getGroupStudentGeneralFeeList(Request $request)
    {
        $data = [
            'academic_class_id' => $request->academic_class_id ?? null,
            'academic_year_id' => $request->academic_year_id ?? null,
            'academic_group_id' => session()->get('ACADEMIC_GROUP_ID') ?? null,
            'academic_version_id' => $request->academic_version_id ?? null,
            'academic_shift_id' => $request->academic_shift_id ?? null,
            'academic_session_id' => $request->academic_session_id ?? null,
            'academic_student_admission_type_id' => $request->academic_student_admission_type_id ?? null,
            'academic_student_category_id' => $request->academic_student_category_id ?? null,
            'academic_student_type_id' => $request->academic_student_type_id ?? null,
            'academic_class_group_id' => $request->academic_class_group_id ?? null,
            'site_id' => $request->site_id ?? null,
            'start_date' => $request->start_date ?? null,
            'end_date' => $request->end_date ?? null,
        ];

        $final_data = [];
        $gross_generate = $gross_paid = $gross_waiver = $gross_fine = 0;

        $siteLists = $data['site_id'] ?
            GlobalSiteInfo::where('id', $data['site_id'])->get() :
            GlobalSiteInfo::whereIn('id', $this->siteIds())->orderByDesc('id')->get();

        foreach ($siteLists as $site) {
            $site_id = $site->id;

            $studentHistories = $this->GlobalStudentHistory
                ->where('site_id', $site_id)
                ->when($data['academic_version_id'], fn($q) => $q->where('academic_version_id', $data['academic_version_id']))
                ->when($data['academic_shift_id'], fn($q) => $q->where('academic_shift_id', $data['academic_shift_id']))
                ->when($data['academic_year_id'], fn($q) => $q->where('academic_year_id', $data['academic_year_id']))
                ->when($data['academic_class_id'], fn($q) => $q->where('academic_class_id', $data['academic_class_id']))
                ->when($data['academic_class_group_id'], fn($q) => $q->where('academic_class_group_id', $data['academic_class_group_id']))
                ->when($data['academic_session_id'], fn($q) => $q->where('academic_session_id', $data['academic_session_id']))
                ->when($data['academic_student_admission_type_id'], fn($q) => $q->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']))
                ->when($data['academic_student_category_id'], fn($q) => $q->where('academic_student_category_id', $data['academic_student_category_id']))
                ->when($data['academic_student_type_id'], fn($q) => $q->where('academic_student_type_id', $data['academic_student_type_id']))
                ->where('academic_group_id', $data['academic_group_id'])
                ->where('status', true)
                ->select('id', 'user_id')
                ->get();

            if ($studentHistories->isEmpty()) {
                continue;
            }

            $studentHistoryIds = $studentHistories->pluck('id');

            $paymentHistories = GlobalSiteStudentFeePaymentHistory::whereIn('student_history_id', $studentHistoryIds)
                ->where('site_id', $site_id)
                ->where('academic_group_id', $data['academic_group_id'])
                ->when($data['start_date'] && $data['end_date'], fn($q) => $q->whereBetween('payment_date', [$data['start_date'], $data['end_date']]))
                ->get()->groupBy('student_history_id');

            $feeFines = GlobalSiteStudentFeeFine::whereIn('student_history_id', $studentHistoryIds)
                ->where('site_id', $site_id)
                ->where('academic_group_id', $data['academic_group_id'])
                ->get()->groupBy('student_history_id');

            $demandSlipDetails = GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIds)
                ->where('site_id', $site_id)
                ->where('academic_group_id', $data['academic_group_id'])
                ->get()->groupBy('student_history_id');

            $allGenerateIds = $demandSlipDetails->flatMap(fn($group) => $group->pluck('site_student_fee_generate_ids')->flatMap(fn($v) => explode(',', $v)))->unique();
            $allWaiverIds = $demandSlipDetails->flatMap(fn($group) => $group->pluck('site_student_fee_waiver_offer_history_ids')->flatMap(fn($v) => explode(',', $v)))->unique();

            $feeGenerateMap = GlobalSiteStudentFeeGenerate::whereIn('id', $allGenerateIds)->get()->keyBy('id');
            $waiverMap = GlobalSiteStudentFeeWaiverOfferHistory::whereIn('id', $allWaiverIds)->get()->keyBy('id');

            $site_total_generate = $site_total_paid = $site_total_waiver = $site_total_fine = 0;

            foreach ($studentHistories as $student) {
                $generate_amount = $waiver_amount = $fine_amount = $paid_amount = 0;

                $stdDetails = $demandSlipDetails[$student->id] ?? collect();
                $generate_ids = $stdDetails->pluck('site_student_fee_generate_ids')->flatMap(fn($v) => explode(',', $v))->unique();
                $waiver_ids = $stdDetails->pluck('site_student_fee_waiver_offer_history_ids')->flatMap(fn($v) => explode(',', $v))->unique();

                foreach ($generate_ids as $id) {
                    $generate_amount += $feeGenerateMap[$id]->amount ?? 0;
                }

                foreach ($waiver_ids as $id) {
                    $waiver = $waiverMap[$id] ?? null;
                    if ($waiver) {
                        if ($waiver->percantage_status) {
                            $relatedFee = GlobalSiteStudentFeeGenerate::where('student_history_id', $student->id)
                                ->where('site_student_fee_fine_allocation_id', $waiver->site_student_fee_fine_allocation_id)
                                ->first();
                            if ($relatedFee) {
                                $waiver_amount += ($relatedFee->amount * $waiver->amount) / 100;
                            }
                        } else {
                            $waiver_amount += $waiver->amount;
                        }
                    }
                }

                $paid_amount = ($paymentHistories[$student->id] ?? collect())->sum('paid_amount');
                $fine_amount = ($feeFines[$student->id] ?? collect())->sum('fine_amount');

                $site_total_generate += $generate_amount;
                $site_total_paid += $paid_amount;
                $site_total_waiver += $waiver_amount;
                $site_total_fine += $fine_amount;
            }

            $total_payable = ($site_total_generate + $site_total_fine) - $site_total_waiver;
            $total_due = $total_payable - $site_total_paid;

            $class = AcademicClass::find($data['academic_class_id']);

            $final_data[] = [
                'total_generate_amount' => $site_total_generate,
                'total_paid_amount' => $site_total_paid,
                'total_waiver_amount' => $site_total_waiver,
                'total_fine_amount' => $site_total_fine,
                'total_due_amount' => $total_due,
                'total_payable_amount' => $total_payable,
                'class_name' => $class->class_name ?? 'All class',
                'site_name' => $site->site_name,
            ];

            $gross_generate += $site_total_generate;
            $gross_paid += $site_total_paid;
            $gross_waiver += $site_total_waiver;
            $gross_fine += $site_total_fine;
        }

        $gross_total_payable = ($gross_generate + $gross_fine) - $gross_waiver;
        $gross_total_due = $gross_total_payable - $gross_paid;

        $gross_report = [
            'gross_total_generate_amount' => $gross_generate,
            'gross_total_paid_amount' => $gross_paid,
            'gross_total_waiver_amount' => $gross_waiver,
            'gross_total_fine_amount' => $gross_fine,
            'gross_total_due_amount' => $gross_total_due,
            'gross_total_payable_amount' => $gross_total_payable,
        ];

        return [$final_data, $gross_report];
    }
    public function GeneralReportPdf(Request $request)
    {

        $data = $this->getGroupStudentGeneralFeeList($request);
        $final_data = $data[0];
        $gross_report = $data[1];

        $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();
        $pdf = PDF::loadView(
            'default.admin.site_group.fee.student-general-report-pdf',
            compact(
                'final_data',
                'gross_report',
                'SiteGroupInfo',
            )
        )
            ->setPaper('a4', 'portrait')
            ->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';
        $route_name = route('open-pdf-file-storage-for-group', [$name]);




        return response()->json(['route_name' => $route_name], 200);
    }
}
