<?php

namespace App\Http\Controllers\SiteGroup\Fee;

use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Examinations\Examination;
use App\Models\Site\Fee\GlobalSiteFeeGenerate;
use App\Models\Site\Fee\GlobalSiteStudentFeeFineAllocation;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\SiteGroupSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\Fee\SiteGroupFeeSubHeadAllocation;
use App\Models\Student\StudentHistory;
use App\Models\User\GlobalUser;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use phpDocumentor\Reflection\Types\Array_;
use Response;
use Session;

class SiteGroupFeeGenerateController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
    }

    public function getSiteGroupAcademicGroupBaseSiteList(Request $request){


        $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');

        $siteList=GlobalSiteInfo::select('id')
            ->whereIn('id',$siteIDs)
            ->get();


        $siteGroupfeeHeadIDs=SiteGroupFeeSubHeadAllocation::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->distinct('academic_fee_head_id')
            ->pluck('academic_fee_head_id');

        $siteGroupFeeHeadList=AcademicFeeHead::whereIn('id', $siteGroupfeeHeadIDs)->get();


        return response()->json([$siteList, $siteGroupFeeHeadList], 200, []);

    }







    public function getSiteFeeHeadBaseTypeList(Request $request){


        if( $request->checked_fee_head_id!=null){

            $feeheadlist=AcademicFeeHead::where('id', $request->checked_fee_head_id)->first();
            $headBaseValue=null;
            $headBaseTypelist=Array();
            if($feeheadlist->head_key=='monthly'){
                $headBaseTypelist=AcademicMonthName::get();
                $headBaseValue='monthly';
            }
            else if($feeheadlist->head_key=='examination'){

                $selectedSiteGroupList=GlobalSiteInfoSetting::where('site_id',$request->checked_site_id)
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->first();
                $Examinationlist= Examination::whereIn('id', explode(',', $selectedSiteGroupList->examination_ids))->get();

                $headBaseTypelist=[];
                $headBaseTypelistArr=Array();
                foreach ($Examinationlist as $key => $value) {

                    $headBaseTypelistArr['id']=$value->id;
                    $headBaseTypelistArr['name']=$value->examination_name;

                    $headBaseTypelist[$key]=array_merge($headBaseTypelistArr);
                }
                $headBaseValue='examination';

            }
            else if($feeheadlist->head_key=='admission'){

                $headBaseTypelist=AcademicAdmissionFeeType::get();
                $headBaseValue='admission';

            }
            else if($feeheadlist->head_key=='general'){

                $headBaseTypelist=AcademicGeneralFeeType::get();
                $headBaseValue='general';

            }


        }

        return response()->json([$headBaseValue, $headBaseTypelist], 200, []);


    }







    public function getSiteClassDeptfeeHeadBaseFee(Request $request){



        $siteGroupFeeList=$this->returnSiteGroupFeeList($request);
        $siteStudentIDs=$this->returnSiteStudentIDs($request);

     //   dd($siteStudentIDs);

//        $siteStudentList=GlobalUser::whereIn('id',$siteStudentIDs)
//            ->select('id',)

        $siteGroupFeeListIDs=[];
        foreach ($siteGroupFeeList as $key => $value) {
            $siteGroupFeeListIDs[]=$value['id'];
        }


        if($request->student_histories_id){
            $studentFeeGeneratedList=GlobalSiteStudentFeeGenerate::where('site_id', $request->checked_site_id)
                ->whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
                ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                ->where('student_history_id', $request->student_histories_id)
                ->get();

            if(count($studentFeeGeneratedList)>0){
                $feeGeneratedList=$studentFeeGeneratedList;
            }else{
                $feeGeneratedList=GlobalSiteFeeGenerate::where('site_id', $request->checked_site_id)
                    ->whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
                    ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                    ->get();
            }



        }else{
            $feeGeneratedList=GlobalSiteFeeGenerate::where('site_id', $request->checked_site_id)
                ->whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
                ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                ->get();
        }

        $siteGroupFeeFinalList=[];
        $siteGroupFeeFinalArr=Array();
        foreach ($siteGroupFeeList as $key => $value) {

            $checkIfPresent=$feeGeneratedList->where('site_student_fee_fine_allocation_id',$value['id']);

            if(count($checkIfPresent)>0){

                $siteGroupFeeFinalArr['select_fee_sub_head_id']=true;
            }else{
                $siteGroupFeeFinalArr['select_fee_sub_head_id']=false;
            }
            $siteGroupFeeFinalList[$key]=array_merge($siteGroupFeeFinalArr, $value);

        }


        return response()->json([$siteGroupFeeFinalList, $siteStudentIDs], 200, []);

    }




    private function returnSiteGroupFeeList(Request $request){
        $data = $request->all();

        $FeeGroupsGlobalID=AcademicFeeGroup::whereIn('head_key', ['global'])->pluck('id');

        $FeeGroupsClassStudentID=AcademicFeeGroup::whereIn('head_key', ['classbase','studentbase'])->pluck('id');

        $siteGroupFeeList=Array();
        if($request->checked_site_id!=null && $request->checked_fee_head_id!=null && $request->academic_class_id!=null){

            $SiteFeeList=GlobalSiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
                ->where('site_group_id',Session::get('SITE_GROUP_ID'))
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                ->where('site_id',$request->checked_site_id)
                ->where('academic_fee_head_id',$request->checked_fee_head_id)
                ->where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->get();

            $siteGlobalFeeList=$SiteFeeList
                ->whereIn('academic_fee_group_id', $FeeGroupsGlobalID)
                ->where('academic_class_id', null)
                ->where('academic_department_id', null);

            $siteClassStudentFeeList=$SiteFeeList
                ->whereIn('academic_fee_group_id', $FeeGroupsClassStudentID)
                ->where('academic_class_id',$request->academic_class_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                });

            if($request->academic_student_category_id!=null || $request->academic_student_type_id!=null
                || $request->academic_student_admission_type_id!=null)
            {
                $siteGroupFeeList=$siteClassStudentFeeList;

            }else{
                $siteGroupFeeList=array_merge($siteGlobalFeeList->toArray(), $siteClassStudentFeeList->toArray());
            }

        }

        return $siteGroupFeeList;
    }



    private function returnSiteStudentIDs(Request $request){

        $data = $request->all();

        if($request->academic_class_id){

            if($request->academic_class_group_present){

                $siteStudentIDs=GlobalStudentHistory::with(['student'=>function($query){
                    $query->select('id');
                }])
                    ->where('site_id',$request->checked_site_id)
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id','user_id']);



            }else{

                $siteStudentIDs=GlobalStudentHistory::with(['student'=>function($query){
                    $query->select('id');
                }])

                    ->where('site_id',$request->checked_site_id)
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id','user_id']);

            }

        }

        return $siteStudentIDs;

    }









    public function createUpdateSiteGroupFeeGenerate(Request $request){



        $data = $request->all();

        if($request->academic_class_group_present){

            $siteStudentIDs=GlobalStudentHistory::where('site_id',$request->checked_site_id)
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                ->where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->where('academic_class_id',$request->academic_class_id)
                ->where('status',true)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->get(['id','user_id']);



        }else{

            $siteStudentIDs=GlobalStudentHistory::where('site_id',$request->checked_site_id)
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                ->where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->where('academic_class_id',$request->academic_class_id)
                ->where('status',true)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->get(['id','user_id', 'academic_student_category_id',
                    'academic_student_type_id', 'academic_student_admission_type_id', 'academic_residence_id',
                    'academic_quata_id','academic_transport_id']);

        }



        $siteGroupFeeList=$this->returnSiteGroupFeeList($request);

        $siteGroupFeeListIDs=[];
        foreach ($siteGroupFeeList as $key => $value) {
            $siteGroupFeeListIDs[]=$value['id'];
        }








        if ($request->fee_head_name == 'monthly') {
            $checked_admission_examination_general_ids = $request->select_month_ids;
        } else {
            $checked_admission_examination_general_ids[] = $request->checked_admission_examination_general_id;
        }


        $presentSiteFeeGenerateList = GlobalSiteFeeGenerate::where('site_id', $request->checked_site_id)
            ->whereIn('fee_head_type_id', $checked_admission_examination_general_ids)
            ->whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
            ->get();




        $presentSiteStudentFeeGenerateList = GlobalSiteStudentFeeGenerate::where('site_id', $request->checked_site_id)
            ->whereIn('fee_head_type_id',$checked_admission_examination_general_ids)
            ->whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
            ->get();







        $chargest = [];
        $charges = [];

        foreach ($checked_admission_examination_general_ids as $ket => $typeid) {


            $presentSiteFeeGenerate = $presentSiteFeeGenerateList->where('fee_head_type_id', $typeid);

            $presentSiteStudentFeeGenerate = $presentSiteStudentFeeGenerateList->where('fee_head_type_id', $typeid);


            $checkAlreadyPaymentCreate=GlobalSiteFeeGenerate::whereIn('site_student_fee_fine_allocation_id',$siteGroupFeeListIDs)
                ->where('fee_head_type_id', $typeid)
                ->where('status',false)
                ->first();




            if (!$checkAlreadyPaymentCreate) {


                if (!($request->student_histories_id)) {

                    $editedFeeGenerateIDs=[];
                    foreach ($request->siteBaseFeeList as $keys => $values) {
                        if ($values['select_fee_sub_head_id']) {

                            $checkPresentSiteFeeGenerate = $presentSiteFeeGenerate
                                ->where('site_student_fee_fine_allocation_id', $values['id'])
                                ->first();

                            if ($checkPresentSiteFeeGenerate) {
                                $editedFeeGenerateIDs[] = $checkPresentSiteFeeGenerate->id;


                                $checkPresentSiteFeeGenerate->amount = $values['amount'];
                                $checkPresentSiteFeeGenerate->save();

                            } else {
                                $chargest[] = [
                                    'site_student_fee_fine_allocation_id' => $values['id'],
                                    'fee_head_type_id' => $typeid,
                                    'amount' => $values['amount'],
                                    'status' => true,
                                    'site_id' => $request->checked_site_id,
                                    'site_group_id' => Session::get('SITE_GROUP_ID'),
                                    'academic_fee_head_id' => $request->checked_fee_head_id,
                                ];
                            }

                        }
                    }



                    if (!$checkAlreadyPaymentCreate) {
                        $siteFeeGeneratePresentIDArr=$presentSiteFeeGenerateList->where('fee_head_type_id', $typeid)->pluck('id');
                        $siteFeeGenerateidCheck=array_diff($siteFeeGeneratePresentIDArr->toArray(), $editedFeeGenerateIDs);
                        GlobalSiteFeeGenerate::whereIn('id', $siteFeeGenerateidCheck)->update(['status' => false]);;
                    }

                }


            }




            if ($request->student_histories_id) {

                $checkAlreadyPaymentCreate=GlobalSiteStudentFeeGenerate::whereIn('site_student_fee_fine_allocation_id',$siteGroupFeeListIDs)
                    ->where('fee_head_type_id', $typeid)
                    ->where('student_history_id', $request->student_histories_id)
                    ->where('status',false)
                    ->first();

                if(!$checkAlreadyPaymentCreate){
                    $siteStudentIDsList = GlobalStudentHistory::where('site_id', $request->checked_site_id)
                        ->where('id', $request->student_histories_id)
                        ->get(['id', 'user_id', 'academic_student_category_id',
                            'academic_student_type_id', 'academic_student_admission_type_id', 'academic_residence_id',
                            'academic_quata_id', 'academic_transport_id']);
                }else{
                    $siteStudentIDsList=Array();
                }

            }
            else{

                if (!$checkAlreadyPaymentCreate) {
                    $siteStudentIDsList=$siteStudentIDs;
                }else{
                    $siteStudentIDsList=Array();
                }

            }






            if(count($siteStudentIDsList)>0) {

                $editedStudentFeeFenerateIDs=[];
                $studentIDs=[];
                foreach ($siteStudentIDsList as $key => $value) {
                    $studentIDs[]=$value->id;



                    foreach ($request->siteBaseFeeList as $keys => $values) {


                        if ($values['select_fee_sub_head_id']) {


                            if ($values['academic_fee_sub_head']['head_key'] == 'general') {

                                if ($values['academic_student_category_id']) {
                                    if ($values['academic_student_category_id'] == $value->academic_student_category_id) {


                                        $checkPresentSiteStudentFeeGenerate = $presentSiteStudentFeeGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentFeeGenerate) {

                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentFeeGenerate->id;


                                            $checkPresentSiteStudentFeeGenerate->amount = $values['amount'];
                                            $checkPresentSiteStudentFeeGenerate->save();
                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'amount' => $values['amount'],
                                                'status' => true,
                                                'site_id' => $request->checked_site_id,
                                                'site_group_id' => Session::get('SITE_GROUP_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                            ];
                                        }


                                    }
                                } else if ($values['academic_student_admission_type_id']) {
                                    if ($values['academic_student_admission_type_id'] == $value->academic_student_admission_type_id) {

                                        $checkPresentSiteStudentFeeGenerate = $presentSiteStudentFeeGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentFeeGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentFeeGenerate->id;


                                            $checkPresentSiteStudentFeeGenerate->amount = $values['amount'];
                                            $checkPresentSiteStudentFeeGenerate->save();
                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'amount' => $values['amount'],
                                                'status' => true,
                                                'site_id' => $request->checked_site_id,
                                                'site_group_id' => Session::get('SITE_GROUP_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                            ];
                                        }

                                    }
                                } else if ($values['academic_student_type_id']) {
                                    if ($values['academic_student_type_id'] == $value->academic_student_type_id) {

                                        $checkPresentSiteStudentFeeGenerate = $presentSiteStudentFeeGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentFeeGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentFeeGenerate->id;


                                            $checkPresentSiteStudentFeeGenerate->amount = $values['amount'];
                                            $checkPresentSiteStudentFeeGenerate->save();
                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'amount' => $values['amount'],
                                                'status' => true,
                                                'site_id' => $request->checked_site_id,
                                                'site_group_id' => Session::get('SITE_GROUP_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                            ];
                                        }

                                    }
                                } else {
                                    $checkPresentSiteStudentFeeGenerate = $presentSiteStudentFeeGenerate
                                        ->where('student_history_id', $value->id)
                                        ->where('site_student_fee_fine_allocation_id', $values['id'])
                                        ->where('fee_head_type_id', $typeid)
                                        ->first();

                                    if ($checkPresentSiteStudentFeeGenerate) {
                                        $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentFeeGenerate->id;


                                        $checkPresentSiteStudentFeeGenerate->amount = $values['amount'];
                                        $checkPresentSiteStudentFeeGenerate->save();
                                    } else {
                                        $charges[] = [
                                            'student_history_id' => $value->id,
                                            'site_student_fee_fine_allocation_id' => $values['id'],
                                            'fee_head_type_id' => $typeid,
                                            'amount' => $values['amount'],
                                            'status' => true,
                                            'site_id' => $request->checked_site_id,
                                            'site_group_id' => Session::get('SITE_GROUP_ID'),
                                            'academic_fee_head_id' => $request->checked_fee_head_id,
                                        ];
                                    }
                                }

                            } else if ($values['academic_fee_sub_head']['head_key'] == 'transport') {

                                if ($value->academic_transport_id) {
                                    if ($values['academic_fee_sub_head']['head_key_base_id'] == $value->academic_transport_id) {

                                        $checkPresentSiteStudentFeeGenerate = $presentSiteStudentFeeGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentFeeGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentFeeGenerate->id;


                                            $checkPresentSiteStudentFeeGenerate->amount = $values['amount'];
                                            $checkPresentSiteStudentFeeGenerate->save();
                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'amount' => $values['amount'],
                                                'status' => true,
                                                'site_id' => $request->checked_site_id,
                                                'site_group_id' => Session::get('SITE_GROUP_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                            ];
                                        }


                                    }
                                }


                            } else if ($values['academic_fee_sub_head']['head_key'] == 'residance') {


                                if ($value->academic_residence_id) {
                                    if ($values['academic_fee_sub_head']['head_key_base_id'] == $value->academic_residence_id) {

                                        $checkPresentSiteStudentFeeGenerate = $presentSiteStudentFeeGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentFeeGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentFeeGenerate->id;


                                            $checkPresentSiteStudentFeeGenerate->amount = $values['amount'];
                                            $checkPresentSiteStudentFeeGenerate->save();
                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'amount' => $values['amount'],
                                                'status' => true,
                                                'site_id' => $request->checked_site_id,
                                                'site_group_id' => Session::get('SITE_GROUP_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                            ];
                                        }

                                    }
                                }

                            } else if ($values['academic_fee_sub_head']['head_key'] == 'gender') {


                                if ($value->gender_id) {
                                    if ($values['academic_fee_sub_head']['head_key_base_id'] == $value->gender_id) {

                                        $checkPresentSiteStudentFeeGenerate = $presentSiteStudentFeeGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentFeeGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentFeeGenerate->id;


                                            $checkPresentSiteStudentFeeGenerate->amount = $values['amount'];
                                            $checkPresentSiteStudentFeeGenerate->save();
                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'amount' => $values['amount'],
                                                'status' => true,
                                                'site_id' => $request->checked_site_id,
                                                'site_group_id' => Session::get('SITE_GROUP_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                            ];
                                        }

                                    }
                                }

                            }


                        }


                    }


                }




                $siteStudentFeeGeneratePresentIDArr=$presentSiteStudentFeeGenerateList
                    ->where('fee_head_type_id', $typeid)
                    ->whereIn('student_history_id', $studentIDs)
                    ->pluck('id');
                $siteStudentFeeGenerateidCheck=array_diff($siteStudentFeeGeneratePresentIDArr->toArray(), $editedStudentFeeFenerateIDs);
                GlobalSiteStudentFeeGenerate::whereIn('id', $siteStudentFeeGenerateidCheck)->update(['status' => false]);;



            }




        }



        if(count($chargest)>0){
            GlobalSiteFeeGenerate::insert($chargest);
        }


        if(count($charges)>0){
            GlobalSiteStudentFeeGenerate::insert($charges);
        }




        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);






    }














}
