<?php

namespace App\Http\Controllers\SiteGroup\Fee;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Examinations\Examination;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeeFineAllocation;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\GlobalSiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Student\StudentHistory;
use App\Models\User\GlobalUser;
use App\Models\User\User;
use Auth;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class SiteGroupPaymentSlipGenerateController extends ProjectController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
    }


    public function getDemandListForPayment(Request $request){


        if($request->student_user_number){
            $userList=GlobalUser::where('username', $request->student_user_number)->select('id')->first();
            $studentHistoryIDList=GlobalStudentHistory::where('user_id',$userList->id)->where('status',1)->pluck('id');

            $demanSlipId=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
                ->where('status',1)
                ->orderBy('id', 'desc')
                ->first();

            if(!$demanSlipId){
                $paidDemanSlipId=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
                    ->where('status',false)
                    ->orderBy('id', 'desc')
                    ->first();
                if($paidDemanSlipId){
                    return Response::json(['message' => 'There are no rest Demand Slip!', 'mode' => 'Error!'],411);
                }

            }

            $slip_number = $demanSlipId->id;
            $slip_no = $demanSlipId->id+100000;
        }else if($request->demand_slip_no){
            $slip_number = $request->demand_slip_no - 100000;
            $slip_no = $request->demand_slip_no;

        }

        $paidDemanSlipIdcheck=GlobalSiteStudentFeeDemandSlipDetails::where('id', $slip_number)
            ->first();

        if(!$paidDemanSlipIdcheck){
            return Response::json(['message' => 'Invalid Demand Slip!', 'mode' => 'Error!'],411);
        }else{
            if($paidDemanSlipIdcheck->status==false){
                return Response::json(['message' => 'This Demand Slip Amount Is Paid!', 'mode' => 'Error!'],411);
            }
        }





        $demand_slip_details = GlobalSiteStudentFeeDemandSlipDetails::where('id', $slip_number)->first();
        $student_details = GlobalStudentHistory::
        with(['student','stClass','accGroup','section', 'department'])
            ->where('id',$demand_slip_details->student_history_id)
            ->first();



        $user_details = User::where('id',$demand_slip_details->created_by)->first();
        $user_name = $user_details->first_name;

        $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
        $fee_generate_list = GlobalSiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();


        $waiver_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);
        $waiver_generate_list = GlobalSiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generate_id_splite)->get();



        //==================Fee List=========
        $fee_allocation_details_array = [];
        $fee_allocation_details_arr = Array();
        foreach ($fee_generate_list as $key => $value){

            $fee_allocation_detail= GlobalSiteStudentFeeFineAllocation::
            with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                ->where('id',$value->site_student_fee_fine_allocation_id)->first();


                if ($fee_allocation_detail->academicFeeHead->head_key == 'admission'){
                    $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

                }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly'){
                    $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

                }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination'){
                    $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details_arr['fee_type_name'] = $fee_type->examination_name;

                }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general'){
                    $fee_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
                }


            $fee_allocation_details_arr['academic_fee_head']=$fee_allocation_detail->academicFeeHead;
            $fee_allocation_details_arr['academic_fee_sub_head']=$fee_allocation_detail->academicFeeSubHead;


            $fee_allocation_details_array[$key]=array_merge($fee_allocation_details_arr, $value->toArray());


        }

        $fee_allocation_details=collect($fee_allocation_details_array);
        $total_in_word = $this->convertNumberToWord($demand_slip_details->total_amount);
        $total_amount =  $demand_slip_details->total_amount;


        $fee_allocation_details_list=$this->feeHeadSubHeadTypeMultiStemArray($fee_allocation_details);







            //==================Waiver List =========
        $waiver_allocation_details_array = [];
        $waiver_allocation_details_arr = Array();
        foreach ($waiver_generate_list as $key => $value){


            if($value->site_student_fee_fine_allocation_id){


                $waiver_allocation_detail= GlobalSiteStudentFeeFineAllocation::
                with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                    ->where('id',$value->site_student_fee_fine_allocation_id)->first();


                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
                    $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
                    $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
                    $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->examination_name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
                    $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                }

                $waiver_allocation_details_arr['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                $waiver_allocation_details_arr['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;


                $waiver_allocation_details_array[$key]=array_merge($waiver_allocation_details_arr, $value->toArray());
            }

        }
        $waiver_allocation=collect($waiver_allocation_details_array);



        $waiver_allocation_details=$this->feeHeadSubHeadTypeMultiStemArray($waiver_allocation);


        $finalArray=compact('demand_slip_details','student_details','slip_no',
        'fee_allocation_details_list', 'waiver_allocation_details', 'total_amount','user_name','total_in_word');

        return $finalArray;
    }



    private function feeHeadSubHeadTypeMultiStemArray($fee_allocation_details){

        $head_Id=$fee_allocation_details->pluck('academic_fee_head.id')->unique();
        $fee_head_list=AcademicFeeHead::get();

        
        $fee_head_arr=Array();
        $fee_head_array=[];
        foreach ($head_Id as $key => $value){

            $head_list=$fee_head_list->where('id',$value)->first();

            $fee_head_arr['id']=$value;
            $fee_head_arr['name']=$head_list->name;


            $fee_head_pre_array=[];
            foreach ($fee_allocation_details as $keys => $values){
                if($value==$values['academic_fee_head']['id']){

                    $fee_head_pre_array[$keys]=$values;
                }
            }

            $fee_head_pre_array_collect=collect($fee_head_pre_array);
            $fee_head_pre_array_collect_id= $fee_head_pre_array_collect->pluck('fee_head_type_id')->unique();


            $fee_head_type_arr=Array();
            $fee_head_type_array=[];
            $sub_head_full_count=[];
            foreach ($fee_head_pre_array_collect_id as $keyt => $valuet){

                $fee_head_type_listt=$fee_head_pre_array_collect->where('fee_head_type_id', $valuet)->first();

                $fee_head_type_arr['fee_type_id']=$valuet;
                $fee_head_type_arr['fee_type_name']=$fee_head_type_listt['fee_type_name'];


                $fee_head_type_pre_array=[];
                foreach ($fee_head_pre_array_collect as $keytt => $valuett){

                    if($valuet==$valuett['fee_head_type_id']){
                        $fee_head_type_pre_array[$keytt]=$valuett;
                    }
                }

                $fee_head_type_arr['fee_sub_head_count']=count($fee_head_type_pre_array);
                $fee_head_type_arr['fee_sub_head']=$fee_head_type_pre_array;

                $sub_head_full_count[$keyt]=count($fee_head_type_pre_array);

                $fee_head_type_array[$keyt]=array_merge($fee_head_type_arr);

            }

            $fee_head_arr['head_type_base_sub_head_count']=array_sum($sub_head_full_count);
            $fee_head_arr['head_type']=$fee_head_type_array;

            $fee_head_array[$key]=array_merge($fee_head_arr);
        }
        $fee_allocation_details_list=collect($fee_head_array);

        return $fee_allocation_details_list;
    }





    public function createSiteGroupBaseSingleStudentFeePayment(GlobalSiteStudentFeePaymentHistory $payment, Request $request){

        $slip_id=$request->slip_no-100000;

        $demandslipid=GlobalSiteStudentFeeDemandSlipDetails::where('id',$slip_id)
            ->first();



        $getLastPaymentSlipNo=$payment->where('site_id',$demandslipid->site_id)->orderBy('id','desc')->first();


        $newPaymentSlipNo=($getLastPaymentSlipNo?$getLastPaymentSlipNo->voucher_no:1000)+1;



        $payment->academic_group_id=Session::get('ACADEMIC_GROUP_ID');
        $payment->student_history_id=$demandslipid->student_history_id;
        $payment->site_student_fee_demand_slip_details_id=$demandslipid->id;
        $payment->paid_amount=$request->paid_amount;
        $payment->due_amount=($request->total_amount)-($request->paid_amount);
        $payment->voucher_no=$newPaymentSlipNo;
        $payment->created_by=Auth::user()->id;
        $payment->site_id=$demandslipid->site_id;
        $payment->site_group_id=Session::get('SITE_GROUP_ID');
        $payment->status=true;
        $payment->payment_date=Carbon::today();
        $payment->save();



        $demandslipid->status=false;
        $demandslipid->save();

        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);


    }









    public function getMultipleStudentDemandSlipListForPayment(Request $request){


        $data = $request->all();


        if($request->academic_class_id){

            if($request->academic_class_group_present){

                $siteStudentIDs=GlobalStudentHistory::with(['student'=>function($query){
                    $query->select('id', 'username');
                },'stClass','accGroup','section', 'department',
                    'siteStudentFeeDemandSlipDetails'=>function($query){
                        $query->where('status', true);


                    }])
                    ->where('site_id',$request->checked_site_id)
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))

                    ->when(!empty($data['student_history_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_history_id']);
                    })

                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id','user_id', 'site_id', 'academic_class_id', 'academic_class_group_id',
                        'academic_session_id', 'academic_department_id']);



            }else{

                $siteStudentIDs=GlobalStudentHistory::with(['student'=>function($query){
                    $query->select('id', 'username');
                },'stClass','accGroup','section', 'department',
                    'siteStudentFeeDemandSlipDetails'=>function($query){
                        $query->where('status', true);

                    }])
                    ->where('site_id',$request->checked_site_id)
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))

                    ->when(!empty($data['student_history_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_history_id']);
                    })

                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id','user_id', 'site_id', 'academic_class_id', 'academic_class_group_id',
                        'academic_session_id', 'academic_department_id']);

            }

        }

        return $siteStudentIDs;



    }





    public function createSiteGroupBaseMultipleStudentPayment(GlobalSiteStudentFeePaymentHistory $payment, Request $request){

        $demandSlipIDs=[];
        foreach ($request->select_student_for_fee as $key => $value){

            $SiteStudentFeeDemandList=$request->SiteStudentFeeDemandList;
            $SiteStudentFeeDemandListCollecton=collect($SiteStudentFeeDemandList);

            $checkPaymentSelect=$SiteStudentFeeDemandListCollecton->where('id',$value)->first();


            if($checkPaymentSelect){
                $getLastPaymentSlipNo=$payment->where('site_id',$checkPaymentSelect['site_id'])->orderBy('id','desc')->first();
                $newPaymentSlipNo=($getLastPaymentSlipNo?$getLastPaymentSlipNo->voucher_no:1000)+1;



                $MultiplePayment=new GlobalSiteStudentFeePaymentHistory();


                $MultiplePayment->academic_group_id=Session::get('ACADEMIC_GROUP_ID');
                $MultiplePayment->student_history_id=$value['id'];
                $MultiplePayment->site_student_fee_demand_slip_details_id=$checkPaymentSelect['site_student_fee_demand_slip_details']['id'];
                $MultiplePayment->paid_amount=$checkPaymentSelect['site_student_fee_demand_slip_details']['total_amount'];
                $payment->due_amount=0;
                $MultiplePayment->voucher_no=$newPaymentSlipNo;
                $MultiplePayment->created_by=Auth::user()->id;
                $MultiplePayment->site_id=$checkPaymentSelect['site_id'];
                $MultiplePayment->site_group_id=Session::get('SITE_GROUP_ID');
                $MultiplePayment->status=true;
                $MultiplePayment->payment_date=Carbon::today();
                $MultiplePayment->save();




                $demandSlipIDs[]=$checkPaymentSelect['site_student_fee_demand_slip_details']['id'];


            }


        }


        GlobalSiteStudentFeeDemandSlipDetails::whereIn('id', $demandSlipIDs)
            ->update(['status' => false]);

//        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);



    }






}
