<?php

namespace App\Http\Controllers\SiteGroup\Quiz;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use App\Models\SiteGroup\Quiz\SiteGroupQuiz;
use App\Models\SiteGroup\Quiz\SiteGroupQuizDeclares;
use App\Models\SiteGroup\Quiz\SiteGroupQuizDeclareSettings;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use Auth;
use Response;
use DB;
use Exception;
use Illuminate\Validation\Rules\Unique;
use Session;

class SiteGroupQuizDeclareController extends SiteGroupProjectController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');

    }

    //
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = "Site Group Quiz Declare";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function createQuiz(Request $request){


      //  dd($request->all());


        try{
         //   $site_id = Session::get('SITE_ID');
    
            $this->validate($request, [
                'quiz_name' => 'required',
            ]);
          
            $quiz = new SiteGroupQuiz();
            $quiz->quiz_name = $request->quiz_name;
            $quiz->quiz_key = $request->quiz_key;
            $quiz->quiz_note = $request->quiz_note;
            $quiz->status = $request->status;

            $quiz->save();
    
            return response()->json(['message'=>'Quiz Add Successfully', 'status'=>true]);
    
        }catch (ValidationException $exception) {
                DB::rollBack();
                return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
            } catch (Exception $exception) {
                DB::rollBack();
                return Response::json(['message' => $exception->getMessage()], 410);
            }
    
    }

    
    public function getQuizlist(){
        $quiz_list = SiteGroupQuiz::orderBy('id', 'DESC')->paginate(10);
 
        return response()->json(['quiz_list'=>$quiz_list]);
     }

     
    public function quizEdit(Request $request){
        $quiz_item = SiteGroupQuiz::findOrFail($request->quiz_id);

        return response()->json(['quiz_item'=>$quiz_item],200);

    }


    public function quizUpate(Request $request){
        try{
            $this->validate($request, [
                'quiz_name' => 'required',
            ]);

          
            $quiz =  SiteGroupQuiz::findOrFail($request->id);
            $quiz->quiz_name = $request->quiz_name;
            $quiz->quiz_key = $request->quiz_key;
            $quiz->quiz_note = $request->quiz_note;
            $quiz->status = $request->status;
            $quiz->save();
    
            return response()->json(['message'=>'Quiz Update Successfully', 'status'=>true]);
    
        }catch (ValidationException $exception) {
                DB::rollBack();
                return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
            } catch (Exception $exception) {
                DB::rollBack();
                return Response::json(['message' => $exception->getMessage()], 410);
            }

        }


        public function quizDelete(Request $request){
            DB::beginTransaction();
            try{
            $quiz =  SiteGroupQuiz::findOrFail($request->quiz_id);
             if($quiz->delete()){

                $declareQuiz =  SiteGroupQuizDeclares::where('quiz_id',$request->quiz_id);
                $declareQuiz_ids=$declareQuiz->pluck('id');
                if($declareQuiz->delete()){
                    SiteGroupQuizDeclareSettings::whereIn('quiz_declare_id',$declareQuiz_ids)->delete();
                    DB::table('quiz_declare_students')->whereIn('quiz_declare_id',$declareQuiz_ids)->delete();
                    DB::table('student_quiz_answer_details')->whereIn('quiz_declare_id',$declareQuiz_ids)->delete();
                
                }
                $quiz->delete();
                return response()->json(['message'=>'Quiz Delete Successfully', 'status'=>true]);
                DB::commit();
            }
        }catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }

            public function groupSiteList(){
                try{

                
                $siteIDs=$this->siteIds();
                $siteList=GlobalSiteInfo::select('id')
                    ->whereIn('id',$siteIDs)
                    ->get();

                return $siteList;
                }catch (Exception $exception) {
                    return Response::json(['message' => $exception->getMessage()], 410);
                }
        
            }

            public function getActiveQuizList(){

                $quiz_list = SiteGroupQuiz::orderBy('id', 'DESC')->where('status',1)->get();
 
                return $quiz_list;
        
            }

            public function checkGroupQuizForEdit(Request $requests){
                try{
                $data[] = $requests->all();
                $quizDeclareInfo = SiteGroupQuizDeclares::with('quizDeclareSettings')
                            ->where('quiz_id',$requests->quiz_id)
                            ->where('academic_year_id',$requests->academic_year_id)
                            ->orderBy('id','DESC')
                            ->first();

                $checkQuizDeclared = SiteGroupQuizDeclares::where('academic_year_id',$requests->academic_year_id)
                    ->where('quiz_id', $requests->quiz_id)
                    ->get();

                        
                    $declare_site_ids = $checkQuizDeclared->pluck('site_id')->unique()->filter();
                return response()->json(['quizDeclareInfo'=>$quizDeclareInfo, 'declare_site_ids'=>$declare_site_ids],200);
            }catch (ValidationException $exception) {
                DB::rollBack();
                return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
            } catch (Exception $exception) {
                DB::rollBack();
                return Response::json(['message' => $exception->getMessage()], 410);
            }
            }

            public function createGroupBaseNewQuizDeclare(Request $requests, SiteGroupQuizDeclares $siteGroupQuizDeclares){

                $data[]=$requests->all();
                 DB::beginTransaction();

                    try {
         
                     $this->validate($requests, [
                         'academic_year_id' => 'required',
                         'quiz_id' => 'required',
                         'start_date' => 'required',
                         'start_time' => 'required',
                         'end_time' => 'required',
                         'duration' => 'required',
                         'question_per_student' => 'required',
                         'select_site_info_ids' => 'required',
                         
                     ]);


                     $QuizDeclared=$siteGroupQuizDeclares
                     ->where('academic_year_id', $requests->academic_year_id)
                     ->where('quiz_id', $requests->quiz_id)
                     ->get();


                   
                     if($requests->select_site_info_ids){
                        foreach($requests->select_site_info_ids as $site_id){
                       
                            $checkQuizDeclared=$QuizDeclared->where('site_id', $site_id)
                            ->first();
                        if($checkQuizDeclared){
                       
                            $siteQuizDeclareId = $checkQuizDeclared->id;
       
                            $quizDeclareSetting = SiteGroupQuizDeclareSettings::where('quiz_declare_id',$siteQuizDeclareId)->first();
                        
                            $quizDeclareSetting->start_date = $requests->start_date;
                            $quizDeclareSetting->start_time =date("H:i", strtotime($requests->start_time));
                            $quizDeclareSetting->end_time = date("H:i", strtotime($requests->end_time));
                            $quizDeclareSetting->start_date_time = $requests->start_date.' '.date("H:i", strtotime($requests->start_time));
                            $quizDeclareSetting->end_date_time = $requests->start_date.' '.date("H:i", strtotime($requests->end_time));

                            $quizDeclareSetting->duration = $requests->duration;
                            $quizDeclareSetting->question_per_student = $requests->question_per_student;
                            $quizDeclareSetting->result_show_to_student_panel_status = $requests->result_show_to_student_panel_status;
                            $quizDeclareSetting->is_start = 1;
                            $quizDeclareSetting->save();
                               
                        }else{
                            $quiz_declare = new SiteGroupQuizDeclares();
                            $quiz_declare->academic_year_id=$requests->academic_year_id;
                            $quiz_declare->quiz_id=$requests->quiz_id;
                            $quiz_declare->site_id=$site_id;
                            $quiz_declare->declare_key='group';
                            $quiz_declare->created_by=Auth::user()->id;
                            $quiz_declare->status=true;
                            if($quiz_declare->save()){

                                $siteQuizDeclareId = $quiz_declare->id;
                                
                                $quizDeclareSetting = new SiteGroupQuizDeclareSettings();
                
                                $quizDeclareSetting->quiz_declare_id = $siteQuizDeclareId;
                                $quizDeclareSetting->start_date = $requests->start_date;
                                $quizDeclareSetting->start_time =date("H:i", strtotime($requests->start_time));
                                $quizDeclareSetting->end_time = date("H:i", strtotime($requests->end_time));
                                $quizDeclareSetting->start_date_time = $requests->start_date.' '.date("H:i", strtotime($requests->start_time));
                                $quizDeclareSetting->end_date_time = $requests->start_date.' '.date("H:i", strtotime($requests->end_time));

                                $quizDeclareSetting->duration = $requests->duration;
                                $quizDeclareSetting->question_per_student = $requests->question_per_student;
                                $quizDeclareSetting->result_show_to_student_panel_status = $requests->result_show_to_student_panel_status;
                                $quizDeclareSetting->is_start = 1;
                
                                $quizDeclareSetting->save();
                
                            }
                        }
                
                           }
                     }
                 
                    DB::commit();
                  
                     return Response::json(['message' => 'Save Successfully!', 'mode' => 'success'], 200);
         
                 } catch (ValidationException $exception) {
                     DB::rollBack();
                     return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
                 } catch (Exception $exception) {
                     DB::rollBack();
                     return Response::json(['message' => $exception->getMessage()], 410);
                 }
             }

             public function siteGroupQuizDeclareList(Request $request){
                $site_ids=$this->siteIds();
                $site_quiz_declare_list = SiteGroupQuizDeclares::
                    with('quiz','year','siteInfo','quizDeclareSettings')
                    ->when(!empty($request->quiz_id),function($q) use ($request) {
                        $q->where('quiz_id',$request->quiz_id);
                    })
                    ->whereIn('site_id',$site_ids)
                    ->withCount('quizDeclareStudents')
                    ->get();

                return $site_quiz_declare_list;

             }

             public function siteGroupBasedeclareQuizDelete($declare_id){
                DB::beginTransaction();

                try{
                $declare_quiz =  SiteGroupQuizDeclares::findOrFail($declare_id);

                if($declare_quiz->delete()){
                    SiteGroupQuizDeclareSettings::where('quiz_declare_id',$declare_id)->delete();
                    DB::table('quiz_declare_students')->where('quiz_declare_id',$declare_id)->delete();
                    DB::table('student_quiz_answer_details')->where('quiz_declare_id',$declare_id)->delete();
                  
                }
                DB::commit();
                return response()->json(['message'=>'Declare Quiz Delete Successfully', 'status'=>true]);
            }catch (ValidationException $exception) {
                DB::rollBack();
                return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
            } catch (Exception $exception) {
                DB::rollBack();
                return Response::json(['message' => $exception->getMessage()], 410);
            }
            
            }


          
        
        }

