<?php

namespace App\Http\Controllers\SiteGroup;

use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoTranslation;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SiteGroup\Role\SiteGroupRole;
use App\Models\User\User;
use App\Traits\SmsFunctionsTrait;
use Auth;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\ValidationException;
use Response;
use Session;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfo\GlobalSiteInfo;


class SiteGroupUserController extends ProjectController
{

    use SmsFunctionsTrait;

    private $user;

    public function __construct(User $user)
    {

        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->user = $user;

    }

    public function index()
    {
        $viewType = 'Site Group User List';

//        dd(Session::get('SITE_GROUP_ID'));
//
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.site_group.user.site-group-user-list', compact('viewType'));
    }

    //only site group user list
    public function siteGroupUserList()
    {
        try {
            $user = User::select('id', 'username', 'email', 'contact_number', 'status')->get();
            return $user;
        } catch (ModelNotFoundException $exception) {

            return JsonResponse::create(['message' => 'User Not Found'], 410);

        } catch (Exception $exception) {

            return JsonResponse::create(['message' => $exception->getMessage(), 410]);
        }
    }


    //only site group user list
    public function getsiteGroupUserListWithPagination()
    {
        try {
            
            // $user = User::select('id', 'username', 'email', 'contact_number', 'status')->paginate(10);
            // return $user;

            $site_group_id = (int)session()->get('SITE_GROUP_ID');
            $userWithPagination = User::with(['siteGroupRoles', 'siteInfoes'])
                ->orderBy('id','DESC')
                ->select('id', 'username', 'email', 'phone', 'status')
                ->paginate(10);
              //  dd($userWithPagination);
            $siteGroupRole = SiteGroupRole::all();
        //    $siteList = SiteInfo::where('site_group_id', $site_group_id)->get();

            $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))->pluck('id');
                   
            $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');
            $siteList=GlobalSiteInfo::select('id')
                ->whereIn('id',$siteIDs)
                ->get();
          
            return response()->json([$userWithPagination, $siteGroupRole, $siteList], 200);


        } catch (ModelNotFoundException $exception) {

            return JsonResponse::create(['message' => 'User Not Found'], 410);

        } catch (Exception $exception) {

            return JsonResponse::create(['message' => $exception->getMessage(), 410]);
        }
    }

    //get site group user list and role list
    public function getSiteGroupUserListAndRoleListAndSiteList()
    {

        try {
            $site_group_id = (int)session()->get('SITE_GROUP_ID');
            $userWithPagination = $this->user
                ->with(['siteGroupRoles', 'siteInfoes'])
                ->orderBy('id', 'DESC')
                ->select('id', 'username', 'email', 'contact_number', 'status')
                ->paginate(10);
            $siteGroupRole = SiteGroupRole::all();
            $siteList = SiteInfo::where('site_group_id', $site_group_id)->get();

            return response()->json([$userWithPagination, $siteGroupRole, $siteList], 200);


        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'User Or Role Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 410]);
        }
    }

    public function siteGroupUserStore(Request $request)
    {
   //     dd($request->all());
        try {
            $this->validate($request, [
                'username' => 'required|unique:users',  //unique:table name
                'password' => 'required',  //unique:table name
                'email' => 'required|unique:users',  //unique:table name
                'phone' => 'required',  //unique:table name
            ]);


            $send_sms = $request->sendSms;

            $this->user->username = $request->get('username');
            $this->user->password = $request->get('password');
            $this->user->email = $request->get('email');
            $this->user->phone = $request->get('phone');
            $this->user->status = $request->get('status');
            $this->user->alias = session()->get('ALIAS1');

            if ($this->user->save()) {
                $role_ids = $request->siteGroupRolecheckbox;
                $site_id = $request->siteListcheckbox;
                $this->user->siteGroupRoles()->sync($role_ids);
                $this->user->siteInfoes()->sync($site_id);


                if ($send_sms && $request->phone) {

                    $this->sendSmsToUser($this->user, $request->password, 'User Details Created For ');

                    return Response::json(['message' => 'Updated Successfully With SMS', 'mode' => 'Saved!'], 200);
                }
                return Response::json(['message' => 'Save Successfully!'], 200);
            }

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }


    public function update(Request $request, $id)
    {
        try {

            $this->validate($request, [
                'username' => 'required|unique:users,username,' . $id . ',id',
                'email' => 'required|unique:users,email,' . $id . ',id',
                'phone' => 'required',

            ]);

            $eduUserToEdit = $this->user->findOrFail($id);

            $eduUserToEdit->first_name = $request->get('first_name');
            $eduUserToEdit->last_name = $request->get('last_name');
            $eduUserToEdit->email = $request->get('email');

            if ($request->password) $eduUserToEdit->password = $request->password;

            $eduUserToEdit->phone = $request->get('phone');
            $eduUserToEdit->status = $request->get('status');

            $send_sms = $request->sendSms;


            $role_ids = $request->siteGroupRolecheckbox;
            $eduUserToEdit->siteGroupRoles()->sync($role_ids);

            $site_id = $request->siteListcheckbox;
            $eduUserToEdit->siteInfoes()->sync($site_id);

            if ($eduUserToEdit->save()) {

                if ($send_sms && $request->phone) {
                    $this->sendSmsToUser($eduUserToEdit, $request->password, 'User Details Updated For ');
                    return Response::json(['message' => 'Updated Successfully With SMS', 'mode' => 'Saved!'], 200);
                }

                return Response::json(['message' => 'Successfully Updated!'], 200);
            }
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    private function sendSmsToUser(User $user, $password, $text)
    {
        try {


            //   $url = config('app.url');
            //  $parsedUrl = parse_url($url);
            $type_id = Session::get('SITE_GROUP_ID');
            $site_g = GlobalSiteGroup::findOrFail(Session::get('SITE_GROUP_ID'));
            //$sub_domain = $parsedUrl['scheme'] . '://' . $site_g->group_alias . '.' . $parsedUrl['host'];

            $url = $this->getDomain($site_g->group_alias);


            $sms_txt = $user->full_name;
            $sms_txt .= '[nl]' . $url;
            $sms_txt .= '[nl]' . 'Username: ' . $user->username;
            $sms_txt .= '[nl]' . 'Password: ' . $password;
            $sms_txt .= '[nl]' . 'Regards: ' . $site_g->name;


            $rr = $this->sendSmsUsingQueue([$user->phone], $sms_txt, 'site_group', $type_id);


            //  $this->sendSms([$user->contact_number], arrayToString($data));

            return true;
        } catch (Exception $exception) {

        }

    }


}
