<?php

namespace App\Http\Controllers\Timetable;

use App\Forms\DataHelper;
use App\Http\Controllers\ProjectController;
use App\Models\Setting\Setting;
use App\Models\Site\Routine\ClassTiming;
use App\Models\Site\Routine\WeekdayClassTiming;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Student\Section;
use App\Models\Student\StudentClass;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Response;

class WeekdayClassTimingController extends ProjectController
{
    use DataHelper;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    private $weekdayClassTiming;
    private $setting;
    private $classTiming;
    private $class;
    private $section;
    private $siteShiftClassGroupSectionSetting;


    public function __construct(WeekdayClassTiming $weekdayClassTiming, Setting $setting, ClassTiming $classTiming, StudentClass $class, Section $section, SiteShiftClassGroupSectionSetting $siteShiftClassGroupSectionSetting)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->weekdayClassTiming = $weekdayClassTiming;
        $this->setting = $setting;
        $this->classTiming = $classTiming;
        $this->class = $class;
        $this->section = $section;
        $this->siteShiftClassGroupSectionSetting = $siteShiftClassGroupSectionSetting;
    }


    public function index()
    {
        $viewType = 'Weekday';
        return view('default.admin.weekday-class-timing.index', compact('viewType'));
    }


    public function weekdayListForSection(Request $request)
    {
//        dd('h');

        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;

            //   dd($data);


            $get_section_class_group_detail = $this->siteShiftClassGroupSectionSetting
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->first();


            if (!$get_section_class_group_detail) {
                return Response::json(['message' => 'No "SiteShiftClassGroupSectionSetting" Found! Go: <a href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);
            }


            $classTiming = $this->classTiming->all();
            $weekDays = $this->getWeekDay();
            $weekday_list = [];

            $weekdayClassTiming = $this->weekdayClassTiming
                ->where('academic_version_id', $data['academic_version_id'])
                // ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->where('academic_section_id', $data['academic_section_id'])
                ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->first();

//            dd($weekdayClassTiming);


            // return $weekdayClassTiming;

            if ($weekdayClassTiming) {
                $timing = json_decode($weekdayClassTiming->weekday_timing_info, true);
                foreach ($weekDays as $dayk => $day) {
                    foreach ($timing as $k => $value) {
                        if ($day->weekday_key == $k) {
                            $weekday_list[$dayk]['status'] = true;
                            $weekday_list[$dayk]['weekday_name'] = $day->weekday_name;
                            $weekday_list[$dayk]['weekday_key'] = $day->weekday_key;
                            $weekday_list[$dayk]['timing_id'] = $value;
                            break;
                        } else {
                            $weekday_list[$dayk]['status'] = false;
                            $weekday_list[$dayk]['weekday_name'] = $day->weekday_name;
                            $weekday_list[$dayk]['weekday_key'] = $day->weekday_key;
                            $weekday_list[$dayk]['timing_id'] = null;
                        }
                    }
                }

            } else {

                $this->checkClassSection($data);// check only if data not found . if found show them otherwise

                foreach ($weekDays as $dayk => $day) {
                    $weekday_list[$dayk]['status'] = true;
                    $weekday_list[$dayk]['weekday_name'] = $day->weekday_name;
                    $weekday_list[$dayk]['weekday_key'] = $day->weekday_key;
                    $weekday_list[$dayk]['timing_id'] = null;
                }

            }
            $weekday_class_timing_id = $weekdayClassTiming->id ?? null;


            return Response::json([$weekday_class_timing_id, $weekday_list, $classTiming], 200);


        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);

        }
    }

    public function saveWeekdayListForSection(WeekdayClassTiming $weekdayClassTiming, Request $request)
    {

        try {

            $this->validate($request, [
                'academic_version_id' => 'required',
                'academic_year_id' => 'required',
                'academic_shift_id' => 'required',
                'academic_class_id' => 'required',

            ]);

            $weekday_list = [];

            $check = WeekdayClassTiming::where('id', $request->weekday_class_timing_id)->first();

            if ($check) {

                foreach ($request->weekday_timing_info as $k => $value) {
                    if ($value['status'] == true && $value['timing_id'] == null) {
                        return Response::json(['message' => 'Please Select Timing'], 422);
                    } else if ($value['status'] == true && $value['timing_id'] != null) {
                        $weekday_list[$value['weekday_key']] = $value['timing_id'];
                    }
                }

                $check->update([

                    'weekday_timing_info' => json_encode($weekday_list),
                    'academic_version_id' => $request->academic_version_id,
                    'academic_department_id' => $request->academic_department_id,
                    'academic_class_id' => $request->academic_class_id,
                    'academic_section_id' => $request->academic_section_id,
                    'site_batch_detail_id' => $request->site_batch_detail_id,
                    'academic_shift_id' => $request->academic_shift_id,
                    'academic_class_group_id' => $request->academic_class_group_id,
                    'academic_session_id' => $request->academic_session_id,

                ]);


                return JsonResponse::create([
                    'message' => 'Successfully Updated!',
                    'mode' => 'Updated!',
                ]);

            } else {//new


                foreach ($request->weekday_timing_info as $k => $value) {

                    if ($value['status'] == true && $value['timing_id'] == null) {
                        return Response::json(['message' => 'Please Select Timing'], 422);
                    } else if ($value['status'] == true && $value['timing_id'] != null) {
                        $weekday_list[$value['weekday_key']] = $value['timing_id'];
                    }
                }
                $weekday_timing_info = json_encode($weekday_list);
                $weekdayClassTiming->academic_version_id = $request->academic_version_id;
                $weekdayClassTiming->academic_department_id = $request->academic_department_id;
                // $weekdayClassTiming->academic_year_id = $request->academic_year_id;
                $weekdayClassTiming->academic_class_id = $request->academic_class_id;
                $weekdayClassTiming->academic_section_id = $request->academic_section_id;
                $weekdayClassTiming->academic_shift_id = $request->academic_shift_id;
                $weekdayClassTiming->academic_class_group_id = $request->academic_class_group_id;
                $weekdayClassTiming->academic_session_id = $request->academic_session_id;
                $weekdayClassTiming->weekday_timing_info = $weekday_timing_info;
                $weekdayClassTiming->save();

                return Response::json(['message' => 'Save Successfully!'], 200);
            }


        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 412);
        }
    }


}
