<?php

namespace App\Http\Controllers\User;

use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Forms\UserForm;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Mail\SendMailToUserWithQueue;
use App\Models\AddFieldTable\AddFieldToTable;
use App\Models\Image\Photo;
use App\Models\Site\SiteInfo;
use App\Models\Media\Media;
use App\Models\Role\Role;

use Error;
use Exception;
use Hash;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Requests;
 use App\User;
//use App\Models\User\User;
use Illuminate\Support\Facades\Session;
use App\Http\Requests\Validator;
use App\Models\Notification\Notification;
use Illuminate\Validation\ValidationException;
use Image;
use Intervention\Image\Facades\Image as InterImage;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use DB;
use Illuminate\Support\Facades\Auth;
use Mail;
use Response;


class UsersController extends ProjectController
{
    use Lang, FormControll, DataHelper;

    private $user;
    private $fileName;
    private $extension;


    /**
     * UsersController constructor.
     * @param User $user
     */
    public function __construct(User $user)
    {

        $this->middleware('auth');

        $this->user = $user;

    }

    /**
     * $userList and $dataArr from  App\Lists\UserList containing the array and the model to pass
     * for creating dynamic lists
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(User $employee, Role $role)
    {
        //dd('ok');
        $viewType = 'Employee List';

        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $roleId = $this->role('employee');
        $roleOfEmployee = $role->findOrFail($roleId);
        $employeeList = $roleOfEmployee->users()->orderBy('id', 'DESC')->paginate(20);

//dd($employeeList);
        return view('default.admin.users.index', compact('employeeList', 'viewType', 'model', 'roleOfEmployee', 'locale', 'defaultLocale'));
    }

    public function getNotifications()
    {
        
     //   $user_id=Auth::user();

     $user=auth()->user();

    //     auth()->user()->unreadNotifications);
        

    //     $user_id=Auth::user()->id;

    //     $user=User::find($user_id);
    //    return $user;

        return [
            'read' => Auth::user()->readNotifications,
            'unread' => $user->unreadNotifications
        ];

    }

    public function getNoticeListWithPaginationForViewAllPage(Request $request)
    {
        try {

            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;

            $user_id=Auth::user()->id;
            $user=User::find($user_id);

            $notices =$user
                ->notifications()
                ->paginate($paginate);

         //   auth()->user()->unreadNotifications->markAsRead();


            return response()->json([$notices]);

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }


    public function viewNotification($id)//notice id
    {

        try {
            $viewType = 'View Notice';

            return view('default.admin.layouts.master', compact('viewType'));
            return view('default.admin.notice.view', compact('viewType', 'notification'));

        } catch (Exception $exception) {
            return view('default.no-permission', compact('message', 'title', 'viewType'));
            //  throw new Error($exception->getMessage());
        }
    }

    public function viewEmpLeaveNotification($id)//notice id
    {

        try {
            $viewType = 'View Notification';
            $title = 'View Notification';
            $message = 'No Notification Found!';
            $notification = auth()->user()->notifications()->findOrFail($id);

            //   dd($notification);

            $notification->markAsRead();

            return view('default.admin.site.Notification.emp-leave', compact('viewType', 'notification'));
        } catch (Exception $exception) {
            return view('default.no-permission', compact('message', 'title', 'viewType'));
            //  throw new Error($exception->getMessage());
        }
    }

    public function viewEmpLeaveApplicationNotification($id)//notice id
    {

        try {
            $viewType = 'View Notification';
            $title = 'View Notification';
            $message = 'No Notification Found!';
            $notification = auth()->user()->notifications()->findOrFail($id);

            //   dd($notification);

            $notification->markAsRead();

            return view('default.admin.site.Notification.emp-leave-application', compact('viewType', 'notification'));
        } catch (Exception $exception) {
            return view('default.no-permission', compact('message', 'title', 'viewType'));
            //  throw new Error($exception->getMessage());
        }
    }


    public function viewAllNotice()
    {
        $viewType = 'View All Notice';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.notice.view-all', compact('viewType'));


    }

    public function myInvitation()
    {
        $viewType = 'Meeting Invitation';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function profilePage(Request $request)
    {
        if ($request->ajax() || $request->isJson()) {

            $user = Auth::user();
            $user_id = $user->id;
            $user_type = $user->user_type;
            $the_user = $this->user
                ->with(['latestPhoto' => function ($q) use ($user_type, $user_id) {
                    $q->when($user_type == 'student', function ($q1) use ($user_id) {
                        $q1->where('imageable_type', 'App\Models\Site\Student\Student');
                    });
                    $q->when($user_type == 'employee', function ($q1) use ($user_id) {
                        $q1->where('imageable_type', 'App\Models\Site\Employee\Employee');
                    });
                }])->findOrFail($user_id);


            $data = [
                'id' => $the_user->id,
                'email' => $the_user->email,
                'contact_number' => $the_user->contact_number,
                'date_of_birth' => $the_user->date_of_birth,
                'blood_group' => $the_user->bloodGroup->blood_group_name ?? '',
                'latest_photo' => $the_user->latestPhoto->path ?? '/uploads/image-not.png',
            ];


            return Response::json($data, 200);
        }
        $viewType = 'Profile View';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function updateProfile(Request $request)
    {
        try {


            $this->validate($request, [
                'email' => 'required',
            ]);

            $user_id = Auth::user()->id;
            $the_user = $this->user->findOrFail($user_id);
            if (!$the_user->can_update) {
                return JsonResponse::create(['message' => 'You can"t change your profile now!'], 410);
            }

            $the_user->email = $request->email;
            $the_user->can_update = false;
            $the_user->save();


            return Response::json(['message' => 'Profile Info Has Successfully Been Changed!', 'mode' => 'Success'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function changePassword(Request $request)
    {
        try {
            //image upload only
            if ($request->image) {
                $user_id = Auth::user()->id;
                $the_user = $this->user->findOrFail($user_id);
                $this->saveUserPhoto($the_user, $request);
                $message = 'Your  Picture Successfully Updated !';
                return Response::json(['message' => $message, 'mode' => 'Update'], 200);
            }

            $this->validate($request, [
                'current_password' => 'required',
                'new_password' => 'required|min:8',
                'confirm_password' => 'required|same:new_password',
            ]);

            $user_id = Auth::user()->id;
            $the_user = $this->user->findOrFail($user_id);

            $url = $this->getDomain($the_user->alias);


            $password = $request->new_password;


            $current_password = $the_user->password;
            if (Hash::check($request->current_password, $current_password)) {

                $the_user->password = trim($password);
                $the_user->save();
            } else {
                throw new \Error('Current Password Not Matched!');
            }


            $subject = "Login Info: ";//. $the_site->site_name;

            $data = [
                'name' => $the_user->full_name,
                'username' => $the_user->username ?? '',
                'sub_domain' => $url,
                'password' => $password,
                'message' => 'Requested User Login Info!',
                'user_id' => Auth::user()->username
            ];


            Mail::to(['edudeskbd@gmail.com'])->send(new SendMailToUserWithQueue($subject, $data));


            $this->clearDatabaseSessionForSiteUsers(0, $user_id);


            return Response::json(['message' => 'Login Info Has Successfully Been Changed!', 'mode' => 'Success'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    private function saveUserPhoto(User $newlyCreatedUser, Request $request)
    {


        if ($this->is_base64_string($request->image)) {
            $name = time() . '.' . explode('/', explode(':', substr($request->image, 0, strpos($request->image, ';')))[1])[1];

            $path = '/uploads/' . $name;
            Image::make($request->image)->resize(150, 150)->save(public_path('uploads/') . $name);


            $photo = new Photo();
            $photo->name = $name;
            $photo->path = $path;
            $photo->user_id = $newlyCreatedUser->id;
            $newlyCreatedUser->photo()->save($photo);

        }
    }

    /**
     * @param UserForm $userForm
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function createUserForm(UserForm $userForm)
    {
        $viewType = 'Create Employee';
        $createUser = $userForm;
        return view('default.admin.users.create', compact('viewType', 'createUser'));
    }

    /**
     * @param Validator $validatedRequest
     * @return \Illuminate\Http\RedirectResponse
     */
    public function createUser(Requests\Validator $validatedRequest)
    {
        //dd($validatedRequest->first_name);

        $allUsers = $this->user;
        $isOwnFieldsSaved = $this->ownFieldsToSave($allUsers, $validatedRequest);
        $isTranslatedFieldsSaved = $this->translatedAttrToSave($allUsers, $validatedRequest);

        if ($isOwnFieldsSaved && $isTranslatedFieldsSaved) {

            $newlyCreatedUser = $isOwnFieldsSaved;
            $basicUserInfoArr = [
                'user_id' => $newlyCreatedUser->id,
                'created_at' => date('Y-m-d')
            ];

            $this->setRole(
                $newlyCreatedUser,
                $validatedRequest
            );


            $this->saveEmployeeHistory(
                $newlyCreatedUser,
                $validatedRequest,
                $basicUserInfoArr
            );

            $this->saveBankAccounts(
                $newlyCreatedUser,
                $validatedRequest,
                $basicUserInfoArr
            );

            $this->saveUserSalary(
                $newlyCreatedUser,
                $validatedRequest,
                $basicUserInfoArr
            );

            $this->savePhoto(
                $newlyCreatedUser,
                $validatedRequest
            );

            $this->saveDocuments(
                $newlyCreatedUser,
                $validatedRequest
            );
            $this->saveExtraFields(
                $newlyCreatedUser,
                $validatedRequest
            );

            return back()->withSuccess('Successfully Created');

        }


    }

    private function ownFieldsToSave(User $user, Requests\Validator $validatedRequest)
    {
        if (isset($user->ownFields)) {
            foreach ($user->ownFields as $ownField) {
                if ($validatedRequest->{$ownField})
                    $user->{$ownField} = $validatedRequest->{$ownField};
            }
        }

        //dd($validatedRequest->PERMANENT_ADDRESS);
        $this->usernameToSave($user, $validatedRequest);
        $this->passwordToSave($user, $validatedRequest);

        //dd($this->usernameToSave($user,$validatedRequest));


        if ($user->save()) {

            return $user;
        }

        return false;
    }

    /**
     * @param User $user
     * @param Validator $validatedRequest
     */


    private function passwordToSave(User $user, Requests\Validator $validatedRequest)
    {
        //dd($validatedRequest->get('username'));
        if ($validatedRequest->password == null) {

            $user->password = bcrypt(mt_rand(10000, 99999));
        }
    }


    private function usernameToSave(User $user, Requests\Validator $validatedRequest)
    {

        //dd($validatedRequest->get('address'));


        $empname = $validatedRequest->first_name;

        $siteinfos = new SiteInfo();
        $siteinfo = $siteinfos->first();
        $countryid = $siteinfo->country_id;
        $divisionid = $siteinfo->division_id;
        $districtid = $siteinfo->district_id;
        $thanaid = $siteinfo->thana_id;
        $id = $siteinfo->id;


        $createusername = $countryid . $divisionid . $districtid . $thanaid . $id . '@' . $empname;

        //$user = new User();

        $usercheck = $user->where('username', $createusername)->first();

        if ($usercheck != null) {
            $usercheck1 = $createusername . '_';

            $usercheck2 = '';

            for ($i = 0; $i < 1000; $i++) {

                $i += 1;
                $usercheck2 = $usercheck1 . $i;
                $usercheck3 = $user->where('username', $usercheck2)->first();
                if ($usercheck3) {
                    //dd('found');
                    $i--;
                    continue;
                }
                break;
            }

            $user->username = $usercheck2;
            //dd( $user->username);
            return;
        }


        $user->username = $createusername;

        //dd( $user->username);
    }


    private function translatedAttrToSave(User $user, Requests\Validator $validatedRequest)
    {
        foreach ($user->translatedAttributes as $field) {
            foreach ($this->locales() as $locale => $value) {
                if ($validatedRequest->get($field . '_' . $locale)) {
                    $user->translateOrNew($locale)->{$field} = $validatedRequest->get($field . '_' . $locale);
                }
            }
        }

        if ($user->save()) {

            return true;
        }
        return false;
    }

    /**
     * @param User $user
     * @return mixed
     */
    private function newlyCreatedUser(User $user)
    {
        $newlyCreatedUser = $user->all()->last();

        return $newlyCreatedUser;
    }

    /**
     * @param User $user
     * @param Validator $validatedRequest
     */
    private function setRole(User $user, Validator $validatedRequest)
    {

        if ($validatedRequest->role) {
            $roleId = $validatedRequest->role;
            $user->roles()->attach($roleId);
        }
    }

    /**
     * @param User $user
     * @param Validator $validatedRequest
     * @param array $employeeHistory
     */
    private function saveEmployeeHistory(User $user, Requests\Validator $validatedRequest, array $employeeHistory = [])
    {
        $countArr = count($employeeHistory);

        if (isset($user->employeeHistoryFields)) {
            foreach ($user->employeeHistoryFields as $employeeHistoryField) {
                if ($validatedRequest->{$employeeHistoryField})
                    $employeeHistory[$employeeHistoryField] = $validatedRequest->{$employeeHistoryField};
            }
        }
//dd($employeeHistory);
        if (count($employeeHistory) > $countArr) {
            $user->employeeHistories()->create($employeeHistory);
        }
    }

    /**
     * @param User $user
     * @param Validator $validatedRequest
     * @param array $bankAccount
     */
    private function saveBankAccounts(User $user, Validator $validatedRequest, array $bankAccount = [])
    {
        $countArr = count($bankAccount);

        if (isset($user->bankAccountFields)) {
            foreach ($user->bankAccountFields as $bankAccountField) {
                if ($validatedRequest->{$bankAccountField})
                    $bankAccount[$bankAccountField] = $validatedRequest->{$bankAccountField};
            }
        }
        if (count($bankAccount) > $countArr) {
            $user->bankAccounts()->create($bankAccount);
        }
    }

    /**
     * @param User $user
     * @param Validator $validatedRequest
     * @param array $userSalary
     */
    private function saveUserSalary(User $user, Validator $validatedRequest, array $userSalary = [])
    {
        $countArr = count($userSalary);

        if (isset($user->userSalaryFields)) {
            foreach ($user->userSalaryFields as $userSalaryField) {
                if ($validatedRequest->{$userSalaryField})
                    $userSalary[$userSalaryField] = $validatedRequest->{$userSalaryField};
            }
        }
        if (count($userSalary) > $countArr) {
            $user->userSalaries()->create($userSalary);
        }
    }

    /**
     * @param User $user
     * @param Validator $validatedRequest
     */
    private function savePhoto(User $user, Validator $validatedRequest)
    {
        if ($validatedRequest->photo):
            $image = $validatedRequest->file('photo');
            $this->imageUpload($image, $user);
        endif;
    }

    /**
     * @param User $user
     * @param Validator $validatedRequest
     */
    private function saveDocuments(User $user, Validator $validatedRequest)
    {
        if ($validatedRequest->file):
            $filesExceptImage = $validatedRequest->file('file');
            foreach ($filesExceptImage as $file) {
                if ($file):
                    $this->fileUpload($file, $user);
                endif;
            }
        endif;
    }

    /**
     * @param $file
     * @param $newlyCreatedUser
     */
    private function fileUpload($file, User $newlyCreatedUser)
    {
        $this->fileName = time() . str_random(3) . $file->getClientOriginalName();
        $this->extension = $file->getClientOriginalExtension();
        $destinationPath = public_path('uploads');
        $file->move($destinationPath, $this->fileName);
        $media = new Media();
        $media->name = $this->fileNameWithoutExtension($this->fileName);
        $media->extension = $this->extension;
        $media->user_id = $newlyCreatedUser->id;
        $newlyCreatedUser->files()->save($media);
    }

    /**
     * Upload Image
     * @param $file
     * @param $newlyCreatedUser
     */
    private function imageUpload($image, User $newlyCreatedUser)
    {

        $this->fileName = time() . str_random(3) . $image->getClientOriginalName();
        InterImage::make($image->getRealPath())->resize(200, 200)->save('uploads/' . $this->fileName);
        $photo = new Photo();
        $photo->name = $this->fileName;
        $photo->user_id = $newlyCreatedUser->id;
        $photo->extension = 'jpeg';
        $newlyCreatedUser->photo()->save($photo);
    }


    /**
     * @param User $user
     * @param Requests\Validator $validatedRequest
     */
    private function saveExtraFields(User $user, Requests\Validator $validatedRequest)
    {
        $newFieldsForUsers = $user->getNewFieldsName('user');
        if (isset($newFieldsForUsers) && !empty($newFieldsForUsers)) {
            foreach ($newFieldsForUsers as $newUserField) {
                $addNewFields = new AddFieldToTable();
                if ($validatedRequest->{$newUserField})
                    $addNewFields->key = $newUserField;
                $addNewFields->value = $validatedRequest->{$newUserField};
                $user->addFieldsToTable()->save($addNewFields);
            }

        }

    }

    /**
     * get FileName without Extension
     * @param $fileName
     * @return string
     */
    private function fileNameWithoutExtension($fileName)
    {
        $ext = strtolower(substr($fileName, strrpos($fileName, '.') + 1));
        $fileNameWithoutExt = basename($fileName, '.' . $ext); // output: "youFileName" only

        return $fileNameWithoutExt;
    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function viewUser($id)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $userProfile = $this->user->findOrFail($id);
        $photo = $userProfile->photo->last()->name;
//dd($photo);
        return view('default.admin.users.view', compact('userProfile', 'locale', 'defaultLocale', 'photo'));

    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function editUserForm($id, UserForm $userForm)
    {
        $viewType = 'Edit User';
        $editUser = $userForm;
        $userProfile = $this->editFormModel($this->user->findOrFail($id));
        // $photo = $userProfile->photo->last()->name;

        return view('default.admin.users.edit', compact('userProfile', 'viewType', 'editUser', 'photo'));
    }


    /**
     * @patch edit user
     * @param $id
     * @param Validator $validatedRequest
     */
    public function editUser($id, Validator $validatedRequest)
    {

        $userProfile = $this->user->findOrFail($id);
        $isOwnFieldsSaved = $this->ownFieldsToSave($userProfile, $validatedRequest);
        $isTranslatedFieldsSaved = $this->translatedAttrToSave($userProfile, $validatedRequest);
        $basicUserInfoArr = [
            'user_id' => $userProfile->id,
            'updated_at' => date('Y-m-d')
        ];


        if ($isOwnFieldsSaved) {

            if ($isTranslatedFieldsSaved) {

                $this->setRole(
                    $userProfile,
                    $validatedRequest
                );
                $this->saveEmployeeHistory(
                    $userProfile,
                    $validatedRequest,
                    $basicUserInfoArr
                );

                $this->saveBankAccounts(
                    $userProfile,
                    $validatedRequest,
                    $basicUserInfoArr
                );

                $this->saveUserSalary(
                    $userProfile,
                    $validatedRequest,
                    $basicUserInfoArr
                );

                $this->savePhoto(
                    $userProfile,
                    $validatedRequest
                );

                $this->saveDocuments(
                    $userProfile,
                    $validatedRequest
                );
                return back()->withSuccess('Successfully Updated');
            }
        }


    }

    /**
     * @param $id
     * @return $this|\Illuminate\Http\RedirectResponse
     */
    public function deleteUser($id)
    {
        $userToDelete = $this->user->findOrFail($id);
        if ($userToDelete->delete()):
            return back();
        endif;
        return back()->withErrors('Not Successfully Deleted');
    }


}
