<?php

namespace App\Jobs;

use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Student\StudentHistory;
use App\Models\User\GlobalUser;
use App\Notifications\Site\StudentDemandSlipGenerateNotification;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Notification;

class DemandSlipJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public $tries = 1;

    protected $slip_details;

    public function __construct($slip_details)
    {
        $this->slip_details = $slip_details;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        foreach ($this->slip_details as $key => $value){

            $user_id = GlobalStudentHistory::where('id', $value->student_history_id)->first()->user_id ?? 0;

            $user = GlobalUser::where('id', $user_id)
                ->select(['id'])
                ->first();


            $route=route('site-notice-view',['']);

            $user->notify(new StudentDemandSlipGenerateNotification($value->id,$route));


           // Notification::send($user, new StudentPaymentNotification($value));
        }

    }
}
