<?php

namespace App\Jobs;

use App\Models\Attendance\GlobalStudentAttendance;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Employee\GlobalEmployeeAttendance;
use App\Traits\SmsApiTrait;
use DB;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Log;

class SendAttSmsJob implements ShouldQueue
{
    //use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, RequestHandleWithThirdPartyApi, SmsRelatedFunction, SmsApiTrait;
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, SmsApiTrait;



    protected $details;
    protected $numbers;
    protected $numbers_array;
    protected $att_details;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($numbers, $details)
    {
        $this->numbers = $numbers;
        $this->numbers_array = $numbers;
        $this->details = $details;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        //dynamic sms=========================================================
        // 3 require for dynamic sms too
        $att_type = $this->details['att_type'];//in or out att_type att_user_type att_table_id
        $att_user_type = $this->details['att_user_type'];// st or emp
        $att_table_id = $this->details['att_table_id'];//table id for update


        //sms try start

        // comment by Rayhan


        // $issue = new IssueDetail();
        // $issue->issue_type = 'sms_failed';
        // $issue->issuer_type = $this->details['sms_bearer'];
        // $issue->issue_details = 'SendAttSms Job Started-:' . json_encode($this->details);
        // $issue->site_id = $this->details['sms_bearer_id'];
        // $issue->save();

        $sms_responses = $this->sendSmsDynamicApi($this->numbers_array, $this->details);// got to the method to see what it returns

        $followup_id = $sms_responses['followup_id'];
        $msg_id = $sms_responses['sms_api_id'];
        $status = $sms_responses['sms_sent_status'];

  /*      $response['followup_id'] = $follow_up->id;
        $response['sms_api_id'] = $response_id ?? 0;
        $response['sms_company'] = 'zamanit';
        $response['sms_sent_status'] = $status;
        $response['sent_time'] = date('Y-m-d H:i:s', strtotime($time));*/


        if ($status) {
            if ($att_user_type == 'student') {

                if ($att_type == 'in') {

                    $stdAttendance = new GlobalStudentAttendance();
                    $stdAttendance
                        ->where('id', $att_table_id)
                        ->update([
                            'in_sms_id' => $followup_id
                        ]);

                } else {//out
                    $stdAttendance = new GlobalStudentAttendance();
                    $stdAttendance
                        ->where('id', $att_table_id)
                        ->update([
                            'out_sms_id' => $followup_id
                        ]);
                }


            }elseif ($att_user_type == 'employee') {

                if ($att_type == 'in') {
                    $stdAttendance = new GlobalEmployeeAttendance();
                    $stdAttendance
                        ->where('id', $att_table_id)
                        ->update([
                            'in_sms_id' => $followup_id
                        ]);
    
                } else {//out
                    $stdAttendance = new GlobalEmployeeAttendance();
                    $stdAttendance
                        ->where('id', $att_table_id)
                        ->update([
                            'out_sms_id' => $followup_id
                        ]);
                }
            }


        } else {//some thing wrong to send sms  then set o to in or out sms id

            $issue = new IssueDetail();
            $issue->issue_type = 'sms_failed';
            $issue->issue_details = 'SendAttSms Job Failed:';
            $issue->bearer_type = $this->details['sms_bearer'];
            $issue->bearer_id = $this->details['sms_bearer_id'];
            $issue->save();

            if ($att_user_type == 'student') {

                if ($att_type == 'in') {

                    $stdAttendance = new GlobalStudentAttendance();
                    $stdAttendance
                        ->where('id', $att_table_id)
                        ->update([
                            'in_sms_id' => 0
                        ]);

                } else {//out
                    $stdAttendance = new GlobalStudentAttendance();
                    $stdAttendance
                        ->where('id', $att_table_id)
                        ->update([
                            'out_sms_id' => 0
                        ]);
                }

            }elseif ($att_user_type == 'employee') {

                if ($att_type == 'in') {
                    $stdAttendance = new GlobalEmployeeAttendance();
                    $stdAttendance
                        ->where('id', $att_table_id)
                        ->update([
                            'in_sms_id' => 0
                        ]);
    
                } else {//out
                    $stdAttendance = new GlobalEmployeeAttendance();
                    $stdAttendance
                        ->where('id', $att_table_id)
                        ->update([
                            'out_sms_id' => 0
                        ]);
                }
            }

        }
    }


    /**
     * The job failed to process.
     *
     * @param  Exception $exception
     * @return void
     */
    public function failed(Exception $exception)
    {


        $issue = new IssueDetail();
        $issue->issue_type = 'sms_failed';
        $issue->issue_details = 'SendAttSms Job Failed: ' . $exception->getMessage();
        $issue->bearer_type = $this->details['sms_bearer'];
        $issue->bearer_id = $this->details['sms_bearer_id'];
        $issue->save();

        $att_type = $this->details['att_type'];//in or out
        $att_user_type = $this->details['att_user_type'];// st or emp
        $att_table_id = $this->details['att_table_id'];//table id for update

        if ($att_user_type == 'student') {

            if ($att_type == 'in') {

                $stdAttendance = new GlobalStudentAttendance();
                $stdAttendance
                    ->where('id', $att_table_id)
                    ->update([
                        'in_sms_id' => 0
                    ]);

            } else {//out
                $stdAttendance = new GlobalStudentAttendance();
                $stdAttendance
                    ->where('id', $att_table_id)
                    ->update([
                        'out_sms_id' => 0
                    ]);
            }

        } elseif ($att_user_type == 'employee') {

            if ($att_type == 'in') {
                $stdAttendance = new GlobalEmployeeAttendance();
                $stdAttendance
                    ->where('id', $att_table_id)
                    ->update([
                        'in_sms_id' => 0
                    ]);

            } else {//out
                $stdAttendance = new GlobalEmployeeAttendance();
                $stdAttendance
                    ->where('id', $att_table_id)
                    ->update([
                        'out_sms_id' => 0
                    ]);
            }
        }
    }
}
