<?php

namespace App\Jobs\Site;

use App\Models\Site\Notice\Notice;
use App\Notifications\Site\NoticeNotification;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Notification;

class NoticeJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */

    private $user_ids_array;
    private $the_notice;
    private $route;
    public $tries = 1;




    public function __construct($user_ids_array,Notice $the_notice,$route)
    {
        $this->user_ids_array=$user_ids_array;
        $this->the_notice=$the_notice;
        $this->route=$route;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $users = User::whereIn('id', $this->user_ids_array)
            ->select(['id'])
            ->get();
            
        Notification::send($users, new NoticeNotification($this->the_notice,$this->route));
    }
}
