<?php

namespace App\Mail;

use App\Models\Edu\Issue\IssueDetail;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendMailToUserWithQueue extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $tries = 2;
    public $sub;
    public $data;
    public function __construct($subject,$data)
    {
        $this->sub=$subject;
        $this->data=$data;

    }

    /**
     *
     *  'name' => $emp->first_name . ' ' . $emp->last_name,
    'username' => $username,
    'sub_domain' => $sub_domain,
    'password' => $password,
    'message' => 'Employee Successfully Added!',
    'user_id' => Auth::user()->username
     *
     *
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {

        $name1= $this->data['name'] ?? 'no name';


        return $this->view('user-credentials-mail',
            [
                'name' =>$name1 ,
                'username' => $this->data['username'],
                'sub_domain' =>$this->data['sub_domain'],
                'heading' =>$this->data['heading'] ??                                                                                                                                            '',
                'password' => $this->data['password'],
                'body_text' => $this->data['message'],
                'by' => $this->data['user_id'],
            ]
        )->subject($this->sub);
    }


    public function failed(Exception $exception)
    {

        $issue = new    IssueDetail();
        $issue->issue_type = 'mail';
        $issue->issuer_type = 'site';
        $issue->issue_details = json_encode($exception->getMessage());
        $issue->save();

    }
}
