<?php

namespace App\Models\Academic;

use Illuminate\Database\Eloquent\Model;

class AcademicCalendarSubheadColor extends Model
{
    public $timestamps = false;
    protected $table='academic_calendar_subhead_colors';

    const ACADEMIC_CALENDAR_HEAD_ID = 'academic_calendar_head_id';
    const COLOR_NAME = 'color_name';
    const COLOR_ID='color_id';
    const STATUS = 'status';

    protected $fillable = [

        self::ACADEMIC_CALENDAR_HEAD_ID,
        self::COLOR_NAME,
        self::COLOR_ID,
        self::STATUS

    ];

    public $ownFields = [

        self::ACADEMIC_CALENDAR_HEAD_ID,
        self::COLOR_NAME,
        self::COLOR_ID,
        self::STATUS

    ];


    public function academicCalendarHead()
    {
        return $this->belongsTo(AcademicCalendarHead::class);
    }

}