<?php

namespace App\Models\Academic;

use App\Models\Attendance\StudentAttendance;
use App\Models\Edu\ClassRoom\EduClassRoom;
use App\Models\Site\Employee\StudentAssignToTeacher;
use App\Models\Site\Exam\SiteExamQuestionInfo;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\Web\ClassRoom\ClassRoom;
use App\User;
use Illuminate\Database\Eloquent\Model;

class AcademicClass extends Model
{

    public $timestamps = false;
    protected $table='academic_classes';

    const CLASS_NAME = 'class_name';
    const SERIAL_NO = 'serial_no';
    const NOTE = 'note';
    const Academic_Group_Present='academic_group_present';
    const STATUS = 'status';


    protected $fillable = [
        self::CLASS_NAME,
        self::SERIAL_NO,
        self::Academic_Group_Present,
        self::NOTE,
        self::STATUS
    ];

    public $ownFields = [
        self::CLASS_NAME,
        self::SERIAL_NO,
        self::Academic_Group_Present,
        self::NOTE,
        self::STATUS
    ];


    /***
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function subjects()
    {
        return $this->belongsToMany(AcademicSubject::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function classRoom()
    {
        return $this->hasMany(ClassRoom::class);
    }

    public function studentAttendance()
    {
        return $this->hasMany('App\Models\Attendance\StudentAttendance');
    }

    public function siteShiftClassGroupSetting()
    {
        return $this->hasMany(SiteShiftClassGroupSectionSetting::class);
    }
    public function eduClassRoom()
    {
        return $this->hasMany(EduClassRoom::class);
    }

    public function siteExamQuestionInfo()
    {
        return $this->hasMany(SiteExamQuestionInfo::class);
    }
    public function studentAssignToTeacher()
    {
        return $this->hasMany(StudentAssignToTeacher::class);
    }

}
