<?php

namespace App\Models\Academic;


use App\Models\Edu\ClassRoom\EduClassRoom;
use App\Models\Site\Exam\SiteExamQuestionInfo;
use App\Models\Site\Web\ClassRoom\ClassRoom;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class AcademicClassWiseSubject extends Model
{

    use Translatable;

    const Academic_class_id = 'academic_class_id';
    const Academic_subject_id = 'academic_subject_id';

    public $timestamps = true;
    protected $table = 'academic_class_academic_subject';

    protected $fillable = [
        self::Academic_class_id,
        self::Academic_subject_id,
    ];


    public function classes()
    {
        return $this->belongsToMany(AcademicClass::class);
    }

    public function subjects()
    {
        return $this->belongsToMany(AcademicSubject::class);
    }

  


}
