<?php

namespace App\Models\Academic;

use App\Models\Edu\ClassRoom\EduClassRoom;
use App\Models\Site\Employee\StudentAssignToTeacher;
use App\Models\Site\Exam\SiteExamQuestionInfo;
use App\Models\Site\Web\ClassRoom\ClassRoom;
use Illuminate\Database\Eloquent\Model;

class AcademicDepartment extends Model
{
    public $timestamps = false;
    protected $table='academic_departments';

    const NAME = 'name';
    const STATUS = 'status';


    protected $fillable = [
        self::NAME,
        self::STATUS
    ];

    public $ownFields = [
        self::NAME,
        self::STATUS
    ];

    public function classRoom()
    {
        return $this->hasMany(ClassRoom::class);
    }

    public function eduClassRoom()
    {
        return $this->hasMany(EduClassRoom::class);
    }

    public function siteExamQuestionInfo()
    {
        return $this->hasMany(SiteExamQuestionInfo::class);
    }
    public function studentAssignToTeacher()
    {
        return $this->hasMany(StudentAssignToTeacher::class);
    }


}
