<?php

namespace App\Models\Academic;


use App\Models\Edu\ClassRoom\EduClassRoom;
use App\Models\Site\Exam\SiteExamQuestionInfo;
use App\Models\Site\Web\ClassRoom\ClassRoom;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class AcademicSubject extends Model
{

    use Translatable;

    const ACADEMIC_CLASS_IDS = 'academic_class_ids';
    const SUBJECT_NAME = 'subject_name';
    const BELONGS_TO_ACADEMIC_GROUP = 'belongs_to_academic_group';

    public $timestamps = true;
    protected $table = 'academic_subjects';

    protected $fillable = [
        self::SUBJECT_NAME,
        self::ACADEMIC_CLASS_IDS,
        self::BELONGS_TO_ACADEMIC_GROUP
    ];
    public $translatedAttributes = [
        self::SUBJECT_NAME,

    ];

    public function classes()
    {
        return $this->belongsToMany(AcademicClass::class);
    }

    public function classRoom()
    {
        return $this->hasMany(ClassRoom::class);
    }


    public function subGrCondSettings()
    {
        return $this->hasOne(SubjectGroupConditionSetting::class,'academic_subject_id');
    }

    public function eduClassRoom()
    {
        return $this->hasMany(EduClassRoom::class);
    }

    public function siteExamQuestionInfo()
    {
        return $this->hasMany(SiteExamQuestionInfo::class);
    }



}
