<?php

namespace App\Models\Assessment;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicSubject;
use Illuminate\Database\Eloquent\Model;

class AssessmentExpertiseWiseTopic extends Model
{

    protected $table = 'assessment_expertise_wise_topics';

    const Academic_class_id = 'academic_class_id';
    const Academic_subject_id = 'academic_subject_id';
    const Assessment_type_id = 'assessment_type_id';
    const Expertise_id = 'expertise_id';
    const Topic_name = 'topic_name';
    const Topic_no = 'topic_no';
    const Serial = 'serial';
    const Description = 'description';
    const Status = 'status';


    protected $fillable = [
        self::Academic_class_id,
        self::Academic_subject_id,
        self::Assessment_type_id,
        self::Expertise_id,
        self::Topic_name,
        self::Topic_no,
        self::Serial,
        self::Description,
        self::Status,
    ];

    public function assessmentType()
    {
        return $this->belongsTo(AssessmentType::class,'assessment_type_id');
    }

    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class,'academic_class_id');
    }
    
    public function academicSubject()
    {
        return $this->belongsTo(AcademicSubject::class,'academic_subject_id');
    }

    public function expertise()
    {
        return $this->belongsTo(AssessmentExpertise::class,'expertise_id');
    }
    
  
}
