<?php

namespace App\Models\Assessment;

use Illuminate\Database\Eloquent\Model;

class ExpertiseAssessmentTypeAndTypeNoSetting extends Model
{
    protected $table='expertise_assessment_type_and_type_no_settings';

    protected $appends = array('assessment_name');


    const Academic_year_id = 'academic_year_id';
    const Academic_class_id = 'academic_class_id';

    const Assessment_id = 'assessment_id';
    const Academic_subject_id = 'academic_subject_id';
    const Expertise_id = 'expertise_id';
    const Topic_id = 'topic_id';
    const Assessment_type_id = 'assessment_type_id';
    const Assessment_type_no_id = 'assessment_type_no_id';
    const Position_show = 'position_show';
    const Status = 'status';

    protected $fillable = [
        self::Academic_year_id,
        self::Academic_class_id,

        self::Academic_subject_id,
        self::Assessment_id,
        self::Topic_id,
        self::Expertise_id,
        self::Assessment_type_id,
        self::Assessment_type_no_id,
        self::Position_show,
        self::Status,

    ];

    public function assessment()
    {
        return $this->belongsTo(Assessment::class);

    }

    public function getAssessmentNameAttribute()
    {
        return  $this->attributes['assessment_name']= $this->assessment->assessment_name;

    }

}
