<?php

namespace App\Models\Attendance;

use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\User\GlobalUser;
use Illuminate\Database\Eloquent\Model;

class GlobalStudentAttendance extends Model
{
    protected $table='student_attendances';
    public $timestamps = false;

    protected  $casts=[
        'in_sms_id'=>'integer',
        'out_sms_id'=>'integer',
        'late_status'=>'integer',
    ];



    const USER = 'user_id';
    const ROLL_NO = 'roll_no';
    const PRESENT_TYPE = 'present_type';
    const PRESENT_TYPE_ID = 'present_type_id';
    const IN_TIME = 'in_time';
    const OUT_TIME = 'out_time';
    const ATTENDANCE_DATE = 'present_date';
    const ATTENDANCE_DATE_TIME = 'present_date_time';
    const ATTENDANCE_YEAR = 'present_year';
    const ATTENDANCE_MONTH = 'present_month';
    const ATTENDANCE_DAY = 'present_day';

    const STUDENT_CLASS = 'student_class';
    const SECTION = 'section';
    const SUBJECT = 'subject';
    const NAME = 'name';
    const LATE_STATUS = 'late_status';
    const SITE_ID = 'site_id';


    protected $fillable = [
        self::USER,
        self::NAME,
        self::ROLL_NO,
        self::PRESENT_TYPE,
        self::PRESENT_TYPE_ID,
        self::IN_TIME,
        self::OUT_TIME,
        self::ATTENDANCE_DATE,
        self::ATTENDANCE_YEAR,
        self::ATTENDANCE_MONTH,
        self::ATTENDANCE_DAY,
        self::ATTENDANCE_DATE_TIME,
        self::LATE_STATUS,
        self::SITE_ID,
    ];

    protected $ownFields = [
        self::USER,
        self::NAME,
        self::ROLL_NO,
        self::PRESENT_TYPE,
        self::PRESENT_TYPE_ID,
        self::IN_TIME,
        self::OUT_TIME,
        self::ATTENDANCE_DATE,
        self::ATTENDANCE_YEAR,
        self::ATTENDANCE_MONTH,
        self::ATTENDANCE_DAY,
        self::ATTENDANCE_DATE_TIME
    ];



    public function studentHistory()
    {
        return $this->belongsTo(GlobalStudentHistory::class, 'student_history_id');
    }

    public function userHistory()
    {
        return $this->belongsTo(GlobalStudentHistory::class, 'student_history_id');
    }

}
